(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18285,        596]
NotebookOptionsPosition[     11673,        398]
NotebookOutlinePosition[     15609,        506]
CellTagsIndexPosition[     15087,        491]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Transactions in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/Transactions#31020"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Transactions in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLCommitTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCommitTransaction"], 
          "SQLRollbackTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLRollbackTransaction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SQLCommitTransaction\"\>", 
       2->"\<\"SQLRollbackTransaction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections"], 
          "Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"Database Transactions and Result Sets\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLBeginTransaction", "ObjectName",
 CellID->2702],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLBeginTransaction", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["initiates an SQL transaction. ", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[StyleBox["A group of SQL commands grouped into a transaction \
will only take effect permanently when the transaction is committed. The \
transaction can be canceled or returned to a savepoint.", "Text"]], "Notes",
 CellID->832]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32923997],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->808012267],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->16584181],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,15"},
 CellLabel->"In[2]:=",
 CellID->18413],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<X\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<Integer\>\""}]}], 
       "]"}], ",", " ", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<Y\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<Integer\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,3",
 CellLabel->"In[3]:=",
 CellID->11400],

Cell["Begin a transaction:", "ExampleText",
 CellID->22816],

Cell[BoxData[
 RowBox[{"SQLBeginTransaction", "[", "conn", "]"}]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,17"},
 CellLabel->"In[4]:=",
 CellID->31690],

Cell["Insert data:", "ExampleText",
 CellID->13162],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"61", ",", "80"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,18"},
 CellLabel->"In[5]:=",
 CellID->8935],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"72", ",", "5"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,19"},
 CellLabel->"In[6]:=",
 CellID->29126],

Cell["Commit the transaction:", "ExampleText",
 CellID->19410],

Cell[BoxData[
 RowBox[{"SQLCommitTransaction", "[", "conn", "]"}]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,20"},
 CellLabel->"In[7]:=",
 CellID->19877],

Cell["Select the data:", "ExampleText",
 CellID->11382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"Ex--21943492438155078303,21",
 CellLabel->"In[8]:=",
 CellID->26260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"61", ",", "80"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "5"}], "}"}]}], "}"}]], "Output",
 CellTags->"Ex--21943492438155078303,21",
 CellLabel->"Out[8]=",
 CellID->27189]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,22"},
 CellLabel->"In[9]:=",
 CellID->26705],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,23"},
 CellLabel->"In[10]:=",
 CellID->13874]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCommitTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCommitTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLRollbackTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25141],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Transactions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->473145049],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"]], "MoreAbout",\

 CellID->112636613],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->949383230],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->335056019]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLBeginTransaction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 28.7813860}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLBeginTransaction[conn] initiates an SQL transaction. ", 
    "synonyms" -> {}, "title" -> "SQLBeginTransaction", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLBeginTransaction"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4513, 135, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32923997]},
 "b:6.4"->{
  Cell[5586, 173, 270, 8, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,15"},
   CellID->18413],
  Cell[6554, 205, 167, 4, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,17"},
   CellID->31690],
  Cell[6778, 214, 369, 10, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,18"},
   CellID->8935],
  Cell[7150, 226, 369, 10, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,19"},
   CellID->29126],
  Cell[7587, 241, 168, 4, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,20"},
   CellID->19877],
  Cell[8296, 271, 255, 8, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,22"},
   CellID->26705],
  Cell[8554, 281, 202, 6, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,23"},
   CellID->13874]},
 "Ex--21943492438155078303,15"->{
  Cell[5586, 173, 270, 8, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,15"},
   CellID->18413]},
 "Ex--21950856252955103714,3"->{
  Cell[5859, 183, 630, 17, 70, "Input",
   CellTags->"Ex--21950856252955103714,3",
   CellID->11400]},
 "Ex--21943492438155078303,17"->{
  Cell[6554, 205, 167, 4, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,17"},
   CellID->31690]},
 "Ex--21943492438155078303,18"->{
  Cell[6778, 214, 369, 10, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,18"},
   CellID->8935]},
 "Ex--21943492438155078303,19"->{
  Cell[7150, 226, 369, 10, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,19"},
   CellID->29126]},
 "Ex--21943492438155078303,20"->{
  Cell[7587, 241, 168, 4, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,20"},
   CellID->19877]},
 "Ex--21943492438155078303,21"->{
  Cell[7838, 252, 185, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,21",
   CellID->26260],
  Cell[8026, 259, 255, 9, 70, "Output",
   CellTags->"Ex--21943492438155078303,21",
   CellID->27189]},
 "Ex--21943492438155078303,22"->{
  Cell[8296, 271, 255, 8, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,22"},
   CellID->26705]},
 "Ex--21943492438155078303,23"->{
  Cell[8554, 281, 202, 6, 70, "Input",
   CellTags->{"b:6.4", "Ex--21943492438155078303,23"},
   CellID->13874]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12727, 423},
 {"b:6.4", 12858, 427},
 {"Ex--21943492438155078303,15", 13685, 449},
 {"Ex--21950856252955103714,3", 13832, 453},
 {"Ex--21943492438155078303,17", 13969, 457},
 {"Ex--21943492438155078303,18", 14117, 461},
 {"Ex--21943492438155078303,19", 14265, 465},
 {"Ex--21943492438155078303,20", 14414, 469},
 {"Ex--21943492438155078303,21", 14562, 473},
 {"Ex--21943492438155078303,22", 14802, 480},
 {"Ex--21943492438155078303,23", 14950, 484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2614, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3237, 89, 56, 1, 70, "ObjectName",
 CellID->2702],
Cell[3296, 92, 423, 13, 70, "Usage",
 CellID->8707]
}, Open  ]],
Cell[CellGroupData[{
Cell[3756, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4234, 127, 242, 3, 70, "Notes",
 CellID->832]
}, Closed]],
Cell[CellGroupData[{
Cell[4513, 135, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32923997],
Cell[CellGroupData[{
Cell[4897, 149, 148, 5, 70, "ExampleSection",
 CellID->808012267],
Cell[5048, 156, 134, 3, 70, "Input",
 CellID->16584181],
Cell[5185, 161, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5586, 173, 270, 8, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,15"},
 CellID->18413],
Cell[5859, 183, 630, 17, 70, "Input",
 CellTags->"Ex--21950856252955103714,3",
 CellID->11400],
Cell[6492, 202, 59, 1, 70, "ExampleText",
 CellID->22816],
Cell[6554, 205, 167, 4, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,17"},
 CellID->31690],
Cell[6724, 211, 51, 1, 70, "ExampleText",
 CellID->13162],
Cell[6778, 214, 369, 10, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,18"},
 CellID->8935],
Cell[7150, 226, 369, 10, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,19"},
 CellID->29126],
Cell[7522, 238, 62, 1, 70, "ExampleText",
 CellID->19410],
Cell[7587, 241, 168, 4, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,20"},
 CellID->19877],
Cell[7758, 247, 55, 1, 70, "ExampleText",
 CellID->11382],
Cell[CellGroupData[{
Cell[7838, 252, 185, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,21",
 CellID->26260],
Cell[8026, 259, 255, 9, 70, "Output",
 CellTags->"Ex--21943492438155078303,21",
 CellID->27189]
}, Open  ]],
Cell[8296, 271, 255, 8, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,22"},
 CellID->26705],
Cell[8554, 281, 202, 6, 70, "Input",
 CellTags->{"b:6.4", "Ex--21943492438155078303,23"},
 CellID->13874]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8805, 293, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9124, 304, 529, 17, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[9690, 326, 314, 9, 70, "TutorialsSection",
 CellID->25141],
Cell[10007, 337, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10297, 348, 429, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[10763, 365, 319, 9, 70, "MoreAboutSection",
 CellID->473145049],
Cell[11085, 376, 169, 4, 70, "MoreAbout",
 CellID->112636613],
Cell[11257, 382, 200, 5, 70, "MoreAbout",
 CellID->949383230],
Cell[11460, 389, 171, 4, 70, "MoreAbout",
 CellID->335056019]
}, Open  ]],
Cell[11646, 396, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

