(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29799,        827]
NotebookOptionsPosition[     21516,        583]
NotebookOutlinePosition[     26592,        721]
CellTagsIndexPosition[     25937,        703]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Data Type Mapping in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DataTypeMapping#24423"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Data Type Mapping in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLDateTime" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDateTime"], 
          "SQLExpr" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExpr"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLDateTime\"\>", 
       2->"\<\"SQLExpr\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLBinary", "ObjectName",
 CellID->9458],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLBinary", "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox[
     "represents raw binary data that can be stored in a database.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->76261319],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->328489522],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,2"},
 CellLabel->"In[2]:=",
 CellID->7975],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<BINTABLE\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BINCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<BINARY\>\""}]}], "]"}],
      "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,4",
 CellLabel->"In[3]:=",
 CellID->10556],

Cell["Here is a plot:", "ExampleText",
 CellID->7531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plot", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}]}]], "Input",
 CellTags->"Ex--21943492438155078303,4",
 CellLabel->"In[4]:=",
 CellID->31495],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl13k01PsbB3BrlhTzHYqiS9qJupFUPJ9kjVSoWxGSFpOsXSSp3CIlSbRd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     "]]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  Method->{},
  PlotRange->{{0, 2 Pi}, Automatic},
  PlotRangeClipping->True]], "Output",
 CellTags->"Ex--21943492438155078303,4",
 CellLabel->"Out[4]=",
 CellID->8044]
}, Open  ]],

Cell["\<\
This generates a string that contains the image in GIF format:\
\>", "ExampleText",
 CellID->30591],

Cell[BoxData[
 RowBox[{
  RowBox[{"gif", " ", "=", 
   RowBox[{"ExportString", "[", 
    RowBox[{"plot", ",", " ", "\"\<GIF\>\""}], "]"}]}], ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,5"},
 CellLabel->"In[5]:=",
 CellID->26803],

Cell["This shows part of the string:", "ExampleText",
 CellID->3388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"gif", ",", " ", "100"}], "]"}]], "Input",
 CellTags->"Ex--21943492438155078303,6",
 CellLabel->"In[6]:=",
 CellID->18915],

Cell[BoxData["\<\"GIF89ah\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\[CapitalOHat]\.00\[CapitalOTilde]\.00\.00\.00\.00\.00?=\.99KI\.9fQO\
\[Sterling]WU\.a6][\[Copyright]cb\[Not]ih\[Degree]on\.b3ut\[Paragraph]{z\.b9\
\.81\.80\.bc\.87\.86\[CapitalAGrave]\.8d\.8c\[CapitalATilde]\.93\.92\
\[CapitalAE]\.99\.98\[CapitalEAcute]\.9f\.9e\[CapitalIGrave]\[Yen]\[Currency]\
\[CapitalIDoubleDot]\[LeftGuillemet]\.aa\[CapitalOGrave]\[PlusMinus]\[Degree]\
\[CapitalOTilde]\[CenterDot]\[Paragraph]\[CapitalOSlash]\.bd\.bc\
\[CapitalUDoubleDot]\[CapitalATilde]\[CapitalAHat]\[SZ]\[CapitalEAcute]\
\[CapitalEGrave]\[AHat]\[CapitalIDoubleDot]\[CapitalIHat]\[ARing]\
\[CapitalOTilde]\[CapitalOHat]\[EGrave]\[CapitalUHat]\[CapitalUAcute]\[IGrave]\
\[AAcute]\[AAcute]\[IDoubleDot]\[CCedilla]\[CCedilla]\[OGrave]\"\>"], "Output",\

 CellTags->"Ex--21943492438155078303,6",
 CellLabel->"Out[6]=",
 CellID->7450]
}, Open  ]],

Cell[TextData[{
 "This converts the string into a list of bytes wrapped in ",
 Cell[BoxData["SQLBinary"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12319],

Cell[BoxData[
 RowBox[{
  RowBox[{"byteData", " ", "=", " ", 
   RowBox[{"SQLBinary", "[", 
    RowBox[{"ToCharacterCode", "[", "gif", "]"}], "]"}]}], ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,7"},
 CellLabel->"In[7]:=",
 CellID->6272],

Cell["This inserts the data:", "ExampleText",
 CellID->25791],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\"", ",", " ", 
    RowBox[{"{", "\"\<BINCOL\>\"", "}"}], ",", " ", 
    RowBox[{"{", "byteData", "}"}]}], "]"}], ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,8"},
 CellLabel->"In[8]:=",
 CellID->29383],

Cell["This retrieves the data:", "ExampleText",
 CellID->10133],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", " ", 
   RowBox[{"SQLSelect", "[", 
    RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\""}], "]"}]}], ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,9"},
 CellLabel->"In[9]:=",
 CellID->1775],

Cell["This converts it back into a string:", "ExampleText",
 CellID->24642],

Cell[BoxData[
 RowBox[{
  RowBox[{"gifData", " ", "=", 
   RowBox[{"FromCharacterCode", "[", " ", 
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], " ", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,10"},
 CellLabel->"In[10]:=",
 CellID->23569],

Cell["Here is the imported image:", "ExampleText",
 CellID->18300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"gifData", ",", "\"\<GIF\>\""}], "]"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
 CellLabel->"In[11]:=",
 CellID->17954],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne16qjgQx/vvOVbRumo99hRbX7ilvYTzab/tze4FbYsiSHlJJjPJGPw9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   "], {{0, 0}, {360, 212}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzt08lKm3EUxuFQvABBEGtx4R0USiuC8PYaxFLptBBcF0RFELwHxTGpibfQ
0tJiG3sHHTJoBqOJGTRmaKSlYpuIPW++/zmr0m6FPBAO4bf5vnOSwYnno5M3
fD7f/T+fLt+/NLAVEp8RCopPuEN5uB6NEEYpgh/fhfUxiiEWJUxTQftunPCA
4ojHhPWHtIe9XcJdKmpPJggb6yKB1RVh/RGl0E8p9FJJ+36a8CIg0pgl608p
gwHKeM9h/fCAvP0cYIiOtd+mLLopi/U1Yf2sIbL4+kVk0Ucn2l+9FDksLYoc
5sj6FB15+z/y9mHd3auH8himsnZ3r/Z98vBvCOtvXosCVpZFAb8uhPUZKnr3
K3r7PtV+j0q69/fbwvr5T1HSvd6iivZ3b8Wx7q19J+tuH+N0guZvYd29700q
4wlVtbv3SSVFGeEPwrp73oBfnHq/g5r2eargMVUQ3BTWR6iq87IlrLeaoqrz
GdW174RFTefHHWF9geo6275pd9/dbP+frf/f/JtO7/ROv879CtKV46s=
      "], #]]& ),
   ColorFunctionScaling->False],
  ImageSize->{361, 213},
  PlotRange->{{0, 360}, {0, 212}}]], "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
 CellLabel->"Out[11]=",
 CellID->12078]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,12"},
 CellLabel->"In[12]:=",
 CellID->3585],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,13"},
 CellLabel->"In[13]:=",
 CellID->2257]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDateTime",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExpr",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExpr"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8456],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Data Type Mapping in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->479345902],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->369489441]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLBinary - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 29.6720053}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLBinary[data] represents raw binary data that can be stored in a \
database.", "synonyms" -> {}, "title" -> "SQLBinary", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLBinary"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3318, 102, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:6.1.1"->{
  Cell[4384, 140, 270, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,2"},
   CellID->7975],
  Cell[10714, 280, 250, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,5"},
   CellID->26803],
  Cell[12398, 326, 259, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,7"},
   CellID->6272],
  Cell[12724, 338, 320, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,8"},
   CellID->29383],
  Cell[13113, 351, 252, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,9"},
   CellID->1775],
  Cell[13446, 363, 327, 10, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,10"},
   CellID->23569],
  Cell[13867, 380, 199, 5, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
   CellID->17954],
  Cell[14069, 387, 4418, 78, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
   CellID->12078],
  Cell[18502, 468, 261, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,12"},
   CellID->3585],
  Cell[18766, 478, 222, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,13"},
   CellID->2257]},
 "Ex--21943492438155078303,2"->{
  Cell[4384, 140, 270, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,2"},
   CellID->7975]},
 "Ex--21950856252955103714,4"->{
  Cell[4657, 150, 445, 12, 70, "Input",
   CellTags->"Ex--21950856252955103714,4",
   CellID->10556]},
 "Ex--21943492438155078303,4"->{
  Cell[5183, 169, 308, 10, 70, "Input",
   CellTags->"Ex--21943492438155078303,4",
   CellID->31495],
  Cell[5494, 181, 5093, 91, 70, "Output",
   CellTags->"Ex--21943492438155078303,4",
   CellID->8044]},
 "Ex--21943492438155078303,5"->{
  Cell[10714, 280, 250, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,5"},
   CellID->26803]},
 "Ex--21943492438155078303,6"->{
  Cell[11060, 294, 175, 5, 70, "Input",
   CellTags->"Ex--21943492438155078303,6",
   CellID->18915],
  Cell[11238, 301, 979, 15, 70, "Output",
   CellTags->"Ex--21943492438155078303,6",
   CellID->7450]},
 "Ex--21943492438155078303,7"->{
  Cell[12398, 326, 259, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,7"},
   CellID->6272]},
 "Ex--21943492438155078303,8"->{
  Cell[12724, 338, 320, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,8"},
   CellID->29383]},
 "Ex--21943492438155078303,9"->{
  Cell[13113, 351, 252, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,9"},
   CellID->1775]},
 "Ex--21943492438155078303,10"->{
  Cell[13446, 363, 327, 10, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,10"},
   CellID->23569]},
 "Ex--21943492438155078303,11"->{
  Cell[13867, 380, 199, 5, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
   CellID->17954],
  Cell[14069, 387, 4418, 78, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
   CellID->12078]},
 "Ex--21943492438155078303,12"->{
  Cell[18502, 468, 261, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,12"},
   CellID->3585]},
 "Ex--21943492438155078303,13"->{
  Cell[18766, 478, 222, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,13"},
   CellID->2257]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22557, 608},
 {"b:6.1.1", 22683, 612},
 {"Ex--21943492438155078303,2", 23870, 643},
 {"Ex--21950856252955103714,4", 24017, 647},
 {"Ex--21943492438155078303,4", 24153, 651},
 {"Ex--21943492438155078303,5", 24392, 658},
 {"Ex--21943492438155078303,6", 24541, 662},
 {"Ex--21943492438155078303,7", 24780, 669},
 {"Ex--21943492438155078303,8", 24928, 673},
 {"Ex--21943492438155078303,9", 25077, 677},
 {"Ex--21943492438155078303,10", 25226, 681},
 {"Ex--21943492438155078303,11", 25378, 685},
 {"Ex--21943492438155078303,12", 25648, 692},
 {"Ex--21943492438155078303,13", 25798, 696}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2159, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2782, 80, 46, 1, 70, "ObjectName",
 CellID->9458],
Cell[2831, 83, 450, 14, 70, "Usage",
 CellID->25967]
}, Open  ]],
Cell[CellGroupData[{
Cell[3318, 102, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3695, 116, 147, 5, 70, "ExampleSection",
 CellID->76261319],
Cell[3845, 123, 135, 3, 70, "Input",
 CellID->328489522],
Cell[3983, 128, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4384, 140, 270, 8, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,2"},
 CellID->7975],
Cell[4657, 150, 445, 12, 70, "Input",
 CellTags->"Ex--21950856252955103714,4",
 CellID->10556],
Cell[5105, 164, 53, 1, 70, "ExampleText",
 CellID->7531],
Cell[CellGroupData[{
Cell[5183, 169, 308, 10, 70, "Input",
 CellTags->"Ex--21943492438155078303,4",
 CellID->31495],
Cell[5494, 181, 5093, 91, 70, "Output",
 CellTags->"Ex--21943492438155078303,4",
 CellID->8044]
}, Open  ]],
Cell[10602, 275, 109, 3, 70, "ExampleText",
 CellID->30591],
Cell[10714, 280, 250, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,5"},
 CellID->26803],
Cell[10967, 289, 68, 1, 70, "ExampleText",
 CellID->3388],
Cell[CellGroupData[{
Cell[11060, 294, 175, 5, 70, "Input",
 CellTags->"Ex--21943492438155078303,6",
 CellID->18915],
Cell[11238, 301, 979, 15, 70, "Output",
 CellTags->"Ex--21943492438155078303,6",
 CellID->7450]
}, Open  ]],
Cell[12232, 319, 163, 5, 70, "ExampleText",
 CellID->12319],
Cell[12398, 326, 259, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,7"},
 CellID->6272],
Cell[12660, 335, 61, 1, 70, "ExampleText",
 CellID->25791],
Cell[12724, 338, 320, 8, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,8"},
 CellID->29383],
Cell[13047, 348, 63, 1, 70, "ExampleText",
 CellID->10133],
Cell[13113, 351, 252, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,9"},
 CellID->1775],
Cell[13368, 360, 75, 1, 70, "ExampleText",
 CellID->24642],
Cell[13446, 363, 327, 10, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,10"},
 CellID->23569],
Cell[13776, 375, 66, 1, 70, "ExampleText",
 CellID->18300],
Cell[CellGroupData[{
Cell[13867, 380, 199, 5, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
 CellID->17954],
Cell[14069, 387, 4418, 78, 70, "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,11"},
 CellID->12078]
}, Open  ]],
Cell[18502, 468, 261, 8, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,12"},
 CellID->3585],
Cell[18766, 478, 222, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,13"},
 CellID->2257]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19037, 491, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19356, 502, 485, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19878, 524, 313, 9, 70, "TutorialsSection",
 CellID->8456],
Cell[20194, 535, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[20484, 546, 443, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[20964, 563, 319, 9, 70, "MoreAboutSection",
 CellID->479345902],
Cell[21286, 574, 188, 4, 70, "MoreAbout",
 CellID->369489441]
}, Open  ]],
Cell[21489, 581, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

