(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22192,        791]
NotebookOptionsPosition[     16643,        590]
NotebookOutlinePosition[     19120,        671]
CellTagsIndexPosition[     19011,        665]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"], 
          "Column Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure"], 
          "Column Representation in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure#2154"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Creating Tables in DatabaseLink User Guide\"\>", 
       3->"\<\"Column Structure in DatabaseLink User Guide\"\>", 
       4->"\<\"Column Representation in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLCreateTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLCreateTable"], 
          "SQLColumn" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumn"], 
          "SQLColumns" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumns"], 
          "SQLColumnInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLColumnInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SQLCreateTable\"\>", 
       2->"\<\"SQLColumn\"\>", 3->"\<\"SQLColumns\"\>", 
       4->"\<\"SQLColumnInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLColumnNames", "ObjectName",
 CellID->12295],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLColumnNames", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a list of ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["table", "TI"], ",", 
        StyleBox["name", "TI"]}], "}"}]], "InlineFormula"],
     " pairs for each column in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25428]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->29681],

Cell[BoxData[GridBox[{
   {"\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {"\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTable",
 CellID->18490]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335966591],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->362355746],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->171065796],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->27633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnNames", "[", "conn", "]"}], "//", "Short"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[3]:=",
 CellID->27037],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_TYPE\"\>"}], "}"}], 
    ",", 
    RowBox[{"\[LeftSkeleton]", "404", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], "}"}],
  Short]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[3]//Short=",
 CellID->23893]
}, Open  ]],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["table", "TI"], ",", " ", 
    StyleBox["column", "TI"]}], "}"}]], "InlineFormula"],
 " pairs from tables whose names start with \"SA\":"
}], "ExampleText",
 CellID->22630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<SA%\>\""}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[4]:=",
 CellID->20274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[4]=",
 CellID->12993]
}, Open  ]],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["table", "TI"], ",", " ", 
    StyleBox["column", "TI"]}], "}"}]], "InlineFormula"],
 " pairs from a particular table:"
}], "ExampleText",
 CellID->28782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[5]:=",
 CellID->32203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[5]=",
 CellID->17461]
}, Open  ]],

Cell["Here is another way:", "ExampleText",
 CellID->8290],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->19662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<SAMPLETABLE1\>\"", ",", "\"\<%\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[7]:=",
 CellID->22307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[7]=",
 CellID->20997]
}, Open  ]],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["table", "TI"], ",", " ", 
    StyleBox["column", "TI"]}], "}"}]], "InlineFormula"],
 " pairs for columns whose names begin with \"V\" in any table:"
}], "ExampleText",
 CellID->31151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<%\>\"", ",", "\"\<V%\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[8]:=",
 CellID->18423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[8]=",
 CellID->8890]
}, Open  ]],

Cell["Here is another way:", "ExampleText",
 CellID->16717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"SQLColumn", "[", "\"\<V%\>\"", "]"}]}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[9]:=",
 CellID->6640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_CATALOG\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[9]=",
 CellID->28703]
}, Open  ]],

Cell["Extract just the column names:", "ExampleText",
 CellID->5566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumnNames", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[10]:=",
 CellID->4883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ENTRY\"\>", ",", "\<\"VALUE\"\>", ",", "\<\"NAME\"\>"}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[10]=",
 CellID->23661]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[11]:=",
 CellID->22659]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26610],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumns",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumns"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumnInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31071],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Column Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"]
}], "Tutorials",
 CellID->294321021],

Cell[TextData[{
 ButtonBox["Column Representation in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"]
}], "Tutorials",
 CellID->510020099]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLColumnNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 33.7501042}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLColumnNames[conn] returns a list of {table, name} pairs for each \
column in an SQL connection.", "synonyms" -> {}, "title" -> "SQLColumnNames", 
    "type" -> "Symbol", "uri" -> "DatabaseLink/ref/SQLColumnNames"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4694, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->335966591]},
 "b:3.3"->{
  Cell[5996, 193, 157, 5, 70, "Input",
   CellTags->"b:3.3",
   CellID->27037],
  Cell[6156, 200, 402, 13, 70, "Output",
   CellTags->"b:3.3",
   CellID->23893],
  Cell[6851, 229, 167, 5, 70, "Input",
   CellTags->"b:3.3",
   CellID->20274],
  Cell[7021, 236, 384, 12, 70, "Output",
   CellTags->"b:3.3",
   CellID->12993],
  Cell[7680, 264, 207, 6, 70, "Input",
   CellTags->"b:3.3",
   CellID->32203],
  Cell[7890, 272, 384, 12, 70, "Output",
   CellTags->"b:3.3",
   CellID->17461],
  Cell[8510, 298, 236, 8, 70, "Input",
   CellTags->"b:3.3",
   CellID->22307],
  Cell[8749, 308, 384, 12, 70, "Output",
   CellTags->"b:3.3",
   CellID->20997],
  Cell[9438, 336, 223, 7, 70, "Input",
   CellTags->"b:3.3",
   CellID->18423],
  Cell[9664, 345, 1280, 36, 70, "Output",
   CellTags->"b:3.3",
   CellID->8890],
  Cell[11043, 389, 197, 6, 70, "Input",
   CellTags->"b:3.3",
   CellID->6640],
  Cell[11243, 397, 1281, 36, 70, "Output",
   CellTags->"b:3.3",
   CellID->28703],
  Cell[12632, 441, 286, 9, 70, "Input",
   CellTags->"b:3.3",
   CellID->4883],
  Cell[12921, 452, 181, 6, 70, "Output",
   CellTags->"b:3.3",
   CellID->23661]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17719, 615},
 {"b:3.3", 17851, 619}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2294, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2917, 78, 52, 1, 70, "ObjectName",
 CellID->12295],
Cell[2972, 81, 587, 18, 70, "Usage",
 CellID->25428]
}, Open  ]],
Cell[CellGroupData[{
Cell[3596, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4074, 121, 69, 1, 70, "Notes",
 CellID->29681],
Cell[4146, 124, 511, 15, 70, "3ColumnTable",
 CellID->18490]
}, Closed]],
Cell[CellGroupData[{
Cell[4694, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335966591],
Cell[CellGroupData[{
Cell[5079, 158, 148, 5, 70, "ExampleSection",
 CellID->362355746],
Cell[5230, 165, 135, 3, 70, "Input",
 CellID->171065796],
Cell[5368, 170, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5769, 182, 202, 7, 70, "Input",
 CellID->27633],
Cell[CellGroupData[{
Cell[5996, 193, 157, 5, 70, "Input",
 CellTags->"b:3.3",
 CellID->27037],
Cell[6156, 200, 402, 13, 70, "Output",
 CellTags->"b:3.3",
 CellID->23893]
}, Open  ]],
Cell[6573, 216, 253, 9, 70, "ExampleText",
 CellID->22630],
Cell[CellGroupData[{
Cell[6851, 229, 167, 5, 70, "Input",
 CellTags->"b:3.3",
 CellID->20274],
Cell[7021, 236, 384, 12, 70, "Output",
 CellTags->"b:3.3",
 CellID->12993]
}, Open  ]],
Cell[7420, 251, 235, 9, 70, "ExampleText",
 CellID->28782],
Cell[CellGroupData[{
Cell[7680, 264, 207, 6, 70, "Input",
 CellTags->"b:3.3",
 CellID->32203],
Cell[7890, 272, 384, 12, 70, "Output",
 CellTags->"b:3.3",
 CellID->17461]
}, Open  ]],
Cell[8289, 287, 58, 1, 70, "ExampleText",
 CellID->8290],
Cell[8350, 290, 135, 4, 70, "Input",
 CellID->19662],
Cell[CellGroupData[{
Cell[8510, 298, 236, 8, 70, "Input",
 CellTags->"b:3.3",
 CellID->22307],
Cell[8749, 308, 384, 12, 70, "Output",
 CellTags->"b:3.3",
 CellID->20997]
}, Open  ]],
Cell[9148, 323, 265, 9, 70, "ExampleText",
 CellID->31151],
Cell[CellGroupData[{
Cell[9438, 336, 223, 7, 70, "Input",
 CellTags->"b:3.3",
 CellID->18423],
Cell[9664, 345, 1280, 36, 70, "Output",
 CellTags->"b:3.3",
 CellID->8890]
}, Open  ]],
Cell[10959, 384, 59, 1, 70, "ExampleText",
 CellID->16717],
Cell[CellGroupData[{
Cell[11043, 389, 197, 6, 70, "Input",
 CellTags->"b:3.3",
 CellID->6640],
Cell[11243, 397, 1281, 36, 70, "Output",
 CellTags->"b:3.3",
 CellID->28703]
}, Open  ]],
Cell[12539, 436, 68, 1, 70, "ExampleText",
 CellID->5566],
Cell[CellGroupData[{
Cell[12632, 441, 286, 9, 70, "Input",
 CellTags->"b:3.3",
 CellID->4883],
Cell[12921, 452, 181, 6, 70, "Output",
 CellTags->"b:3.3",
 CellID->23661]
}, Open  ]],
Cell[13117, 461, 149, 5, 70, "Input",
 CellID->22659]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13315, 472, 311, 9, 70, "SeeAlsoSection",
 CellID->26610],
Cell[13629, 483, 1034, 35, 70, "SeeAlso",
 CellID->3760]
}, Open  ]],
Cell[CellGroupData[{
Cell[14700, 523, 314, 9, 70, "TutorialsSection",
 CellID->31071],
Cell[15017, 534, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[15307, 545, 420, 12, 70, "Tutorials",
 CellID->133710995],
Cell[15730, 559, 424, 12, 70, "Tutorials",
 CellID->294321021],
Cell[16157, 573, 444, 12, 70, "Tutorials",
 CellID->510020099]
}, Open  ]],
Cell[16616, 588, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

