(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32132,        964]
NotebookOptionsPosition[     27099,        783]
NotebookOutlinePosition[     29231,        852]
CellTagsIndexPosition[     29122,        846]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"], 
          "Column Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure"], 
          "Column Representation in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ColumnStructure#2154"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Creating Tables in DatabaseLink User Guide\"\>", 
       3->"\<\"Column Structure in DatabaseLink User Guide\"\>", 
       4->"\<\"Column Representation in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLCreateTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLCreateTable"], 
          "SQLColumn" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumn"], 
          "SQLColumnNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLColumnNames"], 
          "SQLColumnInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLColumnInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SQLCreateTable\"\>", 
       2->"\<\"SQLColumn\"\>", 3->"\<\"SQLColumnNames\"\>", 
       4->"\<\"SQLColumnInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLColumns", "ObjectName",
 CellID->29866],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLColumns", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the ",
     Cell[BoxData["SQLColumn"], "InlineFormula"],
     " objects for each column in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->30308],

Cell[BoxData[GridBox[{
   {"\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {"\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTable",
 CellID->28223]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8963111],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->290157320],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->146438787],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->19814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLColumns", "[", "conn", "]"}], "//", 
  RowBox[{
   RowBox[{"Short", "[", 
    RowBox[{"#", ",", " ", "15"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16090],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_TYPE\"\>"}], "}"}], 
      ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "0"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "32"}]}], "]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_CAT\"\>"}], "}"}], 
      ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_SCHEM\"\>"}], "}"}],
       ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"OBJECT_NAME\"\>"}], "}"}], 
      ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "0"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
    RowBox[{"\[LeftSkeleton]", "398", "\[RightSkeleton]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"TABLE_NAME\"\>"}],
        "}"}], ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
      RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
      RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
      RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
   "}"}],
  Short[#, 15]& ]], "Output",
 CellLabel->"Out[3]//Short=",
 CellID->5427]
}, Open  ]],

Cell["Get all columns from tables whose names start with \"SA\":", \
"ExampleText",
 CellID->23743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", " ", "\"\<SA%\>\""}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[4]:=",
 CellID->1604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[4]=",
 CellID->10599]
}, Open  ]],

Cell["Get all columns from a particular table:", "ExampleText",
 CellID->16474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"SQLTable", "[", "\"\<SAMPLETABLE1\>\"", "]"}]}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[5]:=",
 CellID->7195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[5]=",
 CellID->506]
}, Open  ]],

Cell["Here is another way:", "ExampleText",
 CellID->5158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<SAMPLETABLE1\>\"", ",", "\"\<%\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[6]:=",
 CellID->17589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"ENTRY\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"INTEGER\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"NAME\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[6]=",
 CellID->9858]
}, Open  ]],

Cell["Get columns whose names begin with \"V\" from all tables:", \
"ExampleText",
 CellID->27809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<%\>\"", ",", "\"\<V%\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[7]:=",
 CellID->17889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"BOOLEAN\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], 
     ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "0"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}],
       "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
       ",", "\<\"VIEW_CATALOG\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", 
       ",", "\<\"VIEW_CATALOG\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}],
      ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
      "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
      "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
       ",", "\<\"VIEW_SCHEMA\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}],
       "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[7]=",
 CellID->11447]
}, Open  ]],

Cell["Here is another way:", "ExampleText",
 CellID->40],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumns", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"SQLColumn", "[", "\"\<V%\>\"", "]"}]}], "]"}]], "Input",
 CellTags->"b:3.3",
 CellLabel->"In[8]:=",
 CellID->3818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VALID\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"BOOLEAN\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", "\<\"VALUE\"\>"}], "}"}], 
     ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "0"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SAMPLETABLE1\"\>", ",", "\<\"VALUE\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"DOUBLE\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "Null"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", "\<\"VARCHAR_SEPARATOR\"\>"}],
       "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
       ",", "\<\"VIEW_CATALOG\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", 
       ",", "\<\"VIEW_CATALOG\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", "\<\"VIEW_DEFINITION\"\>"}], "}"}],
      ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
      "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_NAME\"\>"}], 
      "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
       ",", "\<\"VIEW_SCHEMA\"\>"}], "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}], ",", 
   RowBox[{"SQLColumn", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"VIEW_SCHEMA\"\>"}],
       "}"}], ",", 
     RowBox[{"\<\"DataTypeName\"\>", "\[Rule]", "\<\"VARCHAR\"\>"}], ",", 
     RowBox[{"\<\"Nullable\"\>", "\[Rule]", "1"}], ",", 
     RowBox[{"\<\"DataLength\"\>", "\[Rule]", "2147483647"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.3",
 CellLabel->"Out[8]=",
 CellID->9364]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[9]:=",
 CellID->17975]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18684],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumnNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLColumnInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22667],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->133710995],

Cell[TextData[{
 ButtonBox["Column Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"]
}], "Tutorials",
 CellID->294321021],

Cell[TextData[{
 ButtonBox["Column Representation in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure#2154"]
}], "Tutorials",
 CellID->510020099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->247482334],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->54272910]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLColumns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 36.6094609}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLColumns[conn] returns the SQLColumn objects for each column in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLColumns", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLColumns"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5189, 156, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8963111]},
 "b:3.3"->{
  Cell[9926, 292, 162, 5, 70, "Input",
   CellTags->"b:3.3",
   CellID->1604],
  Cell[10091, 299, 1139, 27, 70, "Output",
   CellTags->"b:3.3",
   CellID->10599],
  Cell[11349, 334, 202, 6, 70, "Input",
   CellTags->"b:3.3",
   CellID->7195],
  Cell[11554, 342, 1137, 27, 70, "Output",
   CellTags->"b:3.3",
   CellID->506],
  Cell[12789, 377, 232, 8, 70, "Input",
   CellTags->"b:3.3",
   CellID->17589],
  Cell[13024, 387, 1138, 27, 70, "Output",
   CellTags->"b:3.3",
   CellID->9858],
  Cell[14300, 423, 219, 7, 70, "Input",
   CellTags->"b:3.3",
   CellID->17889],
  Cell[14522, 432, 4108, 92, 70, "Output",
   CellTags->"b:3.3",
   CellID->11447],
  Cell[18726, 532, 193, 6, 70, "Input",
   CellTags->"b:3.3",
   CellID->3818],
  Cell[18922, 540, 4107, 92, 70, "Output",
   CellTags->"b:3.3",
   CellID->9364]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28151, 808},
 {"b:3.3", 28281, 812}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2905, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3528, 94, 48, 1, 70, "ObjectName",
 CellID->29866],
Cell[3579, 97, 475, 14, 70, "Usage",
 CellID->30953]
}, Open  ]],
Cell[CellGroupData[{
Cell[4091, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4569, 133, 69, 1, 70, "Notes",
 CellID->30308],
Cell[4641, 136, 511, 15, 70, "3ColumnTable",
 CellID->28223]
}, Closed]],
Cell[CellGroupData[{
Cell[5189, 156, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8963111],
Cell[CellGroupData[{
Cell[5572, 170, 148, 5, 70, "ExampleSection",
 CellID->290157320],
Cell[5723, 177, 135, 3, 70, "Input",
 CellID->146438787],
Cell[5861, 182, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6262, 194, 202, 7, 70, "Input",
 CellID->19814],
Cell[CellGroupData[{
Cell[6489, 205, 211, 7, 70, "Input",
 CellID->16090],
Cell[6703, 214, 3084, 69, 70, "Output",
 CellID->5427]
}, Open  ]],
Cell[9802, 286, 99, 2, 70, "ExampleText",
 CellID->23743],
Cell[CellGroupData[{
Cell[9926, 292, 162, 5, 70, "Input",
 CellTags->"b:3.3",
 CellID->1604],
Cell[10091, 299, 1139, 27, 70, "Output",
 CellTags->"b:3.3",
 CellID->10599]
}, Open  ]],
Cell[11245, 329, 79, 1, 70, "ExampleText",
 CellID->16474],
Cell[CellGroupData[{
Cell[11349, 334, 202, 6, 70, "Input",
 CellTags->"b:3.3",
 CellID->7195],
Cell[11554, 342, 1137, 27, 70, "Output",
 CellTags->"b:3.3",
 CellID->506]
}, Open  ]],
Cell[12706, 372, 58, 1, 70, "ExampleText",
 CellID->5158],
Cell[CellGroupData[{
Cell[12789, 377, 232, 8, 70, "Input",
 CellTags->"b:3.3",
 CellID->17589],
Cell[13024, 387, 1138, 27, 70, "Output",
 CellTags->"b:3.3",
 CellID->9858]
}, Open  ]],
Cell[14177, 417, 98, 2, 70, "ExampleText",
 CellID->27809],
Cell[CellGroupData[{
Cell[14300, 423, 219, 7, 70, "Input",
 CellTags->"b:3.3",
 CellID->17889],
Cell[14522, 432, 4108, 92, 70, "Output",
 CellTags->"b:3.3",
 CellID->11447]
}, Open  ]],
Cell[18645, 527, 56, 1, 70, "ExampleText",
 CellID->40],
Cell[CellGroupData[{
Cell[18726, 532, 193, 6, 70, "Input",
 CellTags->"b:3.3",
 CellID->3818],
Cell[18922, 540, 4107, 92, 70, "Output",
 CellTags->"b:3.3",
 CellID->9364]
}, Open  ]],
Cell[23044, 635, 148, 5, 70, "Input",
 CellID->17975]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23241, 646, 311, 9, 70, "SeeAlsoSection",
 CellID->18684],
Cell[23555, 657, 1042, 35, 70, "SeeAlso",
 CellID->3760]
}, Open  ]],
Cell[CellGroupData[{
Cell[24634, 697, 314, 9, 70, "TutorialsSection",
 CellID->22667],
Cell[24951, 708, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[25241, 719, 420, 12, 70, "Tutorials",
 CellID->133710995],
Cell[25664, 733, 424, 12, 70, "Tutorials",
 CellID->294321021],
Cell[26091, 747, 444, 12, 70, "Tutorials",
 CellID->510020099]
}, Open  ]],
Cell[CellGroupData[{
Cell[26572, 764, 319, 9, 70, "MoreAboutSection",
 CellID->247482334],
Cell[26894, 775, 163, 3, 70, "MoreAbout",
 CellID->54272910]
}, Open  ]],
Cell[27072, 781, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

