(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14678,        514]
NotebookOptionsPosition[     11255,        397]
NotebookOutlinePosition[     12538,        434]
CellTagsIndexPosition[     12453,        429]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Database Connections in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections"], 
          "Establishing a Connection in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#16139"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"Database Connections in DatabaseLink User Guide\"\>", 
       3->"\<\"Establishing a Connection in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "CloseSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/CloseSQLConnection"], "SQLConnections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLConnections"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 
       2->"\<\"CloseSQLConnection\"\>", 
       3->"\<\"SQLConnections\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLConnection", "ObjectName",
 CellID->10946],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnection", "[", 
       StyleBox["\[Ellipsis]", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that represents a connection to a data \
source."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19103]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SQLConnections",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLConnections"]], "InlineFormula"],
 " both return an ",
 StyleBox["SQLConnection", "MR"],
 " object."
}], "Notes",
 CellID->30231],

Cell[TextData[{
 "The following options can be modified in an ",
 StyleBox["SQLConnection", "MR"],
 " object:"
}], "Notes",
 CellID->236494485],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Catalog\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the catalog for the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadOnly\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the connection to be read only", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TransactionIsolationLevel\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[StyleBox[
    "set transaction isolation for the connection", "TableText"]], 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->133059716]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->438715315],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->25689997],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->177592308],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell["Create connections:", "ExampleText",
 CellID->21862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn1", "=", 
  RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32072],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>"}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->71689409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn2", "=", 
  RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2480],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "2", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->127122573]
}, Open  ]],

Cell["List connections:", "ExampleText",
 CellID->26897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnections", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLConnection", "[", 
    RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>"}], "]"}], ",", 
   RowBox[{"SQLConnection", "[", 
    RowBox[{"\<\"publisher\"\>", ",", "2", ",", "\<\"Open\"\>"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->203419470]
}, Open  ]],

Cell[TextData[{
 "This sets the ",
 StyleBox["ReadOnly", "MR"],
 " option on one of the connections to ",
 StyleBox["True", "MR"],
 "."
}], "ExampleText",
 CellID->246445538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"conn1", ",", 
   RowBox[{"ReadOnly", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->136402261],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>", ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->402895236]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn1", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[6]:=",
 CellID->19203],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn2", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[7]:=",
 CellID->23277]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnections",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnections"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3394],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Database Connections in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections"]
}], "Tutorials",
 CellID->204035945],

Cell[TextData[{
 ButtonBox["Establishing a Connection in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLConnection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 39.6406915}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLConnection[...] is an object that represents a connection to a data \
source.", "synonyms" -> {}, "title" -> "SQLConnection", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLConnection"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5196, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->438715315]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12310, 422}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1993, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2616, 72, 51, 1, 70, "ObjectName",
 CellID->10946],
Cell[2670, 75, 429, 13, 70, "Usage",
 CellID->19103]
}, Open  ]],
Cell[CellGroupData[{
Cell[3136, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3614, 110, 418, 15, 70, "Notes",
 CellID->30231],
Cell[4035, 127, 143, 5, 70, "Notes",
 CellID->236494485],
Cell[4181, 134, 978, 23, 70, "3ColumnTableMod",
 CellID->133059716]
}, Closed]],
Cell[CellGroupData[{
Cell[5196, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->438715315],
Cell[CellGroupData[{
Cell[5581, 176, 147, 5, 70, "ExampleSection",
 CellID->25689997],
Cell[5731, 183, 135, 3, 70, "Input",
 CellID->177592308],
Cell[5869, 188, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6270, 200, 58, 1, 70, "ExampleText",
 CellID->21862],
Cell[CellGroupData[{
Cell[6353, 205, 147, 4, 70, "Input",
 CellID->32072],
Cell[6503, 211, 164, 4, 70, "Output",
 CellID->71689409]
}, Open  ]],
Cell[CellGroupData[{
Cell[6704, 220, 151, 4, 70, "Input",
 CellID->2480],
Cell[6858, 226, 173, 5, 70, "Output",
 CellID->127122573]
}, Open  ]],
Cell[7046, 234, 56, 1, 70, "ExampleText",
 CellID->26897],
Cell[CellGroupData[{
Cell[7127, 239, 100, 3, 70, "Input",
 CellID->3542],
Cell[7230, 244, 320, 9, 70, "Output",
 CellID->203419470]
}, Open  ]],
Cell[7565, 256, 174, 7, 70, "ExampleText",
 CellID->246445538],
Cell[CellGroupData[{
Cell[7764, 267, 173, 5, 70, "Input",
 CellID->136402261],
Cell[7940, 274, 223, 5, 70, "Output",
 CellID->402895236]
}, Open  ]],
Cell[8178, 282, 168, 6, 70, "Input",
 CellID->19203],
Cell[8349, 290, 168, 6, 70, "Input",
 CellID->23277]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8566, 302, 311, 9, 70, "SeeAlsoSection",
 CellID->20829],
Cell[8880, 313, 784, 26, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[9701, 344, 313, 9, 70, "TutorialsSection",
 CellID->3394],
Cell[10017, 355, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10307, 366, 440, 12, 70, "Tutorials",
 CellID->204035945],
Cell[10750, 380, 463, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[11228, 395, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

