(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21783,        572]
NotebookOptionsPosition[     18382,        468]
NotebookOutlinePosition[     20301,        521]
CellTagsIndexPosition[     20143,        514]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Connection Information in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DatabaseConnections#37361426"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>",
        2->"\<\"Connection Information in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "CloseSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/CloseSQLConnection"], "SQLConnections" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLConnections"], 
          "SQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLConnection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 
       2->"\<\"CloseSQLConnection\"\>", 3->"\<\"SQLConnections\"\>", 
       4->"\<\"SQLConnection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLConnectionInformation", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnectionInformation", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a list of information about the SQL \
connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->171691359],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->26155970],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell["Open a connection to a sample database:", "ExampleText",
 CellID->1535425884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", " ", "=", " ", 
  RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}]], "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellLabel->"In[2]:=",
 CellID->279939859],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"demo\"\>", ",", "1", ",", "\<\"Open\"\>"}], "]"}]], "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellLabel->"Out[2]=",
 CellID->76385560]
}, Open  ]],

Cell["Get information about the connection:", "ExampleText",
 CellID->1739330036],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"SQLConnectionInformation", "[", "conn", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->248529233],

Cell["\<\
Display a tidier form of the information about the connection:\
\>", "ExampleText",
 CellID->1372512088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Transpose", "[", "data", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->231267409],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"AllProceduresAreCallable\"\>", "True"},
    {"\<\"AllTablesAreSelectable\"\>", "True"},
    {"\<\"CatalogSeparator\"\>", "\<\"\"\>"},
    {"\<\"CatalogTerm\"\>", "\<\"\"\>"},
    {"\<\"DatabaseMajorVersion\"\>", "1"},
    {"\<\"DatabaseMinorVersion\"\>", "8"},
    {"\<\"DatabaseProductName\"\>", "\<\"HSQL Database Engine\"\>"},
    {"\<\"DatabaseProductVersion\"\>", "\<\"1.8.0\"\>"},
    {"\<\"DataDefinitionCausesTransactionCommit\"\>", "True"},
    {"\<\"DataDefinitionIgnoredInTransactions\"\>", "False"},
    {"\<\"DefaultTransactionIsolationLevel\"\>", "\<\"ReadUncommitted\"\>"},
    {"\<\"DeletesAreDetectedForForwardOnly\"\>", "False"},
    {"\<\"DeletesAreDetectedForScrollInsensitive\"\>", "False"},
    {"\<\"DeletesAreDetectedForScrollSensitive\"\>", "False"},
    {"\<\"DoesMaxRowSizeIncludeBlobs\"\>", "True"},
    {"\<\"DriverMajorVersion\"\>", "1"},
    {"\<\"DriverMinorVersion\"\>", "8"},
    {"\<\"DriverName\"\>", "\<\"HSQL Database Engine Driver\"\>"},
    {"\<\"DriverVersion\"\>", "\<\"1.8.0\"\>"},
    {"\<\"ExtraNameCharacters\"\>", "\<\"\"\>"},
    {"\<\"IdentifierQuoteString\"\>", "\<\"\\\"\"\>"},
    {"\<\"InsertsAreDetectedForForwardOnly\"\>", "False"},
    {"\<\"InsertsAreDetectedForScrollInsensitive\"\>", "False"},
    {"\<\"InsertsAreDetectedForScrollSensitive\"\>", "False"},
    {"\<\"IsCatalogAtStartOfTableName\"\>", "False"},
    {"\<\"JDBCMajorVersion\"\>", "3"},
    {"\<\"JDBCMinorVersion\"\>", "0"},
    {"\<\"LocatorsUpdateCopy\"\>", "False"},
    {"\<\"MaxBinaryLiteralLength\"\>", "0"},
    {"\<\"MaxCatalogNameLength\"\>", "0"},
    {"\<\"MaxCharLiteralLength\"\>", "0"},
    {"\<\"MaxColumnNameLength\"\>", "0"},
    {"\<\"MaxColumnsInGroupBy\"\>", "0"},
    {"\<\"MaxColumnsInIndex\"\>", "0"},
    {"\<\"MaxColumnsInOrderBy\"\>", "0"},
    {"\<\"MaxColumnsInSelect\"\>", "0"},
    {"\<\"MaxColumnsInTable\"\>", "0"},
    {"\<\"MaxConnections\"\>", "0"},
    {"\<\"MaxCursorNameLength\"\>", "0"},
    {"\<\"MaxIndexLength\"\>", "0"},
    {"\<\"MaxProcedureNameLength\"\>", "0"},
    {"\<\"MaxRowSize\"\>", "0"},
    {"\<\"MaxSchemaNameLength\"\>", "0"},
    {"\<\"MaxStatementLength\"\>", "0"},
    {"\<\"MaxStatements\"\>", "0"},
    {"\<\"MaxTableNameLength\"\>", "0"},
    {"\<\"MaxTablesInSelect\"\>", "0"},
    {"\<\"MaxUserNameLength\"\>", "0"},
    {"\<\"NullPlusNonNullIsNull\"\>", "True"},
    {"\<\"NullsAreSortedAtEnd\"\>", "False"},
    {"\<\"NullsAreSortedAtStart\"\>", "False"},
    {"\<\"NullsAreSortedHight\"\>", "False"},
    {"\<\"NullsAreSortedLow\"\>", "True"},
    {"\<\"NumericFunctions\"\>", \
"\<\"ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,\
PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,BITAND,BITOR,BITXOR,\
ROUNDMAGIC\"\>"},
    {"\<\"OthersDeletesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OthersDeletesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OthersDeletesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OthersInsertsAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OthersInsertsAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OthersInsertsAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OthersUpdatesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OthersUpdatesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OthersUpdatesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OwnDeletesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OwnDeletesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OwnDeletesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OwnInsertsAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OwnInsertsAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OwnInsertsAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"OwnUpdatesAreVisibleForForwardOnly\"\>", "False"},
    {"\<\"OwnUpdatesAreVisibleForScrollInsensitive\"\>", "False"},
    {"\<\"OwnUpdatesAreVisibleForScrollSensitive\"\>", "False"},
    {"\<\"ProcedureTerm\"\>", "\<\"\"\>"},
    {"\<\"ReadOnly\"\>", "False"},
    {"\<\"SchemaTerm\"\>", "\<\"SCHEMA\"\>"},
    {"\<\"SearchStringEscape\"\>", "\<\"\\\\\"\>"},
    {"\<\"SQLKeywords\"\>", \
"\<\"BEFORE,BIGINT,BINARY,CACHED,DATETIME,LIMIT,LONGVARBINARY,LONGVARCHAR,\
OBJECT,OTHER,SAVEPOINT,TEMP,TEXT,TOP,TRIGGER,TINYINT,VARBINARY,VARCHAR_\
IGNORECASE\"\>"},
    {"\<\"SQLStateType\"\>", "\<\"XOpen\"\>"},
    {"\<\"StoresLowerCaseIdentifiers\"\>", "False"},
    {"\<\"StoresLowerCaseQuotedIdentifiers\"\>", "False"},
    {"\<\"StoresMixedCaseIdentifiers\"\>", "False"},
    {"\<\"StoresMixedCaseQuotedIdentifiers\"\>", "False"},
    {"\<\"StoresUpperCaseIdentifiers\"\>", "True"},
    {"\<\"StoresUpperCaseQuotedIdentifiers\"\>", "False"},
    {"\<\"StringFunctions\"\>", \
"\<\"ASCII,BIT_LENGTH,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,DIFFERENCE,\
HEXTORAW,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,OCTET_LENGTH,RAWTOHEX,REPEAT,\
REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTR,SUBSTRING,UCASE,LOWER,UPPER\"\>"},
    {"\<\"SupportsAlterTableWithAddColumn\"\>", "True"},
    {"\<\"SupportsAlterTableWithDropColumn\"\>", "True"},
    {"\<\"SupportsANSI92EntryLevelSQL\"\>", "False"},
    {"\<\"SupportsANSI92FullSQL\"\>", "False"},
    {"\<\"SupportsANSI92IntermediateSQL\"\>", "False"},
    {"\<\"SupportsBatchUpdates\"\>", "True"},
    {"\<\"SupportsCatalogsInDataManipulation\"\>", "False"},
    {"\<\"SupportsCatalogsInIndexDefinitions\"\>", "False"},
    {"\<\"SupportsCatalogsInPrivilegeDefinitions\"\>", "False"},
    {"\<\"SupportsCatalogsInProcedureCalls\"\>", "False"},
    {"\<\"SupportsCatalogsInTableDefinitions\"\>", "False"},
    {"\<\"SupportsColumnAliasing\"\>", "True"},
    {"\<\"SupportsConvert\"\>", "True"},
    {"\<\"SupportsCoreSQLGrammar\"\>", "True"},
    {"\<\"SupportsCorrelatedSubqueries\"\>", "True"},
    {"\<\"SupportsDataDefinitionAndDataManipulationTransactions\"\>", 
     "False"},
    {"\<\"SupportsDataManipulationTransactionsOnly\"\>", "True"},
    {"\<\"SupportsDifferentTableCorrelationNames\"\>", "True"},
    {"\<\"SupportsExpressionsInOrderBy\"\>", "True"},
    {"\<\"SupportsExtendedSQLGrammar\"\>", "False"},
    {"\<\"SupportsForwardOnlyResultSetReadOnlyConcurrency\"\>", "True"},
    {"\<\"SupportsForwardOnlyResultSetType\"\>", "True"},
    {"\<\"SupportsForwardOnlyResultSetUpdatableConcurrency\"\>", "False"},
    {"\<\"SupportsFullOuterJoins\"\>", "False"},
    {"\<\"SupportsGetGeneratedKeys\"\>", "False"},
    {"\<\"SupportsGroupBy\"\>", "True"},
    {"\<\"SupportsGroupByBeyondSelect\"\>", "True"},
    {"\<\"SupportsGroupByUnrelated\"\>", "True"},
    {"\<\"SupportsIntegrityEnhancementFacility\"\>", "True"},
    {"\<\"SupportsLikeEscapeClause\"\>", "True"},
    {"\<\"SupportsLimitedOuterJoins\"\>", "True"},
    {"\<\"SupportsMinimumSQLGrammar\"\>", "False"},
    {"\<\"SupportsMixedCaseIdentifiers\"\>", "False"},
    {"\<\"SupportsMixedCaseQuotedIdentifiers\"\>", "True"},
    {"\<\"SupportsMultipleOpenResults\"\>", "False"},
    {"\<\"SupportsMultipleResultSets\"\>", "False"},
    {"\<\"SupportsMultipleTransactions\"\>", "True"},
    {"\<\"SupportsNamedParameters\"\>", "True"},
    {"\<\"SupportsNonNullableColumns\"\>", "True"},
    {"\<\"SupportsOpenCursorsAcrossCommit\"\>", "False"},
    {"\<\"SupportsOpenCursorsAcrossRollback\"\>", "False"},
    {"\<\"SupportsOpenStatementsAcrossCommit\"\>", "True"},
    {"\<\"SupportsOpenStatementsAcrossRollback\"\>", "True"},
    {"\<\"SupportsOrderByUnrelated\"\>", "True"},
    {"\<\"SupportsOuterJoins\"\>", "True"},
    {"\<\"SupportsPositionedDelete\"\>", "False"},
    {"\<\"SupportsPositionedUpdate\"\>", "False"},
    {"\<\"SupportsResultSetHoldCursorsOverCommitHoldability\"\>", "True"},
    {"\<\"SupportsResultSetCloseCursorsAtCommitHoldability\"\>", "False"},
    {"\<\"SupportsSavepoints\"\>", "True"},
    {"\<\"SupportsSchemasInDataManipulation\"\>", "False"},
    {"\<\"SupportsSchemasInIndexDefinitions\"\>", "True"},
    {"\<\"SupportsSchemasInPrivilegeDefinitions\"\>", "True"},
    {"\<\"SupportsSchemasInProcedureCalls\"\>", "False"},
    {"\<\"SupportsSchemasInTableDefinitions\"\>", "True"},
    {"\<\"SupportsScrollInsensitiveResultSetReadOnlyConcurrency\"\>", 
     "True"},
    {"\<\"SupportsScrollInsensitiveResultSetType\"\>", "True"},
    {"\<\"SupportsScrollInsensitiveResultSetUpdatableConcurrency\"\>", 
     "False"},
    {"\<\"SupportsScrollSensitiveResultSetReadOnlyConcurrency\"\>", "False"},
    {"\<\"SupportsScrollSensitiveResultSetType\"\>", "False"},
    {"\<\"SupportsScrollSensitiveResultSetUpdatableConcurrency\"\>", 
     "False"},
    {"\<\"SupportsSelectForUpdate\"\>", "False"},
    {"\<\"SupportsStatementPooling\"\>", "False"},
    {"\<\"SupportsStoredProcedures\"\>", "True"},
    {"\<\"SupportsSubqueriesInComparisons\"\>", "True"},
    {"\<\"SupportsSubqueriesInExists\"\>", "True"},
    {"\<\"SupportsSubqueriesInIns\"\>", "True"},
    {"\<\"SupportsSubqueriesInQuantifieds\"\>", "True"},
    {"\<\"SupportsTableCorrelationNames\"\>", "True"},
    {"\<\"SupportsReadCommitedTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsReadUncommitedTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsRepeatableReadTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsSerializableTransactionIsolationLevel\"\>", "True"},
    {"\<\"SupportsTransactions\"\>", "True"},
    {"\<\"SupportsUnion\"\>", "True"},
    {"\<\"SupportsUnionAll\"\>", "True"},
    {"\<\"SystemFunctions\"\>", "\<\"DATABASE,USER,IDENTITY\"\>"},
    {"\<\"TimeDateFunctions\"\>", \
"\<\"CURDATE,CURTIME,DATEDIFF,DAYNAME,DAY,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,\
MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,WEEK,YEAR,TO_CHAR\"\>"},
    {"\<\"UpdatesAreDetectedForForwardOnly\"\>", "False"},
    {"\<\"UpdatesAreDetectedForScrollInsensitive\"\>", "False"},
    {"\<\"UpdatesAreDetectedForScrollSensitive\"\>", "False"},
    {"\<\"URL\"\>", "\<\"jdbc:hsqldb:file:C:\\\\Documents and \
Settings\\\\twj.WRI\\\\Application Data\\\\Mathematica\\\\DatabaseResources\\\
\\Examples\\\\demo\"\>"},
    {"\<\"UserName\"\>", "\<\"SA\"\>"},
    {"\<\"UsesLocalFilePerTable\"\>", "False"},
    {"\<\"UsesLocalFiles\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[4]//TableForm=",
 CellID->891631461]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/CloseSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnections",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnections"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Connection Information in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#37361426"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#37361426"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#37361426"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLConnectionInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 38.5469485}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLConnectionInformation[conn] returns a list of information about the \
SQL connection.", "synonyms" -> {}, "title" -> "SQLConnectionInformation", 
    "type" -> "Symbol", "uri" -> "DatabaseLink/ref/SQLConnectionInformation"},
   "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3014, 89, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:2.2.0"->{
  Cell[4188, 132, 221, 5, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->279939859],
  Cell[4412, 139, 220, 5, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->76385560]},
 "Ex--21943418559164291386,425"->{
  Cell[4188, 132, 221, 5, 70, "Input",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->279939859],
  Cell[4412, 139, 220, 5, 70, "Output",
   CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
   CellID->76385560]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19478, 493},
 {"b:2.2.0", 19603, 497},
 {"Ex--21943418559164291386,425", 19879, 504}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1891, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2514, 70, 46, 0, 70, "ObjectName"],
Cell[2563, 72, 414, 12, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3014, 89, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3391, 103, 148, 5, 70, "ExampleSection",
 CellID->171691359],
Cell[3542, 110, 134, 3, 70, "Input",
 CellID->26155970],
Cell[3679, 115, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4080, 127, 83, 1, 70, "ExampleText",
 CellID->1535425884],
Cell[CellGroupData[{
Cell[4188, 132, 221, 5, 70, "Input",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellID->279939859],
Cell[4412, 139, 220, 5, 70, "Output",
 CellTags->{"b:2.2.0", "Ex--21943418559164291386,425"},
 CellID->76385560]
}, Open  ]],
Cell[4647, 147, 81, 1, 70, "ExampleText",
 CellID->1739330036],
Cell[4731, 150, 168, 5, 70, "Input",
 CellID->248529233],
Cell[4902, 157, 114, 3, 70, "ExampleText",
 CellID->1372512088],
Cell[CellGroupData[{
Cell[5041, 164, 144, 4, 70, "Input",
 CellID->231267409],
Cell[5188, 170, 10644, 203, 70, "Output",
 CellID->891631461]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15893, 380, 295, 8, 70, "SeeAlsoSection"],
Cell[16191, 390, 1052, 35, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[17280, 430, 298, 8, 70, "TutorialsSection"],
Cell[17581, 440, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[17871, 451, 469, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[18355, 466, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

