(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13560,        434]
NotebookOptionsPosition[     10754,        343]
NotebookOutlinePosition[     12057,        380]
CellTagsIndexPosition[     11972,        375]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Connection Pools in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ConnectionPools"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Connection Pools in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "SQLConnectionPools" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLConnectionPools"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 
       2->"\<\"SQLConnectionPools\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLConnectionPool", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnectionPool", "[", 
       StyleBox["\[Ellipsis]", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is an object that represents a connection pool to a \
data source."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLConnectionPools",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " returns an ",
 StyleBox["SQLConnectionPool", "MR"],
 " object."
}], "Notes",
 CellID->30231],

Cell[TextData[{
 "The following options can be modified in an ",
 StyleBox["SQLConnectionPool", "MR"],
 " object:"
}], "Notes",
 CellID->236494485],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Catalog\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "location of the database catalog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadOnly\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the connection to be read only", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TransactionIsolationLevel\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set transaction isolation for the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaximumActiveConnections\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "maximum number of connections to keep in the pool", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaximumIdleConnections\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "maximum number of idle connections to keep in the pool", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MinimumIdleConnections\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "minimum number of idle connections to keep in the pool", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->122457082]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35764667],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->549769189],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->43232557],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", " ", "=", " ", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<publisher\>\"", ",", " ", 
    RowBox[{"\"\<UseConnectionPool\>\"", " ", "\[Rule]", " ", "True"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86786838],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "1", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->51427374]
}, Open  ]],

Cell["\<\
The connection pool used to connect to the publisher database:\
\>", "ExampleText",
 CellID->1688810589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnectionPools", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482739374],

Cell[BoxData[
 RowBox[{"SQLConnectionPool", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{
      "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
       "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject320558407352321], ",", 
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
    "]"}], ",", "1", ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\\\
DatabaseResources\\\\publisher.m\"\>"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->380402458]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnectionPools",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Connection Pools in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLConnectionPool - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 41.5000546}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLConnectionPool[...] is an object that represents a connection pool to \
a data source.", "synonyms" -> {}, "title" -> "SQLConnectionPool", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLConnectionPool"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5350, 162, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->35764667]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11830, 368}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1581, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2204, 65, 39, 0, 70, "ObjectName"],
Cell[2246, 67, 423, 12, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2706, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3184, 101, 265, 10, 70, "Notes",
 CellID->30231],
Cell[3452, 113, 147, 5, 70, "Notes",
 CellID->236494485],
Cell[3602, 120, 1711, 37, 70, "3ColumnTableMod",
 CellID->122457082]
}, Closed]],
Cell[CellGroupData[{
Cell[5350, 162, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35764667],
Cell[CellGroupData[{
Cell[5734, 176, 148, 5, 70, "ExampleSection",
 CellID->549769189],
Cell[5885, 183, 134, 3, 70, "Input",
 CellID->43232557],
Cell[6022, 188, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[CellGroupData[{
Cell[6445, 202, 270, 7, 70, "Input",
 CellID->86786838],
Cell[6718, 211, 172, 5, 70, "Output",
 CellID->51427374]
}, Open  ]],
Cell[6905, 219, 114, 3, 70, "ExampleText",
 CellID->1688810589],
Cell[CellGroupData[{
Cell[7044, 226, 117, 3, 70, "Input",
 CellID->482739374],
Cell[7164, 231, 1622, 35, 70, "Output",
 CellID->380402458]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8847, 273, 295, 8, 70, "SeeAlsoSection"],
Cell[9145, 283, 515, 17, 70, "SeeAlso",
 CellID->19895]
}, Open  ]],
Cell[CellGroupData[{
Cell[9697, 305, 298, 8, 70, "TutorialsSection"],
Cell[9998, 315, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10288, 326, 424, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[10727, 341, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

