(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10381,        341]
NotebookOptionsPosition[      7867,        259]
NotebookOutlinePosition[      9146,        296]
CellTagsIndexPosition[      9062,        291]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Connection Pools in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ConnectionPools"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Connection Pools in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OpenSQLConnection" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/OpenSQLConnection"], "SQLConnectionPools" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLConnectionPools"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OpenSQLConnection\"\>", 
       2->"\<\"SQLConnectionPools\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLConnectionPoolClose", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLConnectionPoolClose", "[", 
       StyleBox["pool", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]closes a connection pool."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->22404031],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->202069774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"conn", " ", "=", " ", 
  RowBox[{"OpenSQLConnection", "[", " ", 
   RowBox[{"\"\<publisher\>\"", ",", " ", 
    RowBox[{"UseConnectionPool", " ", "\[Rule]", " ", "True"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->410259035],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "6", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->280075249]
}, Open  ]],

Cell["The connection pool used to connect to the database:", "ExampleText",
 CellID->548206924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pool", "=", 
  RowBox[{"SQLConnectionPools", "[", "conn", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482739374],

Cell[BoxData[
 RowBox[{"SQLConnectionPool", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{
      "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
       "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject299909580324865], ",", 
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
    "]"}], ",", "1", ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0_Thin\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\
\\DatabaseResources\\\\publisher.m\"\>"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->927407452]
}, Open  ]],

Cell["Close the connection pool:", "ExampleText",
 CellID->1008926038],

Cell[BoxData[
 RowBox[{"SQLConnectionPoolClose", "[", "pool", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->414371230]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenSQLConnection",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLConnectionPools",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Connection Pools in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ConnectionPools"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLConnectionPoolClose - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 40.6094353}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLConnectionPoolClose[pool] closes a connection pool.", 
    "synonyms" -> {}, "title" -> "SQLConnectionPoolClose", "type" -> "Symbol",
     "uri" -> "DatabaseLink/ref/SQLConnectionPoolClose"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2668, 83, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8928, 284}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1581, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2204, 65, 44, 0, 70, "ObjectName"],
Cell[2251, 67, 380, 11, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2668, 83, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3045, 97, 147, 5, 70, "ExampleSection",
 CellID->22404031],
Cell[3195, 104, 135, 3, 70, "Input",
 CellID->202069774],
Cell[CellGroupData[{
Cell[3355, 111, 263, 7, 70, "Input",
 CellID->410259035],
Cell[3621, 120, 173, 5, 70, "Output",
 CellID->280075249]
}, Open  ]],
Cell[3809, 128, 95, 1, 70, "ExampleText",
 CellID->548206924],
Cell[CellGroupData[{
Cell[3929, 133, 143, 4, 70, "Input",
 CellID->482739374],
Cell[4075, 139, 1627, 35, 70, "Output",
 CellID->927407452]
}, Open  ]],
Cell[5717, 177, 70, 1, 70, "ExampleText",
 CellID->1008926038],
Cell[5790, 180, 121, 3, 70, "Input",
 CellID->414371230]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5960, 189, 295, 8, 70, "SeeAlsoSection"],
Cell[6258, 199, 515, 17, 70, "SeeAlso",
 CellID->19895]
}, Open  ]],
Cell[CellGroupData[{
Cell[6810, 221, 298, 8, 70, "TutorialsSection"],
Cell[7111, 231, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7401, 242, 424, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[7840, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

