(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21649,        710]
NotebookOptionsPosition[     16973,        543]
NotebookOutlinePosition[     18985,        608]
CellTagsIndexPosition[     18850,        601]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"], 
          "Creating Tables with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLCreatingTables"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Creating Tables in DatabaseLink User Guide\"\>", 
       3->"\<\"Creating Tables with Raw SQL in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"], 
          "SQLDropTable" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLDropTable"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLExecute\"\>", 
       2->"\<\"SQLDropTable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLCreateTable", "ObjectName",
 CellID->11909],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLCreateTable", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"], ",", 
        StyleBox["columns", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a new table in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14878]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox[ButtonBox["SQLCreateTable",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"], "InlineCode"],
 " returns an integer specifying the number of rows affected by the query. If \
the table is created correctly, this integer will always be zero as no rows \
are affected when creating a new table."
}], "Notes",
 CellID->6923],

Cell["The following option can be given: ", "Notes",
 CellID->27085],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->29400]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103725660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->490798039],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->391950876],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->5767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"SQLTable", "[", "\"\<TEST1\>\"", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<A\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<B\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}]}], 
    "}"}]}], "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[3]:=",
 CellID->15407],

Cell[BoxData["0"], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[3]=",
 CellID->10677]
}, Open  ]],

Cell["Specify whether columns can have null values:", "ExampleText",
 CellID->13784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"SQLTable", "[", "\"\<TEST2\>\"", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<C\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "->", "True"}]}], "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<D\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}], ",", " ", 
       RowBox[{"\"\<Nullable\>\"", "->", "False"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[4]:=",
 CellID->704],

Cell[BoxData["0"], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[4]=",
 CellID->14790]
}, Open  ]],

Cell["Use different data types:", "ExampleText",
 CellID->9834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"SQLTable", "[", "\"\<TEST3\>\"", "]"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TINYINTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TINYINT\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<SMALLINTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<SMALLINT\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<INTEGERCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BIGINTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BIGINT\>\""}]}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<NUMERICCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<NUMERIC\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DECIMALCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DECIMAL\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<FLOATCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<FLOAT\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<REALCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<REAL\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DOUBLECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}], ",",
      
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BITCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BIT\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<LONGVARBINARYCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<LONGVARBINARY\>\""}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<VARBINARYCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARBINARY\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<BINARYCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BINARY\>\""}]}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<LONGVARCHARCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<LONGVARCHAR\>\""}]}], "]"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<VARCHARCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARCHAR\>\""}], ",", "  ", 
       RowBox[{"\"\<DataLength\>\"", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<CHARCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<CHAR\>\""}], ",", "  ", 
       RowBox[{"\"\<DataLength\>\"", "\[Rule]", "3"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DATECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DATE\>\""}]}], "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TIME\>\""}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMESTAMPCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<TIMESTAMP\>\""}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<OBJECTCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<OBJECT\>\""}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1.2",
 CellLabel->"In[5]:=",
 CellID->10891],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.1.2",
 CellLabel->"Out[5]=",
 CellID->621]
}, Open  ]],

Cell["Specify data length:", "ExampleText",
 CellID->18085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", 
   RowBox[{"SQLTable", "[", "\"\<TEST4\>\"", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<X\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARCHAR\>\""}], ",", " ", 
       RowBox[{"\"\<DataLength\>\"", "->", "5"}]}], "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<Y\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<CHAR\>\""}], ",", " ", 
       RowBox[{"\"\<DataLength\>\"", "->", "3"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[6]:=",
 CellID->27734],

Cell[BoxData["0"], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[6]=",
 CellID->25190]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST1\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[7]:=",
 CellID->20542],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST2\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[8]:=",
 CellID->17998],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST3\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[9]:=",
 CellID->22086],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST4\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[10]:=",
 CellID->32018],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[11]:=",
 CellID->15621]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDropTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23024],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Creating Tables with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->362441368],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->340525382]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLCreateTable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 44.2500370}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLCreateTable[conn, table, columns] creates a new table in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLCreateTable", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLCreateTable"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5038, 155, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->103725660]},
 "b:6.4"->{
  Cell[6339, 204, 562, 16, 70, "Input",
   CellTags->"b:6.4",
   CellID->15407],
  Cell[6904, 222, 87, 3, 70, "Output",
   CellTags->"b:6.4",
   CellID->10677],
  Cell[7115, 233, 677, 17, 70, "Input",
   CellTags->"b:6.4",
   CellID->704],
  Cell[7795, 252, 87, 3, 70, "Output",
   CellTags->"b:6.4",
   CellID->14790],
  Cell[12271, 365, 673, 17, 70, "Input",
   CellTags->"b:6.4",
   CellID->27734],
  Cell[12947, 384, 87, 3, 70, "Output",
   CellTags->"b:6.4",
   CellID->25190]},
 "b:4.1.2"->{
  Cell[7985, 263, 4097, 89, 70, "Input",
   CellTags->"b:4.1.2",
   CellID->10891],
  Cell[12085, 354, 87, 3, 70, "Output",
   CellTags->"b:4.1.2",
   CellID->621]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18031, 568},
 {"b:6.4", 18163, 572},
 {"b:4.1.2", 18661, 591}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2420, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3043, 85, 52, 1, 70, "ObjectName",
 CellID->11909],
Cell[3098, 88, 502, 15, 70, "Usage",
 CellID->14878]
}, Open  ]],
Cell[CellGroupData[{
Cell[3637, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4115, 125, 373, 8, 70, "Notes",
 CellID->6923],
Cell[4491, 135, 68, 1, 70, "Notes",
 CellID->27085],
Cell[4562, 138, 439, 12, 70, "3ColumnTableMod",
 CellID->29400]
}, Closed]],
Cell[CellGroupData[{
Cell[5038, 155, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103725660],
Cell[CellGroupData[{
Cell[5423, 169, 148, 5, 70, "ExampleSection",
 CellID->490798039],
Cell[5574, 176, 135, 3, 70, "Input",
 CellID->391950876],
Cell[5712, 181, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6113, 193, 201, 7, 70, "Input",
 CellID->5767],
Cell[CellGroupData[{
Cell[6339, 204, 562, 16, 70, "Input",
 CellTags->"b:6.4",
 CellID->15407],
Cell[6904, 222, 87, 3, 70, "Output",
 CellTags->"b:6.4",
 CellID->10677]
}, Open  ]],
Cell[7006, 228, 84, 1, 70, "ExampleText",
 CellID->13784],
Cell[CellGroupData[{
Cell[7115, 233, 677, 17, 70, "Input",
 CellTags->"b:6.4",
 CellID->704],
Cell[7795, 252, 87, 3, 70, "Output",
 CellTags->"b:6.4",
 CellID->14790]
}, Open  ]],
Cell[7897, 258, 63, 1, 70, "ExampleText",
 CellID->9834],
Cell[CellGroupData[{
Cell[7985, 263, 4097, 89, 70, "Input",
 CellTags->"b:4.1.2",
 CellID->10891],
Cell[12085, 354, 87, 3, 70, "Output",
 CellTags->"b:4.1.2",
 CellID->621]
}, Open  ]],
Cell[12187, 360, 59, 1, 70, "ExampleText",
 CellID->18085],
Cell[CellGroupData[{
Cell[12271, 365, 673, 17, 70, "Input",
 CellTags->"b:6.4",
 CellID->27734],
Cell[12947, 384, 87, 3, 70, "Output",
 CellTags->"b:6.4",
 CellID->25190]
}, Open  ]],
Cell[13049, 390, 203, 7, 70, "Input",
 CellID->20542],
Cell[13255, 399, 203, 7, 70, "Input",
 CellID->17998],
Cell[13461, 408, 203, 7, 70, "Input",
 CellID->22086],
Cell[13667, 417, 204, 7, 70, "Input",
 CellID->32018],
Cell[13874, 426, 149, 5, 70, "Input",
 CellID->15621]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14072, 437, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[14391, 448, 489, 17, 70, "SeeAlso",
 CellID->19895]
}, Open  ]],
Cell[CellGroupData[{
Cell[14917, 470, 314, 9, 70, "TutorialsSection",
 CellID->23024],
Cell[15234, 481, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[15524, 492, 416, 12, 70, "Tutorials",
 CellID->14193],
Cell[15943, 506, 441, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[16421, 523, 319, 9, 70, "MoreAboutSection",
 CellID->362441368],
Cell[16743, 534, 188, 4, 70, "MoreAbout",
 CellID->340525382]
}, Open  ]],
Cell[16946, 541, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

