(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11421,        380]
NotebookOptionsPosition[      8706,        289]
NotebookOutlinePosition[     10011,        327]
CellTagsIndexPosition[      9927,        322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Data Type Mapping in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DataTypeMapping"], 
          "Supported Data Types in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SupportedDataTypes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Data Type Mapping in DatabaseLink User Guide\"\>", 
       3->"\<\"Supported Data Types in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLDataTypeInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLDataTypeInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"SQLDataTypeInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"Database Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLDataTypeNames", "ObjectName",
 CellID->1790],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLDataTypeNames", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox[
     "returns the names of data types that can be stored in an SQL \
connection.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17013]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->913270915],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->271227525],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->13543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDataTypeNames", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TINYINT\"\>", ",", "\<\"BIGINT\"\>", 
   ",", "\<\"LONGVARBINARY\"\>", ",", "\<\"VARBINARY\"\>", 
   ",", "\<\"BINARY\"\>", ",", "\<\"LONGVARCHAR\"\>", ",", "\<\"CHAR\"\>", 
   ",", "\<\"NUMERIC\"\>", ",", "\<\"DECIMAL\"\>", ",", "\<\"INTEGER\"\>", 
   ",", "\<\"SMALLINT\"\>", ",", "\<\"FLOAT\"\>", ",", "\<\"REAL\"\>", 
   ",", "\<\"DOUBLE\"\>", ",", "\<\"VARCHAR\"\>", 
   ",", "\<\"VARCHAR_IGNORECASE\"\>", ",", "\<\"BOOLEAN\"\>", 
   ",", "\<\"DATE\"\>", ",", "\<\"TIME\"\>", ",", "\<\"TIMESTAMP\"\>", 
   ",", "\<\"OTHER\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->6266]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->27651]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SQLDataTypeInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeInformation"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21060],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Data Type Mapping in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Supported Data Types in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SupportedDataTypes"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SupportedDataTypes"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SupportedDataTypes"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->687134445],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->116969343],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->26958955]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLDataTypeNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 46.3125238}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLDataTypeNames[conn] returns the names of data types that can be \
stored in an SQL connection.", "synonyms" -> {}, "title" -> 
    "SQLDataTypeNames", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLDataTypeNames"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3648, 109, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9792, 315}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2461, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3084, 86, 53, 1, 70, "ObjectName",
 CellID->1790],
Cell[3140, 89, 471, 15, 70, "Usage",
 CellID->17013]
}, Open  ]],
Cell[CellGroupData[{
Cell[3648, 109, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4025, 123, 148, 5, 70, "ExampleSection",
 CellID->913270915],
Cell[4176, 130, 135, 3, 70, "Input",
 CellID->271227525],
Cell[4314, 135, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4715, 147, 202, 7, 70, "Input",
 CellID->13543],
Cell[CellGroupData[{
Cell[4942, 158, 110, 3, 70, "Input",
 CellID->7373],
Cell[5055, 163, 634, 12, 70, "Output",
 CellID->6266]
}, Open  ]],
Cell[5704, 178, 148, 5, 70, "Input",
 CellID->27651]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5901, 189, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6220, 200, 236, 6, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[6493, 211, 314, 9, 70, "TutorialsSection",
 CellID->21060],
Cell[6810, 222, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[7100, 233, 421, 12, 70, "Tutorials",
 CellID->14193],
Cell[7524, 247, 436, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[7997, 264, 319, 9, 70, "MoreAboutSection",
 CellID->687134445],
Cell[8319, 275, 179, 4, 70, "MoreAbout",
 CellID->116969343],
Cell[8501, 281, 163, 3, 70, "MoreAbout",
 CellID->26958955]
}, Open  ]],
Cell[8679, 287, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

