(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16129,        572]
NotebookOptionsPosition[     11961,        426]
NotebookOutlinePosition[     13861,        486]
CellTagsIndexPosition[     13750,        480]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Data Type Mapping in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DataTypeMapping#24423"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Data Type Mapping in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLBinary" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLBinary"], 
          "SQLExpr" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExpr"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLBinary\"\>", 
       2->"\<\"SQLExpr\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLDateTime", "ObjectName",
 CellID->11171],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLDateTime", "[", 
       StyleBox["datetime", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox[
     "represents date and time information that can be stored in a database.",
       "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->72512314],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->811699],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.1.2",
 CellLabel->"In[2]:=",
 CellID->29756],

Cell[TextData[{
 "This creates a table with data types ",
 StyleBox["DATE", "TI"],
 ", ",
 StyleBox["DATETIME", "TI"],
 ", and ",
 StyleBox["TIMESTAMP", "TI"],
 ":"
}], "ExampleText",
 CellID->26632],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<DATETIMETABLE\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<DATECOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<DATE\>\""}]}], "]"}], 
      ",", " ", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<DATETIMECOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<DATETIME\>\""}]}], 
       "]"}], ",", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<TIMESTAMPCOL\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<TIMESTAMP\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:6.1.2",
 CellLabel->"In[3]:=",
 CellID->7470],

Cell["This inserts the same data into each column:", "ExampleText",
 CellID->25739],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{
     "\"\<DATECOL\>\"", ",", " ", "\"\<DATETIMECOL\>\"", ",", " ", 
      "\"\<TIMESTAMPCOL\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLDateTime", "[", 
       RowBox[{"Date", "[", "]"}], "]"}], ",", 
      RowBox[{"SQLDateTime", "[", 
       RowBox[{"Date", "[", "]"}], "]"}], ",", " ", 
      RowBox[{"SQLDateTime", "[", 
       RowBox[{"Date", "[", "]"}], "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:6.1.2",
 CellLabel->"In[4]:=",
 CellID->20666],

Cell["This selects the data as stored in the database:", "ExampleText",
 CellID->8522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\""}], "]"}]], "Input",
 CellTags->"b:6.1.2",
 CellLabel->"In[5]:=",
 CellID->7283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{"2005", ",", "9", ",", "17"}], "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{
      "2005", ",", "9", ",", "17", ",", "17", ",", "17", ",", "58.865895`"}], 
      "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{
      "2005", ",", "9", ",", "17", ",", "17", ",", "17", ",", 
       "58.865912999`"}], "}"}], "]"}]}], "}"}], "}"}]], "Output",
 CellTags->"b:6.1.2",
 CellLabel->"Out[5]=",
 CellID->8160]
}, Open  ]],

Cell[TextData[{
 "This creates a table with data type ",
 StyleBox["TIME", "TI"],
 ":"
}], "ExampleText",
 CellID->17553],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TIMETABLE\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<TIME\>\""}]}], "]"}], 
     "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:6.1.2",
 CellLabel->"In[6]:=",
 CellID->24705],

Cell["This inserts time data:", "ExampleText",
 CellID->27091],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TIMETABLE\>\"", ",", " ", 
    RowBox[{"{", "\"\<TIMECOL\>\"", "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"SQLDateTime", "[", 
      RowBox[{"Round", "[", 
       RowBox[{"Take", "[", 
        RowBox[{
         RowBox[{"Date", "[", "]"}], ",", 
         RowBox[{"-", "3"}]}], "]"}], "]"}], "]"}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellTags->"b:6.1.2",
 CellLabel->"In[7]:=",
 CellID->1259],

Cell["This selects the data:", "ExampleText",
 CellID->25386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TIMETABLE\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"SQLDateTime", "[", 
    RowBox[{"{", 
     RowBox[{"17", ",", "18", ",", "3"}], "}"}], "]"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->4629]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TIMETABLE\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[9]:=",
 CellID->42],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[10]:=",
 CellID->28317],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[11]:=",
 CellID->22045]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29947],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLBinary",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLBinary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExpr",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExpr"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14523],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Data Type Mapping in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->367563645],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->231369355]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLDateTime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 47.1875182}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLDateTime[datetime] represents date and time information that can be \
stored in a database.", "synonyms" -> {}, "title" -> "SQLDateTime", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLDateTime"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3338, 103, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:6.1.2"->{
  Cell[4401, 141, 239, 8, 70, "Input",
   CellTags->"b:6.1.2",
   CellID->29756],
  Cell[4845, 162, 812, 21, 70, "Input",
   CellTags->"b:6.1.2",
   CellID->7470],
  Cell[5746, 188, 643, 18, 70, "Input",
   CellTags->"b:6.1.2",
   CellID->20666],
  Cell[6503, 213, 173, 5, 70, "Input",
   CellTags->"b:6.1.2",
   CellID->7283],
  Cell[6679, 220, 602, 19, 70, "Output",
   CellTags->"b:6.1.2",
   CellID->8160],
  Cell[7420, 249, 426, 12, 70, "Input",
   CellTags->"b:6.1.2",
   CellID->24705],
  Cell[7914, 266, 485, 15, 70, "Input",
   CellTags->"b:6.1.2",
   CellID->1259]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13024, 451},
 {"b:6.1.2", 13150, 455}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2153, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2776, 80, 49, 1, 70, "ObjectName",
 CellID->11171],
Cell[2828, 83, 473, 15, 70, "Usage",
 CellID->20654]
}, Open  ]],
Cell[CellGroupData[{
Cell[3338, 103, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3715, 117, 147, 5, 70, "ExampleSection",
 CellID->72512314],
Cell[3865, 124, 132, 3, 70, "Input",
 CellID->811699],
Cell[4000, 129, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4401, 141, 239, 8, 70, "Input",
 CellTags->"b:6.1.2",
 CellID->29756],
Cell[4643, 151, 199, 9, 70, "ExampleText",
 CellID->26632],
Cell[4845, 162, 812, 21, 70, "Input",
 CellTags->"b:6.1.2",
 CellID->7470],
Cell[5660, 185, 83, 1, 70, "ExampleText",
 CellID->25739],
Cell[5746, 188, 643, 18, 70, "Input",
 CellTags->"b:6.1.2",
 CellID->20666],
Cell[6392, 208, 86, 1, 70, "ExampleText",
 CellID->8522],
Cell[CellGroupData[{
Cell[6503, 213, 173, 5, 70, "Input",
 CellTags->"b:6.1.2",
 CellID->7283],
Cell[6679, 220, 602, 19, 70, "Output",
 CellTags->"b:6.1.2",
 CellID->8160]
}, Open  ]],
Cell[7296, 242, 121, 5, 70, "ExampleText",
 CellID->17553],
Cell[7420, 249, 426, 12, 70, "Input",
 CellTags->"b:6.1.2",
 CellID->24705],
Cell[7849, 263, 62, 1, 70, "ExampleText",
 CellID->27091],
Cell[7914, 266, 485, 15, 70, "Input",
 CellTags->"b:6.1.2",
 CellID->1259],
Cell[8402, 283, 61, 1, 70, "ExampleText",
 CellID->25386],
Cell[CellGroupData[{
Cell[8488, 288, 148, 4, 70, "Input",
 CellID->31687],
Cell[8639, 294, 216, 8, 70, "Output",
 CellID->4629]
}, Open  ]],
Cell[8870, 305, 204, 7, 70, "Input",
 CellID->42],
Cell[9077, 314, 212, 7, 70, "Input",
 CellID->28317],
Cell[9292, 323, 149, 5, 70, "Input",
 CellID->22045]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9490, 334, 311, 9, 70, "SeeAlsoSection",
 CellID->29947],
Cell[9804, 345, 481, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10322, 367, 314, 9, 70, "TutorialsSection",
 CellID->14523],
Cell[10639, 378, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10929, 389, 443, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[11409, 406, 319, 9, 70, "MoreAboutSection",
 CellID->367563645],
Cell[11731, 417, 188, 4, 70, "MoreAbout",
 CellID->231369355]
}, Open  ]],
Cell[11934, 424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

