(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23693,        765]
NotebookOptionsPosition[     14976,        512]
NotebookOutlinePosition[     20303,        653]
CellTagsIndexPosition[     19724,        637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Deleting Data in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DeletingData"], 
          "Deleting Data with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLDeletingData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Deleting Data in DatabaseLink User Guide\"\>", 
       3->"\<\"Deleting Data with Raw SQL in DatabaseLink User Guide\"\>"}, "\
\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"], 
          "SQLInsert" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLInsert"], 
          "SQLSelect" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSelect"], 
          "SQLUpdate" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLUpdate"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLExecute\"\>", 
       2->"\<\"SQLInsert\"\>", 3->"\<\"SQLSelect\"\>", 
       4->"\<\"SQLUpdate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"SQL Data Access and Manipulation\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLDelete", "ObjectName",
 CellID->28630],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLDelete", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes the data in a table in an SQL connection."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLDelete", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"], ",", 
        StyleBox["cond", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes data that matches ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18717]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
\[WarningSign] Use this function with caution, as you can lose data \
permanently!\
\>", "Notes",
 CellID->23043],

Cell["\<\
Returns an integer specifying the number of rows affected by the query.\
\>", "Notes",
 CellID->31376],

Cell["The following option can be given: ", "Notes",
 CellID->25314],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16626]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->458424907],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->274764],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->262153418],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,396"},
 CellLabel->"In[2]:=",
 CellID->8964],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<INTEGER\>\""}]}], 
       "]"}], ",", " ", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<DOUBLE\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,5",
 CellLabel->"In[3]:=",
 CellID->19154],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLInsert", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", " ", "10.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", " ", "17.5"}], "}"}]}], "}"}]}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,398"},
 CellLabel->"In[4]:=",
 CellID->18866],

Cell["Delete all the data in a table:", "ExampleText",
 CellID->14693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDelete", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
 CellLabel->"In[5]:=",
 CellID->30664],

Cell[BoxData["2"], "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
 CellLabel->"Out[5]=",
 CellID->23775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
 CellLabel->"In[6]:=",
 CellID->13000],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
 CellLabel->"Out[6]=",
 CellID->12212]
}, Open  ]],

Cell["Delete data matching a condition:", "ExampleText",
 CellID->21100],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLInsert", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", " ", "10.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", " ", "17.5"}], "}"}]}], "}"}]}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,401"},
 CellLabel->"In[7]:=",
 CellID->7551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDelete", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<COL1\>\"", "]"}], " ", ">", " ", "15"}]}], 
  "]"}]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
 CellLabel->"In[8]:=",
 CellID->25476],

Cell[BoxData["1"], "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
 CellLabel->"Out[8]=",
 CellID->6379]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
 CellLabel->"In[9]:=",
 CellID->10943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "10.5`"}], "}"}], "}"}]], "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
 CellLabel->"Out[9]=",
 CellID->17877]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,404"},
 CellLabel->"In[10]:=",
 CellID->3789],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,405"},
 CellLabel->"In[11]:=",
 CellID->361]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSelect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLUpdate",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17117],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Deleting Data in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DeletingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DeletingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DeletingData"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Deleting Data with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDeletingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDeletingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDeletingData"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->102707440],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->573823020],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->74640305],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->419657496]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLDelete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 48.0781375}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLDelete[conn, table] deletes the data in a table in an SQL connection. \
SQLDelete[conn, table, cond] deletes data that matches cond. ", 
    "synonyms" -> {}, "title" -> "SQLDelete", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLDelete"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5825, 178, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->458424907]},
 "b:4.1.5"->{
  Cell[6897, 216, 272, 8, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,396"},
   CellID->8964],
  Cell[7810, 245, 551, 16, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,398"},
   CellID->18866],
  Cell[8459, 268, 199, 5, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
   CellID->30664],
  Cell[8661, 275, 123, 3, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
   CellID->23775],
  Cell[8821, 283, 199, 5, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
   CellID->13000],
  Cell[9023, 290, 140, 4, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
   CellID->12212],
  Cell[9253, 300, 550, 16, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,401"},
   CellID->7551],
  Cell[9828, 320, 301, 8, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
   CellID->25476],
  Cell[10132, 330, 122, 3, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
   CellID->6379],
  Cell[10291, 338, 199, 5, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
   CellID->10943],
  Cell[10493, 345, 197, 6, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
   CellID->17877],
  Cell[10705, 354, 258, 8, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,404"},
   CellID->3789],
  Cell[10966, 364, 203, 6, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,405"},
   CellID->361]},
 "Ex--21943418559164291386,396"->{
  Cell[6897, 216, 272, 8, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,396"},
   CellID->8964]},
 "Ex--21950856252955103714,5"->{
  Cell[7172, 226, 635, 17, 70, "Input",
   CellTags->"Ex--21950856252955103714,5",
   CellID->19154]},
 "Ex--21943418559164291386,398"->{
  Cell[7810, 245, 551, 16, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,398"},
   CellID->18866]},
 "Ex--21943418559164291386,399"->{
  Cell[8459, 268, 199, 5, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
   CellID->30664],
  Cell[8661, 275, 123, 3, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
   CellID->23775]},
 "Ex--21943418559164291386,400"->{
  Cell[8821, 283, 199, 5, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
   CellID->13000],
  Cell[9023, 290, 140, 4, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
   CellID->12212]},
 "Ex--21943418559164291386,401"->{
  Cell[9253, 300, 550, 16, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,401"},
   CellID->7551]},
 "Ex--21943418559164291386,402"->{
  Cell[9828, 320, 301, 8, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
   CellID->25476],
  Cell[10132, 330, 122, 3, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
   CellID->6379]},
 "Ex--21943418559164291386,403"->{
  Cell[10291, 338, 199, 5, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
   CellID->10943],
  Cell[10493, 345, 197, 6, 70, "Output",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
   CellID->17877]},
 "Ex--21943418559164291386,404"->{
  Cell[10705, 354, 258, 8, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,404"},
   CellID->3789]},
 "Ex--21943418559164291386,405"->{
  Cell[10966, 364, 203, 6, 70, "Input",
   CellTags->{"b:4.1.5", "Ex--21943418559164291386,405"},
   CellID->361]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16080, 538},
 {"b:4.1.5", 16214, 542},
 {"Ex--21943418559164291386,396", 17763, 582},
 {"Ex--21950856252955103714,5", 17912, 586},
 {"Ex--21943418559164291386,398", 18050, 590},
 {"Ex--21943418559164291386,399", 18203, 594},
 {"Ex--21943418559164291386,400", 18472, 601},
 {"Ex--21943418559164291386,401", 18741, 608},
 {"Ex--21943418559164291386,402", 18893, 612},
 {"Ex--21943418559164291386,403", 19162, 619},
 {"Ex--21943418559164291386,404", 19433, 626},
 {"Ex--21943418559164291386,405", 19585, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3011, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3634, 96, 47, 1, 70, "ObjectName",
 CellID->28630],
Cell[3684, 99, 838, 26, 70, "Usage",
 CellID->18717]
}, Open  ]],
Cell[CellGroupData[{
Cell[4559, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5037, 147, 123, 4, 70, "Notes",
 CellID->23043],
Cell[5163, 153, 112, 3, 70, "Notes",
 CellID->31376],
Cell[5278, 158, 68, 1, 70, "Notes",
 CellID->25314],
Cell[5349, 161, 439, 12, 70, "3ColumnTableMod",
 CellID->16626]
}, Closed]],
Cell[CellGroupData[{
Cell[5825, 178, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->458424907],
Cell[CellGroupData[{
Cell[6210, 192, 145, 5, 70, "ExampleSection",
 CellID->274764],
Cell[6358, 199, 135, 3, 70, "Input",
 CellID->262153418],
Cell[6496, 204, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6897, 216, 272, 8, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,396"},
 CellID->8964],
Cell[7172, 226, 635, 17, 70, "Input",
 CellTags->"Ex--21950856252955103714,5",
 CellID->19154],
Cell[7810, 245, 551, 16, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,398"},
 CellID->18866],
Cell[8364, 263, 70, 1, 70, "ExampleText",
 CellID->14693],
Cell[CellGroupData[{
Cell[8459, 268, 199, 5, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
 CellID->30664],
Cell[8661, 275, 123, 3, 70, "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,399"},
 CellID->23775]
}, Open  ]],
Cell[CellGroupData[{
Cell[8821, 283, 199, 5, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
 CellID->13000],
Cell[9023, 290, 140, 4, 70, "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,400"},
 CellID->12212]
}, Open  ]],
Cell[9178, 297, 72, 1, 70, "ExampleText",
 CellID->21100],
Cell[9253, 300, 550, 16, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,401"},
 CellID->7551],
Cell[CellGroupData[{
Cell[9828, 320, 301, 8, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
 CellID->25476],
Cell[10132, 330, 122, 3, 70, "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,402"},
 CellID->6379]
}, Open  ]],
Cell[CellGroupData[{
Cell[10291, 338, 199, 5, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
 CellID->10943],
Cell[10493, 345, 197, 6, 70, "Output",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,403"},
 CellID->17877]
}, Open  ]],
Cell[10705, 354, 258, 8, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,404"},
 CellID->3789],
Cell[10966, 364, 203, 6, 70, "Input",
 CellTags->{"b:4.1.5", "Ex--21943418559164291386,405"},
 CellID->361]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11218, 376, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[11537, 387, 1007, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12581, 427, 314, 9, 70, "TutorialsSection",
 CellID->17117],
Cell[12898, 438, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[13188, 449, 408, 12, 70, "Tutorials",
 CellID->14193],
Cell[13599, 463, 433, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[14069, 480, 319, 9, 70, "MoreAboutSection",
 CellID->102707440],
Cell[14391, 491, 179, 4, 70, "MoreAbout",
 CellID->573823020],
Cell[14573, 497, 187, 4, 70, "MoreAbout",
 CellID->74640305],
Cell[14763, 503, 171, 4, 70, "MoreAbout",
 CellID->419657496]
}, Open  ]],
Cell[14949, 510, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

