(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16262,        538]
NotebookOptionsPosition[     10752,        371]
NotebookOutlinePosition[     13964,        459]
CellTagsIndexPosition[     13620,        448]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Dropping Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DroppingTables"], 
          "Dropping Tables with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLDroppingTables"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Dropping Tables in DatabaseLink User Guide\"\>", 
       3->"\<\"Dropping Tables with Raw SQL in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"], 
          "SQLCreateTable" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCreateTable"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLExecute\"\>", 
       2->"\<\"SQLCreateTable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLDropTable", "ObjectName",
 CellID->31461],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLDropTable", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]drops a table in an SQL connection. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
\[WarningSign] Use this function with caution, as you can lose data \
permanently!\
\>", "Notes",
 CellID->28498],

Cell["\<\
Returns an integer specifying the number of rows affected by the query.\
\>", "Notes",
 CellID->17369],

Cell["The following option can be given: ", "Notes",
 CellID->17291],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->8400]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->643708478],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->148050070],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12756760],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,390"},
 CellLabel->"In[2]:=",
 CellID->1441],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<INTEGER\>\""}]}], 
       "]"}], ",", " ", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<DOUBLE\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,5",
 CellLabel->"In[3]:=",
 CellID->5936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDropTable", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
 CellLabel->"In[4]:=",
 CellID->21867],

Cell[BoxData["0"], "Output",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
 CellLabel->"Out[4]=",
 CellID->7028]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
 CellLabel->"In[5]:=",
 CellID->31453],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
 CellLabel->"Out[5]=",
 CellID->27909]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,394"},
 CellLabel->"In[6]:=",
 CellID->13973]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->171643403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14179],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Dropping Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DroppingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DroppingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DroppingTables"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Dropping Tables with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDroppingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDroppingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDroppingTables"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->103737309],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->81427397]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLDropTable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 49.0468813}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLDropTable[conn, table] drops a table in an SQL connection. ", 
    "synonyms" -> {}, "title" -> "SQLDropTable", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLDropTable"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4858, 155, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->643708478]},
 "b:4.1.6"->{
  Cell[5932, 193, 272, 8, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,390"},
   CellID->1441],
  Cell[6866, 224, 202, 5, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
   CellID->21867],
  Cell[7071, 231, 122, 3, 70, "Output",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
   CellID->7028],
  Cell[7230, 239, 203, 5, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
   CellID->31453],
  Cell[7436, 246, 140, 4, 70, "Output",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
   CellID->27909],
  Cell[7591, 253, 204, 6, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,394"},
   CellID->13973]},
 "Ex--21943418559164291386,390"->{
  Cell[5932, 193, 272, 8, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,390"},
   CellID->1441]},
 "Ex--21950856252955103714,5"->{
  Cell[6207, 203, 634, 17, 70, "Input",
   CellTags->"Ex--21950856252955103714,5",
   CellID->5936]},
 "Ex--21943418559164291386,392"->{
  Cell[6866, 224, 202, 5, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
   CellID->21867],
  Cell[7071, 231, 122, 3, 70, "Output",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
   CellID->7028]},
 "Ex--21943418559164291386,393"->{
  Cell[7230, 239, 203, 5, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
   CellID->31453],
  Cell[7436, 246, 140, 4, 70, "Output",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
   CellID->27909]},
 "Ex--21943418559164291386,394"->{
  Cell[7591, 253, 204, 6, 70, "Input",
   CellTags->{"b:4.1.6", "Ex--21943418559164291386,394"},
   CellID->13973]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11791, 396},
 {"b:4.1.6", 11925, 400},
 {"Ex--21943418559164291386,390", 12657, 419},
 {"Ex--21950856252955103714,5", 12806, 423},
 {"Ex--21943418559164291386,392", 12943, 427},
 {"Ex--21943418559164291386,393", 13211, 434},
 {"Ex--21943418559164291386,394", 13480, 441}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2426, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3049, 85, 50, 1, 70, "ObjectName",
 CellID->31461],
Cell[3102, 88, 454, 14, 70, "Usage",
 CellID->27330]
}, Open  ]],
Cell[CellGroupData[{
Cell[3593, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4071, 124, 123, 4, 70, "Notes",
 CellID->28498],
Cell[4197, 130, 112, 3, 70, "Notes",
 CellID->17369],
Cell[4312, 135, 68, 1, 70, "Notes",
 CellID->17291],
Cell[4383, 138, 438, 12, 70, "3ColumnTableMod",
 CellID->8400]
}, Closed]],
Cell[CellGroupData[{
Cell[4858, 155, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->643708478],
Cell[CellGroupData[{
Cell[5243, 169, 148, 5, 70, "ExampleSection",
 CellID->148050070],
Cell[5394, 176, 134, 3, 70, "Input",
 CellID->12756760],
Cell[5531, 181, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5932, 193, 272, 8, 70, "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,390"},
 CellID->1441],
Cell[6207, 203, 634, 17, 70, "Input",
 CellTags->"Ex--21950856252955103714,5",
 CellID->5936],
Cell[CellGroupData[{
Cell[6866, 224, 202, 5, 70, "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
 CellID->21867],
Cell[7071, 231, 122, 3, 70, "Output",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,392"},
 CellID->7028]
}, Open  ]],
Cell[CellGroupData[{
Cell[7230, 239, 203, 5, 70, "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
 CellID->31453],
Cell[7436, 246, 140, 4, 70, "Output",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,393"},
 CellID->27909]
}, Open  ]],
Cell[7591, 253, 204, 6, 70, "Input",
 CellTags->{"b:4.1.6", "Ex--21943418559164291386,394"},
 CellID->13973]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7844, 265, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8163, 276, 497, 17, 70, "SeeAlso",
 CellID->171643403]
}, Open  ]],
Cell[CellGroupData[{
Cell[8697, 298, 314, 9, 70, "TutorialsSection",
 CellID->14179],
Cell[9014, 309, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9304, 320, 416, 12, 70, "Tutorials",
 CellID->14193],
Cell[9723, 334, 441, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[10201, 351, 319, 9, 70, "MoreAboutSection",
 CellID->103737309],
Cell[10523, 362, 187, 4, 70, "MoreAbout",
 CellID->81427397]
}, Open  ]],
Cell[10725, 369, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

