(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60672,       2255]
NotebookOptionsPosition[     44329,       1641]
NotebookOutlinePosition[     50401,       1851]
CellTagsIndexPosition[     50180,       1841]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "SQLExecute in DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/SQLExecute"],
           "Comparing Mathematica and SQL Queries in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/\
ComparingMathematicaAndSQLStyleQueries#12723"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"SQLExecute in DatabaseLink User Guide\"\>", 
       3->"\<\"Comparing Mathematica and SQL Queries in DatabaseLink User \
Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"SQL Data Access and Manipulation\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLExecute", "ObjectName",
 CellID->1405],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLExecute", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["command", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]executes a command in an SQL connection."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLExecute", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["command", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]passes arguments to the command."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->203337233]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
\[WarningSign] Use this function with caution, as you can lose data \
permanently!\
\>", "Notes",
 CellID->7171],

Cell[TextData[{
 "Returns an integer specifying the number of rows affected by the query. \
Returns ",
 StyleBox["$Failed", "MR"],
 " if an error is encountered when dropping a table."
}], "Notes",
 CellID->20580],

Cell["The following options can be given: ", "Notes",
 CellID->22740],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "return the results as strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaxRows\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of rows to return", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->22530]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66678785],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->252246757],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->823391247],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->16586],

Cell["Select data:", "ExampleText",
 CellID->21604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7.2`", ",", "\<\"Day3\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6.2`", ",", "\<\"Day4\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6.`", ",", "\<\"Day5\"\>"}], "}"}]}], "}"}]], "Output",\

 CellLabel->"Out[3]=",
 CellID->19631]
}, Open  ]],

Cell["Create a table:", "ExampleText",
 CellID->29744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<CREATE TABLE TEST (X INTEGER, Y DOUBLE)\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8388],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[4]=",
 CellID->26610]
}, Open  ]],

Cell["Insert data:", "ExampleText",
 CellID->18718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<INSERT INTO TEST (X,Y) VALUES (2, 6.7)\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26919],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[5]=",
 CellID->18259]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<INSERT INTO TEST (X,Y) VALUES (`1`, `2`)\>\"", ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"5", ",", " ", "2.1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5927],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[6]=",
 CellID->14609]
}, Open  ]],

Cell["Select data:", "ExampleText",
 CellID->28119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2.1`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->22716]
}, Open  ]],

Cell["Update data:", "ExampleText",
 CellID->6300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<UPDATE TEST SET Y=6.8\>\""}], "]"}]], "Input",\

 CellLabel->"In[8]:=",
 CellID->21396],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[8]=",
 CellID->16853]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->11458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6.8`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6.8`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->20830]
}, Open  ]],

Cell["Delete data:", "ExampleText",
 CellID->24593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<DELETE FROM TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->30806],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[10]=",
 CellID->29849]
}, Open  ]],

Cell["Drop the table:", "ExampleText",
 CellID->14854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<DROP TABLE TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->24272],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[11]=",
 CellID->26160]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[12]:=",
 CellID->12294],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->105929776]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->146],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Selecting Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4229],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->226634127],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<publisher\>\"", "]"}]}], 
   ";"}], "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[2]:=",
 CellID->10428],

Cell["Select data matching a condition:", "ExampleText",
 CellID->10559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<SELECT * FROM ROYSCHED WHERE ROYALTY >= .11 AND ROYALTY <= .12\>\""}],
   "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[3]:=",
 CellID->22241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "6000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "15000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[3]=",
 CellID->29421]
}, Open  ]],

Cell["Select the same data using a prepared statement:", "ExampleText",
 CellID->22688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<SELECT * FROM ROYSCHED WHERE ROYALTY >= `1` AND ROYALTY <= `2`\>\"", 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.11", ",", "0.12"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[4]:=",
 CellID->16366],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "6000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "15000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[4]=",
 CellID->12033]
}, Open  ]],

Cell["Specify a column in a prepared statement: ", "ExampleText",
 CellID->26685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<SELECT `1` FROM ROYSCHED WHERE TITLE_ID = `2`\>\"", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], ",", 
     "\"\<BS1011\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[5]:=",
 CellID->2270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.1`", "}"}], ",", 
   RowBox[{"{", "0.12`", "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[5]=",
 CellID->25329]
}, Open  ]],

Cell["Give a sequence of arguments in a prepared statement:", "ExampleText",
 CellID->32261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<SELECT `1` FROM ROYSCHED WHERE TITLE_ID = `2`\>\"", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLArgument", "[", 
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<LORANGE\>\"", "]"}], ",", 
       RowBox[{"SQLColumn", "[", "\"\<HIRANGE\>\"", "]"}], ",", 
       RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}]}], "]"}], ",", 
     "\"\<BS1011\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[6]:=",
 CellID->22860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5000", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5001", ",", "50000", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[6]=",
 CellID->2208]
}, Open  ]],

Cell["Apply a database function to the selected data:", "ExampleText",
 CellID->8982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT COUNT(ROYALTY) FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[7]:=",
 CellID->22162],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "51", "}"}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[7]=",
 CellID->32506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT MIN(ROYALTY) FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[8]:=",
 CellID->6878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "0.1`", "}"}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[8]=",
 CellID->11979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT ROYALTY * 2 FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[9]:=",
 CellID->1897],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.36`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.36`", "}"}], ",", 
   RowBox[{"{", "0.4`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.36`", "}"}], ",", 
   RowBox[{"{", "0.4`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[9]=",
 CellID->7887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT ROYALTY / 10 FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[10]:=",
 CellID->6538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.018`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.018`", "}"}], ",", 
   RowBox[{"{", "0.02`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.018`", "}"}], ",", 
   RowBox[{"{", "0.02`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[10]=",
 CellID->14469]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT - ROYALTY FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[11]:=",
 CellID->30783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[11]=",
 CellID->17540]
}, Open  ]],

Cell["Select only distinct values:", "ExampleText",
 CellID->22795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT DISTINCT ROYALTY FROM ROYSCHED\>\""}],
   "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[12]:=",
 CellID->7266],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.1`", "}"}], ",", 
   RowBox[{"{", "0.12`", "}"}], ",", 
   RowBox[{"{", "0.14`", "}"}], ",", 
   RowBox[{"{", "0.16`", "}"}], ",", 
   RowBox[{"{", "0.18`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[12]=",
 CellID->18633]
}, Open  ]],

Cell["Group values:", "ExampleText",
 CellID->13509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", 
   "\"\<SELECT TITLE_ID,\n     MIN(ROYALTY) FROM ROYSCHED GROUP BY TITLE_ID\>\
\""}], "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[13]:=",
 CellID->24557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[13]=",
 CellID->2317]
}, Open  ]],

Cell["Select a range of results:", "ExampleText",
 CellID->26134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT TOP 5 * FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[14]:=",
 CellID->32053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "4001", ",", "50000", ",", "0.16`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[14]=",
 CellID->18135]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT LIMIT 5 10 * FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[15]:=",
 CellID->12258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "7001", ",", "50000", ",", "0.18`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "5001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[15]=",
 CellID->2593]
}, Open  ]],

Cell["Join data from multiple tables:", "ExampleText",
 CellID->17843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<SELECT DISTINCT TITLES.TITLE FROM TITLES INNER JOIN ROYSCHED ON \
TITLES.TITLE_ID=ROYSCHED.TITLE_ID WHERE TITLES.PUB_ID='0877' AND \
ROYSCHED.ROYALTY > .1\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[16]:=",
 CellID->21693],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"Hamburger Again!\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"How to Burn a Compact Disk\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Let Them Eat Cake!\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Made to Wonder: Cooking the Macabre\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Too Many Cooks\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Treasures of the Sierra Madre\"\>", "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.2",
 CellLabel->"Out[16]=",
 CellID->16466]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.2",
 CellLabel->"In[17]:=",
 CellID->22951]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Creating Tables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18140],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->94027099],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[2]:=",
 CellID->12937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", 
   "\"\<CREATE TABLE ADDRESSES (\n    USERNAME VARCHAR NOT NULL PRIMARY KEY, \
\n    ADDRESS VARCHAR,\n    CITY VARCHAR, \n    ZIPCODE VARCHAR, \n    UNIQUE \
(ADDRESS, CITY, ZIPCODE))\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[3]:=",
 CellID->5174],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[3]=",
 CellID->2512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<CREATE TABLE MAILER (\n  MAILERID INT IDENTITY, \n  USERNAME VARCHAR \
NOT NULL, \n  SENDMAILER BIT DEFAULT '1' NOT NULL,\n  FOREIGN KEY (USERNAME) \
REFERENCES ADDRESSES (USERNAME))\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[4]:=",
 CellID->6097],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.2.3",
 CellLabel->"Out[4]=",
 CellID->9551]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", "\"\<DROP TABLE MAILER\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[5]:=",
 CellID->2695],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", "\"\<DROP TABLE ADDRESSES\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[6]:=",
 CellID->21817],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.3",
 CellLabel->"In[7]:=",
 CellID->23492]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Updating Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21292],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->29050261],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->27530],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<CREATE TABLE TEST (X INTEGER, Y DOUBLE)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[3]:=",
 CellID->613],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO TEST (X, Y) VALUES (4, 8.3)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->25296],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO TEST (X, Y) VALUES (3, 9.1)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->21710],

Cell["Update data matching a condition:", "ExampleText",
 CellID->32389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<UPDATE TEST SET X = 7 WHERE Y < 9\>\""}], 
  "]"}]], "Input",
 CellTags->"b:1.1.5",
 CellLabel->"In[6]:=",
 CellID->5628],

Cell[BoxData["1"], "Output",
 CellTags->"b:1.1.5",
 CellLabel->"Out[6]=",
 CellID->5809]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM TEST\>\""}], "]"}]], "Input",
 CellTags->"b:1.1.5",
 CellLabel->"In[7]:=",
 CellID->28786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "9.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8.3`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:1.1.5",
 CellLabel->"Out[7]=",
 CellID->31744]
}, Open  ]],

Cell["Use a prepared statement:", "ExampleText",
 CellID->18840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{
  "conn", ",", " ", "\"\<UPDATE TEST SET X = `1` WHERE Y >= `2`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:1.1.5",
 CellLabel->"In[8]:=",
 CellID->8182],

Cell[BoxData["1"], "Output",
 CellTags->"b:1.1.5",
 CellLabel->"Out[8]=",
 CellID->28569]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", " ", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM TEST\>\""}], "]"}]], "Input",
 CellTags->"b:1.1.5",
 CellLabel->"In[9]:=",
 CellID->6120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "8.3`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:1.1.5",
 CellLabel->"Out[9]=",
 CellID->27393]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", "\"\<DROP TABLE TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[10]:=",
 CellID->6292],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[11]:=",
 CellID->14962]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deleting Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14214],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->369911939],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->26807],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<CREATE TABLE TEST (X INTEGER, Y DOUBLE)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[3]:=",
 CellID->13194],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO TEST (X, Y) VALUES (4, 8.3)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->8705],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO TEST (X, Y) VALUES (3, 9.1)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->14713],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO TEST (X, Y) VALUES (1, 1.6)\>\""}], 
    "]"}], ";"}], "InputDeemphasis"]], "Input",
 CellLabel->"In[6]:=",
 CellID->7011],

Cell["Delete data matching a condition:", "ExampleText",
 CellID->18913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<DELETE FROM TEST WHERE X = 1\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[7]:=",
 CellID->6693],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[7]=",
 CellID->19664]
}, Open  ]],

Cell["Use a prepared statement:", "ExampleText",
 CellID->26203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<DELETE FROM TEST WHERE Y = `1`\>\"", ",", " ", 
   RowBox[{"{", "8.3", "}"}]}], "]"}]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[8]:=",
 CellID->28995],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.6",
 CellLabel->"Out[8]=",
 CellID->17762]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", "\"\<DROP TABLE TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[9]:=",
 CellID->14381],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.2.6",
 CellLabel->"In[10]:=",
 CellID->26946]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13675],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["SQLExecute in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Comparing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/tutorial/ComparingMathematicaAndSQLStyleQueries#\
12723"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/tutorial/ComparingMathematicaAndSQLStyleQueries#\
12723"],
  FontSlant->"Italic"],
 ButtonBox[" and SQL Queries in ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/tutorial/ComparingMathematicaAndSQLStyleQueries#\
12723"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/tutorial/ComparingMathematicaAndSQLStyleQueries#\
12723"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/tutorial/ComparingMathematicaAndSQLStyleQueries#\
12723"]
}], "Tutorials",
 CellID->66529344]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->93737341],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->148617363],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->158474803],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->603857331]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLExecute - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 50.1406243}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLExecute[conn, command] executes a command in an SQL connection. \
SQLExecute[conn, command, args] passes arguments to the command.", 
    "synonyms" -> {}, "title" -> "SQLExecute", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLExecute"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5632, 171, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66678785]},
 "b:4.2.2"->{
  Cell[11789, 438, 245, 8, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->10428],
  Cell[12134, 453, 234, 8, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->22241],
  Cell[12371, 463, 1822, 53, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->29421],
  Cell[14320, 524, 300, 10, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->16366],
  Cell[14623, 536, 1822, 53, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->12033],
  Cell[16566, 597, 344, 11, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->2270],
  Cell[16913, 610, 189, 7, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->25329],
  Cell[17234, 625, 535, 15, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->22860],
  Cell[17772, 642, 268, 9, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->2208],
  Cell[18165, 659, 200, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->22162],
  Cell[18368, 667, 135, 5, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->32506],
  Cell[18540, 677, 197, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->6878],
  Cell[18740, 685, 137, 5, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->11979],
  Cell[18914, 695, 196, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->1897],
  Cell[19113, 703, 2031, 56, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->7887],
  Cell[21181, 764, 198, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->6538],
  Cell[21382, 772, 2189, 56, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->14469],
  Cell[23608, 833, 196, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->30783],
  Cell[23807, 841, 3053, 107, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->17540],
  Cell[26967, 956, 202, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->7266],
  Cell[27172, 964, 341, 11, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->18633],
  Cell[27605, 983, 234, 8, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->24557],
  Cell[27842, 993, 1464, 41, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->2317],
  Cell[29411, 1042, 194, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->32053],
  Cell[29608, 1050, 641, 20, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->18135],
  Cell[30286, 1075, 199, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->12258],
  Cell[30488, 1083, 1164, 35, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->2593],
  Cell[31762, 1126, 324, 9, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->21693],
  Cell[32089, 1137, 502, 12, 70, "Output",
   CellTags->"b:4.2.2",
   CellID->16466],
  Cell[32606, 1152, 171, 6, 70, "Input",
   CellTags->"b:4.2.2",
   CellID->22951]},
 "b:4.2.3"->{
  Cell[33186, 1177, 239, 8, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->12937],
  Cell[33450, 1189, 367, 9, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->5174],
  Cell[33820, 1200, 88, 3, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->2512],
  Cell[33945, 1208, 350, 9, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->6097],
  Cell[34298, 1219, 88, 3, 70, "Output",
   CellTags->"b:4.2.3",
   CellID->9551],
  Cell[34401, 1225, 229, 8, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->2695],
  Cell[34633, 1235, 233, 8, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->21817],
  Cell[34869, 1245, 170, 6, 70, "Input",
   CellTags->"b:4.2.3",
   CellID->23492]},
 "b:1.1.5"->{
  Cell[36481, 1314, 202, 6, 70, "Input",
   CellTags->"b:1.1.5",
   CellID->5628],
  Cell[36686, 1322, 88, 3, 70, "Output",
   CellTags->"b:1.1.5",
   CellID->5809],
  Cell[36811, 1330, 185, 5, 70, "Input",
   CellTags->"b:1.1.5",
   CellID->28786],
  Cell[36999, 1337, 238, 9, 70, "Output",
   CellTags->"b:1.1.5",
   CellID->31744],
  Cell[37341, 1354, 266, 8, 70, "Input",
   CellTags->"b:1.1.5",
   CellID->8182],
  Cell[37610, 1364, 89, 3, 70, "Output",
   CellTags->"b:1.1.5",
   CellID->28569],
  Cell[37736, 1372, 184, 5, 70, "Input",
   CellTags->"b:1.1.5",
   CellID->6120],
  Cell[37923, 1379, 238, 9, 70, "Output",
   CellTags->"b:1.1.5",
   CellID->27393]},
 "b:4.2.5"->{
  Cell[38176, 1391, 228, 8, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->6292],
  Cell[38407, 1401, 171, 6, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->14962]},
 "b:4.2.6"->{
  Cell[40266, 1480, 225, 7, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->6693],
  Cell[40494, 1489, 89, 3, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->19664],
  Cell[40687, 1500, 269, 8, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->28995],
  Cell[40959, 1510, 89, 3, 70, "Output",
   CellTags->"b:4.2.6",
   CellID->17762],
  Cell[41063, 1516, 228, 8, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->14381],
  Cell[41294, 1526, 171, 6, 70, "Input",
   CellTags->"b:4.2.6",
   CellID->26946]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45433, 1667},
 {"b:4.2.2", 45566, 1671},
 {"b:4.2.3", 48104, 1762},
 {"b:1.1.5", 48786, 1787},
 {"b:4.2.5", 49471, 1812},
 {"b:4.2.6", 49653, 1819}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2111, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2734, 74, 47, 1, 70, "ObjectName",
 CellID->1405],
Cell[2784, 77, 766, 23, 70, "Usage",
 CellID->203337233]
}, Open  ]],
Cell[CellGroupData[{
Cell[3587, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4065, 122, 122, 4, 70, "Notes",
 CellID->7171],
Cell[4190, 128, 213, 6, 70, "Notes",
 CellID->20580],
Cell[4406, 136, 69, 1, 70, "Notes",
 CellID->22740],
Cell[4478, 139, 1117, 27, 70, "3ColumnTableMod",
 CellID->22530]
}, Closed]],
Cell[CellGroupData[{
Cell[5632, 171, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66678785],
Cell[CellGroupData[{
Cell[6016, 185, 148, 5, 70, "ExampleSection",
 CellID->252246757],
Cell[6167, 192, 135, 3, 70, "Input",
 CellID->823391247],
Cell[6305, 197, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6706, 209, 202, 7, 70, "Input",
 CellID->16586],
Cell[6911, 218, 51, 1, 70, "ExampleText",
 CellID->21604],
Cell[CellGroupData[{
Cell[6987, 223, 173, 5, 70, "Input",
 CellID->4489],
Cell[7163, 230, 508, 15, 70, "Output",
 CellID->19631]
}, Open  ]],
Cell[7686, 248, 54, 1, 70, "ExampleText",
 CellID->29744],
Cell[CellGroupData[{
Cell[7765, 253, 184, 6, 70, "Input",
 CellID->8388],
Cell[7952, 261, 67, 2, 70, "Output",
 CellID->26610]
}, Open  ]],
Cell[8034, 266, 51, 1, 70, "ExampleText",
 CellID->18718],
Cell[CellGroupData[{
Cell[8110, 271, 184, 6, 70, "Input",
 CellID->26919],
Cell[8297, 279, 67, 2, 70, "Output",
 CellID->18259]
}, Open  ]],
Cell[CellGroupData[{
Cell[8401, 286, 257, 8, 70, "Input",
 CellID->5927],
Cell[8661, 296, 67, 2, 70, "Output",
 CellID->14609]
}, Open  ]],
Cell[8743, 301, 51, 1, 70, "ExampleText",
 CellID->28119],
Cell[CellGroupData[{
Cell[8819, 306, 158, 4, 70, "Input",
 CellID->21479],
Cell[8980, 312, 216, 8, 70, "Output",
 CellID->22716]
}, Open  ]],
Cell[9211, 323, 50, 1, 70, "ExampleText",
 CellID->6300],
Cell[CellGroupData[{
Cell[9286, 328, 163, 5, 70, "Input",
 CellID->21396],
Cell[9452, 335, 67, 2, 70, "Output",
 CellID->16853]
}, Open  ]],
Cell[CellGroupData[{
Cell[9556, 342, 158, 4, 70, "Input",
 CellID->11458],
Cell[9717, 348, 216, 8, 70, "Output",
 CellID->20830]
}, Open  ]],
Cell[9948, 359, 51, 1, 70, "ExampleText",
 CellID->24593],
Cell[CellGroupData[{
Cell[10024, 364, 157, 4, 70, "Input",
 CellID->30806],
Cell[10184, 370, 68, 2, 70, "Output",
 CellID->29849]
}, Open  ]],
Cell[10267, 375, 54, 1, 70, "ExampleText",
 CellID->14854],
Cell[CellGroupData[{
Cell[10346, 380, 156, 4, 70, "Input",
 CellID->24272],
Cell[10505, 386, 68, 2, 70, "Output",
 CellID->26160]
}, Open  ]],
Cell[10588, 391, 149, 5, 70, "Input",
 CellID->12294],
Cell[10740, 398, 402, 10, 70, "ExampleText",
 CellID->105929776]
}, Open  ]],
Cell[CellGroupData[{
Cell[11179, 413, 214, 7, 70, "ExampleSection",
 CellID->146],
Cell[CellGroupData[{
Cell[11418, 424, 230, 7, 70, "ExampleSubsection",
 CellID->4229],
Cell[11651, 433, 135, 3, 70, "Input",
 CellID->226634127],
Cell[11789, 438, 245, 8, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->10428],
Cell[12037, 448, 72, 1, 70, "ExampleText",
 CellID->10559],
Cell[CellGroupData[{
Cell[12134, 453, 234, 8, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->22241],
Cell[12371, 463, 1822, 53, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->29421]
}, Open  ]],
Cell[14208, 519, 87, 1, 70, "ExampleText",
 CellID->22688],
Cell[CellGroupData[{
Cell[14320, 524, 300, 10, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->16366],
Cell[14623, 536, 1822, 53, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->12033]
}, Open  ]],
Cell[16460, 592, 81, 1, 70, "ExampleText",
 CellID->26685],
Cell[CellGroupData[{
Cell[16566, 597, 344, 11, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->2270],
Cell[16913, 610, 189, 7, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->25329]
}, Open  ]],
Cell[17117, 620, 92, 1, 70, "ExampleText",
 CellID->32261],
Cell[CellGroupData[{
Cell[17234, 625, 535, 15, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->22860],
Cell[17772, 642, 268, 9, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->2208]
}, Open  ]],
Cell[18055, 654, 85, 1, 70, "ExampleText",
 CellID->8982],
Cell[CellGroupData[{
Cell[18165, 659, 200, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->22162],
Cell[18368, 667, 135, 5, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->32506]
}, Open  ]],
Cell[CellGroupData[{
Cell[18540, 677, 197, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->6878],
Cell[18740, 685, 137, 5, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->11979]
}, Open  ]],
Cell[CellGroupData[{
Cell[18914, 695, 196, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->1897],
Cell[19113, 703, 2031, 56, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->7887]
}, Open  ]],
Cell[CellGroupData[{
Cell[21181, 764, 198, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->6538],
Cell[21382, 772, 2189, 56, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->14469]
}, Open  ]],
Cell[CellGroupData[{
Cell[23608, 833, 196, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->30783],
Cell[23807, 841, 3053, 107, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->17540]
}, Open  ]],
Cell[26875, 951, 67, 1, 70, "ExampleText",
 CellID->22795],
Cell[CellGroupData[{
Cell[26967, 956, 202, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->7266],
Cell[27172, 964, 341, 11, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->18633]
}, Open  ]],
Cell[27528, 978, 52, 1, 70, "ExampleText",
 CellID->13509],
Cell[CellGroupData[{
Cell[27605, 983, 234, 8, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->24557],
Cell[27842, 993, 1464, 41, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->2317]
}, Open  ]],
Cell[29321, 1037, 65, 1, 70, "ExampleText",
 CellID->26134],
Cell[CellGroupData[{
Cell[29411, 1042, 194, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->32053],
Cell[29608, 1050, 641, 20, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->18135]
}, Open  ]],
Cell[CellGroupData[{
Cell[30286, 1075, 199, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->12258],
Cell[30488, 1083, 1164, 35, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->2593]
}, Open  ]],
Cell[31667, 1121, 70, 1, 70, "ExampleText",
 CellID->17843],
Cell[CellGroupData[{
Cell[31762, 1126, 324, 9, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->21693],
Cell[32089, 1137, 502, 12, 70, "Output",
 CellTags->"b:4.2.2",
 CellID->16466]
}, Open  ]],
Cell[32606, 1152, 171, 6, 70, "Input",
 CellTags->"b:4.2.2",
 CellID->22951]
}, Closed]],
Cell[CellGroupData[{
Cell[32814, 1163, 232, 7, 70, "ExampleSubsection",
 CellID->18140],
Cell[33049, 1172, 134, 3, 70, "Input",
 CellID->94027099],
Cell[33186, 1177, 239, 8, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->12937],
Cell[CellGroupData[{
Cell[33450, 1189, 367, 9, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->5174],
Cell[33820, 1200, 88, 3, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->2512]
}, Open  ]],
Cell[CellGroupData[{
Cell[33945, 1208, 350, 9, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->6097],
Cell[34298, 1219, 88, 3, 70, "Output",
 CellTags->"b:4.2.3",
 CellID->9551]
}, Open  ]],
Cell[34401, 1225, 229, 8, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->2695],
Cell[34633, 1235, 233, 8, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->21817],
Cell[34869, 1245, 170, 6, 70, "Input",
 CellTags->"b:4.2.3",
 CellID->23492]
}, Closed]],
Cell[CellGroupData[{
Cell[35076, 1256, 230, 7, 70, "ExampleSubsection",
 CellID->21292],
Cell[35309, 1265, 134, 3, 70, "Input",
 CellID->29050261],
Cell[35446, 1270, 202, 7, 70, "Input",
 CellID->27530],
Cell[35651, 1279, 240, 8, 70, "Input",
 CellID->613],
Cell[35894, 1289, 242, 8, 70, "Input",
 CellID->25296],
Cell[36139, 1299, 242, 8, 70, "Input",
 CellID->21710],
Cell[36384, 1309, 72, 1, 70, "ExampleText",
 CellID->32389],
Cell[CellGroupData[{
Cell[36481, 1314, 202, 6, 70, "Input",
 CellTags->"b:1.1.5",
 CellID->5628],
Cell[36686, 1322, 88, 3, 70, "Output",
 CellTags->"b:1.1.5",
 CellID->5809]
}, Open  ]],
Cell[CellGroupData[{
Cell[36811, 1330, 185, 5, 70, "Input",
 CellTags->"b:1.1.5",
 CellID->28786],
Cell[36999, 1337, 238, 9, 70, "Output",
 CellTags->"b:1.1.5",
 CellID->31744]
}, Open  ]],
Cell[37252, 1349, 64, 1, 70, "ExampleText",
 CellID->18840],
Cell[CellGroupData[{
Cell[37341, 1354, 266, 8, 70, "Input",
 CellTags->"b:1.1.5",
 CellID->8182],
Cell[37610, 1364, 89, 3, 70, "Output",
 CellTags->"b:1.1.5",
 CellID->28569]
}, Open  ]],
Cell[CellGroupData[{
Cell[37736, 1372, 184, 5, 70, "Input",
 CellTags->"b:1.1.5",
 CellID->6120],
Cell[37923, 1379, 238, 9, 70, "Output",
 CellTags->"b:1.1.5",
 CellID->27393]
}, Open  ]],
Cell[38176, 1391, 228, 8, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->6292],
Cell[38407, 1401, 171, 6, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->14962]
}, Closed]],
Cell[CellGroupData[{
Cell[38615, 1412, 230, 7, 70, "ExampleSubsection",
 CellID->14214],
Cell[38848, 1421, 135, 3, 70, "Input",
 CellID->369911939],
Cell[38986, 1426, 202, 7, 70, "Input",
 CellID->26807],
Cell[39191, 1435, 242, 8, 70, "Input",
 CellID->13194],
Cell[39436, 1445, 241, 8, 70, "Input",
 CellID->8705],
Cell[39680, 1455, 242, 8, 70, "Input",
 CellID->14713],
Cell[39925, 1465, 241, 8, 70, "Input",
 CellID->7011],
Cell[40169, 1475, 72, 1, 70, "ExampleText",
 CellID->18913],
Cell[CellGroupData[{
Cell[40266, 1480, 225, 7, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->6693],
Cell[40494, 1489, 89, 3, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->19664]
}, Open  ]],
Cell[40598, 1495, 64, 1, 70, "ExampleText",
 CellID->26203],
Cell[CellGroupData[{
Cell[40687, 1500, 269, 8, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->28995],
Cell[40959, 1510, 89, 3, 70, "Output",
 CellTags->"b:4.2.6",
 CellID->17762]
}, Open  ]],
Cell[41063, 1516, 228, 8, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->14381],
Cell[41294, 1526, 171, 6, 70, "Input",
 CellTags->"b:4.2.6",
 CellID->26946]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41526, 1539, 314, 9, 70, "TutorialsSection",
 CellID->13675],
Cell[41843, 1550, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[42133, 1561, 399, 12, 70, "Tutorials",
 CellID->14193],
Cell[42535, 1575, 850, 29, 70, "Tutorials",
 CellID->66529344]
}, Open  ]],
Cell[CellGroupData[{
Cell[43422, 1609, 318, 9, 70, "MoreAboutSection",
 CellID->93737341],
Cell[43743, 1620, 179, 4, 70, "MoreAbout",
 CellID->148617363],
Cell[43925, 1626, 188, 4, 70, "MoreAbout",
 CellID->158474803],
Cell[44116, 1632, 171, 4, 70, "MoreAbout",
 CellID->603857331]
}, Open  ]],
Cell[44302, 1639, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

