(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14490,        477]
NotebookOptionsPosition[      9251,        321]
NotebookOutlinePosition[     12536,        411]
CellTagsIndexPosition[     12145,        399]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Data Type Mapping in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/DataTypeMapping#24423"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Data Type Mapping in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLBinary" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLBinary"], 
          "SQLDateTime" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDateTime"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"SQLBinary\"\>", 
       2->"\<\"SQLDateTime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLExpr", "ObjectName",
 CellID->15623],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLExpr", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["allows a ", "Text"],
     StyleBox["Mathematica", "Text",
      FontSlant->"Italic"],
     StyleBox[" expression to be stored in a database.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->336595540],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->14816104],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,418"},
 CellLabel->"In[2]:=",
 CellID->26880],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<EXPRTABLE\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<EXPRCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<VARCHAR\>\""}]}], 
      "]"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,6",
 CellLabel->"In[3]:=",
 CellID->12253],

Cell["Insert an expression:", "ExampleText",
 CellID->3293],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", "\"\<EXPRTABLE\>\"", ",", " ", 
    RowBox[{"{", "\"\<EXPRCOL\>\"", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SQLExpr", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"x", "^", "2"}], "]"}], "]"}], "}"}]}], "]"}], ";"}]], "Input",\

 CellTags->{"b:6.1.3", "Ex--21943418559164291386,420"},
 CellLabel->"In[4]:=",
 CellID->21321],

Cell["Select an expression:", "ExampleText",
 CellID->20785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<EXPRTABLE\>\""}], "]"}]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
 CellLabel->"In[5]:=",
 CellID->26528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"SQLExpr", "[", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}], "]"}], "}"}], "}"}]], "Output",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
 CellLabel->"Out[5]=",
 CellID->10443]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<EXPRTABLE\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,422"},
 CellLabel->"In[6]:=",
 CellID->31000],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,423"},
 CellLabel->"In[7]:=",
 CellID->10555]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLBinary",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLBinary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDateTime",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2927],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Data Type Mapping in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping#24423"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->104639389],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->56204380]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLExpr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 51.3437416}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLExpr[expr] allows a Mathematica expression to be stored in a \
database.", "synonyms" -> {}, "title" -> "SQLExpr", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLExpr"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3395, 104, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:6.1.3"->{
  Cell[4461, 142, 273, 8, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,418"},
   CellID->26880],
  Cell[5251, 169, 408, 12, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,420"},
   CellID->21321],
  Cell[5747, 188, 204, 5, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
   CellID->26528],
  Cell[5954, 195, 262, 8, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
   CellID->10443],
  Cell[6231, 206, 263, 8, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,422"},
   CellID->31000],
  Cell[6497, 216, 223, 7, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,423"},
   CellID->10555]},
 "Ex--21943418559164291386,418"->{
  Cell[4461, 142, 273, 8, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,418"},
   CellID->26880]},
 "Ex--21950856252955103714,6"->{
  Cell[4737, 152, 449, 12, 70, "Input",
   CellTags->"Ex--21950856252955103714,6",
   CellID->12253]},
 "Ex--21943418559164291386,420"->{
  Cell[5251, 169, 408, 12, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,420"},
   CellID->21321]},
 "Ex--21943418559164291386,421"->{
  Cell[5747, 188, 204, 5, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
   CellID->26528],
  Cell[5954, 195, 262, 8, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
   CellID->10443]},
 "Ex--21943418559164291386,422"->{
  Cell[6231, 206, 263, 8, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,422"},
   CellID->31000]},
 "Ex--21943418559164291386,423"->{
  Cell[6497, 216, 223, 7, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943418559164291386,423"},
   CellID->10555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10283, 346},
 {"b:6.1.3", 10409, 350},
 {"Ex--21943418559164291386,418", 11143, 369},
 {"Ex--21950856252955103714,6", 11293, 373},
 {"Ex--21943418559164291386,420", 11431, 377},
 {"Ex--21943418559164291386,421", 11584, 381},
 {"Ex--21943418559164291386,422", 11853, 388},
 {"Ex--21943418559164291386,423", 12005, 392}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2165, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2788, 80, 45, 1, 70, "ObjectName",
 CellID->15623],
Cell[2836, 83, 522, 16, 70, "Usage",
 CellID->17922]
}, Open  ]],
Cell[CellGroupData[{
Cell[3395, 104, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3772, 118, 148, 5, 70, "ExampleSection",
 CellID->336595540],
Cell[3923, 125, 134, 3, 70, "Input",
 CellID->14816104],
Cell[4060, 130, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4461, 142, 273, 8, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,418"},
 CellID->26880],
Cell[4737, 152, 449, 12, 70, "Input",
 CellTags->"Ex--21950856252955103714,6",
 CellID->12253],
Cell[5189, 166, 59, 1, 70, "ExampleText",
 CellID->3293],
Cell[5251, 169, 408, 12, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,420"},
 CellID->21321],
Cell[5662, 183, 60, 1, 70, "ExampleText",
 CellID->20785],
Cell[CellGroupData[{
Cell[5747, 188, 204, 5, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
 CellID->26528],
Cell[5954, 195, 262, 8, 70, "Output",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,421"},
 CellID->10443]
}, Open  ]],
Cell[6231, 206, 263, 8, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,422"},
 CellID->31000],
Cell[6497, 216, 223, 7, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943418559164291386,423"},
 CellID->10555]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6769, 229, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7088, 240, 489, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7614, 262, 313, 9, 70, "TutorialsSection",
 CellID->2927],
Cell[7930, 273, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[8220, 284, 443, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[8700, 301, 319, 9, 70, "MoreAboutSection",
 CellID->104639389],
Cell[9022, 312, 187, 4, 70, "MoreAbout",
 CellID->56204380]
}, Open  ]],
Cell[9224, 319, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

