(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21593,        699]
NotebookOptionsPosition[     13909,        473]
NotebookOutlinePosition[     18535,        597]
CellTagsIndexPosition[     18050,        583]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Inserting Data in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/InsertingData"], 
          "Inserting Data with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLInsertingData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Inserting Data in DatabaseLink User Guide\"\>", 
       3->"\<\"Inserting Data with Raw SQL in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"], 
          "SQLDelete" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDelete"], 
          "SQLSelect" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSelect"], 
          "SQLUpdate" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLUpdate"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLExecute\"\>", 
       2->"\<\"SQLDelete\"\>", 3->"\<\"SQLSelect\"\>", 
       4->"\<\"SQLUpdate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"SQL Data Access and Manipulation\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLInsert", "ObjectName",
 CellID->13293],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLInsert", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"], ",", 
        StyleBox["cols", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts data into a table in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->23332],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->19044]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134856025],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->15843528],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->284651822],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,247"},
 CellLabel->"In[2]:=",
 CellID->14066],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<INTEGER\>\""}]}], 
       "]"}], ",", " ", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "\[Rule]", "\"\<DOUBLE\>\""}]}], 
       "]"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"Ex--21950856252955103714,5",
 CellLabel->"In[3]:=",
 CellID->11738],

Cell["Insert one row:", "ExampleText",
 CellID->19801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
   RowBox[{"{", 
    RowBox[{"10", ",", " ", "10.5"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
 CellLabel->"In[4]:=",
 CellID->19623],

Cell[BoxData["1"], "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
 CellLabel->"Out[4]=",
 CellID->13843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
 CellLabel->"In[5]:=",
 CellID->441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "10.5`"}], "}"}], "}"}]], "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
 CellLabel->"Out[5]=",
 CellID->3380]
}, Open  ]],

Cell["Insert multiple rows (batch insert):", "ExampleText",
 CellID->19695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", " ", "10.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "55.1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
 CellLabel->"In[6]:=",
 CellID->7918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
 CellLabel->"Out[6]=",
 CellID->3659]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
 CellLabel->"In[7]:=",
 CellID->1363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "10.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "55.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
 CellLabel->"Out[7]=",
 CellID->12628]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,253"},
 CellLabel->"In[8]:=",
 CellID->6329],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,254"},
 CellLabel->"In[9]:=",
 CellID->1088]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSelect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLUpdate",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32331],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Inserting Data in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/InsertingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/InsertingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/InsertingData"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Inserting Data with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLInsertingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLInsertingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLInsertingData"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->100786095],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->133037592],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->101049478],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->530958199]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLInsert - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 52.2343609}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLInsert[conn, table, cols, data] inserts data into a table in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLInsert", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLInsert"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5290, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->134856025]},
 "b:4.1.3"->{
  Cell[6364, 195, 273, 8, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,247"},
   CellID->14066],
  Cell[7357, 229, 364, 9, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
   CellID->19623],
  Cell[7724, 240, 123, 3, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
   CellID->13843],
  Cell[7884, 248, 197, 5, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
   CellID->441],
  Cell[8084, 255, 196, 6, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
   CellID->3380],
  Cell[8395, 269, 472, 13, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
   CellID->7918],
  Cell[8870, 284, 167, 5, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
   CellID->3659],
  Cell[9074, 294, 198, 5, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
   CellID->1363],
  Cell[9275, 301, 340, 11, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
   CellID->12628],
  Cell[9630, 315, 257, 8, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,253"},
   CellID->6329],
  Cell[9890, 325, 203, 6, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,254"},
   CellID->1088]},
 "Ex--21943492438155078303,247"->{
  Cell[6364, 195, 273, 8, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,247"},
   CellID->14066]},
 "Ex--21950856252955103714,5"->{
  Cell[6640, 205, 635, 17, 70, "Input",
   CellTags->"Ex--21950856252955103714,5",
   CellID->11738]},
 "Ex--21943492438155078303,249"->{
  Cell[7357, 229, 364, 9, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
   CellID->19623],
  Cell[7724, 240, 123, 3, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
   CellID->13843]},
 "Ex--21943492438155078303,250"->{
  Cell[7884, 248, 197, 5, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
   CellID->441],
  Cell[8084, 255, 196, 6, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
   CellID->3380]},
 "Ex--21943492438155078303,251"->{
  Cell[8395, 269, 472, 13, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
   CellID->7918],
  Cell[8870, 284, 167, 5, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
   CellID->3659]},
 "Ex--21943492438155078303,252"->{
  Cell[9074, 294, 198, 5, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
   CellID->1363],
  Cell[9275, 301, 340, 11, 70, "Output",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
   CellID->12628]},
 "Ex--21943492438155078303,253"->{
  Cell[9630, 315, 257, 8, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,253"},
   CellID->6329]},
 "Ex--21943492438155078303,254"->{
  Cell[9890, 325, 203, 6, 70, "Input",
   CellTags->{"b:4.1.3", "Ex--21943492438155078303,254"},
   CellID->1088]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14956, 498},
 {"b:4.1.3", 15090, 502},
 {"Ex--21943492438155078303,247", 16400, 536},
 {"Ex--21950856252955103714,5", 16550, 540},
 {"Ex--21943492438155078303,249", 16688, 544},
 {"Ex--21943492438155078303,250", 16957, 551},
 {"Ex--21943492438155078303,251", 17223, 558},
 {"Ex--21943492438155078303,252", 17491, 565},
 {"Ex--21943492438155078303,253", 17760, 572},
 {"Ex--21943492438155078303,254", 17911, 576}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3017, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3640, 96, 47, 1, 70, "ObjectName",
 CellID->13293],
Cell[3690, 99, 538, 16, 70, "Usage",
 CellID->24099]
}, Open  ]],
Cell[CellGroupData[{
Cell[4265, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4743, 137, 68, 1, 70, "Notes",
 CellID->23332],
Cell[4814, 140, 439, 12, 70, "3ColumnTableMod",
 CellID->19044]
}, Closed]],
Cell[CellGroupData[{
Cell[5290, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134856025],
Cell[CellGroupData[{
Cell[5675, 171, 147, 5, 70, "ExampleSection",
 CellID->15843528],
Cell[5825, 178, 135, 3, 70, "Input",
 CellID->284651822],
Cell[5963, 183, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6364, 195, 273, 8, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,247"},
 CellID->14066],
Cell[6640, 205, 635, 17, 70, "Input",
 CellTags->"Ex--21950856252955103714,5",
 CellID->11738],
Cell[7278, 224, 54, 1, 70, "ExampleText",
 CellID->19801],
Cell[CellGroupData[{
Cell[7357, 229, 364, 9, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
 CellID->19623],
Cell[7724, 240, 123, 3, 70, "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,249"},
 CellID->13843]
}, Open  ]],
Cell[CellGroupData[{
Cell[7884, 248, 197, 5, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
 CellID->441],
Cell[8084, 255, 196, 6, 70, "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,250"},
 CellID->3380]
}, Open  ]],
Cell[8295, 264, 75, 1, 70, "ExampleText",
 CellID->19695],
Cell[CellGroupData[{
Cell[8395, 269, 472, 13, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
 CellID->7918],
Cell[8870, 284, 167, 5, 70, "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,251"},
 CellID->3659]
}, Open  ]],
Cell[CellGroupData[{
Cell[9074, 294, 198, 5, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
 CellID->1363],
Cell[9275, 301, 340, 11, 70, "Output",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,252"},
 CellID->12628]
}, Open  ]],
Cell[9630, 315, 257, 8, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,253"},
 CellID->6329],
Cell[9890, 325, 203, 6, 70, "Input",
 CellTags->{"b:4.1.3", "Ex--21943492438155078303,254"},
 CellID->1088]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10142, 337, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10461, 348, 1007, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11505, 388, 314, 9, 70, "TutorialsSection",
 CellID->32331],
Cell[11822, 399, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[12112, 410, 412, 12, 70, "Tutorials",
 CellID->14193],
Cell[12527, 424, 437, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[13001, 441, 319, 9, 70, "MoreAboutSection",
 CellID->100786095],
Cell[13323, 452, 179, 4, 70, "MoreAbout",
 CellID->133037592],
Cell[13505, 458, 188, 4, 70, "MoreAbout",
 CellID->101049478],
Cell[13696, 464, 171, 4, 70, "MoreAbout",
 CellID->530958199]
}, Open  ]],
Cell[13882, 471, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

