(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14056,        465]
NotebookOptionsPosition[     11110,        366]
NotebookOutlinePosition[     12647,        412]
CellTagsIndexPosition[     12536,        406]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Selecting Data in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SelectingData"], 
          "Selecting Data with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLSelectingData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Selecting Data in DatabaseLink User Guide\"\>", 
       3->"\<\"Selecting Data with Raw SQL in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLStringMatchQ" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLStringMatchQ"],
           "SQLSelect" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSelect"], 
          "SQLInsert" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLInsert"], 
          "SQLUpdate" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLUpdate"], 
          "SQLDelete" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDelete"], 
          "SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLStringMatchQ\"\>", 
       2->"\<\"SQLSelect\"\>", 3->"\<\"SQLInsert\"\>", 4->"\<\"SQLUpdate\"\>",
        5->"\<\"SQLDelete\"\>", 6->"\<\"SQLExecute\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SQL Data Access and Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLMemberQ", "ObjectName",
 CellID->17610],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLMemberQ", "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["column", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies a condition in an SQL query used to test \
whether an element of a list matches the value of a column."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->679044558],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->227112632],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->11715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLMemberQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".14", ",", " ", ".16"}], "}"}], ",", " ", 
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:4.1.1",
 CellLabel->"In[3]:=",
 CellID->20253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.1",
 CellLabel->"Out[3]=",
 CellID->31805]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->23684]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLStringMatchQ",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLStringMatchQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSelect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLUpdate",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27256],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Selecting Data in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Selecting Data with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305177275],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->441218909]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLMemberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 53.2031047}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLMemberQ[data, column] specifies a condition in an SQL query used to \
test whether an element of a list matches the value of a column.", 
    "synonyms" -> {}, "title" -> "SQLMemberQ", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLMemberQ"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4164, 117, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:4.1.1"->{
  Cell[5463, 166, 463, 13, 70, "Input",
   CellTags->"b:4.1.1",
   CellID->20253],
  Cell[5929, 181, 1026, 29, 70, "Output",
   CellTags->"b:4.1.1",
   CellID->31805]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12218, 392},
 {"b:4.1.1", 12344, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2924, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3547, 94, 48, 1, 70, "ObjectName",
 CellID->17610],
Cell[3598, 97, 529, 15, 70, "Usage",
 CellID->24828]
}, Open  ]],
Cell[CellGroupData[{
Cell[4164, 117, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4541, 131, 148, 5, 70, "ExampleSection",
 CellID->679044558],
Cell[4692, 138, 135, 3, 70, "Input",
 CellID->227112632],
Cell[4830, 143, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5231, 155, 207, 7, 70, "Input",
 CellID->11715],
Cell[CellGroupData[{
Cell[5463, 166, 463, 13, 70, "Input",
 CellTags->"b:4.1.1",
 CellID->20253],
Cell[5929, 181, 1026, 29, 70, "Output",
 CellTags->"b:4.1.1",
 CellID->31805]
}, Open  ]],
Cell[6970, 213, 148, 5, 70, "Input",
 CellID->23684]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7167, 224, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7486, 235, 1539, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9062, 293, 314, 9, 70, "TutorialsSection",
 CellID->27256],
Cell[9379, 304, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9669, 315, 412, 12, 70, "Tutorials",
 CellID->14193],
Cell[10084, 329, 437, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[10558, 346, 319, 9, 70, "MoreAboutSection",
 CellID->305177275],
Cell[10880, 357, 188, 4, 70, "MoreAbout",
 CellID->441218909]
}, Open  ]],
Cell[11083, 364, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

