(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10421,        365]
NotebookOptionsPosition[      7669,        271]
NotebookOutlinePosition[      9124,        316]
CellTagsIndexPosition[      9015,        310]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetClose", "ObjectName",
 CellID->28233],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetClose", "[", 
       StyleBox["rs", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox["closes a result set.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->718701278],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2953039],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->31034],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14512],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[4]:=",
 CellID->24593],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[5]:=",
 CellID->530]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29171],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->47607588],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->24444013]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetClose - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 54.0624742}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetClose[rs] closes a result set.", "synonyms" -> {}, "title" -> 
    "SQLResultSetClose", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/SQLResultSetClose"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3325, 103, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:6.2.1"->{
  Cell[4844, 160, 132, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->24593],
  Cell[4979, 166, 173, 6, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->530]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8703, 296},
 {"b:6.2.1", 8829, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2198, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2821, 82, 55, 1, 70, "ObjectName",
 CellID->28233],
Cell[2879, 85, 409, 13, 70, "Usage",
 CellID->3995]
}, Open  ]],
Cell[CellGroupData[{
Cell[3325, 103, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3702, 117, 148, 5, 70, "ExampleSection",
 CellID->718701278],
Cell[3853, 124, 133, 3, 70, "Input",
 CellID->2953039],
Cell[3989, 129, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4390, 141, 207, 7, 70, "Input",
 CellID->31034],
Cell[4600, 150, 241, 8, 70, "Input",
 CellID->14512],
Cell[4844, 160, 132, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->24593],
Cell[4979, 166, 173, 6, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->530]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5201, 178, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5520, 189, 502, 17, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[6059, 211, 314, 9, 70, "TutorialsSection",
 CellID->29171],
Cell[6376, 222, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[6666, 233, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[7107, 250, 318, 9, 70, "MoreAboutSection",
 CellID->47607588],
Cell[7428, 261, 199, 5, 70, "MoreAbout",
 CellID->24444013]
}, Open  ]],
Cell[7642, 269, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

