(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21381,        817]
NotebookOptionsPosition[     15039,        586]
NotebookOutlinePosition[     17107,        652]
CellTagsIndexPosition[     16996,        646]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>", 
       3->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetCurrent", "ObjectName",
 CellID->3873],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetCurrent", "[", 
       StyleBox["rs", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads the current row from a result set."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4327]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->3413],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "return the results as strings", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3454]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5506888],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->78876602],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->785478668],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->5646],

Cell["Open a result set:", "ExampleText",
 CellID->23525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[3]:=",
 CellID->28213],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"8", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[3]=",
 CellID->16824]
}, Open  ]],

Cell["Shift the current position to the first row:", "ExampleText",
 CellID->17929],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetShift", "[", 
   RowBox[{"rs", ",", "1"}], "]"}], ";"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[4]:=",
 CellID->8695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[5]:=",
 CellID->25403],

Cell[BoxData["1"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[5]=",
 CellID->12594]
}, Open  ]],

Cell["Get the current row:", "ExampleText",
 CellID->7993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[6]:=",
 CellID->26067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], 
  "}"}]], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[6]=",
 CellID->22187]
}, Open  ]],

Cell["Close the result set:", "ExampleText",
 CellID->4640],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[7]:=",
 CellID->25079],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[8]:=",
 CellID->10041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12534],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"GetAsStrings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4860],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->297293964],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->4907],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32621],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetShift", "[", 
   RowBox[{"rs", ",", "1"}], "]"}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetCurrent", "[", 
   RowBox[{"rs", ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", "->", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->25293],

Cell["{\"BS1011\", \"0\", \"5000\", \"0.1\"}", "Output",
 CellLabel->"Out[5]//InputForm=",
 CellID->5117]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->7717],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[7]:=",
 CellID->20403]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->435884432],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->10639],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29011],

Cell["There is nothing to read before the first row:", "ExampleText",
 CellID->26925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24028],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[4]=",
 CellID->19978]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->10748],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"No data is available\\\"\\)\"\>"}]], "Message", "MSG",
 CellID->2850],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[5]=",
 CellID->22892]
}, Open  ]],

Cell["There is nothing to read after the last row:", "ExampleText",
 CellID->26444],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetGoto", "[", 
   RowBox[{"rs", ",", " ", "Infinity"}], "]"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->23623],

Cell[BoxData["52"], "Output",
 CellLabel->"Out[7]=",
 CellID->24353]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->12036],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"No data is available\\\"\\)\"\>"}]], "Message", "MSG",
 CellID->31547],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[8]=",
 CellID->21346]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->826],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[10]:=",
 CellID->16061]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31896],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14726330],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->458620760]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetCurrent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 56.0624614}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetCurrent[rs] reads the current row from a result set.", 
    "synonyms" -> {}, "title" -> "SQLResultSetCurrent", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLResultSetCurrent"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4512, 142, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5506888]},
 "b:6.2.3"->{
  Cell[5875, 194, 263, 9, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->28213],
  Cell[6141, 205, 189, 6, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->16824],
  Cell[6431, 217, 173, 6, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->8695],
  Cell[6629, 227, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->25403],
  Cell[6767, 233, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->12594],
  Cell[6954, 244, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->26067],
  Cell[7091, 250, 176, 6, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->22187],
  Cell[7344, 262, 132, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->25079],
  Cell[7479, 268, 175, 6, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->10041]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16101, 611},
 {"b:6.2.3", 16233, 615}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 85, 56, 1, 70, "ObjectName",
 CellID->3873],
Cell[3037, 88, 404, 12, 70, "Usage",
 CellID->4327]
}, Open  ]],
Cell[CellGroupData[{
Cell[3478, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3956, 122, 67, 1, 70, "Notes",
 CellID->3413],
Cell[4026, 125, 449, 12, 70, "3ColumnTableMod",
 CellID->3454]
}, Closed]],
Cell[CellGroupData[{
Cell[4512, 142, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5506888],
Cell[CellGroupData[{
Cell[4895, 156, 147, 5, 70, "ExampleSection",
 CellID->78876602],
Cell[5045, 163, 135, 3, 70, "Input",
 CellID->785478668],
Cell[5183, 168, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5584, 180, 206, 7, 70, "Input",
 CellID->5646],
Cell[5793, 189, 57, 1, 70, "ExampleText",
 CellID->23525],
Cell[CellGroupData[{
Cell[5875, 194, 263, 9, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->28213],
Cell[6141, 205, 189, 6, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->16824]
}, Open  ]],
Cell[6345, 214, 83, 1, 70, "ExampleText",
 CellID->17929],
Cell[6431, 217, 173, 6, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->8695],
Cell[CellGroupData[{
Cell[6629, 227, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->25403],
Cell[6767, 233, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->12594]
}, Open  ]],
Cell[6871, 239, 58, 1, 70, "ExampleText",
 CellID->7993],
Cell[CellGroupData[{
Cell[6954, 244, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->26067],
Cell[7091, 250, 176, 6, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->22187]
}, Open  ]],
Cell[7282, 259, 59, 1, 70, "ExampleText",
 CellID->4640],
Cell[7344, 262, 132, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->25079],
Cell[7479, 268, 175, 6, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->10041]
}, Open  ]],
Cell[CellGroupData[{
Cell[7691, 279, 218, 7, 70, "ExampleSection",
 CellID->12534],
Cell[CellGroupData[{
Cell[7934, 290, 232, 7, 70, "ExampleSubsection",
 CellID->4860],
Cell[8169, 299, 135, 3, 70, "Input",
 CellID->297293964],
Cell[8307, 304, 206, 7, 70, "Input",
 CellID->4907],
Cell[8516, 313, 241, 8, 70, "Input",
 CellID->32621],
Cell[8760, 323, 152, 5, 70, "Input",
 CellID->27692],
Cell[CellGroupData[{
Cell[8937, 332, 224, 7, 70, "Input",
 CellID->25293],
Cell[9164, 341, 105, 2, 70, "Output",
 CellID->5117]
}, Open  ]],
Cell[9284, 346, 109, 3, 70, "Input",
 CellID->7717],
Cell[9396, 351, 148, 5, 70, "Input",
 CellID->20403]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[9593, 362, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[9827, 371, 135, 3, 70, "Input",
 CellID->435884432],
Cell[9965, 376, 207, 7, 70, "Input",
 CellID->10639],
Cell[10175, 385, 241, 8, 70, "Input",
 CellID->29011],
Cell[10419, 395, 85, 1, 70, "ExampleText",
 CellID->26925],
Cell[CellGroupData[{
Cell[10529, 400, 113, 3, 70, "Input",
 CellID->24028],
Cell[10645, 405, 67, 2, 70, "Output",
 CellID->19978]
}, Open  ]],
Cell[CellGroupData[{
Cell[10749, 412, 112, 3, 70, "Input",
 CellID->10748],
Cell[10864, 417, 164, 4, 70, "Message",
 CellID->2850],
Cell[11031, 423, 73, 2, 70, "Output",
 CellID->22892]
}, Open  ]],
Cell[11119, 428, 83, 1, 70, "ExampleText",
 CellID->26444],
Cell[11205, 431, 163, 5, 70, "Input",
 CellID->10654],
Cell[CellGroupData[{
Cell[11393, 440, 113, 3, 70, "Input",
 CellID->23623],
Cell[11509, 445, 68, 2, 70, "Output",
 CellID->24353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11614, 452, 112, 3, 70, "Input",
 CellID->12036],
Cell[11729, 457, 165, 4, 70, "Message",
 CellID->31547],
Cell[11897, 463, 73, 2, 70, "Output",
 CellID->21346]
}, Open  ]],
Cell[11985, 468, 108, 3, 70, "Input",
 CellID->826],
Cell[12096, 473, 149, 5, 70, "Input",
 CellID->16061]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12294, 484, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12613, 495, 778, 26, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[13428, 526, 314, 9, 70, "TutorialsSection",
 CellID->31896],
Cell[13745, 537, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[14035, 548, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[14476, 565, 318, 9, 70, "MoreAboutSection",
 CellID->14726330],
Cell[14797, 576, 200, 5, 70, "MoreAbout",
 CellID->458620760]
}, Open  ]],
Cell[15012, 584, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

