(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16844,        555]
NotebookOptionsPosition[     10440,        365]
NotebookOutlinePosition[     14363,        472]
CellTagsIndexPosition[     13930,        459]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetClose\"\>", 
       2->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"Database Transactions and Result Sets\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetOpen", "ObjectName",
 CellID->7118],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetOpen", "[", 
       StyleBox["query", "TI"], "]"}]], "InlineFormula",
      ShowStringCharacters->False],
     "\[LineSeparator]",
     StyleBox["makes a result set from an SQL query.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31550]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->171492989],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->828854968],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21944536111827919394,22",
 CellLabel->"In[2]:=",
 CellID->25813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\""}], "]"}], 
   "]"}]}]], "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
 CellLabel->"In[3]:=",
 CellID->14651],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"0", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
 CellLabel->"Out[3]=",
 CellID->25880]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,24"},
 CellLabel->"In[4]:=",
 CellID->27844],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,25"},
 CellLabel->"In[5]:=",
 CellID->24743],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7741],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->269403804],

Cell[TextData[{
 "Use ",
 StyleBox["SQLSelect", "MR"],
 " instead of ",
 StyleBox["SQLExecute", "MR"],
 ": "
}], "ExampleText",
 CellID->11245],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"Ex--21944536111827919394,22",
 CellLabel->"In[2]:=",
 CellID->4949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLSelect", "[", 
    RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}]], "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
 CellLabel->"In[3]:=",
 CellID->21705],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"1", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
 CellLabel->"Out[3]=",
 CellID->24514]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,29"},
 CellLabel->"In[4]:=",
 CellID->19785],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,30"},
 CellLabel->"In[5]:=",
 CellID->9227]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2097],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->323482858],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->508715145],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->636031883],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->834501722]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetOpen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 14, 58.1718229}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetOpen[query] makes a result set from an SQL query.", 
    "synonyms" -> {}, "title" -> "SQLResultSetOpen", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLResultSetOpen"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3746, 110, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Ex--21944536111827919394,22"->{
  Cell[4813, 148, 249, 8, 70, "Input",
   CellTags->"Ex--21944536111827919394,22",
   CellID->25813],
  Cell[6404, 212, 248, 8, 70, "Input",
   CellTags->"Ex--21944536111827919394,22",
   CellID->4949]},
 "b:6.2.1"->{
  Cell[5087, 160, 291, 8, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
   CellID->14651],
  Cell[5381, 170, 222, 6, 70, "Output",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
   CellID->25880],
  Cell[5618, 179, 165, 4, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,24"},
   CellID->27844],
  Cell[5786, 185, 208, 6, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,25"},
   CellID->24743],
  Cell[6677, 224, 272, 7, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
   CellID->21705],
  Cell[6952, 233, 222, 6, 70, "Output",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
   CellID->24514],
  Cell[7189, 242, 165, 4, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,29"},
   CellID->19785],
  Cell[7357, 248, 207, 6, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,30"},
   CellID->9227]},
 "Ex--21944536111827919394,23"->{
  Cell[5087, 160, 291, 8, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
   CellID->14651],
  Cell[5381, 170, 222, 6, 70, "Output",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
   CellID->25880]},
 "Ex--21944536111827919394,24"->{
  Cell[5618, 179, 165, 4, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,24"},
   CellID->27844]},
 "Ex--21944536111827919394,25"->{
  Cell[5786, 185, 208, 6, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,25"},
   CellID->24743]},
 "Ex--21944536111827919394,28"->{
  Cell[6677, 224, 272, 7, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
   CellID->21705],
  Cell[6952, 233, 222, 6, 70, "Output",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
   CellID->24514]},
 "Ex--21944536111827919394,29"->{
  Cell[7189, 242, 165, 4, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,29"},
   CellID->19785]},
 "Ex--21944536111827919394,30"->{
  Cell[7357, 248, 207, 6, 70, "Input",
   CellTags->{"b:6.2.1", "Ex--21944536111827919394,30"},
   CellID->9227]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11490, 390},
 {"Ex--21944536111827919394,22", 11636, 394},
 {"b:6.2.1", 11854, 401},
 {"Ex--21944536111827919394,23", 12810, 426},
 {"Ex--21944536111827919394,24", 13076, 433},
 {"Ex--21944536111827919394,25", 13226, 437},
 {"Ex--21944536111827919394,28", 13376, 441},
 {"Ex--21944536111827919394,29", 13642, 448},
 {"Ex--21944536111827919394,30", 13792, 452}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2566, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3189, 88, 53, 1, 70, "ObjectName",
 CellID->7118],
Cell[3245, 91, 464, 14, 70, "Usage",
 CellID->31550]
}, Open  ]],
Cell[CellGroupData[{
Cell[3746, 110, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4123, 124, 148, 5, 70, "ExampleSection",
 CellID->171492989],
Cell[4274, 131, 135, 3, 70, "Input",
 CellID->828854968],
Cell[4412, 136, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4813, 148, 249, 8, 70, "Input",
 CellTags->"Ex--21944536111827919394,22",
 CellID->25813],
Cell[CellGroupData[{
Cell[5087, 160, 291, 8, 70, "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
 CellID->14651],
Cell[5381, 170, 222, 6, 70, "Output",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,23"},
 CellID->25880]
}, Open  ]],
Cell[5618, 179, 165, 4, 70, "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,24"},
 CellID->27844],
Cell[5786, 185, 208, 6, 70, "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,25"},
 CellID->24743],
Cell[5997, 193, 120, 3, 70, "ExampleDelimiter",
 CellID->7741],
Cell[6120, 198, 135, 3, 70, "Input",
 CellID->269403804],
Cell[6258, 203, 143, 7, 70, "ExampleText",
 CellID->11245],
Cell[6404, 212, 248, 8, 70, "Input",
 CellTags->"Ex--21944536111827919394,22",
 CellID->4949],
Cell[CellGroupData[{
Cell[6677, 224, 272, 7, 70, "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
 CellID->21705],
Cell[6952, 233, 222, 6, 70, "Output",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,28"},
 CellID->24514]
}, Open  ]],
Cell[7189, 242, 165, 4, 70, "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,29"},
 CellID->19785],
Cell[7357, 248, 207, 6, 70, "Input",
 CellTags->{"b:6.2.1", "Ex--21944536111827919394,30"},
 CellID->9227]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7613, 260, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7932, 271, 504, 17, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[8473, 293, 313, 9, 70, "TutorialsSection",
 CellID->2097],
Cell[8789, 304, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9079, 315, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[9520, 332, 319, 9, 70, "MoreAboutSection",
 CellID->323482858],
Cell[9842, 343, 179, 4, 70, "MoreAbout",
 CellID->508715145],
Cell[10024, 349, 200, 5, 70, "MoreAbout",
 CellID->636031883],
Cell[10227, 356, 171, 4, 70, "MoreAbout",
 CellID->834501722]
}, Open  ]],
Cell[10413, 363, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

