(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22805,        849]
NotebookOptionsPosition[     15714,        593]
NotebookOutlinePosition[     18812,        695]
CellTagsIndexPosition[     18675,        688]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>", 
       3->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>", 
       2->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetRead", "ObjectName",
 CellID->26555],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetRead", "[", 
       StyleBox["rs", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]shifts the current position and then reads a row from a \
result set."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetRead", "[", 
       RowBox[{
        StyleBox["rs", "TI"], ",", " ", 
        StyleBox["num", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads ",
     StyleBox["num", "TI"],
     " rows from a result set."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22482]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->25253],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "return the results as strings", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->15000]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216581280],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->103078564],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->227551833],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->31310],

Cell["Open a result set:", "ExampleText",
 CellID->940],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[3]:=",
 CellID->27799],

Cell["Read the first row:", "ExampleText",
 CellID->2997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetRead", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[4]:=",
 CellID->9707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], 
  "}"}]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[4]=",
 CellID->8454]
}, Open  ]],

Cell["Read the second and third rows:", "ExampleText",
 CellID->304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetRead", "[", 
  RowBox[{"rs", ",", "2"}], "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[5]:=",
 CellID->8237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[5]=",
 CellID->10485]
}, Open  ]],

Cell["Read the last four rows:", "ExampleText",
 CellID->12499],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetGoto", "[", 
   RowBox[{"rs", ",", "Infinity"}], "]"}], ";"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[6]:=",
 CellID->30792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetRead", "[", " ", 
  RowBox[{"rs", ",", " ", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[7]:=",
 CellID->29613],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "8001", ",", "16000", ",", "0.14`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[7]=",
 CellID->32612]
}, Open  ]],

Cell["Close the result set:", "ExampleText",
 CellID->18682],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[8]:=",
 CellID->12983],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[9]:=",
 CellID->15351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17137],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"GetAsStrings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5033],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->362111026],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->31864],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[3]:=",
 CellID->23683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetRead", "[", 
   RowBox[{"rs", ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", "->", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[4]:=",
 CellID->11857],

Cell["{\"BS1011\", \"0\", \"5000\", \"0.1\"}", "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[4]//InputForm=",
 CellID->8968]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[5]:=",
 CellID->1710],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[6]:=",
 CellID->21968]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31708],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->107434521],

Cell["Process each row individually, and get the sum:", "ExampleText",
 CellID->2641],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->12437],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{
     "conn", ",", " ", "\"\<roysched\>\"", ",", " ", "\"\<royalty\>\""}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[3]:=",
 CellID->11684],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"res", "=", "0"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", " ", 
     RowBox[{"data", "=", 
      RowBox[{"SQLResultSetRead", "[", "rs", "]"}]}], "]"}], ",", 
    RowBox[{"res", "+=", 
     RowBox[{"data", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ";"}], "\n", "res"}], "Input",\

 CellTags->"b:6.2.1",
 CellLabel->"In[4]:=",
 CellID->32499],

Cell[BoxData["6.4399999999999995`"], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[4]=",
 CellID->32701]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[5]:=",
 CellID->29869],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[6]:=",
 CellID->28583]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27754],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->30626058],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->338054587],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->43443018]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetRead - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 0.1093105}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetRead[rs] shifts the current position and then reads a row \
from a result set. SQLResultSetRead[rs, num] reads num rows from a result \
set.", "synonyms" -> {}, "title" -> "SQLResultSetRead", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLResultSetRead"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5028, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->216581280]},
 "b:6.2.1"->{
  Cell[6371, 206, 263, 9, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->27799],
  Cell[6719, 222, 130, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->9707],
  Cell[6852, 228, 175, 6, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->8454],
  Cell[7135, 242, 153, 5, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->8237],
  Cell[7291, 249, 323, 11, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->10485],
  Cell[8699, 307, 132, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->12983],
  Cell[8834, 313, 175, 6, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->15351],
  Cell[9872, 358, 263, 9, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->23683],
  Cell[10160, 371, 243, 8, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->11857],
  Cell[10406, 381, 127, 3, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->8968],
  Cell[10548, 387, 131, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->1710],
  Cell[10682, 393, 175, 6, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->21968],
  Cell[11568, 431, 301, 10, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->11684],
  Cell[11894, 445, 418, 14, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->32499],
  Cell[12315, 461, 107, 3, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->32701],
  Cell[12437, 467, 132, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->29869],
  Cell[12572, 473, 175, 6, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->28583]},
 "b:6.2.4"->{
  Cell[7695, 266, 180, 6, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->30792],
  Cell[7900, 276, 183, 6, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->29613],
  Cell[8086, 284, 535, 17, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->32612]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16849, 619},
 {"b:6.2.1", 16983, 623},
 {"b:6.2.4", 18403, 675}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2538, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3161, 88, 54, 1, 70, "ObjectName",
 CellID->26555],
Cell[3218, 91, 737, 23, 70, "Usage",
 CellID->22482]
}, Open  ]],
Cell[CellGroupData[{
Cell[3992, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4470, 136, 68, 1, 70, "Notes",
 CellID->25253],
Cell[4541, 139, 450, 12, 70, "3ColumnTableMod",
 CellID->15000]
}, Closed]],
Cell[CellGroupData[{
Cell[5028, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216581280],
Cell[CellGroupData[{
Cell[5413, 170, 148, 5, 70, "ExampleSection",
 CellID->103078564],
Cell[5564, 177, 135, 3, 70, "Input",
 CellID->227551833],
Cell[5702, 182, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6103, 194, 207, 7, 70, "Input",
 CellID->31310],
Cell[6313, 203, 55, 1, 70, "ExampleText",
 CellID->940],
Cell[6371, 206, 263, 9, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->27799],
Cell[6637, 217, 57, 1, 70, "ExampleText",
 CellID->2997],
Cell[CellGroupData[{
Cell[6719, 222, 130, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->9707],
Cell[6852, 228, 175, 6, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->8454]
}, Open  ]],
Cell[7042, 237, 68, 1, 70, "ExampleText",
 CellID->304],
Cell[CellGroupData[{
Cell[7135, 242, 153, 5, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->8237],
Cell[7291, 249, 323, 11, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->10485]
}, Open  ]],
Cell[7629, 263, 63, 1, 70, "ExampleText",
 CellID->12499],
Cell[7695, 266, 180, 6, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->30792],
Cell[CellGroupData[{
Cell[7900, 276, 183, 6, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->29613],
Cell[8086, 284, 535, 17, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->32612]
}, Open  ]],
Cell[8636, 304, 60, 1, 70, "ExampleText",
 CellID->18682],
Cell[8699, 307, 132, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->12983],
Cell[8834, 313, 175, 6, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->15351]
}, Open  ]],
Cell[CellGroupData[{
Cell[9046, 324, 218, 7, 70, "ExampleSection",
 CellID->17137],
Cell[CellGroupData[{
Cell[9289, 335, 232, 7, 70, "ExampleSubsection",
 CellID->5033],
Cell[9524, 344, 135, 3, 70, "Input",
 CellID->362111026],
Cell[9662, 349, 207, 7, 70, "Input",
 CellID->31864],
Cell[9872, 358, 263, 9, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->23683],
Cell[CellGroupData[{
Cell[10160, 371, 243, 8, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->11857],
Cell[10406, 381, 127, 3, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->8968]
}, Open  ]],
Cell[10548, 387, 131, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->1710],
Cell[10682, 393, 175, 6, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->21968]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[10906, 405, 223, 7, 70, "ExampleSection",
 CellID->31708],
Cell[11132, 414, 135, 3, 70, "Input",
 CellID->107434521],
Cell[11270, 419, 85, 1, 70, "ExampleText",
 CellID->2641],
Cell[11358, 422, 207, 7, 70, "Input",
 CellID->12437],
Cell[11568, 431, 301, 10, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->11684],
Cell[CellGroupData[{
Cell[11894, 445, 418, 14, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->32499],
Cell[12315, 461, 107, 3, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->32701]
}, Open  ]],
Cell[12437, 467, 132, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->29869],
Cell[12572, 473, 175, 6, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->28583]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12796, 485, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[13115, 496, 778, 26, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[13930, 527, 314, 9, 70, "TutorialsSection",
 CellID->27754],
Cell[14247, 538, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[14537, 549, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[14978, 566, 318, 9, 70, "MoreAboutSection",
 CellID->30626058],
Cell[15299, 577, 200, 5, 70, "MoreAbout",
 CellID->338054587],
Cell[15502, 584, 170, 4, 70, "MoreAbout",
 CellID->43443018]
}, Open  ]],
Cell[15687, 591, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

