(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16625,        623]
NotebookOptionsPosition[     11181,        426]
NotebookOutlinePosition[     13660,        507]
CellTagsIndexPosition[     13549,        501]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>", 
       3->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetShift", "ObjectName",
 CellID->6504],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetShift", "[", 
       RowBox[{
        StyleBox["rs", "TI"], ",", " ", 
        StyleBox["num", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]shifts the current position of a result set by ",
     Cell[BoxData[
      StyleBox["num", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["SQLResultSetShift", "MR"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if there is data at the new position and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if there is no data."
}], "Notes",
 CellID->4055]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60491367],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->366059378],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->141804941],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->31122],

Cell["Open a result set:", "ExampleText",
 CellID->26053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLSelect", "[", 
    RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[3]:=",
 CellID->19397],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"20", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[3]=",
 CellID->11822]
}, Open  ]],

Cell["The initial position is 0:", "ExampleText",
 CellID->19750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[4]:=",
 CellID->21337],

Cell[BoxData["0"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[4]=",
 CellID->13917]
}, Open  ]],

Cell["Shift two rows:", "ExampleText",
 CellID->4006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetShift", "[", 
  RowBox[{"rs", ",", "2"}], "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[5]:=",
 CellID->4931],

Cell[BoxData["True"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[5]=",
 CellID->22197]
}, Open  ]],

Cell["The new position is 2:", "ExampleText",
 CellID->27505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[6]:=",
 CellID->29236],

Cell[BoxData["2"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[6]=",
 CellID->10357]
}, Open  ]],

Cell["Shift two rows again:", "ExampleText",
 CellID->6599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetShift", "[", 
  RowBox[{"rs", ",", "2"}], "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[7]:=",
 CellID->28290],

Cell[BoxData["True"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[7]=",
 CellID->1898]
}, Open  ]],

Cell["Now the position is 4:", "ExampleText",
 CellID->985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[8]:=",
 CellID->21447],

Cell[BoxData["4"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[8]=",
 CellID->1084]
}, Open  ]],

Cell["Close the result set:", "ExampleText",
 CellID->592],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[9]:=",
 CellID->18725],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[10]:=",
 CellID->8996]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18913],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->327317652],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->281799580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17864917],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->6988798]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetShift - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 1.1874286}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetShift[rs, num] shifts the current position of a result set \
by num.", "synonyms" -> {}, "title" -> "SQLResultSetShift", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLResultSetShift"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4526, 146, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->60491367]},
 "b:6.2.3"->{
  Cell[5892, 198, 239, 7, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->19397],
  Cell[6134, 207, 190, 6, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->11822],
  Cell[6429, 221, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->21337],
  Cell[6567, 227, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->13917],
  Cell[6749, 238, 154, 5, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->4931],
  Cell[6906, 245, 92, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->22197],
  Cell[7099, 256, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->29236],
  Cell[7237, 262, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->10357],
  Cell[7425, 273, 155, 5, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->28290],
  Cell[7583, 280, 91, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->1898],
  Cell[7773, 291, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->21447],
  Cell[7911, 297, 88, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->1084],
  Cell[8075, 306, 132, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->18725],
  Cell[8210, 312, 175, 6, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->8996]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12247, 451},
 {"b:6.2.3", 12380, 455}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 85, 54, 1, 70, "ObjectName",
 CellID->6504],
Cell[3035, 88, 548, 17, 70, "Usage",
 CellID->28822]
}, Open  ]],
Cell[CellGroupData[{
Cell[3620, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4098, 127, 391, 14, 70, "Notes",
 CellID->4055]
}, Closed]],
Cell[CellGroupData[{
Cell[4526, 146, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60491367],
Cell[CellGroupData[{
Cell[4910, 160, 148, 5, 70, "ExampleSection",
 CellID->366059378],
Cell[5061, 167, 135, 3, 70, "Input",
 CellID->141804941],
Cell[5199, 172, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5600, 184, 207, 7, 70, "Input",
 CellID->31122],
Cell[5810, 193, 57, 1, 70, "ExampleText",
 CellID->26053],
Cell[CellGroupData[{
Cell[5892, 198, 239, 7, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->19397],
Cell[6134, 207, 190, 6, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->11822]
}, Open  ]],
Cell[6339, 216, 65, 1, 70, "ExampleText",
 CellID->19750],
Cell[CellGroupData[{
Cell[6429, 221, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->21337],
Cell[6567, 227, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->13917]
}, Open  ]],
Cell[6671, 233, 53, 1, 70, "ExampleText",
 CellID->4006],
Cell[CellGroupData[{
Cell[6749, 238, 154, 5, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->4931],
Cell[6906, 245, 92, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->22197]
}, Open  ]],
Cell[7013, 251, 61, 1, 70, "ExampleText",
 CellID->27505],
Cell[CellGroupData[{
Cell[7099, 256, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->29236],
Cell[7237, 262, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->10357]
}, Open  ]],
Cell[7341, 268, 59, 1, 70, "ExampleText",
 CellID->6599],
Cell[CellGroupData[{
Cell[7425, 273, 155, 5, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->28290],
Cell[7583, 280, 91, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->1898]
}, Open  ]],
Cell[7689, 286, 59, 1, 70, "ExampleText",
 CellID->985],
Cell[CellGroupData[{
Cell[7773, 291, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->21447],
Cell[7911, 297, 88, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->1084]
}, Open  ]],
Cell[8014, 303, 58, 1, 70, "ExampleText",
 CellID->592],
Cell[8075, 306, 132, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->18725],
Cell[8210, 312, 175, 6, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->8996]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8434, 324, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8753, 335, 778, 26, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[9568, 366, 314, 9, 70, "TutorialsSection",
 CellID->18913],
Cell[9885, 377, 291, 9, 70, "Tutorials",
 CellID->327317652],
Cell[10179, 388, 404, 12, 70, "Tutorials",
 CellID->281799580]
}, Open  ]],
Cell[CellGroupData[{
Cell[10620, 405, 318, 9, 70, "MoreAboutSection",
 CellID->17864917],
Cell[10941, 416, 198, 5, 70, "MoreAbout",
 CellID->6988798]
}, Open  ]],
Cell[11154, 424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

