(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18760,        692]
NotebookOptionsPosition[     13338,        497]
NotebookOutlinePosition[     15734,        575]
CellTagsIndexPosition[     15623,        569]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Result Sets in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/ResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Result Sets in DatabaseLink User Guide\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLResultSetOpen" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetOpen"], "SQLResultSetClose" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSetClose"], "SQLResultSets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLResultSets"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLResultSetOpen\"\>", 
       2->"\<\"SQLResultSetClose\"\>", 
       3->"\<\"SQLResultSets\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLResultSetTake", "ObjectName",
 CellID->7523],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLResultSetTake", "[", 
       RowBox[{
        StyleBox["rs", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads rows ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " from a result set."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->1411],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "return the results as strings", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16040]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62759090],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->22056969],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->138779307],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->2670],

Cell["Open a result set:", "ExampleText",
 CellID->10845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLSelect", "[", 
    RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[3]:=",
 CellID->10506],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"13", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[3]=",
 CellID->9088]
}, Open  ]],

Cell["Get rows 2 through 4:", "ExampleText",
 CellID->23256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetTake", "[", " ", 
  RowBox[{"rs", ",", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[4]:=",
 CellID->25107],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[4]=",
 CellID->8266]
}, Open  ]],

Cell["Get the last three rows:", "ExampleText",
 CellID->5857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetTake", "[", " ", 
  RowBox[{"rs", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[5]:=",
 CellID->22678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[5]=",
 CellID->14199]
}, Open  ]],

Cell["Close the result set:", "ExampleText",
 CellID->12674],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[6]:=",
 CellID->14155],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[7]:=",
 CellID->25191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29832],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"GetAsStrings\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30858],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->515633738],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->8917],

Cell[BoxData[
 RowBox[{
  RowBox[{"rs", "=", 
   RowBox[{"SQLResultSetOpen", "[", 
    RowBox[{"SQLSelect", "[", 
     RowBox[{"conn", ",", " ", "\"\<roysched\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[3]:=",
 CellID->28290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetTake", "[", " ", 
   RowBox[{"rs", ",", " ", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", "->", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[4]:=",
 CellID->3967],

Cell["\<\
{{\"BS1011\", \"5001\", \"50000\", \"0.12\"}, {\"CP5018\", \"0\", \"2000\", \
\"0.1\"}, 
 {\"CP5018\", \"2001\", \"4000\", \"0.12\"}}\
\>", "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[4]//InputForm=",
 CellID->1707]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SQLResultSetClose", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[5]:=",
 CellID->8234],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[6]:=",
 CellID->28246]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSetClose",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLResultSets",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSets"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Result Sets in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->478847449],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->146347407]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLResultSetTake - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 3.0467917}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLResultSetTake[rs, {m, n}] reads rows m through n from a result set.", 
    "synonyms" -> {}, "title" -> "SQLResultSetTake", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLResultSetTake"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4797, 153, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62759090]},
 "b:6.2.4"->{
  Cell[6161, 205, 239, 7, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->10506],
  Cell[6403, 214, 189, 6, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->9088],
  Cell[6692, 228, 213, 7, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->25107],
  Cell[6908, 237, 430, 14, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->8266],
  Cell[7440, 259, 255, 9, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->22678],
  Cell[7698, 270, 426, 14, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->14199],
  Cell[8202, 290, 132, 4, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->14155],
  Cell[8337, 296, 175, 6, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->25191],
  Cell[9375, 341, 263, 9, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->28290],
  Cell[9663, 354, 313, 10, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->3967],
  Cell[9979, 366, 230, 7, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->1707],
  Cell[10224, 376, 131, 4, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->8234],
  Cell[10358, 382, 175, 6, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->28246]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14396, 522},
 {"b:6.2.4", 14529, 526}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2355, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2978, 85, 53, 1, 70, "ObjectName",
 CellID->7523],
Cell[3034, 88, 691, 23, 70, "Usage",
 CellID->26364]
}, Open  ]],
Cell[CellGroupData[{
Cell[3762, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4240, 133, 67, 1, 70, "Notes",
 CellID->1411],
Cell[4310, 136, 450, 12, 70, "3ColumnTableMod",
 CellID->16040]
}, Closed]],
Cell[CellGroupData[{
Cell[4797, 153, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62759090],
Cell[CellGroupData[{
Cell[5181, 167, 147, 5, 70, "ExampleSection",
 CellID->22056969],
Cell[5331, 174, 135, 3, 70, "Input",
 CellID->138779307],
Cell[5469, 179, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[5870, 191, 206, 7, 70, "Input",
 CellID->2670],
Cell[6079, 200, 57, 1, 70, "ExampleText",
 CellID->10845],
Cell[CellGroupData[{
Cell[6161, 205, 239, 7, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->10506],
Cell[6403, 214, 189, 6, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->9088]
}, Open  ]],
Cell[6607, 223, 60, 1, 70, "ExampleText",
 CellID->23256],
Cell[CellGroupData[{
Cell[6692, 228, 213, 7, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->25107],
Cell[6908, 237, 430, 14, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->8266]
}, Open  ]],
Cell[7353, 254, 62, 1, 70, "ExampleText",
 CellID->5857],
Cell[CellGroupData[{
Cell[7440, 259, 255, 9, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->22678],
Cell[7698, 270, 426, 14, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->14199]
}, Open  ]],
Cell[8139, 287, 60, 1, 70, "ExampleText",
 CellID->12674],
Cell[8202, 290, 132, 4, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->14155],
Cell[8337, 296, 175, 6, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->25191]
}, Open  ]],
Cell[CellGroupData[{
Cell[8549, 307, 218, 7, 70, "ExampleSection",
 CellID->29832],
Cell[CellGroupData[{
Cell[8792, 318, 233, 7, 70, "ExampleSubsection",
 CellID->30858],
Cell[9028, 327, 135, 3, 70, "Input",
 CellID->515633738],
Cell[9166, 332, 206, 7, 70, "Input",
 CellID->8917],
Cell[9375, 341, 263, 9, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->28290],
Cell[CellGroupData[{
Cell[9663, 354, 313, 10, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->3967],
Cell[9979, 366, 230, 7, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->1707]
}, Open  ]],
Cell[10224, 376, 131, 4, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->8234],
Cell[10358, 382, 175, 6, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->28246]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10594, 395, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10913, 406, 778, 26, 70, "SeeAlso",
 CellID->1990]
}, Open  ]],
Cell[CellGroupData[{
Cell[11728, 437, 312, 9, 70, "TutorialsSection",
 CellID->250],
Cell[12043, 448, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[12333, 459, 404, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[12774, 476, 319, 9, 70, "MoreAboutSection",
 CellID->478847449],
Cell[13096, 487, 200, 5, 70, "MoreAbout",
 CellID->146347407]
}, Open  ]],
Cell[13311, 495, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

