(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9028,        298]
NotebookOptionsPosition[      7062,        235]
NotebookOutlinePosition[      8152,        265]
CellTagsIndexPosition[      8109,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Transactions in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/Transactions#31020"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Transactions in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLBeginTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLBeginTransaction"], 
          "SQLCommitTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCommitTransaction"], 
          "SQLRollbackTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLRollbackTransaction"], 
          "SQLSetSavepoint" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLSetSavepoint"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLBeginTransaction\"\>", 
       2->"\<\"SQLCommitTransaction\"\>", 3->"\<\"SQLRollbackTransaction\"\>",
        4->"\<\"SQLSetSavepoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLSavepoint", "ObjectName",
 CellID->1238],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLSavepoint", "[", 
       StyleBox["\[Ellipsis]", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that represents a savepoint in an SQL \
transaction."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSetSavepoint",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSetSavepoint"]], "InlineFormula"],
 " returns an ",
 StyleBox["SQLSavepoint", "MR"],
 " object."
}], "Notes",
 CellID->30231],

Cell[TextData[StyleBox["A group of SQL commands grouped into a transaction \
will only take effect permanently when the transaction is committed. The \
transaction can be canceled or returned to a savepoint.", "Text"]], "Notes",
 CellID->832],

Cell["The following option can be given: ", "Notes",
 CellID->20065],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", "\"\<\>\"", Cell[
    "the name of the savepoint", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->12516]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14481],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLBeginTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLBeginTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCommitTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCommitTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{" ", 
   StyleBox[
    ButtonBox["SQLRollbackTransaction",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"],
    FontFamily->"Verdana"]}]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSetSavepoint",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSetSavepoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9023],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Transactions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLSavepoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 4.8905299}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLSavepoint[...] is an object that represents a savepoint in an SQL \
transaction.", "synonyms" -> {}, "title" -> "SQLSavepoint", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLSavepoint"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1936, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2559, 73, 49, 1, 70, "ObjectName",
 CellID->1238],
Cell[2611, 76, 432, 13, 70, "Usage",
 CellID->15032]
}, Open  ]],
Cell[CellGroupData[{
Cell[3080, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3558, 111, 252, 9, 70, "Notes",
 CellID->30231],
Cell[3813, 122, 242, 3, 70, "Notes",
 CellID->832],
Cell[4058, 127, 68, 1, 70, "Notes",
 CellID->20065],
Cell[4129, 130, 364, 9, 70, "3ColumnTableMod",
 CellID->12516]
}, Closed]],
Cell[CellGroupData[{
Cell[4530, 144, 311, 9, 70, "SeeAlsoSection",
 CellID->14481],
Cell[4844, 155, 1104, 36, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[5985, 196, 313, 9, 70, "TutorialsSection",
 CellID->9023],
Cell[6301, 207, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[6591, 218, 429, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[7035, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

