(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10034,        324]
NotebookOptionsPosition[      7994,        259]
NotebookOutlinePosition[      9102,        289]
CellTagsIndexPosition[      9059,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Transactions in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/Transactions#31020"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Transactions in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLBeginTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLBeginTransaction"], 
          "SQLCommitTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCommitTransaction"], 
          "SQLRollbackTransaction" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLRollbackTransaction"], "SQLSavepoint" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLSavepoint"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLBeginTransaction\"\>", 
       2->"\<\"SQLCommitTransaction\"\>", 3->"\<\"SQLRollbackTransaction\"\>",
        4->"\<\"SQLSavepoint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Transactions and Result Sets" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Transactions and Result Sets\"\>", 
       2->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLSetSavepoint", "ObjectName",
 CellID->18613],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLSetSavepoint", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]",
     StyleBox[
     "creates a savepoint to be used as part of an SQL transaction.", "Text"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[StyleBox["A group of SQL commands grouped into a transaction \
will only take effect permanently when the transaction is committed. The \
transaction can be canceled or returned to a savepoint.", "Text"]], "Notes",
 CellID->832]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8252],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLBeginTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLBeginTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCommitTransaction",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCommitTransaction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{" ", 
   StyleBox[
    ButtonBox["SQLRollbackTransaction",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"],
    FontFamily->"Verdana"]}]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSavepoint",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSavepoint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19861],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Transactions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Transactions#31020"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->125685444],

Cell[TextData[ButtonBox["Database Transactions and Result Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseTransactionsAndResultSets"]], "MoreAbout",\

 CellID->24101720],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->410871972]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLSetSavepoint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 13.3123510}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLSetSavepoint[conn, name] creates a savepoint to be used as part of an \
SQL transaction.", "synonyms" -> {}, "title" -> "SQLSetSavepoint", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLSetSavepoint"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2749, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3372, 92, 53, 1, 70, "ObjectName",
 CellID->18613],
Cell[3428, 95, 514, 16, 70, "Usage",
 CellID->10600]
}, Open  ]],
Cell[CellGroupData[{
Cell[3979, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4457, 133, 242, 3, 70, "Notes",
 CellID->832]
}, Closed]],
Cell[CellGroupData[{
Cell[4736, 141, 310, 9, 70, "SeeAlsoSection",
 CellID->8252],
Cell[5049, 152, 1098, 36, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[6184, 193, 314, 9, 70, "TutorialsSection",
 CellID->19861],
Cell[6501, 204, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[6791, 215, 429, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[CellGroupData[{
Cell[7257, 232, 319, 9, 70, "MoreAboutSection",
 CellID->125685444],
Cell[7579, 243, 199, 5, 70, "MoreAbout",
 CellID->24101720],
Cell[7781, 250, 171, 4, 70, "MoreAbout",
 CellID->410871972]
}, Open  ]],
Cell[7967, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

