(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18959,        627]
NotebookOptionsPosition[     14738,        478]
NotebookOutlinePosition[     16376,        529]
CellTagsIndexPosition[     16267,        523]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Table Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/TableStructure"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Table Structure in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTable"], 
          "SQLTables" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTables"], 
          "SQLTableInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableInformation"], 
          "SQLTableTypeNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableTypeNames"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLTable\"\>", 2->"\<\"SQLTables\"\>", 
       3->"\<\"SQLTableInformation\"\>", 
       4->"\<\"SQLTableTypeNames\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"Database Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLTableNames", "ObjectName",
 CellID->19975],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLTableNames", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the names of each table in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->20514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TableType\>\"", "\"\<TABLE\>\"", 
    Cell["type of table to return", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->8938]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23261764],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->70653626],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->9853840],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->16070],

Cell["Get the names of all the tables:", "ExampleText",
 CellID->25631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AUTHORS\"\>", ",", "\<\"EDITORS\"\>", 
   ",", "\<\"PUBLISHERS\"\>", ",", "\<\"ROYSCHED\"\>", ",", "\<\"SALES\"\>", 
   ",", "\<\"SALESDETAILS\"\>", ",", "\<\"TITLEAUTHORS\"\>", 
   ",", "\<\"TITLEDITORS\"\>", ",", "\<\"TITLES\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->27219]
}, Open  ]],

Cell["Get the names of tables matching a pattern:", "ExampleText",
 CellID->28781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<TITLE%\>\""}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[4]:=",
 CellID->20990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TITLEAUTHORS\"\>", ",", "\<\"TITLEDITORS\"\>", 
   ",", "\<\"TITLES\"\>"}], "}"}]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[4]=",
 CellID->12833]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[5]:=",
 CellID->8672],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->147198108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->502],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"TableType\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26928],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->302231303],

Cell["Get the names of all types of tables in a data source: ", "ExampleText",
 CellID->30721],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->31447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"\"\<TableType\>\"", "\[Rule]", 
    RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->10945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"SYSTEM_ALLTYPEINFO\"\>", 
   ",", "\<\"SYSTEM_AUTHORIZATIONS\"\>", 
   ",", "\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"SYSTEM_CACHEINFO\"\>", 
   ",", "\<\"SYSTEM_CATALOGS\"\>", ",", "\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
   ",", "\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", 
   ",", "\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
   ",", "\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", 
   ",", "\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"SYSTEM_COLLATIONS\"\>", 
   ",", "\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"SYSTEM_COLUMNS\"\>", 
   ",", "\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"SYSTEM_INDEXINFO\"\>", 
   ",", "\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"SYSTEM_PROCEDURECOLUMNS\"\>", 
   ",", "\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"SYSTEM_PROPERTIES\"\>", 
   ",", "\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", 
   ",", "\<\"SYSTEM_SCHEMAS\"\>", ",", "\<\"SYSTEM_SCHEMATA\"\>", 
   ",", "\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"SYSTEM_SESSIONINFO\"\>", 
   ",", "\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"SYSTEM_SUPERTABLES\"\>", 
   ",", "\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"SYSTEM_TABLEPRIVILEGES\"\>", 
   ",", "\<\"SYSTEM_TABLES\"\>", ",", "\<\"SYSTEM_TABLETYPES\"\>", 
   ",", "\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", ",", "\<\"SYSTEM_TEXTTABLES\"\>", 
   ",", "\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"SYSTEM_TRIGGERS\"\>", 
   ",", "\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"SYSTEM_UDTATTRIBUTES\"\>", 
   ",", "\<\"SYSTEM_UDTS\"\>", ",", "\<\"SYSTEM_USAGE_PRIVILEGES\"\>", 
   ",", "\<\"SYSTEM_USERS\"\>", ",", "\<\"SYSTEM_VERSIONCOLUMNS\"\>", 
   ",", "\<\"SYSTEM_VIEWS\"\>", ",", "\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
   ",", "\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
   ",", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"AUTHORS\"\>", 
   ",", "\<\"EDITORS\"\>", ",", "\<\"PUBLISHERS\"\>", ",", "\<\"ROYSCHED\"\>",
    ",", "\<\"SALES\"\>", ",", "\<\"SALESDETAILS\"\>", 
   ",", "\<\"TITLEAUTHORS\"\>", ",", "\<\"TITLEDITORS\"\>", 
   ",", "\<\"TITLES\"\>"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellTags->"b:3.1",
 CellLabel->"Out[3]=",
 CellID->28406]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->2222]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16657],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTables",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableTypeNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19438],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Table Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"]
}], "Tutorials",
 CellID->591254481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->349248960],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->41264284],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->28873818]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLTableNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 19.0154395}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLTableNames[conn] returns the names of each table in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLTableNames", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLTableNames"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5116, 154, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23261764]},
 "b:3.1"->{
  Cell[7061, 226, 169, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->20990],
  Cell[7233, 233, 196, 6, 70, "Output",
   CellTags->"b:3.1",
   CellID->12833],
  Cell[8974, 303, 246, 7, 70, "Input",
   CellTags->"b:3.1",
   CellID->10945],
  Cell[9223, 312, 2134, 36, 70, "Output",
   CellTags->"b:3.1",
   CellID->28406]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15788, 503},
 {"b:3.1", 15919, 507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2626, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3249, 90, 51, 1, 70, "ObjectName",
 CellID->19975],
Cell[3303, 93, 414, 12, 70, "Usage",
 CellID->30260]
}, Open  ]],
Cell[CellGroupData[{
Cell[3754, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4232, 127, 69, 1, 70, "Notes",
 CellID->20514],
Cell[4304, 130, 775, 19, 70, "3ColumnTableMod",
 CellID->8938]
}, Closed]],
Cell[CellGroupData[{
Cell[5116, 154, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23261764],
Cell[CellGroupData[{
Cell[5500, 168, 147, 5, 70, "ExampleSection",
 CellID->70653626],
Cell[5650, 175, 133, 3, 70, "Input",
 CellID->9853840],
Cell[5786, 180, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6187, 192, 207, 7, 70, "Input",
 CellID->16070],
Cell[6397, 201, 71, 1, 70, "ExampleText",
 CellID->25631],
Cell[CellGroupData[{
Cell[6493, 206, 108, 3, 70, "Input",
 CellID->24061],
Cell[6604, 211, 335, 7, 70, "Output",
 CellID->27219]
}, Open  ]],
Cell[6954, 221, 82, 1, 70, "ExampleText",
 CellID->28781],
Cell[CellGroupData[{
Cell[7061, 226, 169, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->20990],
Cell[7233, 233, 196, 6, 70, "Output",
 CellTags->"b:3.1",
 CellID->12833]
}, Open  ]],
Cell[7444, 242, 147, 5, 70, "Input",
 CellID->8672],
Cell[7594, 249, 402, 10, 70, "ExampleText",
 CellID->147198108]
}, Open  ]],
Cell[CellGroupData[{
Cell[8033, 264, 216, 7, 70, "ExampleSection",
 CellID->502],
Cell[CellGroupData[{
Cell[8274, 275, 230, 7, 70, "ExampleSubsection",
 CellID->26928],
Cell[8507, 284, 135, 3, 70, "Input",
 CellID->302231303],
Cell[8645, 289, 94, 1, 70, "ExampleText",
 CellID->30721],
Cell[8742, 292, 207, 7, 70, "Input",
 CellID->31447],
Cell[CellGroupData[{
Cell[8974, 303, 246, 7, 70, "Input",
 CellTags->"b:3.1",
 CellID->10945],
Cell[9223, 312, 2134, 36, 70, "Output",
 CellTags->"b:3.1",
 CellID->28406]
}, Open  ]],
Cell[11372, 351, 147, 5, 70, "Input",
 CellID->2222]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11580, 363, 311, 9, 70, "SeeAlsoSection",
 CellID->16657],
Cell[11894, 374, 1035, 35, 70, "SeeAlso",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[12966, 414, 314, 9, 70, "TutorialsSection",
 CellID->19438],
Cell[13283, 425, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[13573, 436, 420, 12, 70, "Tutorials",
 CellID->591254481]
}, Open  ]],
Cell[CellGroupData[{
Cell[14030, 453, 319, 9, 70, "MoreAboutSection",
 CellID->349248960],
Cell[14352, 464, 178, 4, 70, "MoreAbout",
 CellID->41264284],
Cell[14533, 470, 163, 3, 70, "MoreAbout",
 CellID->28873818]
}, Open  ]],
Cell[14711, 476, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

