(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15279,        505]
NotebookOptionsPosition[     11722,        381]
NotebookOutlinePosition[     13372,        432]
CellTagsIndexPosition[     13263,        426]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Table Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/TableStructure"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Table Structure in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLTable" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTable"], 
          "SQLTables" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTables"], 
          "SQLTableNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTableNames"], 
          "SQLTableInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SQLTable\"\>", 
       2->"\<\"SQLTables\"\>", 3->"\<\"SQLTableNames\"\>", 
       4->"\<\"SQLTableInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLTableTypeNames", "ObjectName",
 CellID->1675],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLTableTypeNames", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the types of table supported in an SQL \
connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->203308439],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->318347525],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->20272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->20703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GLOBAL TEMPORARY\"\>", ",", "\<\"SYSTEM TABLE\"\>", 
   ",", "\<\"TABLE\"\>", ",", "\<\"VIEW\"\>"}], "}"}]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[3]=",
 CellID->5086]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->20967],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->167991352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23495],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->391870334],

Cell["Get the names of all types of tables in a data source:", "ExampleText",
 CellID->3566],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->14186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"\"\<TableType\>\"", "\[Rule]", 
    RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->8437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", "\<\"SYSTEM_ALLTYPEINFO\"\>", 
   ",", "\<\"SYSTEM_AUTHORIZATIONS\"\>", 
   ",", "\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", "\<\"SYSTEM_CACHEINFO\"\>", 
   ",", "\<\"SYSTEM_CATALOGS\"\>", ",", "\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", 
   ",", "\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", 
   ",", "\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", 
   ",", "\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", 
   ",", "\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", "\<\"SYSTEM_COLLATIONS\"\>", 
   ",", "\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", "\<\"SYSTEM_COLUMNS\"\>", 
   ",", "\<\"SYSTEM_CROSSREFERENCE\"\>", ",", "\<\"SYSTEM_INDEXINFO\"\>", 
   ",", "\<\"SYSTEM_PRIMARYKEYS\"\>", ",", "\<\"SYSTEM_PROCEDURECOLUMNS\"\>", 
   ",", "\<\"SYSTEM_PROCEDURES\"\>", ",", "\<\"SYSTEM_PROPERTIES\"\>", 
   ",", "\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", 
   ",", "\<\"SYSTEM_SCHEMAS\"\>", ",", "\<\"SYSTEM_SCHEMATA\"\>", 
   ",", "\<\"SYSTEM_SEQUENCES\"\>", ",", "\<\"SYSTEM_SESSIONINFO\"\>", 
   ",", "\<\"SYSTEM_SESSIONS\"\>", ",", "\<\"SYSTEM_SUPERTABLES\"\>", 
   ",", "\<\"SYSTEM_SUPERTYPES\"\>", ",", "\<\"SYSTEM_TABLEPRIVILEGES\"\>", 
   ",", "\<\"SYSTEM_TABLES\"\>", ",", "\<\"SYSTEM_TABLETYPES\"\>", 
   ",", "\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", ",", "\<\"SYSTEM_TEXTTABLES\"\>", 
   ",", "\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", "\<\"SYSTEM_TRIGGERS\"\>", 
   ",", "\<\"SYSTEM_TYPEINFO\"\>", ",", "\<\"SYSTEM_UDTATTRIBUTES\"\>", 
   ",", "\<\"SYSTEM_UDTS\"\>", ",", "\<\"SYSTEM_USAGE_PRIVILEGES\"\>", 
   ",", "\<\"SYSTEM_USERS\"\>", ",", "\<\"SYSTEM_VERSIONCOLUMNS\"\>", 
   ",", "\<\"SYSTEM_VIEWS\"\>", ",", "\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", 
   ",", "\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", 
   ",", "\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", "\<\"SAMPLETABLE1\"\>"}], 
  "}"}]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[3]=",
 CellID->19198]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->12626]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTables",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30499],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Table Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"]
}], "Tutorials",
 CellID->591254481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->756750067],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->676382976]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLTableTypeNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 23.8279087}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLTableTypeNames[conn] returns the types of table supported in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLTableTypeNames", "type" -> 
    "Symbol", "uri" -> "DatabaseLink/ref/SQLTableTypeNames"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3562, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "b:3.1"->{
  Cell[4856, 156, 132, 4, 70, "Input",
   CellTags->"b:3.1",
   CellID->20703],
  Cell[4991, 162, 220, 6, 70, "Output",
   CellTags->"b:3.1",
   CellID->5086],
  Cell[6502, 221, 245, 7, 70, "Input",
   CellTags->"b:3.1",
   CellID->8437],
  Cell[6750, 230, 1869, 31, 70, "Output",
   CellTags->"b:3.1",
   CellID->19198]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12793, 406},
 {"b:3.1", 12917, 410}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2420, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3043, 86, 54, 1, 70, "ObjectName",
 CellID->1675],
Cell[3100, 89, 425, 13, 70, "Usage",
 CellID->12136]
}, Open  ]],
Cell[CellGroupData[{
Cell[3562, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3939, 121, 148, 5, 70, "ExampleSection",
 CellID->203308439],
Cell[4090, 128, 135, 3, 70, "Input",
 CellID->318347525],
Cell[4228, 133, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[4629, 145, 202, 7, 70, "Input",
 CellID->20272],
Cell[CellGroupData[{
Cell[4856, 156, 132, 4, 70, "Input",
 CellTags->"b:3.1",
 CellID->20703],
Cell[4991, 162, 220, 6, 70, "Output",
 CellTags->"b:3.1",
 CellID->5086]
}, Open  ]],
Cell[5226, 171, 148, 5, 70, "Input",
 CellID->20967],
Cell[5377, 178, 402, 10, 70, "ExampleText",
 CellID->167991352]
}, Open  ]],
Cell[CellGroupData[{
Cell[5816, 193, 223, 7, 70, "ExampleSection",
 CellID->23495],
Cell[6042, 202, 135, 3, 70, "Input",
 CellID->391870334],
Cell[6180, 207, 92, 1, 70, "ExampleText",
 CellID->3566],
Cell[6275, 210, 202, 7, 70, "Input",
 CellID->14186],
Cell[CellGroupData[{
Cell[6502, 221, 245, 7, 70, "Input",
 CellTags->"b:3.1",
 CellID->8437],
Cell[6750, 230, 1869, 31, 70, "Output",
 CellTags->"b:3.1",
 CellID->19198]
}, Open  ]],
Cell[8634, 264, 148, 5, 70, "Input",
 CellID->12626]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8831, 275, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9150, 286, 943, 32, 70, "SeeAlso",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[10130, 323, 314, 9, 70, "TutorialsSection",
 CellID->30499],
Cell[10447, 334, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[10737, 345, 420, 12, 70, "Tutorials",
 CellID->591254481]
}, Open  ]],
Cell[CellGroupData[{
Cell[11194, 362, 319, 9, 70, "MoreAboutSection",
 CellID->756750067],
Cell[11516, 373, 164, 3, 70, "MoreAbout",
 CellID->676382976]
}, Open  ]],
Cell[11695, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

