(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29030,        917]
NotebookOptionsPosition[     24402,        752]
NotebookOutlinePosition[     26200,        809]
CellTagsIndexPosition[     26091,        803]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Table Structure in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/TableStructure"], 
          "Creating Tables in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/CreatingTables"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Table Structure in DatabaseLink User Guide\"\>", 
       3->"\<\"Creating Tables in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLTables" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTables"], 
          "SQLTableNames" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTableNames"], 
          "SQLTableInformation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableInformation"], 
          "SQLTableTypeNames" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLTableTypeNames"], "SQLCreateTable" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/ref/SQLCreateTable"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SQLTables\"\>", 2->"\<\"SQLTableNames\"\>", 
       3->"\<\"SQLTableInformation\"\>", 4->"\<\"SQLTableTypeNames\"\>", 
       5->"\<\"SQLCreateTable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Information" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Database Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLTables", "ObjectName",
 CellID->21735],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLTables", "[", 
       StyleBox["conn", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the ",
     Cell[BoxData["SQLTable"], "InlineFormula"],
     " objects for each table in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->20373],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TableType\>\"", "\"\<TABLE\>\"", 
    Cell["type of table to return", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->3480]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140156385],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->209445355],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->3081019],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->20979],

Cell["List all the tables:", "ExampleText",
 CellID->16085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"AUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"EDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"PUBLISHERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALESDETAILS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEAUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->30935]
}, Open  ]],

Cell["Get a specific table by name:", "ExampleText",
 CellID->19735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", 
  RowBox[{"conn", ",", " ", "\"\<AUTHORS\>\""}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[4]:=",
 CellID->30883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLTable", "[", 
   RowBox[{"\<\"AUTHORS\"\>", ",", 
    RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], 
  "}"}]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[4]=",
 CellID->2186]
}, Open  ]],

Cell["Get the tables that match a pattern:", "ExampleText",
 CellID->16096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", 
  RowBox[{"conn", ",", " ", "\"\<TITLE%\>\""}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[5]:=",
 CellID->20648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEAUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[5]=",
 CellID->2085]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[6]:=",
 CellID->14752],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->21425132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21982],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "\"TableType\"",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6636],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->81258709],

Cell["Get all types of tables in a data source: ", "ExampleText",
 CellID->7688],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", "=", 
    RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[2]:=",
 CellID->17236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"\"\<TableType\>\"", "\[Rule]", 
    RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]}]}], "]"}]], "Input",
 CellTags->"b:3.1",
 CellLabel->"In[3]:=",
 CellID->26792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_AUTHORIZATIONS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CATALOGS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SCHEMAS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SUPERTABLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLETYPES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_USERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"AUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"EDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"PUBLISHERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALESDETAILS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEAUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->"b:3.1",
 CellLabel->"Out[3]=",
 CellID->27065]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellLabel->"In[4]:=",
 CellID->19278]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12073],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTables",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTables"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLTableTypeNames",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLCreateTable",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLCreateTable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->786],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Table Structure in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"]
}], "Tutorials",
 CellID->591254481],

Cell[TextData[{
 ButtonBox["Creating Tables in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/CreatingTables"]
}], "Tutorials",
 CellID->14193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->91267573],

Cell[TextData[ButtonBox["Database Information",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/DatabaseInformation"]], "MoreAbout",
 CellID->40053941]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLTables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 22.7654155}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLTables[conn] returns the SQLTable objects for each table in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLTables", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLTables"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5363, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->140156385]},
 "b:3.1"->{
  Cell[8392, 264, 166, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->30883],
  Cell[8561, 271, 243, 8, 70, "Output",
   CellTags->"b:3.1",
   CellID->2186],
  Cell[8919, 287, 165, 5, 70, "Input",
   CellTags->"b:3.1",
   CellID->20648],
  Cell[9087, 294, 565, 17, 70, "Output",
   CellTags->"b:3.1",
   CellID->2085],
  Cell[11183, 375, 242, 7, 70, "Input",
   CellTags->"b:3.1",
   CellID->26792],
  Cell[11428, 384, 9077, 221, 70, "Output",
   CellTags->"b:3.1",
   CellID->27065]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25448, 777},
 {"b:3.1", 25580, 781}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2819, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3442, 93, 47, 1, 70, "ObjectName",
 CellID->21735],
Cell[3492, 96, 472, 14, 70, "Usage",
 CellID->32389]
}, Open  ]],
Cell[CellGroupData[{
Cell[4001, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4479, 132, 69, 1, 70, "Notes",
 CellID->20373],
Cell[4551, 135, 775, 19, 70, "3ColumnTableMod",
 CellID->3480]
}, Closed]],
Cell[CellGroupData[{
Cell[5363, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140156385],
Cell[CellGroupData[{
Cell[5748, 173, 148, 5, 70, "ExampleSection",
 CellID->209445355],
Cell[5899, 180, 133, 3, 70, "Input",
 CellID->3081019],
Cell[6035, 185, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6436, 197, 207, 7, 70, "Input",
 CellID->20979],
Cell[6646, 206, 59, 1, 70, "ExampleText",
 CellID->16085],
Cell[CellGroupData[{
Cell[6730, 211, 104, 3, 70, "Input",
 CellID->15713],
Cell[6837, 216, 1447, 40, 70, "Output",
 CellID->30935]
}, Open  ]],
Cell[8299, 259, 68, 1, 70, "ExampleText",
 CellID->19735],
Cell[CellGroupData[{
Cell[8392, 264, 166, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->30883],
Cell[8561, 271, 243, 8, 70, "Output",
 CellTags->"b:3.1",
 CellID->2186]
}, Open  ]],
Cell[8819, 282, 75, 1, 70, "ExampleText",
 CellID->16096],
Cell[CellGroupData[{
Cell[8919, 287, 165, 5, 70, "Input",
 CellTags->"b:3.1",
 CellID->20648],
Cell[9087, 294, 565, 17, 70, "Output",
 CellTags->"b:3.1",
 CellID->2085]
}, Open  ]],
Cell[9667, 314, 148, 5, 70, "Input",
 CellID->14752],
Cell[9818, 321, 401, 10, 70, "ExampleText",
 CellID->21425132]
}, Open  ]],
Cell[CellGroupData[{
Cell[10256, 336, 218, 7, 70, "ExampleSection",
 CellID->21982],
Cell[CellGroupData[{
Cell[10499, 347, 229, 7, 70, "ExampleSubsection",
 CellID->6636],
Cell[10731, 356, 134, 3, 70, "Input",
 CellID->81258709],
Cell[10868, 361, 80, 1, 70, "ExampleText",
 CellID->7688],
Cell[10951, 364, 207, 7, 70, "Input",
 CellID->17236],
Cell[CellGroupData[{
Cell[11183, 375, 242, 7, 70, "Input",
 CellTags->"b:3.1",
 CellID->26792],
Cell[11428, 384, 9077, 221, 70, "Output",
 CellTags->"b:3.1",
 CellID->27065]
}, Open  ]],
Cell[20520, 608, 148, 5, 70, "Input",
 CellID->19278]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20729, 620, 311, 9, 70, "SeeAlsoSection",
 CellID->12073],
Cell[21043, 631, 1315, 44, 70, "SeeAlso",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[22395, 680, 312, 9, 70, "TutorialsSection",
 CellID->786],
Cell[22710, 691, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[23000, 702, 420, 12, 70, "Tutorials",
 CellID->591254481],
Cell[23423, 716, 416, 12, 70, "Tutorials",
 CellID->14193]
}, Open  ]],
Cell[CellGroupData[{
Cell[23876, 733, 318, 9, 70, "MoreAboutSection",
 CellID->91267573],
Cell[24197, 744, 163, 3, 70, "MoreAbout",
 CellID->40053941]
}, Open  ]],
Cell[24375, 750, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

