(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20895,        746]
NotebookOptionsPosition[     15147,        539]
NotebookOutlinePosition[     17617,        620]
CellTagsIndexPosition[     17506,        614]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatabaseLink User Guide" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
          "Updating Data in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/UpdatingData"], 
          "Updating Data with Raw SQL in DatabaseLink User Guide" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/tutorial/SQLUpdatingData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
       2->"\<\"Updating Data in DatabaseLink User Guide\"\>", 
       3->"\<\"Updating Data with Raw SQL in DatabaseLink User Guide\"\>"}, "\
\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SQLExecute" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"], 
          "SQLDelete" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDelete"], 
          "SQLInsert" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLInsert"], 
          "SQLSelect" :> 
          Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSelect"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SQLExecute\"\>", 
       2->"\<\"SQLDelete\"\>", 3->"\<\"SQLInsert\"\>", 
       4->"\<\"SQLSelect\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Database Connections" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"], 
          "SQL Data Access and Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"], 
          "SQL Database Operations" :> 
          Documentation`HelpLookup[
           "paclet:DatabaseLink/guide/SQLDatabaseOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Database Connections\"\>", 
       2->"\<\"SQL Data Access and Manipulation\"\>", 
       3->"\<\"SQL Database Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLUpdate", "ObjectName",
 CellID->16565],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SQLUpdate", "[", 
       RowBox[{
        StyleBox["conn", "TI"], ",", 
        StyleBox["table", "TI"], ",", 
        StyleBox["cols", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]updates data in a table in an SQL connection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23762]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Returns an integer specifying the number of rows affected by the query.\
\>", "Notes",
 CellID->19473],

Cell["The following option can be given: ", "Notes",
 CellID->23681],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the timeout for the query", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->21970]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->541047035],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->34221017],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->218449720],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"]],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "ExampleText",
 CellID->11538],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"conn", " ", "=", " ", 
    RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[2]:=",
 CellID->4429],

Cell["Create a table and insert some data:", "ExampleText",
 CellID->31066],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}], ",", " ", 
    "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[3]:=",
 CellID->27689],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{"10", ",", " ", "10.5"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[4]:=",
 CellID->14663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->11771],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "10.5`"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->5541]
}, Open  ]],

Cell["Update all the data:", "ExampleText",
 CellID->16259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLUpdate", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", " ", "12.5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[6]:=",
 CellID->18631],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[6]=",
 CellID->23572]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[7]:=",
 CellID->2514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"12", ",", "12.5`"}], "}"}], "}"}]], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[7]=",
 CellID->10966]
}, Open  ]],

Cell["Insert more data:", "ExampleText",
 CellID->25988],

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{"20", ",", " ", "20.5"}], "}"}]}], "]"}], ";"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[8]:=",
 CellID->18170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->28168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "12.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "20.5`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->22199]
}, Open  ]],

Cell["Update only data matching a condition:", "ExampleText",
 CellID->655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLUpdate", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1.1"}], "}"}], ",", " ", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<COL1\>\"", "]"}], " ", "<", " ", "15"}]}], 
  " ", "]"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[10]:=",
 CellID->3850],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[10]=",
 CellID->13444]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[11]:=",
 CellID->12936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "20.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[11]=",
 CellID->16278]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"SQLDropTable", "[", 
    RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[12]:=",
 CellID->19406],

Cell[BoxData[
 StyleBox[
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], 
  "InputDeemphasis"]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[13]:=",
 CellID->29427]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLDelete",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLDelete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SQLSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLSelect"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23147],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Updating Data in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UpdatingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UpdatingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UpdatingData"]
}], "Tutorials",
 CellID->14193],

Cell[TextData[{
 ButtonBox["Updating Data with Raw SQL in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLUpdatingData"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLUpdatingData"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLUpdatingData"]
}], "Tutorials",
 CellID->34023392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->201224385],

Cell[TextData[ButtonBox["Database Connections",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/DatabaseConnectionsAndResources"]], "MoreAbout",
 CellID->61554627],

Cell[TextData[ButtonBox["SQL Data Access and Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:DatabaseLink/guide/SQLDataAccessAndManipulation"]], "MoreAbout",
 CellID->547498041],

Cell[TextData[ButtonBox["SQL Database Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:DatabaseLink/guide/SQLDatabaseOperations"]], "MoreAbout",\

 CellID->284601539]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLUpdate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 24.8279023}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "SQLUpdate[conn, table, cols, data] updates data in a table in an SQL \
connection.", "synonyms" -> {}, "title" -> "SQLUpdate", "type" -> "Symbol", 
    "uri" -> "DatabaseLink/ref/SQLUpdate"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5397, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->541047035]},
 "b:4.1.4"->{
  Cell[6471, 200, 238, 8, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->4429],
  Cell[6790, 213, 695, 18, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->27689],
  Cell[7488, 233, 353, 10, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->14663],
  Cell[8251, 266, 319, 9, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->18631],
  Cell[8573, 277, 89, 3, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->23572],
  Cell[8699, 285, 164, 5, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->2514],
  Cell[8866, 292, 163, 6, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->10966],
  Cell[9103, 304, 353, 10, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->18170],
  Cell[9962, 340, 429, 12, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->3850],
  Cell[10394, 354, 90, 3, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->13444],
  Cell[10521, 362, 161, 5, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->12936],
  Cell[10685, 369, 241, 9, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->16278],
  Cell[10941, 381, 225, 8, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->19406],
  Cell[11169, 391, 171, 6, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->29427]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16192, 564},
 {"b:4.1.4", 16326, 568}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3011, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3634, 96, 47, 1, 70, "ObjectName",
 CellID->16565],
Cell[3684, 99, 536, 16, 70, "Usage",
 CellID->23762]
}, Open  ]],
Cell[CellGroupData[{
Cell[4257, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4735, 137, 112, 3, 70, "Notes",
 CellID->19473],
Cell[4850, 142, 68, 1, 70, "Notes",
 CellID->23681],
Cell[4921, 145, 439, 12, 70, "3ColumnTableMod",
 CellID->21970]
}, Closed]],
Cell[CellGroupData[{
Cell[5397, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->541047035],
Cell[CellGroupData[{
Cell[5782, 176, 147, 5, 70, "ExampleSection",
 CellID->34221017],
Cell[5932, 183, 135, 3, 70, "Input",
 CellID->218449720],
Cell[6070, 188, 398, 10, 70, "ExampleText",
 CellID->11538],
Cell[6471, 200, 238, 8, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->4429],
Cell[6712, 210, 75, 1, 70, "ExampleText",
 CellID->31066],
Cell[6790, 213, 695, 18, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->27689],
Cell[7488, 233, 353, 10, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->14663],
Cell[CellGroupData[{
Cell[7866, 247, 143, 4, 70, "Input",
 CellID->11771],
Cell[8012, 253, 140, 5, 70, "Output",
 CellID->5541]
}, Open  ]],
Cell[8167, 261, 59, 1, 70, "ExampleText",
 CellID->16259],
Cell[CellGroupData[{
Cell[8251, 266, 319, 9, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->18631],
Cell[8573, 277, 89, 3, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->23572]
}, Open  ]],
Cell[CellGroupData[{
Cell[8699, 285, 164, 5, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->2514],
Cell[8866, 292, 163, 6, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->10966]
}, Open  ]],
Cell[9044, 301, 56, 1, 70, "ExampleText",
 CellID->25988],
Cell[9103, 304, 353, 10, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->18170],
Cell[CellGroupData[{
Cell[9481, 318, 143, 4, 70, "Input",
 CellID->28168],
Cell[9627, 324, 220, 8, 70, "Output",
 CellID->22199]
}, Open  ]],
Cell[9862, 335, 75, 1, 70, "ExampleText",
 CellID->655],
Cell[CellGroupData[{
Cell[9962, 340, 429, 12, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->3850],
Cell[10394, 354, 90, 3, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->13444]
}, Open  ]],
Cell[CellGroupData[{
Cell[10521, 362, 161, 5, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->12936],
Cell[10685, 369, 241, 9, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->16278]
}, Open  ]],
Cell[10941, 381, 225, 8, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->19406],
Cell[11169, 391, 171, 6, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->29427]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11389, 403, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[11708, 414, 1007, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12752, 454, 314, 9, 70, "TutorialsSection",
 CellID->23147],
Cell[13069, 465, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[13359, 476, 408, 12, 70, "Tutorials",
 CellID->14193],
Cell[13770, 490, 433, 12, 70, "Tutorials",
 CellID->34023392]
}, Open  ]],
Cell[CellGroupData[{
Cell[14240, 507, 319, 9, 70, "MoreAboutSection",
 CellID->201224385],
Cell[14562, 518, 178, 4, 70, "MoreAbout",
 CellID->61554627],
Cell[14743, 524, 188, 4, 70, "MoreAbout",
 CellID->547498041],
Cell[14934, 530, 171, 4, 70, "MoreAbout",
 CellID->284601539]
}, Open  ]],
Cell[15120, 537, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

