(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13819,        426]
NotebookOptionsPosition[     10306,        318]
NotebookOutlinePosition[     12257,        372]
CellTagsIndexPosition[     12099,        365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
    
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DatabaseLink User Guide" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/tutorial/Overview"], 
         "Connection Configuration in DatabaseLink User Guide" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/tutorial/DatabaseResources#21025"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DatabaseLink User Guide\"\>", 
      2->"\<\"Connection Configuration in DatabaseLink User Guide\"\>"}, \
"\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WriteDataSource", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WriteDataSource", "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a new HSQL data source ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WriteDataSource", "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", 
        StyleBox["database", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a new data source to ",
     Cell[BoxData[
      StyleBox["database", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->378748354],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", "\"\<\>\"", Cell[
    "textual description of the data source", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<URL\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "URL to use in the JDBC setting", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Username\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "username for the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Password\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "password for the connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Properties\>\"", 
    RowBox[{"{", "}"}], Cell[
    "properties to set for this connection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Location\>\"", "User", Cell[
    "where to install the data source", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RelativePath\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether file-based databases have a relative path", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UseConnectionPool\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether a connection pool should be used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadOnly\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the connection should be read-only", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->29545362]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->167289684],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->90660922],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->208694874],

Cell[TextData[{
 "Create a new data source named ",
 StyleBox["testSource", "MR"],
 " that will use the ",
 Cell[BoxData[
  ButtonBox["HSQL",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/DatabaseReference#28289"]]],
 " database:"
}], "ExampleText",
 CellID->941817809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteDataSource", "[", "\"\<testSource\>\"", "]"}]], "Input",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellLabel->"In[2]:=",
 CellID->76893794],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", ",", "\<\"demoSource\"\>"}], "]"}], 
   ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"demoSource\"\>"}], ",", 
   RowBox[{"\<\"Description\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellLabel->"Out[2]=",
 CellID->526125040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29953826],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->22316340],

Cell[TextData[{
 "Create a new data source that includes the ",
 StyleBox["Username", "MR"],
 " and ",
 StyleBox["Password", "MR"],
 " and is available to all users:"
}], "ExampleText",
 CellID->922780184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteDataSource", "[", 
  RowBox[{
  "\"\<testSQL\>\"", ",", " ", "\"\<MySQL(Connector/J)\>\"", ",", " ", 
   RowBox[{"URL", " ", "\[Rule]", " ", "\"\<main/test\>\""}], ",", " ", 
   RowBox[{"Username", " ", "\[Rule]", " ", "\"\<user\>\""}], ",", " ", 
   RowBox[{"Password", " ", "\[Rule]", " ", "\"\<password\>\""}], ",", " ", 
   RowBox[{"Location", " ", "\[Rule]", " ", "\"\<System\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8519225],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"MySQL(Connector/J)\"\>", ",", "\<\"main/test\"\>"}], "]"}], 
   ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"testSQL\"\>"}], ",", 
   RowBox[{"\<\"Description\"\>", "\[Rule]", "\<\"\"\>"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "\<\"user\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "\<\"password\"\>"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->81883639]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[{
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Overview"]
}], "Tutorials",
 CellID->25027],

Cell[TextData[{
 ButtonBox["Connection Configuration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#21025"],
 StyleBox[ButtonBox["DatabaseLink",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#21025"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#21025"]
}], "Tutorials",
 CellID->133710995]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WriteDataSource - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 25.7966461}", "context" -> 
    "DatabaseLink`", "keywords" -> {}, "index" -> True, "label" -> 
    "DatabaseLink Symbol", "language" -> "en", "paclet" -> "DatabaseLink", 
    "status" -> "None", "summary" -> 
    "WriteDataSource[name] writes a new HSQL data source name. \
WriteDataSource[name, database] writes a new data source to database.", 
    "synonyms" -> {}, "title" -> "WriteDataSource", "type" -> "Symbol", "uri" -> 
    "DatabaseLink/ref/WriteDataSource"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5018, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->167289684]},
 "b:2.3.0"->{
  Cell[6006, 190, 183, 4, 70, "Input",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->76893794],
  Cell[6192, 196, 1005, 21, 70, "Output",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->526125040]},
 "Ex--21943492438155078303,191"->{
  Cell[6006, 190, 183, 4, 70, "Input",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->76893794],
  Cell[6192, 196, 1005, 21, 70, "Output",
   CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
   CellID->526125040]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11421, 344},
 {"b:2.3.0", 11555, 348},
 {"Ex--21943492438155078303,191", 11833, 355}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 845, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1468, 46, 37, 0, 70, "ObjectName"],
Cell[1508, 48, 821, 26, 70, "Usage",
 CellID->32588]
}, Open  ]],
Cell[CellGroupData[{
Cell[2366, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2844, 96, 73, 1, 70, "Notes",
 CellID->378748354],
Cell[2920, 99, 2061, 46, 70, "3ColumnTableMod",
 CellID->29545362]
}, Closed]],
Cell[CellGroupData[{
Cell[5018, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->167289684],
Cell[CellGroupData[{
Cell[5403, 164, 147, 5, 70, "ExampleSection",
 CellID->90660922],
Cell[5553, 171, 135, 3, 70, "Input",
 CellID->208694874],
Cell[5691, 176, 290, 10, 70, "ExampleText",
 CellID->941817809],
Cell[CellGroupData[{
Cell[6006, 190, 183, 4, 70, "Input",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellID->76893794],
Cell[6192, 196, 1005, 21, 70, "Output",
 CellTags->{"b:2.3.0", "Ex--21943492438155078303,191"},
 CellID->526125040]
}, Open  ]],
Cell[7212, 220, 124, 3, 70, "ExampleDelimiter",
 CellID->29953826],
Cell[7339, 225, 134, 3, 70, "Input",
 CellID->22316340],
Cell[7476, 230, 205, 7, 70, "ExampleText",
 CellID->922780184],
Cell[CellGroupData[{
Cell[7706, 241, 480, 10, 70, "Input",
 CellID->8519225],
Cell[8189, 253, 967, 20, 70, "Output",
 CellID->81883639]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9217, 280, 298, 8, 70, "TutorialsSection"],
Cell[9518, 290, 287, 9, 70, "Tutorials",
 CellID->25027],
Cell[9808, 301, 456, 12, 70, "Tutorials",
 CellID->133710995]
}, Open  ]],
Cell[10279, 316, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

