(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10082,        352]
NotebookOptionsPosition[      5875,        221]
NotebookOutlinePosition[      8946,        309]
CellTagsIndexPosition[      8735,        298]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Comparing ",
 StyleBox["Mathematica\[Hyphen]",
  FontSlant->"Italic"],
 "Style Queries and SQL",
 StyleBox["\[Hyphen]",
  FontSlant->"Italic"],
 "Style Queries"
}], "Title",
 CellTags->{"xref:28", "c:40"},
 CellID->11367],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " provides two styles of commands for working with data: one for those who \
are familiar with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and the other for those who are familiar with SQL. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "style requires less knowledge of SQL. However, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands do not give complete coverage; thus, for more advanced queries, \
SQL",
 StyleBox["\[Hyphen]",
  FontSlant->"Italic"],
 "style commands may be preferred. The latter may also be desirable if you \
already have a knowledge of SQL."
}], "Text",
 CellTags->"b:4.1.0",
 CellID->21787],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 StyleBox["\[Hyphen]",
  FontSlant->"Italic"],
 "Style Queries"
}], "Section",
 CellTags->"c:43b",
 CellID->28532],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " offers a number of functions for ",
 StyleBox["Mathematica\[Hyphen]",
  FontSlant->"Italic"],
 "style queries."
}], "Text",
 CellID->30556],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLSelect",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"]], "BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->30974],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLUpdate",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"]], "BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->3447],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLInsert",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"]], "BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->5021],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLDelete",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"]], "BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->18283],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLCreateTable",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLCreateTable"]], "InlineFormula"]], \
"BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->26222],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLDropTable",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLDropTable"]], "InlineFormula"]], "BulletedText",\

 CellMargins->{{45, 27}, {0, 8}},
 CellID->29331],

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLMemberQ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLMemberQ"]], "InlineFormula"]], "BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->2376],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox["SQLStringMatchQ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:DatabaseLink/ref/SQLStringMatchQ"]], "InlineFormula"]], \
"BulletedText",
 CellMargins->{{45, 27}, {0, 8}},
 CellID->28583],

Cell[TextData[{
 "The first six functions interact with the database. ",
 Cell[BoxData[
  ButtonBox["SQLMemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLMemberQ"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SQLStringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLStringMatchQ"]], "InlineFormula"],
 " are used for testing data in queries with conditions. "
}], "Text",
 CellID->26948]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "SQL",
 StyleBox["\[Hyphen]",
  FontSlant->"Italic"],
 "Style Queries"
}], "Section",
 CellTags->{"xref:29", "c:52", "b:4.2.1"},
 CellID->12723],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " can work with databases with raw SQL statements. This is useful if you \
already have a knowledge of SQL. Statements can be used to select data, \
create tables, insert data, update data, remove data, and drop tables. \
Typically these statements are passed to a command, ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute"]], "InlineFormula"],
 ". The statement used by ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute"]], "InlineFormula"],
 " ",
 "is a string that can contain all arguments. However, it is also possible to \
give the arguments separately, which makes the statement a prepared \
statement. ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute"]], "InlineFormula"],
 " can also be used to execute a batch of prepared statements with different \
arguments, as described in ",
 ButtonBox["Performance: Batch Operation",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/Performance#17968"],
 "."
}], "Text",
 CellTags->"b:4.2.1",
 CellID->5928095]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Comparing Mathematica-Style Queries and SQL-Style Queries - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 30.9528631}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "DatabaseLink provides two styles of commands for working with data: one \
for those who are familiar with Mathematica and the other for those who are \
familiar with SQL. Mathematica style requires less knowledge of SQL. However, \
the Mathematica commands do not give complete coverage; thus, for more \
advanced queries, SQL-style commands may be preferred. The latter may also be \
desirable if you already have a knowledge of SQL. DatabaseLink offers a \
number of functions for Mathematica-style queries. The first six functions \
interact with the database. SQLMemberQ and SQLStringMatchQ are used for \
testing data in queries with conditions. ", "synonyms" -> {}, "title" -> 
    "Comparing Mathematica-Style Queries and SQL-Style Queries", "type" -> 
    "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/ComparingMathematicaAndSQLStyleQueries"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:28"->{
  Cell[729, 29, 239, 10, 70, "Title",
   CellTags->{"xref:28", "c:40"},
   CellID->11367]},
 "c:40"->{
  Cell[729, 29, 239, 10, 70, "Title",
   CellTags->{"xref:28", "c:40"},
   CellID->11367]},
 "b:4.1.0"->{
  Cell[971, 41, 717, 21, 70, "Text",
   CellTags->"b:4.1.0",
   CellID->21787]},
 "c:43b"->{
  Cell[1713, 66, 179, 8, 70, "Section",
   CellTags->"c:43b",
   CellID->28532]},
 "xref:29"->{
  Cell[4397, 174, 161, 7, 70, "Section",
   CellTags->{"xref:29", "c:52", "b:4.2.1"},
   CellID->12723]},
 "c:52"->{
  Cell[4397, 174, 161, 7, 70, "Section",
   CellTags->{"xref:29", "c:52", "b:4.2.1"},
   CellID->12723]},
 "b:4.2.1"->{
  Cell[4397, 174, 161, 7, 70, "Section",
   CellTags->{"xref:29", "c:52", "b:4.2.1"},
   CellID->12723],
  Cell[4561, 183, 1260, 32, 70, "Text",
   CellTags->"b:4.2.1",
   CellID->5928095]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:28", 7886, 264},
 {"c:40", 7989, 268},
 {"b:4.1.0", 8095, 272},
 {"c:43b", 8188, 276},
 {"xref:29", 8284, 280},
 {"c:52", 8401, 284},
 {"b:4.2.1", 8521, 288}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 239, 10, 70, "Title",
 CellTags->{"xref:28", "c:40"},
 CellID->11367],
Cell[971, 41, 717, 21, 70, "Text",
 CellTags->"b:4.1.0",
 CellID->21787],
Cell[CellGroupData[{
Cell[1713, 66, 179, 8, 70, "Section",
 CellTags->"c:43b",
 CellID->28532],
Cell[1895, 76, 208, 8, 70, "Text",
 CellID->30556],
Cell[2106, 86, 214, 6, 70, "BulletedText",
 CellID->30974],
Cell[2323, 94, 213, 6, 70, "BulletedText",
 CellID->3447],
Cell[2539, 102, 213, 6, 70, "BulletedText",
 CellID->5021],
Cell[2755, 110, 214, 6, 70, "BulletedText",
 CellID->18283],
Cell[2972, 118, 226, 7, 70, "BulletedText",
 CellID->26222],
Cell[3201, 127, 222, 7, 70, "BulletedText",
 CellID->29331],
Cell[3426, 136, 215, 6, 70, "BulletedText",
 CellID->2376],
Cell[CellGroupData[{
Cell[3666, 146, 228, 7, 70, "BulletedText",
 CellID->28583],
Cell[3897, 155, 451, 13, 70, "Text",
 CellID->26948]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4397, 174, 161, 7, 70, "Section",
 CellTags->{"xref:29", "c:52", "b:4.2.1"},
 CellID->12723],
Cell[4561, 183, 1260, 32, 70, "Text",
 CellTags->"b:4.2.1",
 CellID->5928095]
}, Open  ]]
}, Open  ]],
Cell[5848, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

