(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28102,        866]
NotebookOptionsPosition[     21136,        633]
NotebookOutlinePosition[     25023,        748]
CellTagsIndexPosition[     24823,        738]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"OpenSQLConnection" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/OpenSQLConnection"], 
         "SQLConnectionPoolClose" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLConnectionPoolClose"], 
         "SQLConnectionPools" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLConnectionPools"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "$SQLUseConnectionPool" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/$SQLUseConnectionPool"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"OpenSQLConnection\"\>", 
      2->"\<\"SQLConnectionPoolClose\"\>", 3->"\<\"SQLConnectionPools\"\>", 
      4->"\<\"True\"\>", 
      5->"\<\"$SQLUseConnectionPool\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Connection Pools", "Title",
 CellTags->"xref:164",
 CellID->31310],

Cell[TextData[{
 "Database connection pools are a common way to improve the performance of \
database operations. They can be useful because creating a new connection can \
easily take several seconds to establish; this is a problem when the database \
operation is one that only needs a few milliseconds. ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " provides a connection pool mechanism built on top of the Apache Commons \
DBCP, ",
 ButtonBox["http://jakarta.apache.org/commons/dbcp/index.html",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://jakarta.apache.org/commons/dbcp/index.html "], None}],
 "."
}], "Text",
 CellTags->"b:6.2.0",
 CellID->623633091],

Cell[CellGroupData[{

Cell["Working with Connection Pools", "Section",
 CellTags->{"xref:166", "b:6.2.1"},
 CellID->7926],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->1670],

Cell[TextData[{
 "To create a connection from a pool you can set the ",
 Cell[BoxData["UseConnectionPool"], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 ". Here is an example."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->9487],

Cell[TextData[{
 "First, the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " package is loaded. Then a connection using a pool is made to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " example database."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->838162193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";", 
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", 
    RowBox[{"\"\<publisher\>\"", ",", " ", 
     RowBox[{"UseConnectionPool", " ", "\[Rule]", " ", "True"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408047620],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "2", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2249643]
}, Open  ]],

Cell[TextData[{
 "Instead of using the ",
 StyleBox["UseConnectionPool", "MR"],
 " option, you could set the default value ",
 Cell[BoxData[
  ButtonBox["$SQLUseConnectionPool",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/$SQLUseConnectionPool"]], 
  "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". When ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " loads it is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->724809806],

Cell[CellGroupData[{

Cell[BoxData["$SQLUseConnectionPool"], "Input",
 CellLabel->"In[2]:=",
 CellID->370031222],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[2]=",
 CellID->544129094]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OpenSQLConnection",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"], "[", 
     StyleBox["src", "TI"], ",", "UseConnectionPool", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "connect to a data source using a connection pool", "TableText"]},
   {
    ButtonBox["$SQLUseConnectionPool",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/$SQLUseConnectionPool"], Cell[
    "whether to always use connection pools", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLConnectionPools",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"], "[", "]"}], 
    Cell["information on all active connection pools", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLConnectionPools",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[TextData[{
     StyleBox["information on pool for connection ", "TableText"],
     Cell[BoxData[
      StyleBox["conn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"SetSQLConnectionPoolOptions", "[", 
     StyleBox["pool", "TI"], "]"}], Cell[TextData[{
     StyleBox["set options for connection pool ", "TableText"],
     Cell[BoxData[
      StyleBox["pool", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLConnectionPoolClose",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPoolClose"], "[", 
     StyleBox["pool", "TI"], "]"}], Cell[TextData[{
     StyleBox["close the connection pool ", "TableText"],
     Cell[BoxData[
      StyleBox["pool", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->51942159],

Cell["Commands for working with connection pools.", "Caption",
 CellTags->"b:6.0",
 CellID->129687603],

Cell["\<\
This shows all the connection pools that have been created; there is only \
one.\
\>", "Text",
 CellTags->"b:6.2.1",
 CellID->136796432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnectionPools", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->223644911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLConnectionPool", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\[LeftGuillemet]", 
      RowBox[{"JavaObject", "[", 
       RowBox[{
       "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
        "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
     JLink`Objects`vm1`JavaObject367842172076033], ",", 
    RowBox[{"JDBC", "[", 
     RowBox[{"\<\"HSQL(Standalone)\"\>", 
      ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application Data\\\
\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], "]"}], 
    ",", "1", ",", 
    RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"\<\"Description\"\>", 
     "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
    ",", 
    RowBox[{"\<\"Location\"\>", 
     "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\
\\6.0_Thin\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\\DatabaseResources\\\\\
publisher.m\"\>"}], ",", 
    RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
    RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
    RowBox[{"\<\"Properties\"\>", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
    RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], 
    ",", 
    RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
    RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->32195145]
}, Open  ]],

Cell["\<\
This shows the connection pool used to connect to the publisher database. You \
can see some of the options that the connection pool is using.\
\>", "Text",
 CellTags->"b:6.2.1",
 CellID->108533982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pool", "=", 
  RowBox[{"SQLConnectionPools", "[", "conn", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->203098963],

Cell[BoxData[
 RowBox[{"SQLConnectionPool", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{
      "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
       "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject367842172076033], ",", 
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
    "]"}], ",", "1", ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0_Thin\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\
\\DatabaseResources\\\\publisher.m\"\>"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->491714131]
}, Open  ]],

Cell["\<\
This closes the connection pool, and it also closes any connections that the \
pool is using.\
\>", "Text",
 CellID->466815679],

Cell[BoxData[
 RowBox[{"SQLConnectionPoolClose", "[", "pool", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->306292289]
}, Open  ]],

Cell[CellGroupData[{

Cell["Connection Pool Options", "Section",
 CellTags->{"xref:166", "b:6.2.1"},
 CellID->58865762],

Cell["\<\
There are a number of options that control how the connection pool operates. \
This example shows how to work with them.\
\>", "Text",
 CellID->712270001],

Cell[TextData[{
 "First, the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " package is loaded. Then a connection using a pool is made to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " example database."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->18333971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";", 
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", 
    RowBox[{"\"\<publisher\>\"", ",", " ", 
     RowBox[{"UseConnectionPool", " ", "\[Rule]", " ", "True"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410259035],

Cell[BoxData[
 RowBox[{"SQLConnection", "[", 
  RowBox[{"\<\"publisher\"\>", ",", "1", ",", "\<\"Open\"\>"}], 
  "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->883951237]
}, Open  ]],

Cell["\<\
This shows all the connection pools that have been created; there is only \
one.\
\>", "Text",
 CellTags->"b:6.2.1",
 CellID->225133563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnectionPools", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->574294987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLConnectionPool", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\[LeftGuillemet]", 
      RowBox[{"JavaObject", "[", 
       RowBox[{
       "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
        "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
     JLink`Objects`vm1`JavaObject344458860167169], ",", 
    RowBox[{"JDBC", "[", 
     RowBox[{"\<\"HSQL(Standalone)\"\>", 
      ",", "\<\"C:\\\\Documents and Settings\\\\User\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
     "]"}], ",", "1", ",", 
    RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"\<\"Description\"\>", 
     "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
    ",", 
    RowBox[{"\<\"Location\"\>", 
     "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\
\\6.0\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\\DatabaseResources\\\\\
publisher.m\"\>"}], ",", 
    RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
    RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
    RowBox[{"\<\"Properties\"\>", "\[Rule]", 
     RowBox[{"{", "}"}]}], ",", 
    RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
    RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], 
    ",", 
    RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
    RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
    RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->788324118]
}, Open  ]],

Cell["\<\
This shows the connection pool used to connect to the publisher database. You \
can see some of the options that the connection pool is using.\
\>", "Text",
 CellTags->"b:6.2.1",
 CellID->91682236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLConnectionPools", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482739374],

Cell[BoxData[
 RowBox[{"SQLConnectionPool", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{
      "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
       "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject344458860167169], ",", 
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\User\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
    "]"}], ",", "1", ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\\\
DatabaseResources\\\\publisher.m\"\>"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->98524125]
}, Open  ]],

Cell[TextData[{
 "This sets the ",
 Cell[BoxData["MaxActiveConnections"], "InlineFormula"],
 " option of this connection pool."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->119187396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSQLConnectionPoolOptions", "[", 
  RowBox[{
   RowBox[{"SQLConnectionPools", "[", "conn", "]"}], ",", " ", 
   RowBox[{"MaxActiveConnections", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->118708885],

Cell[BoxData[
 RowBox[{"SQLConnectionPool", "[", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{
      "org", ".", "apache", ".", "commons", ".", "dbcp", ".", 
       "BasicDataSource"}], "]"}], "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject344458860167169], ",", 
   RowBox[{"JDBC", "[", 
    RowBox[{"\<\"HSQL(Standalone)\"\>", 
     ",", "\<\"C:\\\\Documents and Settings\\\\User\\\\Application \
Data\\\\Mathematica\\\\DatabaseResources\\\\Examples\\\\publisher\"\>"}], 
    "]"}], ",", "1", ",", 
   RowBox[{"\<\"Catalog\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"Description\"\>", 
    "\[Rule]", "\<\"Connection to HSQL publisher database for demos.\"\>"}], 
   ",", 
   RowBox[{"\<\"Location\"\>", 
    "\[Rule]", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\SystemFiles\\\\Links\\\\DatabaseLink\\\\\
DatabaseResources\\\\publisher.m\"\>"}], ",", 
   RowBox[{"\<\"Name\"\>", "\[Rule]", "\<\"publisher\"\>"}], ",", 
   RowBox[{"\<\"Password\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Properties\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"ReadOnly\"\>", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"\<\"RelativePath\"\>", "\[Rule]", "False"}], ",", 
   RowBox[{"\<\"TransactionIsolationLevel\"\>", "\[Rule]", "Automatic"}], ",",
    
   RowBox[{"\<\"UseConnectionPool\"\>", "\[Rule]", "True"}], ",", 
   RowBox[{"\<\"Username\"\>", "\[Rule]", "None"}], ",", 
   RowBox[{"\<\"Version\"\>", "\[Rule]", "2.`"}]}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->63107203]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->62683854],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLConnectionPools",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"], "[", "]"}], 
    Cell["information on all active connection pools", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLConnectionPools",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLConnectionPools"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[TextData[{
     StyleBox["information on pool for connection ", "TableText"],
     Cell[BoxData[
      StyleBox["conn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"SetSQLConnectionPoolOptions", "[", 
     StyleBox["pool", "TI"], "]"}], Cell[TextData[{
     StyleBox["set options for connection pool ", "TableText"],
     Cell[BoxData[
      StyleBox["pool", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"CloseConnectionPool", "[", 
     StyleBox["pool", "TI"], "]"}], Cell[TextData[{
     StyleBox["close the connection pool ", "TableText"],
     Cell[BoxData[
      StyleBox["pool", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->32528],

Cell["Functions for working with connection pool options.", "Caption",
 CellTags->"b:6.0",
 CellID->5651],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], " "},
   {"\"\<MaxActiveConnections\>\"", Cell[
    "maximum number of connections to keep in the pool", "TableText"]},
   {"\"\<MinIdleConnections\>\"", Cell[
    "minimum number of idle connections to keep in the pool", "TableText"]},
   {"\"\<MaxIdleConnections\>\"", Cell[
    "maximum number of idle connections to keep in the pool", "TableText"]},
   {"\"\<Catalog\>\"", Cell[
    "location of the database catalog", "TableText"]},
   {"\"\<ReadOnly\>\"", Cell[TextData[StyleBox[
    "set the connection to be read only", "TableText"]], "TableText"]},
   {"\"\<TransactionIsolationLevel\>\"", Cell[
    "set transaction isolation for the connection", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->5786],

Cell["Connection pool options.", "Caption",
 CellTags->"b:2.2.0",
 CellID->12263]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Connection Pools - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 31.8122326}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "Database connection pools are a common way to improve the performance of \
database operations. They can be useful because creating a new connection can \
easily take several seconds to establish; this is a problem when the database \
operation is one that only needs a few milliseconds. DatabaseLink provides a \
connection pool mechanism built on top of the Apache Commons DBCP, \
http://jakarta.apache.org/commons/dbcp/index.html. If you find that the \
examples in this tutorial do not work as shown, you may need to install or \
restore the example database with the DatabaseExamples` package, as described \
in Using the Example Databases. To create a connection from a pool you can \
set the UseConnectionPool option of OpenSQLConnection. Here is an example.", 
    "synonyms" -> {}, "title" -> "Connection Pools", "type" -> "Tutorial", 
    "uri" -> "DatabaseLink/tutorial/ConnectionPools"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:164"->{
  Cell[1826, 54, 72, 2, 70, "Title",
   CellTags->"xref:164",
   CellID->31310]},
 "b:6.2.0"->{
  Cell[1901, 58, 680, 16, 70, "Text",
   CellTags->"b:6.2.0",
   CellID->623633091]},
 "xref:166"->{
  Cell[2606, 78, 99, 2, 70, "Section",
   CellTags->{"xref:166", "b:6.2.1"},
   CellID->7926],
  Cell[11522, 357, 97, 2, 70, "Section",
   CellTags->{"xref:166", "b:6.2.1"},
   CellID->58865762]},
 "b:6.2.1"->{
  Cell[2606, 78, 99, 2, 70, "Section",
   CellTags->{"xref:166", "b:6.2.1"},
   CellID->7926],
  Cell[3153, 95, 368, 12, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->9487],
  Cell[3524, 109, 293, 10, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->838162193],
  Cell[4373, 142, 658, 25, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->724809806],
  Cell[7228, 237, 146, 5, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->136796432],
  Cell[9203, 290, 208, 5, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->108533982],
  Cell[11522, 357, 97, 2, 70, "Section",
   CellTags->{"xref:166", "b:6.2.1"},
   CellID->58865762],
  Cell[11789, 367, 292, 10, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->18333971],
  Cell[12639, 400, 146, 5, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->225133563],
  Cell[14608, 453, 207, 5, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->91682236],
  Cell[16593, 505, 181, 6, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->119187396]},
 "b:6.0"->{
  Cell[7123, 233, 102, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->129687603],
  Cell[19961, 600, 105, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->5651]},
 "b:2.2.0"->{
  Cell[21001, 625, 81, 2, 70, "Caption",
   CellTags->"b:2.2.0",
   CellID->12263]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:164", 23150, 675},
 {"b:6.2.0", 23246, 679},
 {"xref:166", 23347, 683},
 {"b:6.2.1", 23558, 690},
 {"b:6.0", 24532, 724},
 {"b:2.2.0", 24715, 731}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1201, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1826, 54, 72, 2, 70, "Title",
 CellTags->"xref:164",
 CellID->31310],
Cell[1901, 58, 680, 16, 70, "Text",
 CellTags->"b:6.2.0",
 CellID->623633091],
Cell[CellGroupData[{
Cell[2606, 78, 99, 2, 70, "Section",
 CellTags->{"xref:166", "b:6.2.1"},
 CellID->7926],
Cell[2708, 82, 442, 11, 70, "Text",
 CellID->1670],
Cell[3153, 95, 368, 12, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->9487],
Cell[3524, 109, 293, 10, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->838162193],
Cell[CellGroupData[{
Cell[3842, 123, 342, 9, 70, "Input",
 CellID->408047620],
Cell[4187, 134, 171, 5, 70, "Output",
 CellID->2249643]
}, Open  ]],
Cell[4373, 142, 658, 25, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->724809806],
Cell[CellGroupData[{
Cell[5056, 171, 90, 2, 70, "Input",
 CellID->370031222],
Cell[5149, 175, 75, 2, 70, "Output",
 CellID->544129094]
}, Open  ]],
Cell[5239, 180, 1881, 51, 70, "DefinitionBox",
 CellID->51942159],
Cell[7123, 233, 102, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->129687603],
Cell[7228, 237, 146, 5, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->136796432],
Cell[CellGroupData[{
Cell[7399, 246, 109, 3, 70, "Input",
 CellID->223644911],
Cell[7511, 251, 1677, 36, 70, "Output",
 CellID->32195145]
}, Open  ]],
Cell[9203, 290, 208, 5, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->108533982],
Cell[CellGroupData[{
Cell[9436, 299, 143, 4, 70, "Input",
 CellID->203098963],
Cell[9582, 305, 1627, 35, 70, "Output",
 CellID->491714131]
}, Open  ]],
Cell[11224, 343, 137, 4, 70, "Text",
 CellID->466815679],
Cell[11364, 349, 121, 3, 70, "Input",
 CellID->306292289]
}, Open  ]],
Cell[CellGroupData[{
Cell[11522, 357, 97, 2, 70, "Section",
 CellTags->{"xref:166", "b:6.2.1"},
 CellID->58865762],
Cell[11622, 361, 164, 4, 70, "Text",
 CellID->712270001],
Cell[11789, 367, 292, 10, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->18333971],
Cell[CellGroupData[{
Cell[12106, 381, 342, 9, 70, "Input",
 CellID->410259035],
Cell[12451, 392, 173, 5, 70, "Output",
 CellID->883951237]
}, Open  ]],
Cell[12639, 400, 146, 5, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->225133563],
Cell[CellGroupData[{
Cell[12810, 409, 109, 3, 70, "Input",
 CellID->574294987],
Cell[12922, 414, 1671, 36, 70, "Output",
 CellID->788324118]
}, Open  ]],
Cell[14608, 453, 207, 5, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->91682236],
Cell[CellGroupData[{
Cell[14840, 462, 117, 3, 70, "Input",
 CellID->482739374],
Cell[14960, 467, 1618, 35, 70, "Output",
 CellID->98524125]
}, Open  ]],
Cell[16593, 505, 181, 6, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->119187396],
Cell[CellGroupData[{
Cell[16799, 515, 249, 6, 70, "Input",
 CellID->118708885],
Cell[17051, 523, 1618, 35, 70, "Output",
 CellID->63107203]
}, Open  ]],
Cell[18684, 561, 116, 3, 70, "Input",
 CellID->62683854],
Cell[18803, 566, 1155, 32, 70, "DefinitionBox",
 CellID->32528],
Cell[19961, 600, 105, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->5651],
Cell[20069, 604, 929, 19, 70, "DefinitionBox",
 CellID->5786],
Cell[21001, 625, 81, 2, 70, "Caption",
 CellTags->"b:2.2.0",
 CellID->12263]
}, Open  ]]
}, Open  ]],
Cell[21109, 631, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

