(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    159852,       2989]
NotebookOptionsPosition[    138936,       2372]
NotebookOutlinePosition[    153373,       2772]
CellTagsIndexPosition[    152073,       2737]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"False" :> Documentation`HelpLookup["paclet:ref/False"], 
         "Integer" :> Documentation`HelpLookup["paclet:ref/Integer"], "Null" :> 
         Documentation`HelpLookup["paclet:ref/Null"], "Real" :> 
         Documentation`HelpLookup["paclet:ref/Real"], "SQLBinary" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLBinary"], 
         "SQLDateTime" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDateTime"], 
         "SQLExpr" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExpr"], 
         "String" :> Documentation`HelpLookup["paclet:ref/String"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"False\"\>", 2->"\<\"Integer\"\>", 
      3->"\<\"Null\"\>", 4->"\<\"Real\"\>", 5->"\<\"SQLBinary\"\>", 
      6->"\<\"SQLDateTime\"\>", 7->"\<\"SQLExpr\"\>", 8->"\<\"String\"\>", 
      9->"\<\"True\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Data Type Mapping", "Title",
 CellTags->{"c:67", "xref:149"},
 CellID->12896],

Cell[TextData[{
 "One of the most important issues for using a database is the conversion of \
data as it is stored and retrieved from a database. This ",
 "tutorial",
 " will discuss how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions interact with data stored in a database."
}], "Text",
 CellTags->"b:6.1.0",
 CellID->29617],

Cell[TextData[{
 "The following table shows the mappings between data types and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. For example, a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " expression can be stored in SQL integral types such as INTEGER and \
TINYINT. In addition, if data from a column that is of type VARCHAR is \
selected, this will result in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " expression."
}], "Text",
 CellTags->"b:6.1.0",
 CellID->10112],

Cell[BoxData[GridBox[{
   {Cell["Mathematica expression", "TableHeader"], Cell[
    "data type", "TableHeader"]},
   {
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell["\<\
used mostly with SQL types such as CHAR, VARCHAR, and LONGVARCHAR\
\>", "TableText"]},
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell["\<\
used mostly with SQL types such as INTEGER, TINYINT, SMALLINT, and BIGINT\
\>", "TableText"]},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[
    "used mostly with SQL types such as DOUBLE, FLOAT, and REAL", 
     "TableText"]},
   {
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "used mostly with the SQL type BIT", "TableText"]},
   {
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "used mostly with the SQL type BIT", "TableText"]},
   {
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "used mostly with the SQL type NULL", "TableText"]},
   {
    ButtonBox["SQLBinary",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLBinary"], Cell["\<\
used mostly with SQL types such as BINARY, VARBINARY, and LONGVARBINARY\
\>", "TableText"]},
   {
    ButtonBox["SQLDateTime",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"], Cell[
    "used mostly with SQL types such as DATE, TIME, and TIMESTAMP", 
     "TableText"]},
   {
    ButtonBox["SQLExpr",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLExpr"], Cell[TextData[{
     "a special type of binary data that is used to store ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " ",
     "expressions"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->12717],

Cell[TextData[{
 "The mapping between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and data types stored in a database."
}], "Caption",
 CellTags->"b:6.1.0",
 CellID->18696],

Cell[TextData[{
 "Atomic",
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " expressions such as ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ", and compound expressions formed from ",
 Cell[BoxData[
  ButtonBox["SQLBinary",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLDateTime",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["SQLExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExpr"]], "InlineFormula"],
 " are converted to and from Java objects. These Java objects are then \
processed with JDBC operations taking advantage of any encoding or escaping \
functionality that is provided by the JDBC driver. It is typical that they \
contain code specific to a database for encoding a value passed into or \
received from a query.",
 " ",
 "Since these drivers are often implemented by the makers of the database, it \
is very advantageous to use their functionality as much as possible."
}], "Text",
 CellTags->"b:6.1.0",
 CellID->11585],

Cell[TextData[{
 "Certain data types require ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions that use a special wrapper. For example, the data type ",
 "BINARY",
 " requires a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression that uses the wrapper ",
 Cell[BoxData[
  ButtonBox["SQLBinary",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFormula"],
 ". These wrappers are necessary to prevent ambiguities in the command \
structure."
}], "Text",
 CellTags->"b:6.1.0",
 CellID->24041],

Cell[CellGroupData[{

Cell["SQLBinary", "Section",
 CellTags->{"xref:73", "c:69", "b:6.1.1"},
 CellID->24423],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLBinary",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFormula"],
 " can be used to work with binary data in a database. This allows you to \
store data such as images or compiled code."
}], "Text",
 CellTags->"b:6.1.1",
 CellID->24129],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->24229],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:6.1.1",
 CellID->4565],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,197"},
 CellLabel->"In[3]:=",
 CellID->6559],

Cell["This generates a string that contains a GIF image.", "Text",
 CellTags->"b:6.1.1",
 CellID->8932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gif", " ", "=", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", " ", "\"\<GIF\>\""}], 
   "]"}]}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
 CellLabel->"In[3]:=",
 CellID->22296],

Cell[BoxData["\<\"GIF89ah\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\[CapitalOHat]\.00\[CapitalADoubleDot]\.00\.00\.00\.00\.00\.10\
\.10\.10\.18\.18\.18   (((000888@@@HHHPPPXXX```hhhpppxxx\.7f\.7f\.7f\.87\.87\
\.87\.8f\.8f\.8f\.97\.97\.97\.9f\.9f\.9f\[Section]\[Section]\[Section]\.af\.af\
\.af\[CenterDot]\[CenterDot]\[CenterDot]\[DownQuestion]\[DownQuestion]\
\[DownQuestion]\[CapitalCCedilla]\[CapitalCCedilla]\[CapitalCCedilla]\
\[CapitalIDoubleDot]\[CapitalIDoubleDot]\[CapitalIDoubleDot]\[Times]\[Times]\
\[Times]\[SZ]\[SZ]\[SZ]\[CCedilla]\[CCedilla]\[CCedilla]\[IDoubleDot]\
\[IDoubleDot]\[IDoubleDot]\[Divide]\[Divide]\[Divide]\[YDoubleDot]\
\[YDoubleDot]\[YDoubleDot],\.00\.00\.00\.00h\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\[CapitalOHat]\.00\.00\.05\[YDoubleDot]\
\[AGrave]'\.8edi\.9eh\.aa\[RegisteredTrademark]l\[EDoubleDot]\.bep,\
\[CapitalIDoubleDot]tm\[SZ]x\[RegisteredTrademark]\[IDoubleDot]|\[IDoubleDot]\
\[YDoubleDot]\[CapitalAGrave]\[NonBreakingSpace]pH,\.1aE\.80\[Sterling]r\
\[CapitalEAcute]l:\.9fP\.12 Y\.9aV\[Sterling]\[CapitalOSlash]\[Not]v\
\[CapitalEDoubleDot]\[CapitalARing]RG\[CapitalOHat]\[IDoubleDot]G\
\[CapitalUDoubleDot]-\.9b\[CapitalIDoubleDot]\[EGrave]4\.8a\.1c\.96\.aa\[SZ]\
\[Eth]\.b8\\\\\[CapitalEAcute]FJ\[Section]\[CapitalODoubleDot]9\[EHat]\
\[OGrave]h\.1c\.0e\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.00\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.7f\.0b\.11\.17z\.88\.89hucn\.8a$\[RawEscape]\.11\.07\.00\.07\.0f\.86\.17\
\.1d\.1f\.1d\.17\.17\.13~\.00\.06\.11\[RawEscape]\.8f\[Currency]\[Yen]K\.8cbd\
\.88\.13\.07\.03\\r\.87.\.18\\r\.03\.06\.13\.1e\.a6\.b8\.b9<xvc\.8c\.88\.1d\
\.0f\.02\.0b\[Degree]3\.18\.0b\.03\.0f\.99\.ba\[CapitalIGrave]\[CapitalIAcute]\
?\.aap\.11\[CapitalEAcute]\.1c9\.1c\.0f\.03\.11\[CapitalIHat]\[CapitalUAcute]\
\[CapitalUHat]6\[CapitalEth]i\.17\.04\\r\[CapitalEDoubleDot];\.1d\\r\.04\.16\
\[CapitalUDoubleDot]\[EAcute]\[EHat]+\[CapitalThorn]f\.1d\.0b\.07\.1aA\.1a\.08\
\.0b\[ATilde]\[EDoubleDot]\[OSlash]\[EHat]\[IAcute]]\.16\.04\.13E\.13\
\[CapitalIHat]\[ARing]\[RawEscape]\[CapitalEGrave]m\[SZ]\.16\.07\.08\.a8\.19\
\[AAcute]\.80\[NonBreakingSpace]\[CapitalAAcute]-\.82\.10s\.19\
\[CapitalADoubleDot]\[CapitalOGrave]\[AAcute]\.00\.84&\.92\.14F\
\[CapitalUDoubleDot]\.a8\.88\.97\.99\\f\\\\\.05\.8a1\[CapitalAAcute]` \.03\
\[CapitalCCedilla]\.93z&\[YDoubleDot]>\[PlusMinus]p`\.14\.94\\r\.06(\
\[NonBreakingSpace]\.9c\[UGrave]Fe\.93\\t\\t\[IHat]=\[NTilde]\
\[NonBreakingSpace] \[RawEscape]\[CapitalIAcute]\.9fel.\.91\[Degree]\[AGrave]\
\[DownExclamation]\.96\.06\.0e\.80*\[CapitalOTilde]\\\"\[OHat]\[CapitalEGrave]\
\.03\.06f ,XJ\[OTilde]I\[CapitalOAcute]\\\"\.0f\.1e\[NonBreakingSpace]\.990\
\[Micro]\.aa\[Times]#W\.87dU\[CapitalATilde]\[OTilde]\[LeftGuillemet]\
\[CapitalUGrave]!a\.83\.8c}S\[ODoubleDot]\[Not]\[CapitalUHat]\.1ei\.7f\[Not]\
\.85\.03!\[EAcute]\[CapitalUHat]\[RightGuillemet]8\[AHat]\[ODoubleDot]\.90\.00\
uN\.03\.9fx\.03\[CapitalEDoubleDot]\[Eth]\[EGrave]\[CapitalADoubleDot]\.02\.82\
D\\nd\\n^\[IGrave]B\.af\.0e\\f\\\\\.07\.8c\[CapitalIHat]\[NTilde]\.90\.00\.1d\
\[ATilde]\[CapitalEDoubleDot])\.1c\[ATilde]\[CapitalOSlash]P@\[CCedilla]\.9c\
\.0e\.06\[ADoubleDot]a\.1e\[IAcute]\.a8\.89\.87\.92\[Yen]8{&\.bdX\.b3\.8d\
\[CapitalADoubleDot]\.b8. \.90\[CapitalIGrave]\.ba\[Micro]\.93\.08\\rt\
\[NTilde]\[DiscretionaryHyphen]\.8d\[CapitalUGrave]\[OTilde]\.8c\.0b\.07\.9a\
\[YAcute]\[ARing]\[CapitalIAcute]\[CapitalOSlash]w\\f\\\\\.98\.1asy8\.80\.81\
\.b8`\[ATilde]/\.967w\.a6\[CapitalUAcute]9^\[EGrave].\.16\[UDoubleDot]\
\[CapitalUHat]V!\.81\[OTilde]\[RightGuillemet]\.84\.87\[IGrave]N7\[UDoubleDot]\
\[UHat]Y\[IGrave]+ \[CapitalOAcute]v&\[CapitalYAcute]\.bcY\[OHat])<\.10p\
\[Copyright]\[RegisteredTrademark]\.ba\[UHat]\.aa\[Eth]Qh\.1f\[CapitalOSlash]\
\[YAcute]>\[Thorn]\\\"\[YAcute]\.11T\.9e\.7f@\[ARing]W\.02\.07\.05$\.87\
\[CapitalIDoubleDot]\[YDoubleDot]i&\.11\[OSlash]\.93\.81$ `\.19D\.19\.18\
\[Degree]\.9e\.83\.11A(\[CapitalAHat]x\[RawEscape]\[CapitalIAcute]\.85!G\.1a\
jP\[CapitalAGrave]\.85\[UGrave]0\[OSlash]\[AAcute]I\.10\[Paragraph]\.87R\.85$\
\.9e\.a8O\.1e=xx\.92\.8c.\[AHat]c \
H@\.99X\[ATilde]@\[UGrave]\[EAcute]\[OSlash]\.13\.8b;\[AE]\.93_]T\
\[CapitalNTilde]\.18\[Currency]6\[Eth]\.89\[CapitalOSlash]\\\"G>\.1e\.b9\\r|\
\.07\.88\[Currency]\.14\.90N\.a6\.04\\r\.8c\.8d\[Eth]\[CapitalAGrave]aUFV\.b9\
H/`\.98\.80\.1d\.07\.04\[Not]\.96c\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\[Cent]yY\.13\.98H\[UDoubleDot]\.92C\.02\.15\.b8e\.98\
\.9ap\.b4!fi8\.04\[EGrave]\.16lt\.a6a\[CCedilla]\.15`\[AGrave]\[AAcute]X\.07\
\.04(\[OSlash]\.15\.99f\[ODoubleDot]\.99\[CapitalARing]\.9fx\.1a\
\[CapitalCCedilla]\.80\.04\.81m\[Copyright]h\.170&\.11^\.967\.90\.b4X\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\\rN\
\[CapitalUAcute]Q\.0e\.9c.\.86\[Sterling]\[Section]\.9f\[CapitalThorn] )^\.03\
\.92:\.87f\.08\.1az\.97\.07\.03\.b8\.aa\.aa\.9f7\[Currency]\.ba\.98\.9e\.b3\
\[CapitalODoubleDot]i\[CapitalATilde]\.a8\[Sterling]I\.98k\.1c\.8e\.190\
\[CapitalYAcute]hJ\[Thorn]\.ba&\\r\.14(\[CapitalAGrave]\.9b\
\[DiscretionaryHyphen]\[CapitalAE]\.06\.85\[Yen]\.0b\[Degree]\[CapitalEHat]\
\.ba\.18\[DownExclamation]\[CapitalOGrave]6\[EDoubleDot]\.05\[YDoubleDot]\\r\
\[CapitalIGrave]\.8ev\.aa\[Micro]L\[CapitalIAcute]P\[Not]s\[DownExclamation]\
rK\[EAcute]\\f\\\\p~\[Section]\[Copyright]\.b8\\\\\.84\.85\[LeftGuillemet]s\
\[ARing]\[Cent]\[CapitalUHat]m\\f\\\\\[AAcute]~\[CapitalCCedilla]\
\[CapitalAAcute]\.00K\.ba\.0bV\\f\\\\\.b8\[UGrave]\[Times]\[Yen]\.bdt\
\[CapitalAGrave]@\[DiscretionaryHyphen]\.7f\[CapitalNTilde]\[OGrave]\.0bES\
\[CapitalUGrave]Z\[CenterDot]\[RegisteredTrademark]\[CapitalAGrave]\[YAcute]\
\.ba\[Degree]\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\[OTilde]\[OGrave]\.16/\[CapitalAHat]t<\.8bB\[RightGuillemet]\.0e\[OGrave]\\n\
\[NTilde]\.bd-\.9c\[UHat]!\[CapitalARing]\.17\.17a\[CapitalOAcute]\
\[CapitalATilde]\.0e~\[CapitalUHat]1\.11*\[Micro]\[ARing]b\[CapitalAAcute]#\
\[CapitalATilde]\[CapitalARing]B\[CapitalAGrave]5\\\"\.9a2Z,\[IGrave]K`\.be/\
\.07a\[CapitalEth]\.bc\\r\[RightGuillemet]\[CapitalCCedilla]r\[CapitalIAcute]>\
\.18\.842\.86\.07\[OAcute]\.9c\[CapitalATilde]>\.16\.1f\\t\.b2\[CapitalEth]y\
\[Copyright]\[CapitalAGrave]\[NTilde]\.91\[CapitalAGrave]!\.bd\.8b\
\[CapitalADoubleDot]\.1f4M\[CCedilla]\[CapitalOGrave]N\[Times]\[CapitalEth]\
\[CapitalIHat]\[CapitalNTilde]GRYu7(\.04\[IAcute]\[ADoubleDot]\
\[CapitalIDoubleDot][\[CenterDot]\.00\[CapitalIAcute]\[CapitalIHat]t\[AHat]\
\.1c\[Paragraph]\[CapitalOTilde]'\[CapitalEth]<\[Copyright]\.03\.17\.9d=\.83*\
\[DiscretionaryHyphen]\.92J\[Paragraph]\[CapitalUHat]\.8d\.99\.00\[Paragraph]\
\.93j\[CapitalOAcute]]7\\tf\[LeftGuillemet]\[EHat]\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.9az\[DownQuestion]@\.06\
\[CapitalOTilde]\.93z\.1d\[OSlash]\.9d#\.14\[DiscretionaryHyphen]*\
\[CapitalODoubleDot]\.87W\.91\.07\[AAcute]\.9eJ\[CapitalYAcute]xf\.89\.17\
\[CapitalAGrave]-\[ADoubleDot]\.93c\[CapitalEHat]8\[Copyright]\.8ag\
\[CapitalThorn]\.8b\[AAcute]\.aa>\[EHat]9\[YDoubleDot]\[AHat]\.9b\
\[LeftGuillemet]\[CapitalUAcute]\[Divide]\[EGrave]vlk\[IGrave]\[CapitalYAcute]\
\.17K\[UDoubleDot],\.00s;\[DownExclamation]\[AAcute]\[CapitalUHat]\[EAcute]\
\[OGrave]]\[AE]\[CapitalAGrave]\[Micro]\[CCedilla]N\.03\[Sterling]\.bc\
\[CCedilla]=\[OHat]\[IHat]*\[IGrave]\.93\[SZ]\[Eth]\[CapitalAGrave]\.93\
\[NonBreakingSpace]6\[NTilde]\.94\[Divide]\\\\\[UDoubleDot]\.1a\
\[CapitalIDoubleDot]\.04\[CapitalIDoubleDot]5\.a6Y\.a6R(\[OAcute]\
\[CapitalOHat]W\.7fB;\[CapitalAHat];\.9f\[UDoubleDot]\[OTilde]\[CapitalUAcute]\
[\.0f\.a8\[Divide]\[SZ]#>\.02\[CapitalEDoubleDot]\[CapitalUGrave]\.83\.8f\
\[Section]\[OSlash]\[CapitalUDoubleDot]\.9b\.1f\[AE]\[ODoubleDot]\[EGrave]\
\[CenterDot]\.1f\[Thorn]\[UHat]\[Eth]\.9f/?\[AHat]\[Copyright]\[Degree]\\t\.00\
`\[IHat]\.af\.af>\.9b\[NTilde]\[EDoubleDot]\.9f\[Thorn]\[Thorn]\[ARing]\.03`\
\[Divide]\[Thorn]\[CCedilla]>\.9a\.050\.7f\[Thorn]C \[YDoubleDot]\[AE]\.97\
\[CapitalAGrave]\[Thorn]AO\.81\.0fd\[AGrave]\.02%8\.11\[CapitalThorn]\
\[CapitalUGrave]OP\.18\[CapitalIGrave]\[NonBreakingSpace]\.067\[CapitalEGrave]\
\[CapitalAAcute]\.0ez\[Eth]\.83 \\f\\\\\[DownExclamation]\.08GH\[CapitalAHat]\
\.12\.9a\[Eth]\.84(L\[DownExclamation]\\nW\[CapitalEGrave]\[CapitalAHat]\.11R\
\.af~\[CapitalEth]\.9b\.1d\[CapitalEth]\.bc\.830\.1a^\[IDoubleDot]\.0bap\.13\
\[CapitalAHat]J\[Divide]\[LeftGuillemet]\[CapitalIHat]\[CapitalARing]@\.86\.18\
\.92\.9c\[RightGuillemet]x(\[Paragraph]\.94a.W\[NonBreakingSpace]\.13\.1cS\.80\
(8&\.b2\[AGrave]R%\[Eth]\[DownExclamation]\[CapitalIAcute]\[CapitalOGrave]\
\[ARing]D\[PlusMinus]\.19\.84\.88E|\[Times]\[Cent]&h\.15\[Yen]\[CapitalARing]\
\[CapitalEAcute]\.08P\.93\[CapitalYAcute]\.b8V\[NonBreakingSpace]\.ba\
\[YDoubleDot]\[CapitalAAcute]l\[DownExclamation]\.8a{\[CapitalUHat]\[Cent]\\\
nN\.87\.164\.06\[CapitalIDoubleDot]\.8d\.99\\t\[Sterling]\.08b\[CenterDot]\.bc\
k\.8d\[CapitalNTilde]\.0b\.13a]\[CapitalOGrave]\[AGrave]8@\[CapitalUDoubleDot]\
Ep\.04\.be{\.9e\.1a\[CapitalIDoubleDot]xG\.14\.b8\[Not]\.8drl\.02\.1f\[EAcute]\
g\[CapitalEGrave]\[CapitalUHat]\[EAcute]\.00\.8a\.8a\[Not]\[CapitalYAcute]\\\"\
\\t\.88\.82@\.02a\.92\.94\[IGrave]\[AHat]\.1f?\[NonBreakingSpace]\
\[CapitalCCedilla]4F\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.92\.8a\.04\[ARing])\.129\.beXyl\.89\.98t\.9c!\[EAcute]\[Micro]\
\.0b\[DownExclamation]\.95\.91N\[UHat]i\[Yen]\[CapitalEth]\[Degree]\.18$)\
\[Cent]MhIt\[CapitalOGrave]\.11\[EDoubleDot]X3a\.91J\.88;H\[Yen]{li\.b4N\
\[CapitalEAcute]\.12i\[RightGuillemet]\[Not]Q.yY3\.91yI>\[OHat]QY\
\[CapitalOTilde]:9\.b3\[CapitalUDoubleDot]\\\\\.92\.94\.08c\[ATilde]\.91\
\[EGrave]\[OSlash]\[CapitalEGrave]\[Degree]Y\.b2F\[CapitalOHat]4\[ATilde]\
\[CapitalODoubleDot]\.b8\[UGrave]!mJsk\[CapitalEAcute]\.aaR8\[CapitalARing]\
\.196Z~\.87\.98\[DownQuestion];\[RawEscape]0O\.94\[CapitalIGrave]\[Currency]\
\.b9\[DiscretionaryHyphen]\.9e\[CapitalODoubleDot]\.99g\[OAcute]\
\[CapitalUDoubleDot]\.a6\[Micro]\.0f\.b9S\.90g[\[Section]\[Paragraph]\[UAcute]\
B2\.bd\.99Sg\.a6\[OHat]\.186S\[ODoubleDot]\[CapitalIAcute]\[IDoubleDot]\.08\
\.94\.99\[ATilde]L\.a8\.7f\.16\.96\.b3n\.06n\.99\[Currency]\[CapitalAAcute]\
\[Section]E\.03\[CCedilla]\[CapitalEDoubleDot]\[UHat]h\[YDoubleDot]\\f\\\\\.8c\
\.8d\.83\[CCedilla]h\[Thorn]\.19\[CapitalIDoubleDot]\[CapitalATilde]\
\[CapitalARing]\[OGrave];&\[CapitalATilde]\[CapitalOSlash]\[AAcute]\.0eJ\.1a\
rNqr\\r\[CapitalARing]\\f\\\\\[CapitalUHat]\\\"99h:\.87\[Yen]\.88\.9c\.1cF\
\[IDoubleDot]\[Cent]\[CapitalNTilde]sN\[CapitalIHat]W\[Micro]\.99\.93\.18='R\
\[CenterDot]\[UDoubleDot]-ML\.10\.a6:\[NTilde]w\.19\\\"i\[CapitalOGrave]s\.87\
\.bc\\f\\\\NO\.89\.baW\.ba\[Yen]\[Section]\[UHat]D]G\.17#\[CapitalOHat]\.9e]I\
\.87\.99\[EDoubleDot]\[CCedilla]\[LeftGuillemet]\.00\[Section]\.bc\.07^\\tu#x\
\[EGrave]I\.9cZV6\.a8B\[Copyright]jr)U\.a6\[UAcute]\.bc\.b3\[CapitalThorn]A\
\.94t\[CapitalUHat])M\[Degree]\[CapitalEHat]\.0e^0*\.81p\.9d\[CapitalUAcute]\
\.17\[CapitalYAcute]\[Cent]Wq\[CapitalUAcute]\[Micro]\.81\[Sterling]\
\[Sterling]+M\[ADoubleDot]\.9a\.17\.1c\[UAcute]\[AHat]\[DiscretionaryHyphen]h-\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01[\
\[DownQuestion]\\\":BFv|\.a8\[UGrave]\[CapitalEHat]G\.07y\[CapitalUGrave]\.0f\
lV)G-dg+[$\[DiscretionaryHyphen]\.88\[ODoubleDot]\.b26]\.8aX9\[CapitalUHat]\
\[CapitalUGrave]\.a8\.05g)[\[CapitalOTilde]]kE\[NonBreakingSpace]Vg\
\[CapitalADoubleDot]t`\.0bm\\\\hiB\[CapitalNTilde]3\.04\.96T\.9f\
\[CapitalYAcute]H\.94\.be4\[CapitalUHat]\.12\[CapitalIGrave]\.14%\.93\\rJqK\
\[Degree]\[CapitalUHat]\.8d\[Not]V\[Paragraph]\[CapitalEDoubleDot]\[OTilde]\
\[Not]\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.98\
DV\[AHat]Fw\.04\[YDoubleDot]\[CapitalCCedilla]\.85\.08i\[DiscretionaryHyphen]{\
\[CapitalYAcute]\.0f\.a8h ]\[Yen]UwG`\.1f|\[CapitalADoubleDot]\[IAcute]X\
\[ATilde]\.15AaI\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01T\[OHat]\.a6\.97\.93L\[CapitalYAcute]\.86U\[Copyright]\[OSlash]\
\[CapitalUHat]\\\\}w\[RawEscape]\[CapitalIHat]TC}\.8dU^\[ODoubleDot]TWW\
\[IDoubleDot]%\[CapitalAAcute]z\[ARing]\[CapitalAGrave]\[Times]O\.06\.b8\.04\
\[Micro]ECr\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01|\[AGrave]92\[Section]\.19\[AAcute]\.95\[CapitalATilde]~\
\[DiscretionaryHyphen]\.85\.1c]\[OHat]W\[CapitalAHat]\\r.\.81zp\
\[CapitalNTilde]\[CapitalUDoubleDot]\.94d\.b8\.04)}\.04\.9f\.121aq%\.18\.0b\
\[CenterDot]\[CapitalOTilde]\[IDoubleDot]\.87M\[CapitalEth]^DD\.18\.11xM\
\[IDoubleDot]}\[ARing] \
\.9b\.8arw\[CapitalARing]\\\"\[EGrave]@\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\[Cent]\\t\.87\\f\\\\\.1c \
Q\.18\[CapitalAE]q\\t.\.9c\.86\\n\.9b\[Cent]\[CapitalADoubleDot]\[ODoubleDot]\
\[OGrave]1\.90\[CenterDot]\[Degree]\.81\.96HD\[CapitalEGrave]'P\.b2\.1a\.9a\
\[CapitalIGrave]cR \
\.99_R>CE\.8cyd(\[IDoubleDot]\[CapitalAAcute]\.00Kv\.02\.07\.0e\
\[CapitalAGrave]\[ARing].{9\[CapitalEHat];\[IHat]\.02L\[CapitalEHat]l\[AE]3\
\.9b`\[CapitalIAcute][\.a8P\.95qqe\.88\.8dy\[Degree]P`I\[Micro]\[Not]\.9c\
\[CapitalUHat]\.0fw \.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01m{\[CapitalAHat]\.03\.10\.10\[AE]G\[CapitalOHat]\.b9c\.0eP\.80\.8d\
y\[CapitalEth]\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.04\.98\[Paragraph] nf\.b9\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.05\[Thorn][\.04\\f\\\\\.14`B\.90\.8e\[OHat]\\nD\.14\
h\\\"@\[CapitalAGrave]\.00sv\[CapitalAE]\[DownExclamation]S\[AE]\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.07d6\.08\.15\.b2\.8b\
\.8d4\.1d\.8b\.02\.88\[ATilde]\.07\.1dp@\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.86\[Micro]jV\[RightGuillemet]@\.1a\
\[CapitalEHat] \[CapitalCCedilla]5:\[CapitalIAcute]g1A\[CapitalODoubleDot]\
\[CapitalODoubleDot].\.08\[CapitalAE]\.00\.1c\[Degree]g\.16l\[CapitalAGrave]\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\[CapitalEAcute](t\.90\[Times]\.07V`\[LeftGuillemet]\[NonBreakingSpace]\.03\
\.10\.10\.80\.02\[Eth]\[UDoubleDot]\.02\\n$`\.00\.10P\[ODoubleDot]\.aa\.00\
\[CapitalOTilde]lg\.af\[CapitalAGrave]\[CapitalUAcute]\.00@\.80!Vp\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.08$ \.00\
\[CapitalOAcute]\[CapitalIHat]4\.b3\.1d\.17co\.97\[CapitalAGrave]\.02\.9f\.18\
\.00!\.1e\[NonBreakingSpace]\.80?\.08\.80\.12\.0e\.a8\.80\[Paragraph]\
\[EDoubleDot]D\.18T8\[CapitalEth]\[CapitalYAcute]\\n\[ATilde]\
\[CapitalADoubleDot]\.04\.1e@\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\.01\
\.01\.01\.01\.01\.01N\.14\.9b\.19\[Thorn]\.96 \
\[CapitalAGrave]\[CapitalAAcute]\.93\.87\.1cBp\[AAcute]\[CapitalIHat]\.195\
\[CapitalADoubleDot]'N\[NTilde]\.8ao#\.04\.00;\"\>"], "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
 CellLabel->"Out[3]=",
 CellID->29855]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 " is used to create a list of bytes that represent the image. This list will \
also be wrapped in ",
 Cell[BoxData[
  ButtonBox["SQLBinary",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.1.1",
 CellID->12053],

Cell[BoxData[
 RowBox[{
  RowBox[{"byteData", " ", "=", " ", 
   RowBox[{"SQLBinary", "[", 
    RowBox[{"ToCharacterCode", "[", "gif", "]"}], "]"}]}], ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,199"},
 CellLabel->"In[4]:=",
 CellID->16962],

Cell["This creates a table for demonstration purposes.", "Text",
 CellTags->"b:6.1.1",
 CellID->3584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{"\"\<BINCOL\>\"", ",", " ", 
      RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<BINARY\>\""}]}], "]"}], 
    "}"}]}], "]"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
 CellLabel->"In[5]:=",
 CellID->29734],

Cell[BoxData["0"], "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
 CellLabel->"Out[5]=",
 CellID->6654]
}, Open  ]],

Cell["This inserts the data into the table.", "Text",
 CellTags->"b:6.1.1",
 CellID->16972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\"", ",", " ", 
   RowBox[{"{", "\"\<BINCOL\>\"", "}"}], ",", " ", 
   RowBox[{"{", "byteData", "}"}]}], "]"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
 CellLabel->"In[6]:=",
 CellID->21457],

Cell[BoxData["1"], "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
 CellLabel->"Out[6]=",
 CellID->14369]
}, Open  ]],

Cell[TextData[{
 "The data is now retrieved using ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 ". Since it is binary data, it is returned as an ",
 Cell[BoxData[
  ButtonBox["SQLBinary",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFormula"],
 " expression."
}], "Text",
 CellTags->"b:6.1.1",
 CellID->22532],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", " ", 
   RowBox[{"SQLSelect", "[", 
    RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\""}], "]"}]}], ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,202"},
 CellLabel->"In[7]:=",
 CellID->2963],

Cell[TextData[{
 "Then, the data is converted back into a string using ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 ".",
 " "
}], "Text",
 CellTags->"b:6.1.1",
 CellID->2607],

Cell[BoxData[
 RowBox[{
  RowBox[{"gifData", " ", "=", 
   RowBox[{"FromCharacterCode", "[", " ", 
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1", ",", "1"}], "]"}], "]"}], " ", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,203"},
 CellLabel->"In[8]:=",
 CellID->2483],

Cell["Finally, you can import the data and display it.", "Text",
 CellTags->"b:6.1.1",
 CellID->911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"ImportString", "[", 
   RowBox[{"gifData", ",", "\"\<GIF\>\""}], "]"}], "]"}]], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
 CellLabel->"In[9]:=",
 CellID->11635],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndl22zgMhsPUC+243mo3smPLmleaR+jV3M3LzgNNvMuyFhAESRD0d06b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   "], {{0, 0}, {360, 212}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJyFjzkKAkEQRQfxACIiIiJ6Eu/gEQRjr2ZoaGBgYCAiIiLu+4bbbI7jUgU/
aH4wD5oXPLq7qliplasxy7IK/xO3oriWEkqdjJ5RGmTzfpOMnlJaZPP9Nhk9
p3TI5v9dMnpS6ZHN+fpk9LQyIJvzD8noWWVENvcbk9HzyoSMPpsqZPTbVZiR
0e83YU5Gf9yFBRn9+RCWZHT7KazI6I4trMnoriNsyOieK2zJ6L4n7MjoL1/Y
k9GDl3Ago78D4UhGD9/CiYz+CYUzGf37ES5k9Cj/ACD/uKI=
      "], #]]& ),
   ColorFunctionScaling->False],
  ImageSize->{361, 213},
  PlotRange->{{0, 360}, {0, 212}}]], "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
 CellLabel->"Out[9]=",
 CellID->10067]
}, Open  ]],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:6.1.1",
 CellID->22848],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<BINTABLE\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}]}], "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,205"},
 CellLabel->"In[10]:=",
 CellID->4675]
}, Open  ]],

Cell[CellGroupData[{

Cell["SQLDateTime", "Section",
 CellTags->{"xref:74", "c:70", "b:6.1.2"},
 CellID->12938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDateTime",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"]], "InlineFormula"],
 " allows you to store and retrieve date and time information. It also allows \
you to execute queries that depend on specific dates or times."
}], "Text",
 CellTags->"b:6.1.2",
 CellID->2223],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->22142],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:6.1.2",
 CellID->23754],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,206"},
 CellLabel->"In[12]:=",
 CellID->6511],

Cell[TextData[{
 "You can create a table for demonstration purposes. This table contains ",
 StyleBox["DATE",
  FontSlant->"Italic"],
 ", ",
 StyleBox["TIME",
  FontSlant->"Italic"],
 ", ",
 StyleBox["DATETIME",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["TIMESTAMP",
  FontSlant->"Italic"],
 " columns."
}], "Text",
 CellTags->"b:6.1.2",
 CellID->22741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DATECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<DATE\>\""}]}], "]"}], 
     ",", " ", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<TIME\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<DATETIMECOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<DATETIME\>\""}]}], 
      "]"}], ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<TIMESTAMPCOL\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", " ", "\"\<TIMESTAMP\>\""}]}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
 CellLabel->"In[3]:=",
 CellID->20175],

Cell[BoxData["0"], "Output",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
 CellLabel->"Out[3]=",
 CellID->21459]
}, Open  ]],

Cell[TextData[{
 "Now, you can insert data into the table. You can use the output of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", "]"}]], "InlineFormula"],
 " function for all data types except for the data type TIME; for this you \
must specify a list of three integers that specify hours, minutes and \
seconds. Note that DATE will only use the date information from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", "]"}]], "InlineFormula"],
 " and not the time information. DATETIME and TIMESTAMP will use both and \
also nanoseconds."
}], "Text",
 CellTags->"b:6.1.2",
 CellID->17825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<DATECOL\>\"", ",", " ", "\"\<TIMECOL\>\"", ",", " ", 
     "\"\<DATETIMECOL\>\"", ",", " ", "\"\<TIMESTAMPCOL\>\""}], "}"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLDateTime", "[", 
      RowBox[{"DateList", "[", "]"}], "]"}], ",", " ", 
     RowBox[{"SQLDateTime", "[", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], ",", " ", 
     RowBox[{"SQLDateTime", "[", 
      RowBox[{"DateList", "[", "]"}], "]"}], ",", " ", 
     RowBox[{"SQLDateTime", "[", 
      RowBox[{"DateList", "[", "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
 CellLabel->"In[4]:=",
 CellID->3221],

Cell[BoxData["1"], "Output",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
 CellLabel->"Out[4]=",
 CellID->17870]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " can be used to retrieve the data from the database. The data will be \
returned as ",
 Cell[BoxData[
  ButtonBox["SQLDateTime",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"]], "InlineFormula"],
 " expressions.",
 " "
}], "Text",
 CellTags->"b:6.1.2",
 CellID->1626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\""}], "]"}]], "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
 CellLabel->"In[5]:=",
 CellID->31934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{"2006", ",", "2", ",", "7"}], "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{
      "2006", ",", "2", ",", "7", ",", "14", ",", "34", ",", 
       "58.385512699`"}], "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{"{", 
      RowBox[{
      "2006", ",", "2", ",", "7", ",", "14", ",", "34", ",", 
       "58.385512699`"}], "}"}], "]"}]}], "}"}], "}"}]], "Output",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
 CellLabel->"Out[5]=",
 CellID->15205]
}, Open  ]],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:6.1.2",
 CellID->31783],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<DATETIMETABLE\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}]}], "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,210"},
 CellLabel->"In[6]:=",
 CellID->23850]
}, Open  ]],

Cell[CellGroupData[{

Cell["SQLExpr", "Section",
 CellTags->{"xref:75", "c:71", "b:6.1.3"},
 CellID->17398],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExpr"]], "InlineFormula"],
 " can be used to store ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in a database. When they are retrieved, they are converted \
back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Text",
 CellTags->"b:6.1.3",
 CellID->22279],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellTags->"b:6.1.3",
 CellID->22701],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:6.1.3",
 CellID->12193],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,211"},
 CellLabel->"In[8]:=",
 CellID->12734],

Cell[TextData[{
 "In order to store a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, you need to create a column that can be used to store a string \
such as ",
 "VARCHAR",
 "."
}], "Text",
 CellTags->"b:6.1.3",
 CellID->1637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCreateTable", "[", 
  RowBox[{"conn", ",", " ", "\"\<EXPRTABLE\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"SQLColumn", "[", 
     RowBox[{"\"\<EXPRCOL\>\"", ",", " ", 
      RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<VARCHAR\>\""}]}], "]"}], 
    "}"}]}], "]"}]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
 CellLabel->"In[3]:=",
 CellID->26534],

Cell[BoxData["0"], "Output",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
 CellLabel->"Out[3]=",
 CellID->5556]
}, Open  ]],

Cell[TextData[{
 "This inserts a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression into the database."
}], "Text",
 CellTags->"b:6.1.3",
 CellID->1993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLInsert", "[", 
  RowBox[{"conn", ",", "\"\<EXPRTABLE\>\"", ",", " ", 
   RowBox[{"{", "\"\<EXPRCOL\>\"", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"SQLExpr", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], "]"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
 CellLabel->"In[4]:=",
 CellID->10176],

Cell[BoxData["1"], "Output",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
 CellLabel->"Out[4]=",
 CellID->25705]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " retrieves the data from the database. The data is returned as an ",
 Cell[BoxData[
  ButtonBox["SQLExpr",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExpr"]], "InlineFormula"],
 " expression."
}], "Text",
 CellTags->"b:6.1.3",
 CellID->6962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", " ", "=", " ", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<EXPRTABLE\>\""}], "]"}]}]], "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
 CellLabel->"In[5]:=",
 CellID->10548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"SQLExpr", "[", 
    RowBox[{"Sin", "[", 
     SuperscriptBox["x", "2"], "]"}], "]"}], "}"}], "}"}]], "Output",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
 CellLabel->"Out[5]=",
 CellID->15881]
}, Open  ]],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:6.1.3",
 CellID->300],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<EXPRTABLE\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}]}], "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,215"},
 CellLabel->"In[6]:=",
 CellID->14413]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Data Type Mapping - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 37.1090737}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "One of the most important issues for using a database is the conversion \
of data as it is stored and retrieved from a database. This tutorial will \
discuss how Mathematica expressions interact with data stored in a database. \
The following table shows the mappings between data types and Mathematica \
expressions. For example, a Mathematica Integer expression can be stored in \
SQL integral types such as INTEGER and TINYINT. In addition, if data from a \
column that is of type VARCHAR is selected, this will result in a Mathematica \
String expression. The mapping between Mathematica expressions and data types \
stored in a database.", "synonyms" -> {}, "title" -> "Data Type Mapping", 
    "type" -> "Tutorial", "uri" -> "DatabaseLink/tutorial/DataTypeMapping"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:67"->{
  Cell[1972, 53, 83, 2, 70, "Title",
   CellTags->{"c:67", "xref:149"},
   CellID->12896]},
 "xref:149"->{
  Cell[1972, 53, 83, 2, 70, "Title",
   CellTags->{"c:67", "xref:149"},
   CellID->12896]},
 "b:6.1.0"->{
  Cell[2058, 57, 346, 10, 70, "Text",
   CellTags->"b:6.1.0",
   CellID->29617],
  Cell[2407, 69, 753, 25, 70, "Text",
   CellTags->"b:6.1.0",
   CellID->10112],
  Cell[5214, 161, 195, 7, 70, "Caption",
   CellTags->"b:6.1.0",
   CellID->18696],
  Cell[5412, 170, 1816, 59, 70, "Text",
   CellTags->"b:6.1.0",
   CellID->11585],
  Cell[7231, 231, 554, 18, 70, "Text",
   CellTags->"b:6.1.0",
   CellID->24041]},
 "xref:73"->{
  Cell[7810, 253, 87, 2, 70, "Section",
   CellTags->{"xref:73", "c:69", "b:6.1.1"},
   CellID->24423]},
 "c:69"->{
  Cell[7810, 253, 87, 2, 70, "Section",
   CellTags->{"xref:73", "c:69", "b:6.1.1"},
   CellID->24423]},
 "b:6.1.1"->{
  Cell[7810, 253, 87, 2, 70, "Section",
   CellTags->{"xref:73", "c:69", "b:6.1.1"},
   CellID->24423],
  Cell[7900, 257, 320, 9, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->24129],
  Cell[8668, 281, 212, 10, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->4565],
  Cell[8883, 293, 320, 9, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,197"},
   CellID->6559],
  Cell[9206, 304, 103, 2, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->8932],
  Cell[9334, 310, 421, 13, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
   CellID->22296],
  Cell[9758, 325, 110117, 1422, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
   CellID->29855],
  Cell[119890, 1750, 439, 14, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->12053],
  Cell[120332, 1766, 262, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,199"},
   CellID->16962],
  Cell[120597, 1775, 101, 2, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->3584],
  Cell[120723, 1781, 394, 10, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
   CellID->29734],
  Cell[121120, 1793, 122, 3, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
   CellID->6654],
  Cell[121257, 1799, 91, 2, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->16972],
  Cell[121373, 1805, 301, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
   CellID->21457],
  Cell[121677, 1814, 123, 3, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
   CellID->14369],
  Cell[121815, 1820, 439, 14, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->22532],
  Cell[122257, 1836, 254, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,202"},
   CellID->2963],
  Cell[122514, 1845, 270, 10, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->2607],
  Cell[122787, 1857, 326, 10, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,203"},
   CellID->2483],
  Cell[123116, 1869, 100, 2, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->911],
  Cell[123241, 1875, 231, 6, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
   CellID->11635],
  Cell[123475, 1883, 3963, 71, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
   CellID->10067],
  Cell[127453, 1957, 101, 2, 70, "Text",
   CellTags->"b:6.1.1",
   CellID->22848],
  Cell[127557, 1961, 303, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,205"},
   CellID->4675]},
 "Ex--21943492438155078303,197"->{
  Cell[8883, 293, 320, 9, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,197"},
   CellID->6559]},
 "Ex--21943492438155078303,198"->{
  Cell[9334, 310, 421, 13, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
   CellID->22296],
  Cell[9758, 325, 110117, 1422, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
   CellID->29855]},
 "Ex--21943492438155078303,199"->{
  Cell[120332, 1766, 262, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,199"},
   CellID->16962]},
 "Ex--21943492438155078303,200"->{
  Cell[120723, 1781, 394, 10, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
   CellID->29734],
  Cell[121120, 1793, 122, 3, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
   CellID->6654]},
 "Ex--21943492438155078303,201"->{
  Cell[121373, 1805, 301, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
   CellID->21457],
  Cell[121677, 1814, 123, 3, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
   CellID->14369]},
 "Ex--21943492438155078303,202"->{
  Cell[122257, 1836, 254, 7, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,202"},
   CellID->2963]},
 "Ex--21943492438155078303,203"->{
  Cell[122787, 1857, 326, 10, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,203"},
   CellID->2483]},
 "Ex--21943492438155078303,204"->{
  Cell[123241, 1875, 231, 6, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
   CellID->11635],
  Cell[123475, 1883, 3963, 71, 70, "Output",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
   CellID->10067]},
 "Ex--21943492438155078303,205"->{
  Cell[127557, 1961, 303, 8, 70, "Input",
   CellTags->{"b:6.1.1", "Ex--21943492438155078303,205"},
   CellID->4675]},
 "xref:74"->{
  Cell[127897, 1974, 89, 2, 70, "Section",
   CellTags->{"xref:74", "c:70", "b:6.1.2"},
   CellID->12938]},
 "c:70"->{
  Cell[127897, 1974, 89, 2, 70, "Section",
   CellTags->{"xref:74", "c:70", "b:6.1.2"},
   CellID->12938]},
 "b:6.1.2"->{
  Cell[127897, 1974, 89, 2, 70, "Section",
   CellTags->{"xref:74", "c:70", "b:6.1.2"},
   CellID->12938],
  Cell[127989, 1978, 346, 9, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->2223],
  Cell[128783, 2002, 231, 10, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->23754],
  Cell[129017, 2014, 321, 9, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,206"},
   CellID->6511],
  Cell[129341, 2025, 356, 16, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->22741],
  Cell[129722, 2045, 942, 23, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
   CellID->20175],
  Cell[130667, 2070, 123, 3, 70, "Output",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
   CellID->21459],
  Cell[130805, 2076, 797, 22, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->17825],
  Cell[131627, 2102, 816, 21, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
   CellID->3221],
  Cell[132446, 2125, 123, 3, 70, "Output",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
   CellID->17870],
  Cell[132584, 2131, 448, 15, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->1626],
  Cell[133057, 2150, 208, 5, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
   CellID->31934],
  Cell[133268, 2157, 751, 22, 70, "Output",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
   CellID->15205],
  Cell[134034, 2182, 101, 2, 70, "Text",
   CellTags->"b:6.1.2",
   CellID->31783],
  Cell[134138, 2186, 308, 8, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,210"},
   CellID->23850]},
 "Ex--21943492438155078303,206"->{
  Cell[129017, 2014, 321, 9, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,206"},
   CellID->6511]},
 "Ex--21943492438155078303,207"->{
  Cell[129722, 2045, 942, 23, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
   CellID->20175],
  Cell[130667, 2070, 123, 3, 70, "Output",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
   CellID->21459]},
 "Ex--21943492438155078303,208"->{
  Cell[131627, 2102, 816, 21, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
   CellID->3221],
  Cell[132446, 2125, 123, 3, 70, "Output",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
   CellID->17870]},
 "Ex--21943492438155078303,209"->{
  Cell[133057, 2150, 208, 5, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
   CellID->31934],
  Cell[133268, 2157, 751, 22, 70, "Output",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
   CellID->15205]},
 "Ex--21943492438155078303,210"->{
  Cell[134138, 2186, 308, 8, 70, "Input",
   CellTags->{"b:6.1.2", "Ex--21943492438155078303,210"},
   CellID->23850]},
 "xref:75"->{
  Cell[134483, 2199, 85, 2, 70, "Section",
   CellTags->{"xref:75", "c:71", "b:6.1.3"},
   CellID->17398]},
 "c:71"->{
  Cell[134483, 2199, 85, 2, 70, "Section",
   CellTags->{"xref:75", "c:71", "b:6.1.3"},
   CellID->17398]},
 "b:6.1.3"->{
  Cell[134483, 2199, 85, 2, 70, "Section",
   CellTags->{"xref:75", "c:71", "b:6.1.3"},
   CellID->17398],
  Cell[134571, 2203, 427, 15, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->22279],
  Cell[135001, 2220, 448, 12, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->22701],
  Cell[135452, 2234, 213, 10, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->12193],
  Cell[135668, 2246, 321, 9, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,211"},
   CellID->12734],
  Cell[135992, 2257, 246, 10, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->1637],
  Cell[136263, 2271, 397, 10, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
   CellID->26534],
  Cell[136663, 2283, 122, 3, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
   CellID->5556],
  Cell[136800, 2289, 167, 7, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->1993],
  Cell[136992, 2300, 382, 10, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
   CellID->10176],
  Cell[137377, 2312, 123, 3, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
   CellID->25705],
  Cell[137515, 2318, 415, 13, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->6962],
  Cell[137955, 2335, 241, 6, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
   CellID->10548],
  Cell[138199, 2343, 262, 8, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
   CellID->15881],
  Cell[138476, 2354, 99, 2, 70, "Text",
   CellTags->"b:6.1.3",
   CellID->300],
  Cell[138578, 2358, 304, 8, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,215"},
   CellID->14413]},
 "Ex--21943492438155078303,211"->{
  Cell[135668, 2246, 321, 9, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,211"},
   CellID->12734]},
 "Ex--21943492438155078303,212"->{
  Cell[136263, 2271, 397, 10, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
   CellID->26534],
  Cell[136663, 2283, 122, 3, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
   CellID->5556]},
 "Ex--21943492438155078303,213"->{
  Cell[136992, 2300, 382, 10, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
   CellID->10176],
  Cell[137377, 2312, 123, 3, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
   CellID->25705]},
 "Ex--21943492438155078303,214"->{
  Cell[137955, 2335, 241, 6, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
   CellID->10548],
  Cell[138199, 2343, 262, 8, 70, "Output",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
   CellID->15881]},
 "Ex--21943492438155078303,215"->{
  Cell[138578, 2358, 304, 8, 70, "Input",
   CellTags->{"b:6.1.3", "Ex--21943492438155078303,215"},
   CellID->14413]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:67", 140820, 2412},
 {"xref:149", 140927, 2416},
 {"b:6.1.0", 141033, 2420},
 {"xref:73", 141459, 2436},
 {"c:69", 141575, 2440},
 {"b:6.1.1", 141694, 2444},
 {"Ex--21943492438155078303,197", 144210, 2517},
 {"Ex--21943492438155078303,198", 144361, 2521},
 {"Ex--21943492438155078303,199", 144637, 2528},
 {"Ex--21943492438155078303,200", 144792, 2532},
 {"Ex--21943492438155078303,201", 145067, 2539},
 {"Ex--21943492438155078303,202", 145342, 2546},
 {"Ex--21943492438155078303,203", 145496, 2550},
 {"Ex--21943492438155078303,204", 145651, 2554},
 {"Ex--21943492438155078303,205", 145928, 2561},
 {"xref:74", 146061, 2565},
 {"c:70", 146180, 2569},
 {"b:6.1.2", 146302, 2573},
 {"Ex--21943492438155078303,206", 147907, 2619},
 {"Ex--21943492438155078303,207", 148061, 2623},
 {"Ex--21943492438155078303,208", 148337, 2630},
 {"Ex--21943492438155078303,209", 148612, 2637},
 {"Ex--21943492438155078303,210", 148888, 2644},
 {"xref:75", 149022, 2648},
 {"c:71", 149141, 2652},
 {"b:6.1.3", 149263, 2656},
 {"Ex--21943492438155078303,211", 150949, 2705},
 {"Ex--21943492438155078303,212", 151104, 2709},
 {"Ex--21943492438155078303,213", 151379, 2716},
 {"Ex--21943492438155078303,214", 151655, 2723},
 {"Ex--21943492438155078303,215", 151930, 2730}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1347, 26, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1972, 53, 83, 2, 70, "Title",
 CellTags->{"c:67", "xref:149"},
 CellID->12896],
Cell[2058, 57, 346, 10, 70, "Text",
 CellTags->"b:6.1.0",
 CellID->29617],
Cell[2407, 69, 753, 25, 70, "Text",
 CellTags->"b:6.1.0",
 CellID->10112],
Cell[3163, 96, 2048, 63, 70, "DefinitionBox",
 CellID->12717],
Cell[5214, 161, 195, 7, 70, "Caption",
 CellTags->"b:6.1.0",
 CellID->18696],
Cell[5412, 170, 1816, 59, 70, "Text",
 CellTags->"b:6.1.0",
 CellID->11585],
Cell[7231, 231, 554, 18, 70, "Text",
 CellTags->"b:6.1.0",
 CellID->24041],
Cell[CellGroupData[{
Cell[7810, 253, 87, 2, 70, "Section",
 CellTags->{"xref:73", "c:69", "b:6.1.1"},
 CellID->24423],
Cell[7900, 257, 320, 9, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->24129],
Cell[8223, 268, 442, 11, 70, "Text",
 CellID->24229],
Cell[8668, 281, 212, 10, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->4565],
Cell[8883, 293, 320, 9, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,197"},
 CellID->6559],
Cell[9206, 304, 103, 2, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->8932],
Cell[CellGroupData[{
Cell[9334, 310, 421, 13, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
 CellID->22296],
Cell[9758, 325, 110117, 1422, 70, "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,198"},
 CellID->29855]
}, Open  ]],
Cell[119890, 1750, 439, 14, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->12053],
Cell[120332, 1766, 262, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,199"},
 CellID->16962],
Cell[120597, 1775, 101, 2, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->3584],
Cell[CellGroupData[{
Cell[120723, 1781, 394, 10, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
 CellID->29734],
Cell[121120, 1793, 122, 3, 70, "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,200"},
 CellID->6654]
}, Open  ]],
Cell[121257, 1799, 91, 2, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->16972],
Cell[CellGroupData[{
Cell[121373, 1805, 301, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
 CellID->21457],
Cell[121677, 1814, 123, 3, 70, "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,201"},
 CellID->14369]
}, Open  ]],
Cell[121815, 1820, 439, 14, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->22532],
Cell[122257, 1836, 254, 7, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,202"},
 CellID->2963],
Cell[122514, 1845, 270, 10, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->2607],
Cell[122787, 1857, 326, 10, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,203"},
 CellID->2483],
Cell[123116, 1869, 100, 2, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->911],
Cell[CellGroupData[{
Cell[123241, 1875, 231, 6, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
 CellID->11635],
Cell[123475, 1883, 3963, 71, 70, "Output",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,204"},
 CellID->10067]
}, Open  ]],
Cell[127453, 1957, 101, 2, 70, "Text",
 CellTags->"b:6.1.1",
 CellID->22848],
Cell[127557, 1961, 303, 8, 70, "Input",
 CellTags->{"b:6.1.1", "Ex--21943492438155078303,205"},
 CellID->4675]
}, Open  ]],
Cell[CellGroupData[{
Cell[127897, 1974, 89, 2, 70, "Section",
 CellTags->{"xref:74", "c:70", "b:6.1.2"},
 CellID->12938],
Cell[127989, 1978, 346, 9, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->2223],
Cell[128338, 1989, 442, 11, 70, "Text",
 CellID->22142],
Cell[128783, 2002, 231, 10, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->23754],
Cell[129017, 2014, 321, 9, 70, "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,206"},
 CellID->6511],
Cell[129341, 2025, 356, 16, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->22741],
Cell[CellGroupData[{
Cell[129722, 2045, 942, 23, 70, "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
 CellID->20175],
Cell[130667, 2070, 123, 3, 70, "Output",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,207"},
 CellID->21459]
}, Open  ]],
Cell[130805, 2076, 797, 22, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->17825],
Cell[CellGroupData[{
Cell[131627, 2102, 816, 21, 70, "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
 CellID->3221],
Cell[132446, 2125, 123, 3, 70, "Output",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,208"},
 CellID->17870]
}, Open  ]],
Cell[132584, 2131, 448, 15, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->1626],
Cell[CellGroupData[{
Cell[133057, 2150, 208, 5, 70, "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
 CellID->31934],
Cell[133268, 2157, 751, 22, 70, "Output",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,209"},
 CellID->15205]
}, Open  ]],
Cell[134034, 2182, 101, 2, 70, "Text",
 CellTags->"b:6.1.2",
 CellID->31783],
Cell[134138, 2186, 308, 8, 70, "Input",
 CellTags->{"b:6.1.2", "Ex--21943492438155078303,210"},
 CellID->23850]
}, Open  ]],
Cell[CellGroupData[{
Cell[134483, 2199, 85, 2, 70, "Section",
 CellTags->{"xref:75", "c:71", "b:6.1.3"},
 CellID->17398],
Cell[134571, 2203, 427, 15, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->22279],
Cell[135001, 2220, 448, 12, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->22701],
Cell[135452, 2234, 213, 10, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->12193],
Cell[135668, 2246, 321, 9, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,211"},
 CellID->12734],
Cell[135992, 2257, 246, 10, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->1637],
Cell[CellGroupData[{
Cell[136263, 2271, 397, 10, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
 CellID->26534],
Cell[136663, 2283, 122, 3, 70, "Output",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,212"},
 CellID->5556]
}, Open  ]],
Cell[136800, 2289, 167, 7, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->1993],
Cell[CellGroupData[{
Cell[136992, 2300, 382, 10, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
 CellID->10176],
Cell[137377, 2312, 123, 3, 70, "Output",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,213"},
 CellID->25705]
}, Open  ]],
Cell[137515, 2318, 415, 13, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->6962],
Cell[CellGroupData[{
Cell[137955, 2335, 241, 6, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
 CellID->10548],
Cell[138199, 2343, 262, 8, 70, "Output",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,214"},
 CellID->15881]
}, Open  ]],
Cell[138476, 2354, 99, 2, 70, "Text",
 CellTags->"b:6.1.3",
 CellID->300],
Cell[138578, 2358, 304, 8, 70, "Input",
 CellTags->{"b:6.1.3", "Ex--21943492438155078303,215"},
 CellID->14413]
}, Open  ]]
}, Open  ]],
Cell[138909, 2370, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

