(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17049,        633]
NotebookOptionsPosition[     10291,        393]
NotebookOutlinePosition[     14467,        527]
CellTagsIndexPosition[     14373,        521]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLDelete" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLDelete"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"SQLDelete\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Deleting Data", "Title",
 CellID->14606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 " deletes data from a database. An alternative, using raw SQL, is described \
in ",
 ButtonBox["Deleting Data with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLDeletingData"],
 ". "
}], "Text",
 CellTags->"b:4.1.5",
 CellID->24429],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->32404],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query. Thus, \
if three rows are removed, the result is three, and if no rows are removed, \
the result is zero."
}], "Text",
 CellTags->"b:4.1.5",
 CellID->6705],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLDelete",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLDelete"], "[", 
     StyleBox["table", "TI"], "]"}], Cell[
    "delete data from a database", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLDelete",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLDelete"], "[", 
     StyleBox["table", "TI"], ",", 
     StyleBox["condition", "TI"], "]"}], Cell[
    "delete data from a database using a condition", "TableText"]}
  }]], "DefinitionBox",
 CellID->20626],

Cell["Deleting data from a database.", "Caption",
 CellTags->"b:4.1.5",
 CellID->29812],

Cell[TextData[{
 "Here is an example that deletes data. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:4.1.5",
 CellID->19375],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[1]:=",
 CellID->30093],

Cell[TextData[{
 "A new table, ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 ", is created and data is inserted."
}], "Text",
 CellTags->"b:4.1.5",
 CellID->16565],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{
   "conn", ",", " ", "\"\<TEST\>\"", ",", " ", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", " ", "10.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", " ", "17.5"}], "}"}]}], "}"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]}], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[3]:=",
 CellID->16036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "10.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "17.5`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.5",
 CellLabel->"Out[5]=",
 CellID->14736]
}, Open  ]],

Cell["\<\
The following deletes all the data from the table. Two rows were deleted, and \
the result is two.\
\>", "Text",
 CellTags->"b:4.1.5",
 CellID->29141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDelete", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[6]:=",
 CellID->30814],

Cell[BoxData["2"], "Output",
 CellTags->"b:4.1.5",
 CellLabel->"Out[6]=",
 CellID->5994]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " verifies that all the data has been removed from the table."
}], "Text",
 CellTags->"b:4.1.5",
 CellID->8256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[7]:=",
 CellID->6652],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellTags->"b:4.1.5",
 CellLabel->"Out[7]=",
 CellID->23936]
}, Open  ]],

Cell["This restores the data in the database.", "Text",
 CellTags->"b:4.1.5",
 CellID->30838],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", " ", "10.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", " ", "17.5"}], "}"}]}], "}"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]}], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[8]:=",
 CellID->20482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "10.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "17.5`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.5",
 CellLabel->"Out[9]=",
 CellID->1355]
}, Open  ]],

Cell[TextData[{
 "Here, a condition is used in the ",
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 " command, so that only rows for which the entry in the first column is \
greater than 15 are deleted. This deletes one row, and hence the result is \
one."
}], "Text",
 CellTags->"b:4.1.5",
 CellID->21015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmt", " ", "=", " ", 
  RowBox[{"SQLDelete", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<COL1\>\"", "]"}], " ", ">", " ", "15"}]}],
    "]"}]}]], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[10]:=",
 CellID->1131],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.1.5",
 CellLabel->"Out[10]=",
 CellID->18230]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " verifies that one row was removed from the table."
}], "Text",
 CellTags->"b:4.1.5",
 CellID->17841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[11]:=",
 CellID->14625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "10.5`"}], "}"}], "}"}]], "Output",
 CellTags->"b:4.1.5",
 CellLabel->"Out[11]=",
 CellID->2011]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 " accepts one option."
}], "Text",
 CellTags->"b:4.3",
 CellID->32637],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->4186],

Cell[TextData[{
 "Option of ",
 Cell[BoxData[
  ButtonBox["SQLDelete",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDelete"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->19690],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute."
}], "Text",
 CellTags->"b:4.3",
 CellID->1650],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:4.1.5",
 CellID->5662],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.1.5",
 CellLabel->"In[12]:=",
 CellID->21634]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Deleting Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 38.6871886}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLDelete deletes data from a database. An alternative, using raw SQL, \
is described in Deleting Data with Raw SQL. If you find that the examples in \
this tutorial do not work as shown, you may need to install or restore the \
example database with the DatabaseExamples` package, as described in Using \
the Example Databases. The result of SQLDelete is an integer specifying the \
number of rows affected by the query. Thus, if three rows are removed, the \
result is three, and if no rows are removed, the result is zero.", 
    "synonyms" -> {}, "title" -> "Deleting Data", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/DeletingData"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.1.5"->{
  Cell[1252, 45, 415, 13, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->24429],
  Cell[2116, 73, 394, 11, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->6705],
  Cell[3087, 105, 87, 2, 70, "Caption",
   CellTags->"b:4.1.5",
   CellID->29812],
  Cell[3177, 109, 269, 10, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->19375],
  Cell[3449, 121, 287, 9, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->30093],
  Cell[3739, 132, 163, 7, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->16565],
  Cell[3927, 143, 1145, 31, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->16036],
  Cell[5075, 176, 242, 9, 70, "Output",
   CellTags->"b:4.1.5",
   CellID->14736],
  Cell[5332, 188, 160, 5, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->29141],
  Cell[5517, 197, 165, 5, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->30814],
  Cell[5685, 204, 88, 3, 70, "Output",
   CellTags->"b:4.1.5",
   CellID->5994],
  Cell[5788, 210, 262, 8, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->8256],
  Cell[6075, 222, 164, 5, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->6652],
  Cell[6242, 229, 106, 4, 70, "Output",
   CellTags->"b:4.1.5",
   CellID->23936],
  Cell[6363, 236, 93, 2, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->30838],
  Cell[6481, 242, 565, 17, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->20482],
  Cell[7049, 261, 241, 9, 70, "Output",
   CellTags->"b:4.1.5",
   CellID->1355],
  Cell[7305, 273, 395, 11, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->21015],
  Cell[7725, 288, 307, 9, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->1131],
  Cell[8035, 299, 90, 3, 70, "Output",
   CellTags->"b:4.1.5",
   CellID->18230],
  Cell[8140, 305, 253, 8, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->17841],
  Cell[8418, 317, 166, 5, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->14625],
  Cell[8587, 324, 163, 6, 70, "Output",
   CellTags->"b:4.1.5",
   CellID->2011],
  Cell[9898, 377, 100, 2, 70, "Text",
   CellTags->"b:4.1.5",
   CellID->5662],
  Cell[10001, 381, 248, 7, 70, "Input",
   CellTags->"b:4.1.5",
   CellID->21634]},
 "b:4.3"->{
  Cell[8765, 333, 221, 8, 70, "Text",
   CellTags->"b:4.3",
   CellID->32637],
  Cell[9475, 358, 220, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->19690],
  Cell[9698, 369, 197, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->1650]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.1.5", 12055, 432},
 {"b:4.3", 14110, 508}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 578, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1203, 42, 46, 1, 70, "Title",
 CellID->14606],
Cell[1252, 45, 415, 13, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->24429],
Cell[1670, 60, 443, 11, 70, "Text",
 CellID->32404],
Cell[2116, 73, 394, 11, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->6705],
Cell[2513, 86, 571, 17, 70, "DefinitionBox",
 CellID->20626],
Cell[3087, 105, 87, 2, 70, "Caption",
 CellTags->"b:4.1.5",
 CellID->29812],
Cell[3177, 109, 269, 10, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->19375],
Cell[3449, 121, 287, 9, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->30093],
Cell[3739, 132, 163, 7, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->16565],
Cell[CellGroupData[{
Cell[3927, 143, 1145, 31, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->16036],
Cell[5075, 176, 242, 9, 70, "Output",
 CellTags->"b:4.1.5",
 CellID->14736]
}, Open  ]],
Cell[5332, 188, 160, 5, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->29141],
Cell[CellGroupData[{
Cell[5517, 197, 165, 5, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->30814],
Cell[5685, 204, 88, 3, 70, "Output",
 CellTags->"b:4.1.5",
 CellID->5994]
}, Open  ]],
Cell[5788, 210, 262, 8, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->8256],
Cell[CellGroupData[{
Cell[6075, 222, 164, 5, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->6652],
Cell[6242, 229, 106, 4, 70, "Output",
 CellTags->"b:4.1.5",
 CellID->23936]
}, Open  ]],
Cell[6363, 236, 93, 2, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->30838],
Cell[CellGroupData[{
Cell[6481, 242, 565, 17, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->20482],
Cell[7049, 261, 241, 9, 70, "Output",
 CellTags->"b:4.1.5",
 CellID->1355]
}, Open  ]],
Cell[7305, 273, 395, 11, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->21015],
Cell[CellGroupData[{
Cell[7725, 288, 307, 9, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->1131],
Cell[8035, 299, 90, 3, 70, "Output",
 CellTags->"b:4.1.5",
 CellID->18230]
}, Open  ]],
Cell[8140, 305, 253, 8, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->17841],
Cell[CellGroupData[{
Cell[8418, 317, 166, 5, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->14625],
Cell[8587, 324, 163, 6, 70, "Output",
 CellTags->"b:4.1.5",
 CellID->2011]
}, Open  ]],
Cell[8765, 333, 221, 8, 70, "Text",
 CellTags->"b:4.3",
 CellID->32637],
Cell[8989, 343, 483, 13, 70, "DefinitionBox3Col",
 CellID->4186],
Cell[9475, 358, 220, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->19690],
Cell[9698, 369, 197, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->1650],
Cell[9898, 377, 100, 2, 70, "Text",
 CellTags->"b:4.1.5",
 CellID->5662],
Cell[10001, 381, 248, 7, 70, "Input",
 CellTags->"b:4.1.5",
 CellID->21634]
}, Open  ]],
Cell[10264, 391, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

