(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65598,       2562]
NotebookOptionsPosition[     52163,       2063]
NotebookOutlinePosition[     59985,       2331]
CellTagsIndexPosition[     59650,       2316]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Examples", "Title",
 CellID->3788],

Cell[CellGroupData[{

Cell["Command Cache", "Section",
 CellTags->{"xref:53", "c:77", "b:7.1"},
 CellID->18127],

Cell[TextData[{
 "This example shows how to use a private database to store ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands and query the data from Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellTags->"b:7.1",
 CellID->467],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->3728],

Cell[TextData[{
 "The example code is loaded from the ",
 StyleBox["Examples", "MR"],
 " subdirectory of ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellTags->"b:7.1",
 CellID->14893],

Cell[BoxData[
 RowBox[{"<<", "DatabaseLink`Examples`CommandCache`"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[1]:=",
 CellID->24648],

Cell[TextData[{
 "The command cache allows you to store ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions as typeset box expressions data in a database. ",
 StyleBox["StoreCommand", "MR"],
 " is used to store the boxes in the database."
}], "Text",
 CellTags->"b:7.1",
 CellID->22483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StoreCommand", "[", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{"2", "+", "2"}], "]"}], "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[2]:=",
 CellID->17807],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"2\"\>"}], "}"}], 
  "]"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[2]=",
 CellID->2421]
}, Open  ]],

Cell[TextData[{
 "The data can then be retrieved from the database using ",
 StyleBox["CommandCache[].", "MR"]
}], "Text",
 CellTags->"b:7.1",
 CellID->14310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommandCache", "[", "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[3]:=",
 CellID->6617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{"SQLExpr", "[", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"2\"\>"}], "}"}], 
      "]"}], "]"}], ",", "\<\"Plus[2, 2]\"\>", ",", 
    RowBox[{"SQLBinary", "[", 
     RowBox[{"{", 
      RowBox[{
      "71", ",", "73", ",", "70", ",", "56", ",", "57", ",", "97", ",", "31", 
       ",", "0", ",", "17", ",", "0", ",", "240", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "255", ",", "255", ",", "255", ",", "33",
        ",", "249", ",", "4", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "44", ",", "0", ",", "0", ",", "0", ",", "0", ",", "31", ",",
        "0", ",", "17", ",", "0", ",", "0", ",", "2", ",", "46", ",", "140", 
       ",", "143", ",", "169", ",", "203", ",", "237", ",", "15", ",", "163", 
       ",", "156", ",", "180", ",", "42", ",", "128", ",", "41", ",", "6", 
       ",", "140", ",", "27", ",", "15", ",", "129", ",", "96", ",", "103", 
       ",", "141", ",", "215", ",", "98", ",", "38", ",", "41", ",", "178", 
       ",", "6", ",", "173", ",", "235", ",", "172", ",", "91", ",", "166", 
       ",", "198", ",", "71", ",", "42", ",", "223", ",", "232", ",", "124", 
       ",", "94", ",", "188", ",", "5", ",", "12", ",", "10", ",", "135", ",",
        "68", ",", "68", ",", "1", ",", "0", ",", "59"}], "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{
     "2004", ",", "8", ",", "4", ",", "16", ",", "57", ",", "56.7308773`"}], 
     "]"}]}], "}"}], "}"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[3]=",
 CellID->22813]
}, Open  ]],

Cell[TextData[{
 "Several attributes of each command are stored in the database. Each command \
is given an ID, generated when it is stored. The expression is stored as a \
string formatted with ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 "; this allows it to be reused in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In addition, an image of the expression is saved as well as the time at \
which the data was stored. ",
 StyleBox["GetCommandAttributes", "MR"],
 " can be used to get the attribute names. These can be used to filter the \
data returned."
}], "Text",
 CellTags->"b:7.1",
 CellID->9514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GetCommandAttributes", "[", "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[4]:=",
 CellID->14309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ID\"\>", ",", "\<\"EXPR\"\>", ",", "\<\"FULLFORM\"\>", 
   ",", "\<\"IMAGE\"\>", ",", "\<\"USED\"\>", ",", "\<\"*\"\>"}], 
  "}"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[4]=",
 CellID->7616]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CommandCache", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<ID\>\"", ",", "\"\<FULLFORM\>\""}], "}"}], "]"}], 
  " "}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[5]:=",
 CellID->18935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", "\<\"Plus[2, 2]\"\>"}], "}"}], "}"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[5]=",
 CellID->17451]
}, Open  ]],

Cell[TextData[{
 "The following example finds all results that contain ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:7.1",
 CellID->20600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StoreCommand", "[", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{"2", "^", "2"}], "]"}], "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[6]:=",
 CellID->5249],

Cell[BoxData[
 RowBox[{"SuperscriptBox", "[", 
  RowBox[{"\<\"2\"\>", ",", "\<\"2\"\>"}], "]"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[6]=",
 CellID->16519]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CommandCache", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<ID\>\"", ",", "\"\<FULLFORM\>\""}], "}"}], "]"}], 
  " "}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[7]:=",
 CellID->31556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "\<\"Plus[2, 2]\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"Power[2, 2]\"\>"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[7]=",
 CellID->22798]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CommandCache", "[", 
   RowBox[{"\"\<Power\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<ID\>\"", ",", "\"\<FULLFORM\>\""}], "}"}]}], "]"}], 
  " "}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[8]:=",
 CellID->30303],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "\<\"Power[2, 2]\"\>"}], "}"}], "}"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[8]=",
 CellID->6224]
}, Open  ]],

Cell["A command can also be retrieved using its ID.", "Text",
 CellTags->"b:7.1",
 CellID->11008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommandCache", "[", "1", "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[9]:=",
 CellID->5844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"SQLExpr", "[", 
     RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\<\"2\"\>", ",", "\<\"2\"\>"}], "]"}], "]"}], 
    ",", "\<\"Power[2, 2]\"\>", ",", 
    RowBox[{"SQLBinary", "[", 
     RowBox[{"{", 
      RowBox[{
      "71", ",", "73", ",", "70", ",", "56", ",", "57", ",", "97", ",", "17", 
       ",", "0", ",", "17", ",", "0", ",", "240", ",", "0", ",", "0", ",", 
       "0", ",", "0", ",", "0", ",", "255", ",", "255", ",", "255", ",", "33",
        ",", "249", ",", "4", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
       "0", ",", "44", ",", "0", ",", "0", ",", "0", ",", "0", ",", "17", ",",
        "0", ",", "17", ",", "0", ",", "0", ",", "2", ",", "30", ",", "140", 
       ",", "143", ",", "169", ",", "11", ",", "235", ",", "221", ",", "156", 
       ",", "138", ",", "50", ",", "209", ",", "9", ",", "232", ",", "181", 
       ",", "39", ",", "230", ",", "61", ",", "85", ",", "156", ",", "216", 
       ",", "145", ",", "165", ",", "25", ",", "104", ",", "228", ",", "151", 
       ",", "161", ",", "238", ",", "11", ",", "187", ",", "5", ",", "0", ",",
        "59"}], "}"}], "]"}], ",", 
    RowBox[{"SQLDateTime", "[", 
     RowBox[{
     "2004", ",", "8", ",", "4", ",", "16", ",", "58", ",", "8.511976499`"}], 
     "]"}]}], "}"}], "}"}]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[9]=",
 CellID->32609]
}, Open  ]],

Cell["\<\
Another feature of this package is a Java GUI you can use to browse the data. \
It provides functionality for managing the data and pasting the data into a \
notebook.\
\>", "Text",
 CellTags->"b:7.1",
 CellID->14989],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{460, 473},
 ImageMargins->{{1, 0}, {0, 20}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:7.1",
 CellID->32702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommandBrowser", "[", "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[10]:=",
 CellID->3195],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject338831698034689, 
   JLink`Objects`JavaObject28383845023745]]], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[10]=",
 CellID->20485]
}, Open  ]],

Cell["\<\
The GUI is automatically updated when new commands are added to the database.\
\
\>", "Text",
 CellTags->"b:7.1",
 CellID->3093],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"StoreCommand", "[", 
    RowBox[{"ToBoxes", "[", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         FractionBox["\[Beta]", 
          RowBox[{"(", 
           RowBox[{"\[Wolf]", "+", "\[Mu]"}], ")"}]]}], ")"}], "^", "i"}], 
      "]"}], "]"}], "]"}], " ", ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[11]:=",
 CellID->14343],

Cell[TextData[{
 "Likewise, the GUI is automatically updated when commands are removed. ",
 StyleBox["ClearCommandCache", "MR"],
 " can be used to remove all the data in the command cache."
}], "Text",
 CellTags->"b:7.1",
 CellID->30523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearCommandCache", "[", "]"}]], "Input",
 CellTags->"b:7.1",
 CellLabel->"In[12]:=",
 CellID->1587],

Cell[BoxData["0"], "Output",
 CellTags->"b:7.1",
 CellLabel->"Out[12]=",
 CellID->29314]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Database", "Section",
 CellTags->{"xref:80", "c:78"},
 CellID->9503],

Cell[TextData[{
 "This example shows a database that stores material generated by ",
 StyleBox["Mathematica. ",
  FontSlant->"Italic"],
 "Here the material involves graphs and a number of properties of these \
graphs. Even though the number of graphs is not extremely large, generating \
the properties of these graphs can take a significant amount of time. This \
demonstrates the value of a database for persistent storage of the results of \
computations."
}], "Text",
 CellTags->"b:7.2.0",
 CellID->25200],

Cell[CellGroupData[{

Cell["Using the Graph Database", "Subsection",
 CellTags->{"xref:157", "b:7.2.1"},
 CellID->13458],

Cell["To use the graph database you need to load the package. ", "Text",
 CellTags->"b:7.2.1",
 CellID->6618],

Cell[BoxData[
 RowBox[{"<<", "DatabaseLink`Examples`Graphs`"}]], "Input",
 CellTags->"b:7.2.1",
 CellLabel->"In[1]:=",
 CellID->20580],

Cell[TextData[{
 "The first time the package is used you will need to run the ",
 StyleBox["RestoreGraphDatabase", "MR"],
 " command. If you find that the examples in this section do not work as \
shown, you should also run this command. This command can take a long time to \
run, but is only necessary once."
}], "Text",
 CellTags->"b:7.2.1",
 CellID->19796],

Cell[BoxData[
 RowBox[{"RestoreGraphDatabase", "[", "]"}]], "Input",
 CellTags->"b:7.2.1",
 CellID->14798],

Cell[TextData[{
 "The properties of the graphs stored in the database are given by the ",
 StyleBox["GraphProperties", "MR"],
 " function."
}], "Text",
 CellTags->"b:7.2.1",
 CellID->15281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphProperties", "[", "]"}]], "Input",
 CellTags->"b:7.2.1",
 CellLabel->"In[2]:=",
 CellID->19589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"*\"\>", ",", "\<\"GRAPH\"\>", ",", "\<\"ORDER\"\>", 
   ",", "\<\"EDGES\"\>", ",", "\<\"VERTEXCONNECTIVITY\"\>", 
   ",", "\<\"EDGECONNECTIVITY\"\>", ",", "\<\"DIAMETER\"\>", 
   ",", "\<\"GIRTH\"\>", ",", "\<\"NUMBEROFSPANNINGTREES\"\>", 
   ",", "\<\"SPECTRUMLENGTH\"\>", ",", "\<\"SIMPLEQ\"\>", 
   ",", "\<\"CONNECTEDQ\"\>", ",", "\<\"BIPARTITEQ\"\>", 
   ",", "\<\"PLANARQ\"\>", ",", "\<\"REGULARQ\"\>", ",", "\<\"EULERIANQ\"\>", 
   ",", "\<\"HAMILTONIANQ\"\>", ",", "\<\"TREEQ\"\>", 
   ",", "\<\"BICONNECTEDQ\"\>", ",", "\<\"COMPLETEQ\"\>", 
   ",", "\<\"PERFECTQ\"\>", ",", "\<\"SELFCOMPLEMENTARYQ\"\>"}], 
  "}"}]], "Output",
 CellTags->"b:7.2.1",
 CellLabel->"Out[2]=",
 CellID->20798]
}, Open  ]],

Cell[TextData[{
 "Now, you can make a query from the database. This is done with the ",
 StyleBox["GraphQuery", "MR"],
 " command. The following returns all complete graphs."
}], "Text",
 CellTags->"b:7.2.1",
 CellID->28009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphQuery", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<COMPLETEQ\>\"", "\[Rule]", "True"}], "}"}], "]"}]], "Input",
 CellTags->"b:7.2.1",
 CellLabel->"In[3]:=",
 CellID->27157],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .78027 L
s
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.60654 .04652 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.0175847 1.03517 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.72727 .94824 m
.27273 .94824 L
s
.72727 .94824 m
.04545 .5 L
s
.72727 .94824 m
.27273 .05176 L
s
.72727 .94824 m
.72727 .05176 L
s
.72727 .94824 m
.95455 .5 L
s
.27273 .94824 m
.04545 .5 L
s
.27273 .94824 m
.27273 .05176 L
s
.27273 .94824 m
.72727 .05176 L
s
.27273 .94824 m
.95455 .5 L
s
.04545 .5 m
.27273 .05176 L
s
.04545 .5 m
.72727 .05176 L
s
.04545 .5 m
.95455 .5 L
s
.27273 .05176 m
.72727 .05176 L
s
.27273 .05176 m
.95455 .5 L
s
.72727 .05176 m
.95455 .5 L
s
.025 w
.72727 .94824 Mdot
.27273 .94824 Mdot
.04545 .5 Mdot
.27273 .05176 Mdot
.72727 .05176 Mdot
.95455 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0118122 0.941131 0.0459853 0.919705 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.77352 .86409 m
.37036 .95401 L
s
.77352 .86409 m
.04706 .70206 L
s
.77352 .86409 m
.04706 .29794 L
s
.77352 .86409 m
.37036 .04599 L
s
.77352 .86409 m
.77352 .13591 L
s
.77352 .86409 m
.95294 .5 L
s
.37036 .95401 m
.04706 .70206 L
s
.37036 .95401 m
.04706 .29794 L
s
.37036 .95401 m
.37036 .04599 L
s
.37036 .95401 m
.77352 .13591 L
s
.37036 .95401 m
.95294 .5 L
s
.04706 .70206 m
.04706 .29794 L
s
.04706 .70206 m
.37036 .04599 L
s
.04706 .70206 m
.77352 .13591 L
s
.04706 .70206 m
.95294 .5 L
s
.04706 .29794 m
.37036 .04599 L
s
.04706 .29794 m
.77352 .13591 L
s
.04706 .29794 m
.95294 .5 L
s
.37036 .04599 m
.77352 .13591 L
s
.37036 .04599 m
.95294 .5 L
s
.77352 .13591 m
.95294 .5 L
s
.025 w
.77352 .86409 Mdot
.37036 .95401 Mdot
.04706 .70206 Mdot
.04706 .29794 Mdot
.37036 .04599 Mdot
.77352 .13591 Mdot
.95294 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:7.2.1",
 CellLabel->"From In[3]:=",
 CellID->20472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "10",
       "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\", \"\>", 
      "\[InvisibleSpace]", "\<\"Undirected\"\>", 
      "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
     SequenceForm[
     "\[SkeletonIndicator]Graph:<", 10, ", ", 5, ", ", "Undirected", 
      ">\[SkeletonIndicator]"],
     Editable->False], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "15",
       "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\", \"\>", 
      "\[InvisibleSpace]", "\<\"Undirected\"\>", 
      "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
     SequenceForm[
     "\[SkeletonIndicator]Graph:<", 15, ", ", 6, ", ", "Undirected", 
      ">\[SkeletonIndicator]"],
     Editable->False], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "21",
       "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "7", 
      "\[InvisibleSpace]", "\<\", \"\>", 
      "\[InvisibleSpace]", "\<\"Undirected\"\>", 
      "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
     SequenceForm[
     "\[SkeletonIndicator]Graph:<", 21, ", ", 7, ", ", "Undirected", 
      ">\[SkeletonIndicator]"],
     Editable->False], "}"}]}], "}"}]], "Output",
 CellTags->"b:7.2.1",
 CellLabel->"Out[3]=",
 CellID->23622]
}, Open  ]],

Cell[TextData[{
 "The format used for the graphs is that provided by the ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " package. This draws a picture of the graph and also returns a symbolic \
object that could be used for further computation by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:7.2.1",
 CellID->18538],

Cell["The following returns the first three regular graphs.", "Text",
 CellTags->"b:7.2.1",
 CellID->12292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphQuery", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<REGULARQ\>\"", "\[Rule]", "True"}], "}"}], ",", 
   RowBox[{"\"\<MaxHits\>\"", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellTags->"b:7.2.1",
 CellLabel->"In[4]:=",
 CellID->6038],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .78027 L
s
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.60654 .04652 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.0175847 1.03517 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.72727 .94824 m
.27273 .05176 L
s
.72727 .94824 m
.72727 .05176 L
s
.27273 .94824 m
.27273 .05176 L
s
.27273 .94824 m
.95455 .5 L
s
.04545 .5 m
.72727 .05176 L
s
.04545 .5 m
.95455 .5 L
s
.025 w
.72727 .94824 Mdot
.27273 .94824 Mdot
.04545 .5 Mdot
.27273 .05176 Mdot
.72727 .05176 Mdot
.95455 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:7.2.1",
 CellLabel->"From In[4]:=",
 CellID->24179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\", \"\>", 
      "\[InvisibleSpace]", "\<\"Undirected\"\>", 
      "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
     SequenceForm[
     "\[SkeletonIndicator]Graph:<", 5, ", ", 5, ", ", "Undirected", 
      ">\[SkeletonIndicator]"],
     Editable->False], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "10",
       "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\", \"\>", 
      "\[InvisibleSpace]", "\<\"Undirected\"\>", 
      "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
     SequenceForm[
     "\[SkeletonIndicator]Graph:<", 10, ", ", 5, ", ", "Undirected", 
      ">\[SkeletonIndicator]"],
     Editable->False], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\", \"\>", 
      "\[InvisibleSpace]", "\<\"Undirected\"\>", 
      "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
     SequenceForm[
     "\[SkeletonIndicator]Graph:<", 6, ", ", 6, ", ", "Undirected", 
      ">\[SkeletonIndicator]"],
     Editable->False], "}"}]}], "}"}]], "Output",
 CellTags->"b:7.2.1",
 CellLabel->"Out[4]=",
 CellID->18190]
}, Open  ]],

Cell["\<\
The following finds Hamiltonian graphs, returning their diameter, girth, and \
edge information. As before, a picture of the graph is also drawn.\
\>", "Text",
 CellTags->"b:7.2.1",
 CellID->29657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphQuery", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<HAMILTONIANQ\>\"", "\[Rule]", "True"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<diameter\>\"", ",", " ", "\"\<girth\>\"", ",", " ", 
     "\"\<edges\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->"b:7.2.1",
 CellLabel->"In[5]:=",
 CellID->7958],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .74419 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0177187 0.238095 [
[ 0 0 0 0 ]
[ 1 .74419 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .74419 L
0 .74419 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0177187 0.245293 0.239203 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0454545 0.909091 -0.0175847 1.03517 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.72727 .94824 m
.27273 .05176 L
s
.72727 .94824 m
.72727 .05176 L
s
.27273 .94824 m
.27273 .05176 L
s
.27273 .94824 m
.95455 .5 L
s
.04545 .5 m
.72727 .05176 L
s
.04545 .5 m
.95455 .5 L
s
.025 w
.72727 .94824 Mdot
.27273 .94824 Mdot
.04545 .5 Mdot
.27273 .05176 Mdot
.72727 .05176 Mdot
.95455 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.261351 0.245293 0.482835 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.261351 0.488926 0.482835 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.261351 0.732558 0.482835 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.60654 .04652 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.261351 0.97619 0.482835 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .78027 L
s
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.04868 .21973 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.60654 .04652 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.504983 0.245293 0.726467 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.267442 0.504983 0.488926 0.726467 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.511074 0.504983 0.732558 0.726467 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.754707 0.504983 0.97619 0.726467 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0221976 0.973522 0.0465153 0.930307 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.005 w
[ ] 0 setdash
.60654 .95348 m
.04868 .21973 L
s
.60654 .95348 m
.60654 .04652 L
s
.60654 .95348 m
.95132 .5 L
s
.04868 .78027 m
.60654 .04652 L
s
.04868 .78027 m
.95132 .5 L
s
.04868 .21973 m
.60654 .04652 L
s
.04868 .21973 m
.95132 .5 L
s
.60654 .04652 m
.95132 .5 L
s
.025 w
.60654 .95348 Mdot
.04868 .78027 Mdot
.04868 .21973 Mdot
.60654 .04652 Mdot
.95132 .5 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 214.313},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:7.2.1",
 CellLabel->"From In[5]:=",
 CellID->6191,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],
 ImageRangeCache->{{{0, 287}, {213.313, 0}} -> {-0.102679, -0.0744342, \
0.0146528, 0.0146528}, {{7, 70.5}, {208.25, 144.75}} -> {-0.171266, \
-0.0600341, 0.017323, 0.0152131}, {{7, 70.5}, {138.375, 74.9375}} -> \
{-0.091057, -1.31979, 0.0161924, 0.0169446}, {{76.8125, 140.313}, {138.375, \
74.9375}} -> {-1.22149, -1.31979, 0.0161924, 0.0169446}, {{146.688, 210.188}, \
{138.375, 74.9375}} -> {-2.35294, -1.31979, 0.0161924, 0.0169446}, {{216.5, \
280}, {138.375, 74.9375}} -> {-3.48337, -1.31979, 0.0161924, 0.0169446}, {{7, \
70.5}, {68.5625, 5.0625}} -> {-0.0904394, -2.50033, 0.0161765, 0.0169279}, \
{{76.8125, 140.313}, {68.5625, 5.0625}} -> {-1.21976, -2.50033, 0.0161765, \
0.0169279}, {{146.688, 210.188}, {68.5625, 5.0625}} -> {-2.3501, -2.50033, \
0.0161765, 0.0169279}, {{216.5, 280}, {68.5625, 5.0625}} -> {-3.47942, \
-2.50033, 0.0161765, 0.0169279}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:7.2.1",
 CellLabel->"Out[5]=",
 CellID->19815]
}, Open  ]],

Cell["\<\
One important aspect of this example package is that it shows commands that \
are specific to the issue of finding graphs rather than general database \
commands. The details of the database interactions are all placed in the \
implementation.\
\>", "Text",
 CellTags->"b:7.2.1",
 CellID->22888]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Graph Database Package", "Subsection",
 CellTags->{"xref:158", "b:7.2.2"},
 CellID->19156],

Cell["The graph database package provides three functions.", "Text",
 CellTags->"b:7.2.2",
 CellID->11511],

Cell[BoxData[GridBox[{
   {
    RowBox[{"GraphProperties", "[", "]"}], Cell[
    "list all graph properties within the database", "TableText"]},
   {
    RowBox[{"GraphQuery", "[", "{", 
     StyleBox["props", "TI"], "}", "]"}], Cell[TextData[{
     "search the database for graphs that match ",
     StyleBox["props", "TI"]
    }], "TableText"]},
   {
    RowBox[{"RestoreGraphDatabase", "[", "]"}], Cell[
    "restore the data in the database (can be slow)", "TableText"]}
  }]], "DefinitionBox",
 CellID->16202],

Cell["Graph database package functions.", "Caption",
 CellTags->"b:4.1.2",
 CellID->2634],

Cell[TextData[{
 "The ",
 StyleBox["RestoreGraphDatabase", "MR"],
 " function recomputes all the data in the database and can take some time to \
complete. Generally you do not want to run this, unless you have corrupted \
the database in some way."
}], "Text",
 CellTags->"b:7.2.2",
 CellID->24272]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Examples - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 40.1403043}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "This example shows how to use a private database to store Mathematica \
commands and query the data from Java and Mathematica. If you find that the \
examples in this section do not work as shown, you may need to install or \
restore the example database with the DatabaseExamples` package, as described \
in Using the Example Databases. The example code is loaded from the Examples \
subdirectory of DatabaseLink. ", "synonyms" -> {}, "title" -> "Examples", 
    "type" -> "Tutorial", "uri" -> "DatabaseLink/tutorial/Examples"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:53"->{
  Cell[794, 34, 89, 2, 70, "Section",
   CellTags->{"xref:53", "c:77", "b:7.1"},
   CellID->18127]},
 "c:77"->{
  Cell[794, 34, 89, 2, 70, "Section",
   CellTags->{"xref:53", "c:77", "b:7.1"},
   CellID->18127]},
 "b:7.1"->{
  Cell[794, 34, 89, 2, 70, "Section",
   CellTags->{"xref:53", "c:77", "b:7.1"},
   CellID->18127],
  Cell[886, 38, 276, 10, 70, "Text",
   CellTags->"b:7.1",
   CellID->467],
  Cell[1593, 63, 211, 9, 70, "Text",
   CellTags->"b:7.1",
   CellID->14893],
  Cell[1807, 74, 138, 4, 70, "Input",
   CellTags->"b:7.1",
   CellID->24648],
  Cell[1948, 80, 301, 9, 70, "Text",
   CellTags->"b:7.1",
   CellID->22483],
  Cell[2274, 93, 184, 6, 70, "Input",
   CellTags->"b:7.1",
   CellID->17807],
  Cell[2461, 101, 202, 7, 70, "Output",
   CellTags->"b:7.1",
   CellID->2421],
  Cell[2678, 111, 158, 5, 70, "Text",
   CellTags->"b:7.1",
   CellID->14310],
  Cell[2861, 120, 118, 4, 70, "Input",
   CellTags->"b:7.1",
   CellID->6617],
  Cell[2982, 126, 1647, 32, 70, "Output",
   CellTags->"b:7.1",
   CellID->22813],
  Cell[4644, 161, 692, 18, 70, "Text",
   CellTags->"b:7.1",
   CellID->9514],
  Cell[5361, 183, 127, 4, 70, "Input",
   CellTags->"b:7.1",
   CellID->14309],
  Cell[5491, 189, 244, 7, 70, "Output",
   CellTags->"b:7.1",
   CellID->7616],
  Cell[5772, 201, 218, 8, 70, "Input",
   CellTags->"b:7.1",
   CellID->18935],
  Cell[5993, 211, 173, 6, 70, "Output",
   CellTags->"b:7.1",
   CellID->17451],
  Cell[6181, 220, 239, 9, 70, "Text",
   CellTags->"b:7.1",
   CellID->20600],
  Cell[6445, 233, 183, 6, 70, "Input",
   CellTags->"b:7.1",
   CellID->5249],
  Cell[6631, 241, 166, 5, 70, "Output",
   CellTags->"b:7.1",
   CellID->16519],
  Cell[6834, 251, 218, 8, 70, "Input",
   CellTags->"b:7.1",
   CellID->31556],
  Cell[7055, 261, 265, 9, 70, "Output",
   CellTags->"b:7.1",
   CellID->22798],
  Cell[7357, 275, 261, 9, 70, "Input",
   CellTags->"b:7.1",
   CellID->30303],
  Cell[7621, 286, 173, 6, 70, "Output",
   CellTags->"b:7.1",
   CellID->6224],
  Cell[7809, 295, 97, 2, 70, "Text",
   CellTags->"b:7.1",
   CellID->11008],
  Cell[7931, 301, 123, 4, 70, "Input",
   CellTags->"b:7.1",
   CellID->5844],
  Cell[8057, 307, 1415, 29, 70, "Output",
   CellTags->"b:7.1",
   CellID->32609],
  Cell[9487, 339, 227, 6, 70, "Text",
   CellTags->"b:7.1",
   CellID->14989],
  Cell[9717, 347, 11363, 190, 70, "Graphics",
   CellTags->"b:7.1",
   CellID->32702],
  Cell[21105, 541, 121, 4, 70, "Input",
   CellTags->"b:7.1",
   CellID->3195],
  Cell[21229, 547, 279, 8, 70, "Output",
   CellTags->"b:7.1",
   CellID->20485],
  Cell[21523, 558, 138, 5, 70, "Text",
   CellTags->"b:7.1",
   CellID->3093],
  Cell[21664, 565, 525, 17, 70, "Input",
   CellTags->"b:7.1",
   CellID->14343],
  Cell[22192, 584, 237, 6, 70, "Text",
   CellTags->"b:7.1",
   CellID->30523],
  Cell[22454, 594, 124, 4, 70, "Input",
   CellTags->"b:7.1",
   CellID->1587],
  Cell[22581, 600, 88, 3, 70, "Output",
   CellTags->"b:7.1",
   CellID->29314]},
 "xref:80"->{
  Cell[22718, 609, 80, 2, 70, "Section",
   CellTags->{"xref:80", "c:78"},
   CellID->9503]},
 "c:78"->{
  Cell[22718, 609, 80, 2, 70, "Section",
   CellTags->{"xref:80", "c:78"},
   CellID->9503]},
 "b:7.2.0"->{
  Cell[22801, 613, 509, 11, 70, "Text",
   CellTags->"b:7.2.0",
   CellID->25200]},
 "xref:157"->{
  Cell[23335, 628, 98, 2, 70, "Subsection",
   CellTags->{"xref:157", "b:7.2.1"},
   CellID->13458]},
 "b:7.2.1"->{
  Cell[23335, 628, 98, 2, 70, "Subsection",
   CellTags->{"xref:157", "b:7.2.1"},
   CellID->13458],
  Cell[23436, 632, 109, 2, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->6618],
  Cell[23548, 636, 134, 4, 70, "Input",
   CellTags->"b:7.2.1",
   CellID->20580],
  Cell[23685, 642, 360, 8, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->19796],
  Cell[24048, 652, 106, 3, 70, "Input",
   CellTags->"b:7.2.1",
   CellID->14798],
  Cell[24157, 657, 189, 6, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->15281],
  Cell[24371, 667, 124, 4, 70, "Input",
   CellTags->"b:7.2.1",
   CellID->19589],
  Cell[24498, 673, 740, 15, 70, "Output",
   CellTags->"b:7.2.1",
   CellID->20798],
  Cell[25253, 691, 224, 6, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->28009],
  Cell[25502, 701, 196, 6, 70, "Input",
   CellTags->"b:7.2.1",
   CellID->27157],
  Cell[25701, 709, 3906, 288, 70, "Graphics",
   CellTags->"b:7.2.1",
   CellID->20472],
  Cell[29610, 999, 1611, 38, 70, "Output",
   CellTags->"b:7.2.1",
   CellID->23622],
  Cell[31236, 1040, 362, 11, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->18538],
  Cell[31601, 1053, 107, 2, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->12292],
  Cell[31733, 1059, 263, 8, 70, "Input",
   CellTags->"b:7.2.1",
   CellID->6038],
  Cell[31999, 1069, 3059, 211, 70, "Graphics",
   CellTags->"b:7.2.1",
   CellID->24179],
  Cell[35061, 1282, 1607, 38, 70, "Output",
   CellTags->"b:7.2.1",
   CellID->18190],
  Cell[36683, 1323, 207, 5, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->29657],
  Cell[36915, 1332, 347, 11, 70, "Input",
   CellTags->"b:7.2.1",
   CellID->7958],
  Cell[37265, 1345, 12616, 635, 70, 7599, 550, "GraphicsData", 
  "PostScript", "Graphics",
   CellTags->"b:7.2.1",
   CellID->6191],
  Cell[49884, 1982, 736, 23, 70, "Output",
   CellTags->"b:7.2.1",
   CellID->19815],
  Cell[50635, 2008, 305, 7, 70, "Text",
   CellTags->"b:7.2.1",
   CellID->22888]},
 "xref:158"->{
  Cell[50977, 2020, 100, 2, 70, "Subsection",
   CellTags->{"xref:158", "b:7.2.2"},
   CellID->19156]},
 "b:7.2.2"->{
  Cell[50977, 2020, 100, 2, 70, "Subsection",
   CellTags->{"xref:158", "b:7.2.2"},
   CellID->19156],
  Cell[51080, 2024, 106, 2, 70, "Text",
   CellTags->"b:7.2.2",
   CellID->11511],
  Cell[51798, 2048, 299, 8, 70, "Text",
   CellTags->"b:7.2.2",
   CellID->24272]},
 "b:4.1.2"->{
  Cell[51706, 2044, 89, 2, 70, "Caption",
   CellTags->"b:4.1.2",
   CellID->2634]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:53", 53798, 2100},
 {"c:77", 53910, 2104},
 {"b:7.1", 54023, 2108},
 {"xref:80", 56779, 2211},
 {"c:78", 56884, 2215},
 {"b:7.2.0", 56992, 2219},
 {"xref:157", 57091, 2223},
 {"b:7.2.1", 57207, 2227},
 {"xref:158", 59140, 2295},
 {"b:7.2.2", 59258, 2299},
 {"b:4.1.2", 59542, 2309}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 40, 1, 70, "Title",
 CellID->3788],
Cell[CellGroupData[{
Cell[794, 34, 89, 2, 70, "Section",
 CellTags->{"xref:53", "c:77", "b:7.1"},
 CellID->18127],
Cell[886, 38, 276, 10, 70, "Text",
 CellTags->"b:7.1",
 CellID->467],
Cell[1165, 50, 425, 11, 70, "Text",
 CellID->3728],
Cell[1593, 63, 211, 9, 70, "Text",
 CellTags->"b:7.1",
 CellID->14893],
Cell[1807, 74, 138, 4, 70, "Input",
 CellTags->"b:7.1",
 CellID->24648],
Cell[1948, 80, 301, 9, 70, "Text",
 CellTags->"b:7.1",
 CellID->22483],
Cell[CellGroupData[{
Cell[2274, 93, 184, 6, 70, "Input",
 CellTags->"b:7.1",
 CellID->17807],
Cell[2461, 101, 202, 7, 70, "Output",
 CellTags->"b:7.1",
 CellID->2421]
}, Open  ]],
Cell[2678, 111, 158, 5, 70, "Text",
 CellTags->"b:7.1",
 CellID->14310],
Cell[CellGroupData[{
Cell[2861, 120, 118, 4, 70, "Input",
 CellTags->"b:7.1",
 CellID->6617],
Cell[2982, 126, 1647, 32, 70, "Output",
 CellTags->"b:7.1",
 CellID->22813]
}, Open  ]],
Cell[4644, 161, 692, 18, 70, "Text",
 CellTags->"b:7.1",
 CellID->9514],
Cell[CellGroupData[{
Cell[5361, 183, 127, 4, 70, "Input",
 CellTags->"b:7.1",
 CellID->14309],
Cell[5491, 189, 244, 7, 70, "Output",
 CellTags->"b:7.1",
 CellID->7616]
}, Open  ]],
Cell[CellGroupData[{
Cell[5772, 201, 218, 8, 70, "Input",
 CellTags->"b:7.1",
 CellID->18935],
Cell[5993, 211, 173, 6, 70, "Output",
 CellTags->"b:7.1",
 CellID->17451]
}, Open  ]],
Cell[6181, 220, 239, 9, 70, "Text",
 CellTags->"b:7.1",
 CellID->20600],
Cell[CellGroupData[{
Cell[6445, 233, 183, 6, 70, "Input",
 CellTags->"b:7.1",
 CellID->5249],
Cell[6631, 241, 166, 5, 70, "Output",
 CellTags->"b:7.1",
 CellID->16519]
}, Open  ]],
Cell[CellGroupData[{
Cell[6834, 251, 218, 8, 70, "Input",
 CellTags->"b:7.1",
 CellID->31556],
Cell[7055, 261, 265, 9, 70, "Output",
 CellTags->"b:7.1",
 CellID->22798]
}, Open  ]],
Cell[CellGroupData[{
Cell[7357, 275, 261, 9, 70, "Input",
 CellTags->"b:7.1",
 CellID->30303],
Cell[7621, 286, 173, 6, 70, "Output",
 CellTags->"b:7.1",
 CellID->6224]
}, Open  ]],
Cell[7809, 295, 97, 2, 70, "Text",
 CellTags->"b:7.1",
 CellID->11008],
Cell[CellGroupData[{
Cell[7931, 301, 123, 4, 70, "Input",
 CellTags->"b:7.1",
 CellID->5844],
Cell[8057, 307, 1415, 29, 70, "Output",
 CellTags->"b:7.1",
 CellID->32609]
}, Open  ]],
Cell[9487, 339, 227, 6, 70, "Text",
 CellTags->"b:7.1",
 CellID->14989],
Cell[9717, 347, 11363, 190, 70, "Graphics",
 CellTags->"b:7.1",
 CellID->32702],
Cell[CellGroupData[{
Cell[21105, 541, 121, 4, 70, "Input",
 CellTags->"b:7.1",
 CellID->3195],
Cell[21229, 547, 279, 8, 70, "Output",
 CellTags->"b:7.1",
 CellID->20485]
}, Open  ]],
Cell[21523, 558, 138, 5, 70, "Text",
 CellTags->"b:7.1",
 CellID->3093],
Cell[21664, 565, 525, 17, 70, "Input",
 CellTags->"b:7.1",
 CellID->14343],
Cell[22192, 584, 237, 6, 70, "Text",
 CellTags->"b:7.1",
 CellID->30523],
Cell[CellGroupData[{
Cell[22454, 594, 124, 4, 70, "Input",
 CellTags->"b:7.1",
 CellID->1587],
Cell[22581, 600, 88, 3, 70, "Output",
 CellTags->"b:7.1",
 CellID->29314]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22718, 609, 80, 2, 70, "Section",
 CellTags->{"xref:80", "c:78"},
 CellID->9503],
Cell[22801, 613, 509, 11, 70, "Text",
 CellTags->"b:7.2.0",
 CellID->25200],
Cell[CellGroupData[{
Cell[23335, 628, 98, 2, 70, "Subsection",
 CellTags->{"xref:157", "b:7.2.1"},
 CellID->13458],
Cell[23436, 632, 109, 2, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->6618],
Cell[23548, 636, 134, 4, 70, "Input",
 CellTags->"b:7.2.1",
 CellID->20580],
Cell[23685, 642, 360, 8, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->19796],
Cell[24048, 652, 106, 3, 70, "Input",
 CellTags->"b:7.2.1",
 CellID->14798],
Cell[24157, 657, 189, 6, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->15281],
Cell[CellGroupData[{
Cell[24371, 667, 124, 4, 70, "Input",
 CellTags->"b:7.2.1",
 CellID->19589],
Cell[24498, 673, 740, 15, 70, "Output",
 CellTags->"b:7.2.1",
 CellID->20798]
}, Open  ]],
Cell[25253, 691, 224, 6, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->28009],
Cell[CellGroupData[{
Cell[25502, 701, 196, 6, 70, "Input",
 CellTags->"b:7.2.1",
 CellID->27157],
Cell[25701, 709, 3906, 288, 70, "Graphics",
 CellTags->"b:7.2.1",
 CellID->20472],
Cell[29610, 999, 1611, 38, 70, "Output",
 CellTags->"b:7.2.1",
 CellID->23622]
}, Open  ]],
Cell[31236, 1040, 362, 11, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->18538],
Cell[31601, 1053, 107, 2, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->12292],
Cell[CellGroupData[{
Cell[31733, 1059, 263, 8, 70, "Input",
 CellTags->"b:7.2.1",
 CellID->6038],
Cell[31999, 1069, 3059, 211, 70, "Graphics",
 CellTags->"b:7.2.1",
 CellID->24179],
Cell[35061, 1282, 1607, 38, 70, "Output",
 CellTags->"b:7.2.1",
 CellID->18190]
}, Open  ]],
Cell[36683, 1323, 207, 5, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->29657],
Cell[CellGroupData[{
Cell[36915, 1332, 347, 11, 70, "Input",
 CellTags->"b:7.2.1",
 CellID->7958],
Cell[37265, 1345, 12616, 635, 70, 7599, 550, "GraphicsData", "PostScript", \
"Graphics",
 CellTags->"b:7.2.1",
 CellID->6191],
Cell[49884, 1982, 736, 23, 70, "Output",
 CellTags->"b:7.2.1",
 CellID->19815]
}, Open  ]],
Cell[50635, 2008, 305, 7, 70, "Text",
 CellTags->"b:7.2.1",
 CellID->22888]
}, Open  ]],
Cell[CellGroupData[{
Cell[50977, 2020, 100, 2, 70, "Subsection",
 CellTags->{"xref:158", "b:7.2.2"},
 CellID->19156],
Cell[51080, 2024, 106, 2, 70, "Text",
 CellTags->"b:7.2.2",
 CellID->11511],
Cell[51189, 2028, 514, 14, 70, "DefinitionBox",
 CellID->16202],
Cell[51706, 2044, 89, 2, 70, "Caption",
 CellTags->"b:4.1.2",
 CellID->2634],
Cell[51798, 2048, 299, 8, 70, "Text",
 CellTags->"b:7.2.2",
 CellID->24272]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[52136, 2061, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

