(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18261,        612]
NotebookOptionsPosition[      9531,        331]
NotebookOutlinePosition[     15993,        524]
CellTagsIndexPosition[     15620,        506]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Introduction to ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"xref:1", "c:1"},
 CellID->21196],

Cell[CellGroupData[{

Cell["Background", "Subsection",
 CellTags->{"xref:2", "c:2", "i:42", "b:0.0"},
 CellID->26633],

Cell["\<\
Data storage, indexing, and retrieval have long been crucial tasks of many \
large organizations such as governments, banks, hospitals, and libraries. As \
human societies have grown increasingly complex, data management requirements \
have also increased. Some of the new challenges include the complexity of \
what the data represents, how the data is used, as well as the sheer volume \
of data. Since the development of modern electronic computers in the latter \
half of the twentieth century, tools such as relational database management \
systems (RDBMS) and the Structured Query Language (SQL) have become standards \
that are widely used for data handling in many different types of \
organizations.\
\>", "Text",
 CellTags->"b:0.0",
 CellID->12158],

Cell["\<\
In a typical organization, many different users need to access the data \
management system, and hence many database applications are server based. \
They can be combined with other server-based technologies, often called \
enterprise technologies, such as web servers, web services, as well as remote \
computing heterogeneous architectures.\
\>", "Text",
 CellTags->"b:0.0",
 CellID->12022],

Cell["\<\
At the current time, there are many different database systems. These range \
from large\[Hyphen]scale, expensive commercial applications that are suitable \
for high\[Hyphen]end uses to freely available open\[Hyphen]source tools \
running on personal computers with operating systems such as Microsoft \
Windows or Linux.\
\>", "Text",
 CellTags->"b:0.0",
 CellID->1146],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application that provides a set of tools allowing convenient integration \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with database management systems."
}], "Text",
 CellTags->"b:0.0",
 CellID->18392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Database ",
 "Applications"
}], "Subsection",
 CellTags->{"xref:2", "c:3", "b:0.1"},
 CellID->13037],

Cell[TextData[{
 "There are a number of important benefits that can be gained from \
integrating ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into a database system."
}], "Text",
 CellTags->"b:0.1",
 CellID->3925],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains a large collection of functions for numerical and symbolic \
computation that can be applied to data taken from a database. After the \
computations have been completed, the results can be stored in a database \
application, allowing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to work on the results at a later time. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " might be used for statistical processing, modeling, or computing some \
optimal configuration. All of these computations typically require and \
produce data that can conveniently be stored in a database application."
}], "Text",
 CellTags->"b:0.1",
 CellID->10647],

Cell[TextData[{
 "Database applications can be integrated with many other application types, \
providing an important form of interoperability. Data derived from one \
application can be stored in the database. Then, elements of this data can be \
retrieved by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", used for computation, and the results stored in the database. Finally, \
another application can extract these results and use them for some further \
purpose. The central database application is the hub of this computational \
network; its interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is made possible by ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->29458]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Features of ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"]
}], "Subsection",
 CellTags->{"xref:3", "c:4", "b:0.2"},
 CellID->6602],

Cell["\<\
Connectivity\[ThinSpace]\[Dash]\[ThinSpace]works with most standard SQL \
database applications and with databases that are local and network based \
(including different types of computers).\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->30807],

Cell["\<\
The HSQL Database Engine (HSQLDB)\[ThinSpace]\[Dash]\[ThinSpace]a lightweight \
database useful for database applications if you don't have an existing \
database.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->4098],

Cell["\<\
Supplied drivers\[ThinSpace]\[Dash]\[ThinSpace]built\[Hyphen]in support for \
many important databases, including MySQL, Open Database Connectivity (ODBC), \
and HSQLDB.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->27830],

Cell["\<\
SQL command interface\[ThinSpace]\[Dash]\[ThinSpace]you can exploit your \
knowledge of SQL without learning a new system.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->29292],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command interface\[ThinSpace]\[Dash]\[ThinSpace]useful if you are familiar \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming."
}], "BulletedText",
 CellTags->"b:0.2",
 CellID->14600],

Cell["\<\
GUI interfaces\[ThinSpace]\[Dash]\[ThinSpace]the Database Explorer and the \
Connection Tool provide convenient tools for opening connections and querying \
the database.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->7278],

Cell["\<\
Access to data and metadata\[ThinSpace]\[Dash]\[ThinSpace]you can inspect the \
names of tables and columns, as well as the data in each entry.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->20799],

Cell[TextData[{
 "Configurable\[ThinSpace]\[Dash]\[ThinSpace]common tasks can be simplified \
and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applications can add their own database information."
}], "BulletedText",
 CellTags->"b:0.2",
 CellID->18352],

Cell["\<\
Batch support\[ThinSpace]\[Dash]\[ThinSpace]provides efficiency when making \
repeated changes to a database.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->20448],

Cell[TextData[{
 "Data type support\[ThinSpace]\[Dash]\[ThinSpace]works with standard SQL \
data types, including numbers, strings, binary data, date and time, as well \
as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions."
}], "BulletedText",
 CellTags->"b:0.2",
 CellID->13882],

Cell["\<\
Support for advanced features\[ThinSpace]\[Dash]\[ThinSpace]such as multiple \
connections and transactions (including rollbacks and savepoints).\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->540],

Cell["\<\
Secure Socket Layer (SSL) support\[ThinSpace]\[Dash]\[ThinSpace]security for \
communications with the database.\
\>", "BulletedText",
 CellTags->"b:0.2",
 CellID->28315]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " Technology"
}], "Subsection",
 CellTags->{"xref:4", "c:5", "b:0.3"},
 CellID->4575],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " is based on the commonly used Java database connectivity (JDBC) \
technology, ",
 ButtonBox["java.sun.com/products/jdbc/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://java.sun.com/products/jdbc/"], None}],
 ". The package makes extensive use of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Java toolkit ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " ",
 ButtonBox["www.wolfram.com/solutions/mathlink/jlink/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/mathlink/jlink/"], None}],
 ", though no Java programming is required. The Database Explorer uses the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphical user interface toolkit ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 ", ",
 ButtonBox["www.wolfram.com/solutions/guikit",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/guikit"], None}],
 "."
}], "Text",
 CellTags->"b:0.3",
 CellID->8762],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " comes with a selection of drivers for a number of databases. If it does \
not include a driver for your database, you can install your own driver, as \
described in ",
 ButtonBox["Database Connections: JDBC Connections",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#27756"],
 ". "
}], "Text",
 CellTags->"b:0.3",
 CellID->9567]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to DatabaseLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 43.3277839}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "Data storage, indexing, and retrieval have long been crucial tasks of \
many large organizations such as governments, banks, hospitals, and \
libraries. As human societies have grown increasingly complex, data \
management requirements have also increased. Some of the new challenges \
include the complexity of what the data represents, how the data is used, as \
well as the sheer volume of data. Since the development of modern electronic \
computers in the latter half of the twentieth century, tools such as \
relational database management systems (RDBMS) and the Structured Query \
Language (SQL) have become standards that are widely used for data handling \
in many different types of organizations. In a typical organization, many \
different users need to access the data management system, and hence many \
database applications are server based. They can be combined with other \
server-based technologies, often called enterprise technologies, such as web \
servers, web services, as well as remote computing heterogeneous \
architectures. At the current time, there are many different database \
systems. These range from large-scale, expensive commercial applications that \
are suitable for high-end uses to freely available open-source tools running \
on personal computers with operating systems such as Microsoft Windows or \
Linux.", "synonyms" -> {}, "title" -> "Introduction to DatabaseLink", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/Introduction"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:1"->{
  Cell[729, 29, 144, 6, 70, "Title",
   CellTags->{"xref:1", "c:1"},
   CellID->21196]},
 "c:1"->{
  Cell[729, 29, 144, 6, 70, "Title",
   CellTags->{"xref:1", "c:1"},
   CellID->21196]},
 "xref:2"->{
  Cell[898, 39, 95, 2, 70, "Subsection",
   CellTags->{"xref:2", "c:2", "i:42", "b:0.0"},
   CellID->26633],
  Cell[2937, 96, 168, 7, 70, "Subsection",
   CellTags->{"xref:2", "c:3", "b:0.1"},
   CellID->13037]},
 "c:2"->{
  Cell[898, 39, 95, 2, 70, "Subsection",
   CellTags->{"xref:2", "c:2", "i:42", "b:0.0"},
   CellID->26633]},
 "i:42"->{
  Cell[898, 39, 95, 2, 70, "Subsection",
   CellTags->{"xref:2", "c:2", "i:42", "b:0.0"},
   CellID->26633]},
 "b:0.0"->{
  Cell[898, 39, 95, 2, 70, "Subsection",
   CellTags->{"xref:2", "c:2", "i:42", "b:0.0"},
   CellID->26633],
  Cell[996, 43, 768, 13, 70, "Text",
   CellTags->"b:0.0",
   CellID->12158],
  Cell[1767, 58, 402, 8, 70, "Text",
   CellTags->"b:0.0",
   CellID->12022],
  Cell[2172, 68, 381, 8, 70, "Text",
   CellTags->"b:0.0",
   CellID->1146],
  Cell[2556, 78, 344, 13, 70, "Text",
   CellTags->"b:0.0",
   CellID->18392]},
 "c:3"->{
  Cell[2937, 96, 168, 7, 70, "Subsection",
   CellTags->{"xref:2", "c:3", "b:0.1"},
   CellID->13037]},
 "b:0.1"->{
  Cell[2937, 96, 168, 7, 70, "Subsection",
   CellTags->{"xref:2", "c:3", "b:0.1"},
   CellID->13037],
  Cell[3108, 105, 223, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->3925],
  Cell[3334, 115, 726, 17, 70, "Text",
   CellTags->"b:0.1",
   CellID->10647],
  Cell[4063, 134, 755, 19, 70, "Text",
   CellTags->"b:0.1",
   CellID->29458]},
 "xref:3"->{
  Cell[4855, 158, 153, 6, 70, "Subsection",
   CellTags->{"xref:3", "c:4", "b:0.2"},
   CellID->6602]},
 "c:4"->{
  Cell[4855, 158, 153, 6, 70, "Subsection",
   CellTags->{"xref:3", "c:4", "b:0.2"},
   CellID->6602]},
 "b:0.2"->{
  Cell[4855, 158, 153, 6, 70, "Subsection",
   CellTags->{"xref:3", "c:4", "b:0.2"},
   CellID->6602],
  Cell[5011, 166, 259, 6, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->30807],
  Cell[5273, 174, 230, 6, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->4098],
  Cell[5506, 182, 237, 6, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->27830],
  Cell[5746, 190, 190, 5, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->29292],
  Cell[5939, 197, 274, 10, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->14600],
  Cell[6216, 209, 237, 6, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->7278],
  Cell[6456, 217, 211, 5, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->20799],
  Cell[6670, 224, 262, 8, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->18352],
  Cell[6935, 234, 177, 5, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->20448],
  Cell[7115, 241, 297, 9, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->13882],
  Cell[7415, 252, 211, 5, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->540],
  Cell[7629, 259, 180, 5, 70, "BulletedText",
   CellTags->"b:0.2",
   CellID->28315]},
 "xref:4"->{
  Cell[7846, 269, 152, 6, 70, "Subsection",
   CellTags->{"xref:4", "c:5", "b:0.3"},
   CellID->4575]},
 "c:5"->{
  Cell[7846, 269, 152, 6, 70, "Subsection",
   CellTags->{"xref:4", "c:5", "b:0.3"},
   CellID->4575]},
 "b:0.3"->{
  Cell[7846, 269, 152, 6, 70, "Subsection",
   CellTags->{"xref:4", "c:5", "b:0.3"},
   CellID->4575],
  Cell[8001, 277, 1037, 34, 70, "Text",
   CellTags->"b:0.3",
   CellID->8762],
  Cell[9041, 313, 436, 12, 70, "Text",
   CellTags->"b:0.3",
   CellID->9567]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:1", 12146, 381},
 {"c:1", 12245, 385},
 {"xref:2", 12347, 389},
 {"c:2", 12570, 396},
 {"i:42", 12691, 400},
 {"b:0.0", 12813, 404},
 {"c:3", 13245, 420},
 {"b:0.1", 13361, 424},
 {"xref:3", 13716, 437},
 {"c:4", 13830, 441},
 {"b:0.2", 13946, 445},
 {"xref:4", 15104, 485},
 {"c:5", 15218, 489},
 {"b:0.3", 15334, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 144, 6, 70, "Title",
 CellTags->{"xref:1", "c:1"},
 CellID->21196],
Cell[CellGroupData[{
Cell[898, 39, 95, 2, 70, "Subsection",
 CellTags->{"xref:2", "c:2", "i:42", "b:0.0"},
 CellID->26633],
Cell[996, 43, 768, 13, 70, "Text",
 CellTags->"b:0.0",
 CellID->12158],
Cell[1767, 58, 402, 8, 70, "Text",
 CellTags->"b:0.0",
 CellID->12022],
Cell[2172, 68, 381, 8, 70, "Text",
 CellTags->"b:0.0",
 CellID->1146],
Cell[2556, 78, 344, 13, 70, "Text",
 CellTags->"b:0.0",
 CellID->18392]
}, Open  ]],
Cell[CellGroupData[{
Cell[2937, 96, 168, 7, 70, "Subsection",
 CellTags->{"xref:2", "c:3", "b:0.1"},
 CellID->13037],
Cell[3108, 105, 223, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->3925],
Cell[3334, 115, 726, 17, 70, "Text",
 CellTags->"b:0.1",
 CellID->10647],
Cell[4063, 134, 755, 19, 70, "Text",
 CellTags->"b:0.1",
 CellID->29458]
}, Open  ]],
Cell[CellGroupData[{
Cell[4855, 158, 153, 6, 70, "Subsection",
 CellTags->{"xref:3", "c:4", "b:0.2"},
 CellID->6602],
Cell[5011, 166, 259, 6, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->30807],
Cell[5273, 174, 230, 6, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->4098],
Cell[5506, 182, 237, 6, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->27830],
Cell[5746, 190, 190, 5, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->29292],
Cell[5939, 197, 274, 10, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->14600],
Cell[6216, 209, 237, 6, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->7278],
Cell[6456, 217, 211, 5, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->20799],
Cell[6670, 224, 262, 8, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->18352],
Cell[6935, 234, 177, 5, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->20448],
Cell[7115, 241, 297, 9, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->13882],
Cell[7415, 252, 211, 5, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->540],
Cell[7629, 259, 180, 5, 70, "BulletedText",
 CellTags->"b:0.2",
 CellID->28315]
}, Open  ]],
Cell[CellGroupData[{
Cell[7846, 269, 152, 6, 70, "Subsection",
 CellTags->{"xref:4", "c:5", "b:0.3"},
 CellID->4575],
Cell[8001, 277, 1037, 34, 70, "Text",
 CellTags->"b:0.3",
 CellID->8762],
Cell[9041, 313, 436, 12, 70, "Text",
 CellTags->"b:0.3",
 CellID->9567]
}, Open  ]]
}, Open  ]],
Cell[9504, 329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

