(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30952,       1172]
NotebookOptionsPosition[     18373,        717]
NotebookOutlinePosition[     26161,        976]
CellTagsIndexPosition[     25791,        959]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Performance", "Title",
 CellTags->{"xref:142", "c:72"},
 CellID->31172],

Cell[CellGroupData[{

Cell["Batch Operation", "Section",
 CellTags->{"xref:79", "c:73", "i:48", "b:6.3.0"},
 CellID->17968],

Cell[TextData[{
 "When large amounts of data are being transferred between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and a database, you may find that the operations are slow. In this case it \
may be advantageous to use a batch operation mode. If many small operations \
are being repeated, this will be likely to improve the performance. This \
section will demonstrate how to use batch statements. "
}], "Text",
 CellTags->"b:6.3.0",
 CellID->27358],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->26031],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:6.3.0",
 CellID->26268],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[1]:=",
 CellID->19426],

Cell[TextData[{
 "This creates a simple table. The table name is ",
 StyleBox["BATCH",
  FontSlant->"Italic"],
 " with columns ",
 StyleBox["X",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Y",
  FontSlant->"Italic"],
 ".",
 " ",
 "The data types for ",
 StyleBox["X",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Y",
  FontSlant->"Italic"],
 " are integers. "
}], "Text",
 CellTags->"b:6.3.0",
 CellID->28510],

Cell[BoxData[{
 RowBox[{
  RowBox[{"table", " ", "=", " ", 
   RowBox[{"SQLTable", "[", "\"\<BATCH\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cols", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<X\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<Y\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", "table", ",", " ", "cols"}], "]"}], 
  ";"}]}], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[3]:=",
 CellID->10422],

Cell[TextData[{
 "This generates data to insert into the table. ",
 StyleBox["X",
  FontSlant->"Italic"],
 " will range from 1 to 10,000 and ",
 StyleBox["Y",
  FontSlant->"Italic"],
 " will range from 1 to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"10", ",", 
    SuperscriptBox["000", "2"]}], TraditionalForm]]],
 ". The data consists of 10,000 rows."
}], "Text",
 CellTags->"b:6.3.0",
 CellID->30774],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"table", ",", " ", 
       RowBox[{"SQLArgument", "@@", "cols"}], ",", " ", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"#", ",", " ", 
         RowBox[{"#", "^", "2"}]}], "]"}]}], "}"}], " ", "&"}], " ", "/@", 
    " ", 
    RowBox[{"Range", "[", "10000", "]"}]}]}], ";"}]], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[6]:=",
 CellID->8779],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to execute the SQL insert 10,000 times."
}], "Text",
 CellTags->"b:6.3.0",
 CellID->30910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SQLExecute", "[", 
      RowBox[{
      "conn", ",", " ", "\"\<INSERT INTO `1` (`2`) VALUES (`3`)\>\"", ",", 
       " ", "#"}], "]"}], " ", "&"}], "/@", " ", "data1"}], " ", ";"}], 
  "]"}]], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[7]:=",
 CellID->23552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"25.6562133`8.86073755105823", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 CellTags->"b:6.3.0",
 CellLabel->"Out[7]=",
 CellID->4182]
}, Open  ]],

Cell["This demonstrates that 10,000 elements have been inserted.", "Text",
 CellTags->"b:6.3.0",
 CellID->25391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], "]"}]], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[8]:=",
 CellID->15495],

Cell[BoxData["10000"], "Output",
 CellTags->"b:6.3.0",
 CellLabel->"Out[8]=",
 CellID->5764]
}, Open  ]],

Cell[TextData[{
 "This uses a batch mode to insert the data. This is done by passing a list \
of arguments to ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 ". Each element of the list contains an ",
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " expression, an ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 " expression with the sequence of column names, and an ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 " expression with the pairs of values."
}], "Text",
 CellTags->"b:6.3.0",
 CellID->874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO `1` (`2`) VALUES (`3`)\>\"", ",", " ", 
     "data1"}], "]"}], ";"}], "]"}]], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[9]:=",
 CellID->1364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"7.0755258`8.301303712399534", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 CellTags->"b:6.3.0",
 CellLabel->"Out[9]=",
 CellID->14902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], "]"}]], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[10]:=",
 CellID->28255],

Cell[BoxData["20000"], "Output",
 CellTags->"b:6.3.0",
 CellLabel->"Out[10]=",
 CellID->4460]
}, Open  ]],

Cell["\<\
The batch operation has reduced the time by more than a factor of three. This \
is because it has done the insert operation in one call rather than 10,000 \
smaller calls.\
\>", "Text",
 CellTags->"b:6.3.0",
 CellID->474],

Cell["The new table is dropped and the connection closed.", "Text",
 CellTags->"b:6.3.0",
 CellID->6972],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.3.0",
 CellLabel->"In[11]:=",
 CellID->26821]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplifying Substitution Patterns", "Section",
 CellTags->{"xref:143", "c:74", "i:49", "b:6.3.1"},
 CellID->26122],

Cell["\<\
Simplifying substitution patterns is another technique for increasing \
performance. This will be demonstrated using a table identical to the \
previous example. \
\>", "Text",
 CellTags->"b:6.3.1",
 CellID->25547],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->21577],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:6.3.1",
 CellID->9789],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[1]:=",
 CellID->25605],

Cell[TextData[{
 "This creates a simple table. The table name is ",
 StyleBox["BATCH",
  FontSlant->"Italic"],
 " with column ",
 StyleBox["X",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Y",
  FontSlant->"Italic"],
 ".",
 " ",
 "The data types for ",
 StyleBox["X",
  FontSlant->"Italic"],
 " and ",
 StyleBox["Y",
  FontSlant->"Italic"],
 " are integers. "
}], "Text",
 CellTags->"b:6.3.1",
 CellID->30195],

Cell[BoxData[{
 RowBox[{
  RowBox[{"table", " ", "=", " ", 
   RowBox[{"SQLTable", "[", "\"\<BATCH\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cols", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<X\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<Y\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", "table", ",", " ", "cols"}], "]"}], 
  ";"}]}], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[3]:=",
 CellID->27594],

Cell[TextData[{
 "Since the table and columns are always the same for this call, it is faster \
to place them directly into a prepared statement rather than substitute \
values for them each time. It is also faster to use a list for the values \
rather than an ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 " expression. This creates the data to be used for the test."
}], "Text",
 CellTags->"b:6.3.1",
 CellID->7950],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", " ", 
       RowBox[{"#", "^", "2"}]}], "}"}], " ", "&"}], " ", "/@", " ", 
    RowBox[{"Range", "[", "10000", "]"}]}]}], ";"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[6]:=",
 CellID->16343],

Cell["\<\
Now the insert operation is carried out. This has reduced the time for the \
operation by a factor of more than 14.\
\>", "Text",
 CellTags->"b:6.3.1",
 CellID->754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO BATCH (X,Y) VALUES (`1`,`2`)\>\"", ",",
      " ", "data2"}], "]"}], ";"}], "]"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[7]:=",
 CellID->2481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.7381556`7.691633645468562", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 CellTags->"b:6.3.1",
 CellLabel->"Out[7]=",
 CellID->1012]
}, Open  ]],

Cell["This confirms that 10,000 inserts have been carried out.", "Text",
 CellTags->"b:6.3.1",
 CellID->11672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], "]"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[9]:=",
 CellID->23439],

Cell[BoxData["10000"], "Output",
 CellTags->"b:6.3.1",
 CellLabel->"Out[9]=",
 CellID->13428]
}, Open  ]],

Cell[TextData[{
 "A final performance improvement can be done by using JDBC syntax for \
substitutions. This limits dynamic values of the types of data that may be \
substituted to only ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLBinary",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBinary"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["SQLDateTime",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDateTime"]], "InlineFormula"],
 ".",
 " ",
 "It also uses '?' instead of the `1` notation (the first parameter in the \
list will replace the first question mark and so on)."
}], "Text",
 CellTags->"b:6.3.1",
 CellID->5912],

Cell["\<\
Now the operation runs nearly 50 times faster than the original simple \
operation of repeated inserts.\
\>", "Text",
 CellTags->"b:6.3.1",
 CellID->9762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"SQLExecute", "[", 
    RowBox[{
    "conn", ",", " ", "\"\<INSERT INTO BATCH (X,Y) VALUES (?,?)\>\"", ",", 
     " ", "data2"}], "]"}], ";"}], "]"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[10]:=",
 CellID->5967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5451894`7.188092396846686", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 CellTags->"b:6.3.1",
 CellLabel->"Out[10]=",
 CellID->24408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], "]"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[12]:=",
 CellID->4415],

Cell[BoxData["20000"], "Output",
 CellTags->"b:6.3.1",
 CellLabel->"Out[12]=",
 CellID->1908]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 " uses this last technique. When you pass a table of values as a parameter \
to ",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 ", it uses the fastest way to insert the data."
}], "Text",
 CellTags->"b:6.3.1",
 CellID->17223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTiming", "[", 
  RowBox[{
   RowBox[{"SQLInsert", "[", 
    RowBox[{"conn", ",", "\"\<BATCH\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
     "data2"}], "]"}], ";"}], "]"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[13]:=",
 CellID->11759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.5754777`7.211573492696209", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 CellTags->"b:6.3.1",
 CellLabel->"Out[13]=",
 CellID->26434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], "]"}]], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[14]:=",
 CellID->5204],

Cell[BoxData["30000"], "Output",
 CellTags->"b:6.3.1",
 CellLabel->"Out[14]=",
 CellID->29486]
}, Open  ]],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:6.3.1",
 CellID->4319],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<BATCH\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.3.1",
 CellLabel->"In[15]:=",
 CellID->958]
}, Open  ]],

Cell[CellGroupData[{

Cell["Result Sets", "Section",
 CellTags->"b:6.3.2",
 CellID->5945],

Cell[TextData[{
 "When many rows of data are returned from a database query, they may require \
a significant amount of memory to hold. For your purposes, you may not need \
to hold all of the data. You may need to use each row individually as part of \
a computation or you may only need to sample the rows. In cases such as \
these, you may find the result set functionality beneficial. This is \
described in ",
 ButtonBox["Result Sets",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ResultSets"],
 "."
}], "Text",
 CellTags->"b:6.3.2",
 CellID->26806]
}, Open  ]],

Cell[CellGroupData[{

Cell["Descriptive Commands", "Section",
 CellTags->{"xref:151", "b:6.3.3"},
 CellID->8166],

Cell[TextData[{
 "If the database is very large, then certain descriptive commands, such as \
querying the number of tables with ",
 Cell[BoxData[
  ButtonBox["SQLTables",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTables"]], "InlineFormula"],
 ", can be slow. In this case, if some of the tables in the database have \
been placed into catalogs, performance can be improved by using the \"",
 StyleBox["Catalog", "MR"],
 "\" or \"",
 StyleBox["Schema", "MR"],
 "\" options. These are described in ",
 ButtonBox["Table Structure: Table Description ",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TableStructure"],
 "and",
 ButtonBox[" Column Structure: Column Description",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/ColumnStructure"],
 ". "
}], "Text",
 CellTags->"b:6.3.3",
 CellID->18700]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Performance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 44.7965245}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "When large amounts of data are being transferred between Mathematica and \
a database, you may find that the operations are slow. In this case it may be \
advantageous to use a batch operation mode. If many small operations are \
being repeated, this will be likely to improve the performance. This section \
will demonstrate how to use batch statements. If you find that the examples \
in this section do not work as shown, you may need to install or restore the \
example database with the DatabaseExamples` package, as described in Using \
the Example Databases. This loads DatabaseLink and connects to the demo \
database.", "synonyms" -> {}, "title" -> "Performance", "type" -> "Tutorial", 
    "uri" -> "DatabaseLink/tutorial/Performance"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:142"->{
  Cell[729, 29, 77, 2, 70, "Title",
   CellTags->{"xref:142", "c:72"},
   CellID->31172]},
 "c:72"->{
  Cell[729, 29, 77, 2, 70, "Title",
   CellTags->{"xref:142", "c:72"},
   CellID->31172]},
 "xref:79"->{
  Cell[831, 35, 101, 2, 70, "Section",
   CellTags->{"xref:79", "c:73", "i:48", "b:6.3.0"},
   CellID->17968]},
 "c:73"->{
  Cell[831, 35, 101, 2, 70, "Section",
   CellTags->{"xref:79", "c:73", "i:48", "b:6.3.0"},
   CellID->17968]},
 "i:48"->{
  Cell[831, 35, 101, 2, 70, "Section",
   CellTags->{"xref:79", "c:73", "i:48", "b:6.3.0"},
   CellID->17968]},
 "b:6.3.0"->{
  Cell[831, 35, 101, 2, 70, "Section",
   CellTags->{"xref:79", "c:73", "i:48", "b:6.3.0"},
   CellID->17968],
  Cell[935, 39, 465, 10, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->27358],
  Cell[1832, 64, 213, 10, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->26268],
  Cell[2048, 76, 287, 9, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->19426],
  Cell[2338, 87, 410, 21, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->28510],
  Cell[2751, 110, 724, 22, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->10422],
  Cell[3478, 134, 401, 15, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->30774],
  Cell[3882, 151, 470, 15, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->8779],
  Cell[4355, 168, 233, 9, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->30910],
  Cell[4613, 181, 359, 12, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->23552],
  Cell[4975, 195, 194, 7, 70, "Output",
   CellTags->"b:6.3.0",
   CellID->4182],
  Cell[5184, 205, 112, 2, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->25391],
  Cell[5321, 211, 200, 6, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->15495],
  Cell[5524, 219, 92, 3, 70, "Output",
   CellTags->"b:6.3.0",
   CellID->5764],
  Cell[5631, 225, 869, 25, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->874],
  Cell[6525, 254, 287, 9, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->1364],
  Cell[6815, 265, 195, 7, 70, "Output",
   CellTags->"b:6.3.0",
   CellID->14902],
  Cell[7047, 277, 201, 6, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->28255],
  Cell[7251, 285, 93, 3, 70, "Output",
   CellTags->"b:6.3.0",
   CellID->4460],
  Cell[7359, 291, 231, 6, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->474],
  Cell[7593, 299, 104, 2, 70, "Text",
   CellTags->"b:6.3.0",
   CellID->6972],
  Cell[7700, 303, 267, 8, 70, "Input",
   CellTags->"b:6.3.0",
   CellID->26821]},
 "xref:143"->{
  Cell[8004, 316, 120, 2, 70, "Section",
   CellTags->{"xref:143", "c:74", "i:49", "b:6.3.1"},
   CellID->26122]},
 "c:74"->{
  Cell[8004, 316, 120, 2, 70, "Section",
   CellTags->{"xref:143", "c:74", "i:49", "b:6.3.1"},
   CellID->26122]},
 "i:49"->{
  Cell[8004, 316, 120, 2, 70, "Section",
   CellTags->{"xref:143", "c:74", "i:49", "b:6.3.1"},
   CellID->26122]},
 "b:6.3.1"->{
  Cell[8004, 316, 120, 2, 70, "Section",
   CellTags->{"xref:143", "c:74", "i:49", "b:6.3.1"},
   CellID->26122],
  Cell[8127, 320, 224, 6, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->25547],
  Cell[8783, 341, 212, 10, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->9789],
  Cell[8998, 353, 287, 9, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->25605],
  Cell[9288, 364, 409, 21, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->30195],
  Cell[9700, 387, 724, 22, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->27594],
  Cell[10427, 411, 513, 12, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->7950],
  Cell[10943, 425, 326, 11, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->16343],
  Cell[11272, 438, 175, 5, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->754],
  Cell[11472, 447, 293, 9, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->2481],
  Cell[11768, 458, 194, 7, 70, "Output",
   CellTags->"b:6.3.1",
   CellID->1012],
  Cell[11977, 468, 110, 2, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->11672],
  Cell[12112, 474, 200, 6, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->23439],
  Cell[12315, 482, 93, 3, 70, "Output",
   CellTags->"b:6.3.1",
   CellID->13428],
  Cell[12423, 488, 1384, 49, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->5912],
  Cell[13810, 539, 164, 5, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->9762],
  Cell[13999, 548, 290, 9, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->5967],
  Cell[14292, 559, 196, 7, 70, "Output",
   CellTags->"b:6.3.1",
   CellID->24408],
  Cell[14525, 571, 200, 6, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->4415],
  Cell[14728, 579, 93, 3, 70, "Output",
   CellTags->"b:6.3.1",
   CellID->1908],
  Cell[14836, 585, 538, 18, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->17223],
  Cell[15399, 607, 338, 10, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->11759],
  Cell[15740, 619, 196, 7, 70, "Output",
   CellTags->"b:6.3.1",
   CellID->26434],
  Cell[15973, 631, 200, 6, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->5204],
  Cell[16176, 639, 94, 3, 70, "Output",
   CellTags->"b:6.3.1",
   CellID->29486],
  Cell[16285, 645, 100, 2, 70, "Text",
   CellTags->"b:6.3.1",
   CellID->4319],
  Cell[16388, 649, 265, 8, 70, "Input",
   CellTags->"b:6.3.1",
   CellID->958]},
 "b:6.3.2"->{
  Cell[16690, 662, 67, 2, 70, "Section",
   CellTags->"b:6.3.2",
   CellID->5945],
  Cell[16760, 666, 574, 13, 70, "Text",
   CellTags->"b:6.3.2",
   CellID->26806]},
 "xref:151"->{
  Cell[17371, 684, 90, 2, 70, "Section",
   CellTags->{"xref:151", "b:6.3.3"},
   CellID->8166]},
 "b:6.3.3"->{
  Cell[17371, 684, 90, 2, 70, "Section",
   CellTags->{"xref:151", "b:6.3.3"},
   CellID->8166],
  Cell[17464, 688, 855, 23, 70, "Text",
   CellTags->"b:6.3.3",
   CellID->18700]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:142", 20229, 757},
 {"c:72", 20331, 761},
 {"xref:79", 20436, 765},
 {"c:73", 20559, 769},
 {"i:48", 20682, 773},
 {"b:6.3.0", 20808, 777},
 {"xref:143", 22643, 844},
 {"c:74", 22769, 848},
 {"i:49", 22895, 852},
 {"b:6.3.1", 23024, 856},
 {"b:6.3.2", 25293, 938},
 {"xref:151", 25475, 945},
 {"b:6.3.3", 25587, 949}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 77, 2, 70, "Title",
 CellTags->{"xref:142", "c:72"},
 CellID->31172],
Cell[CellGroupData[{
Cell[831, 35, 101, 2, 70, "Section",
 CellTags->{"xref:79", "c:73", "i:48", "b:6.3.0"},
 CellID->17968],
Cell[935, 39, 465, 10, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->27358],
Cell[1403, 51, 426, 11, 70, "Text",
 CellID->26031],
Cell[1832, 64, 213, 10, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->26268],
Cell[2048, 76, 287, 9, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->19426],
Cell[2338, 87, 410, 21, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->28510],
Cell[2751, 110, 724, 22, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->10422],
Cell[3478, 134, 401, 15, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->30774],
Cell[3882, 151, 470, 15, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->8779],
Cell[4355, 168, 233, 9, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->30910],
Cell[CellGroupData[{
Cell[4613, 181, 359, 12, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->23552],
Cell[4975, 195, 194, 7, 70, "Output",
 CellTags->"b:6.3.0",
 CellID->4182]
}, Open  ]],
Cell[5184, 205, 112, 2, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->25391],
Cell[CellGroupData[{
Cell[5321, 211, 200, 6, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->15495],
Cell[5524, 219, 92, 3, 70, "Output",
 CellTags->"b:6.3.0",
 CellID->5764]
}, Open  ]],
Cell[5631, 225, 869, 25, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->874],
Cell[CellGroupData[{
Cell[6525, 254, 287, 9, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->1364],
Cell[6815, 265, 195, 7, 70, "Output",
 CellTags->"b:6.3.0",
 CellID->14902]
}, Open  ]],
Cell[CellGroupData[{
Cell[7047, 277, 201, 6, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->28255],
Cell[7251, 285, 93, 3, 70, "Output",
 CellTags->"b:6.3.0",
 CellID->4460]
}, Open  ]],
Cell[7359, 291, 231, 6, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->474],
Cell[7593, 299, 104, 2, 70, "Text",
 CellTags->"b:6.3.0",
 CellID->6972],
Cell[7700, 303, 267, 8, 70, "Input",
 CellTags->"b:6.3.0",
 CellID->26821]
}, Open  ]],
Cell[CellGroupData[{
Cell[8004, 316, 120, 2, 70, "Section",
 CellTags->{"xref:143", "c:74", "i:49", "b:6.3.1"},
 CellID->26122],
Cell[8127, 320, 224, 6, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->25547],
Cell[8354, 328, 426, 11, 70, "Text",
 CellID->21577],
Cell[8783, 341, 212, 10, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->9789],
Cell[8998, 353, 287, 9, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->25605],
Cell[9288, 364, 409, 21, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->30195],
Cell[9700, 387, 724, 22, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->27594],
Cell[10427, 411, 513, 12, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->7950],
Cell[10943, 425, 326, 11, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->16343],
Cell[11272, 438, 175, 5, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->754],
Cell[CellGroupData[{
Cell[11472, 447, 293, 9, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->2481],
Cell[11768, 458, 194, 7, 70, "Output",
 CellTags->"b:6.3.1",
 CellID->1012]
}, Open  ]],
Cell[11977, 468, 110, 2, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->11672],
Cell[CellGroupData[{
Cell[12112, 474, 200, 6, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->23439],
Cell[12315, 482, 93, 3, 70, "Output",
 CellTags->"b:6.3.1",
 CellID->13428]
}, Open  ]],
Cell[12423, 488, 1384, 49, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->5912],
Cell[13810, 539, 164, 5, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->9762],
Cell[CellGroupData[{
Cell[13999, 548, 290, 9, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->5967],
Cell[14292, 559, 196, 7, 70, "Output",
 CellTags->"b:6.3.1",
 CellID->24408]
}, Open  ]],
Cell[CellGroupData[{
Cell[14525, 571, 200, 6, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->4415],
Cell[14728, 579, 93, 3, 70, "Output",
 CellTags->"b:6.3.1",
 CellID->1908]
}, Open  ]],
Cell[14836, 585, 538, 18, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->17223],
Cell[CellGroupData[{
Cell[15399, 607, 338, 10, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->11759],
Cell[15740, 619, 196, 7, 70, "Output",
 CellTags->"b:6.3.1",
 CellID->26434]
}, Open  ]],
Cell[CellGroupData[{
Cell[15973, 631, 200, 6, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->5204],
Cell[16176, 639, 94, 3, 70, "Output",
 CellTags->"b:6.3.1",
 CellID->29486]
}, Open  ]],
Cell[16285, 645, 100, 2, 70, "Text",
 CellTags->"b:6.3.1",
 CellID->4319],
Cell[16388, 649, 265, 8, 70, "Input",
 CellTags->"b:6.3.1",
 CellID->958]
}, Open  ]],
Cell[CellGroupData[{
Cell[16690, 662, 67, 2, 70, "Section",
 CellTags->"b:6.3.2",
 CellID->5945],
Cell[16760, 666, 574, 13, 70, "Text",
 CellTags->"b:6.3.2",
 CellID->26806]
}, Open  ]],
Cell[CellGroupData[{
Cell[17371, 684, 90, 2, 70, "Section",
 CellTags->{"xref:151", "b:6.3.3"},
 CellID->8166],
Cell[17464, 688, 855, 23, 70, "Text",
 CellTags->"b:6.3.3",
 CellID->18700]
}, Open  ]]
}, Open  ]],
Cell[18346, 715, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

