(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76548,       2824]
NotebookOptionsPosition[     49426,       1814]
NotebookOutlinePosition[     63947,       2314]
CellTagsIndexPosition[     63523,       2296]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Infinity" :> Documentation`HelpLookup["paclet:ref/Infinity"], 
         "SQLResultSetClose" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLResultSetClose"], 
         "SQLResultSetColumnNames" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLResultSetColumnNames"], 
         "SQLResultSetCurrent" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLResultSetCurrent"], "SQLResultSetGoto" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLResultSetGoto"],
          "SQLResultSetOpen" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLResultSetOpen"],
          "SQLResultSetPosition" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLResultSetPosition"], "SQLResultSetRead" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLResultSetRead"],
          "SQLResultSetShift" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLResultSetShift"], "SQLResultSetTake" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLResultSetTake"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Infinity\"\>", 2->"\<\"SQLResultSetClose\"\>", 
      3->"\<\"SQLResultSetColumnNames\"\>", 4->"\<\"SQLResultSetCurrent\"\>", 
      5->"\<\"SQLResultSetGoto\"\>", 6->"\<\"SQLResultSetOpen\"\>", 
      7->"\<\"SQLResultSetPosition\"\>", 8->"\<\"SQLResultSetRead\"\>", 
      9->"\<\"SQLResultSetShift\"\>", 
      10->"\<\"SQLResultSetTake\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Result Sets", "Title",
 CellTags->"xref:164",
 CellID->31310],

Cell[TextData[{
 "When many rows of data are returned from a database query, a significant \
amount of memory may be required to hold the result. If all of the data does \
not need to be available at the same time it might be preferable to get the \
result row by row or a few rows at a time. Rows can then be processed \
individually or in small groups. This functionality is provided by the SQL \
result set functions of ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:6.2.0",
 CellID->11058],

Cell[CellGroupData[{

Cell["Basic Result Set Operations", "Section",
 CellTags->{"xref:166", "b:6.2.1"},
 CellID->7926],

Cell["\<\
Result set operations involve creating a result set, reading from it, and \
then closing it. This section discusses the basic ways to work with result \
sets.\
\>", "Text",
 CellTags->"b:6.2.1",
 CellID->9487],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->1670],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLResultSetOpen",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"], "[", 
     StyleBox["query", "TI"], "]"}], Cell[TextData[{
     "create an SQL result set based on ",
     Cell[BoxData[
      StyleBox["query", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetOpen",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"], "[", 
     StyleBox["query", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "create an SQL result set using options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetRead",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"], "[", 
     StyleBox["rs", "TI"], "]"}], Cell[TextData[{
     "read a row from result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetRead",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"], "[", 
     StyleBox["rs", "TI"], ",", 
     StyleBox["num", "TI"], "]"}], Cell[TextData[{
     "read ",
     Cell[BoxData[
      StyleBox["num", "TI"]], "InlineFormula"],
     " rows from result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetClose",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetClose"], "[", 
     StyleBox["rs", "TI"], "]"}], Cell[TextData[{
     "close result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->32528],

Cell["Basic result set functions.", "Caption",
 CellTags->"b:6.0",
 CellID->5651],

Cell[TextData[{
 "The query argument to ",
 Cell[BoxData[
  ButtonBox["SQLResultSetOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"]], 
  "InlineFormula"],
 " is a function that selects data using either ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 ". Here is an example."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->2258],

Cell[TextData[{
 "First, the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " package is loaded and a connection is made to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " example database."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->7213],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DatabaseLink`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[1]:=",
 CellID->9860],

Cell[TextData[{
 "You can use this connection to read eight rows from the ",
 StyleBox["ROYSCHED",
  FontSlant->"Italic"],
 " table."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->25783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", 
    RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[3]:=",
 CellID->21286],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"BS1011\"\>", "0", "5000", "0.1`"},
    {"\<\"BS1011\"\>", "5001", "50000", "0.12`"},
    {"\<\"CP5018\"\>", "0", "2000", "0.1`"},
    {"\<\"CP5018\"\>", "2001", "4000", "0.12`"},
    {"\<\"CP5018\"\>", "4001", "50000", "0.16`"},
    {"\<\"BS1001\"\>", "0", "1000", "0.1`"},
    {"\<\"BS1001\"\>", "1001", "5000", "0.12`"},
    {"\<\"BS1001\"\>", "5001", "7000", "0.16`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[3]//TableForm=",
 CellID->2742]
}, Open  ]],

Cell["You can also obtain a result set from the same query.", "Text",
 CellTags->"b:6.2.1",
 CellID->8610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", 
     RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "]"}]}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[4]:=",
 CellID->4472],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"0", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[4]=",
 CellID->7128]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLResultSetRead",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"]], 
  "InlineFormula"],
 " reads from the result set and returns the rows that were read. After \
reading from a result set, the next read will read the next row. The \
following example reads a single row. Since the result set was just created, \
it reads the first row."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->18434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetRead", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[5]:=",
 CellID->5841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], 
  "}"}]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[5]=",
 CellID->20718]
}, Open  ]],

Cell["The following reads the second and third rows.", "Text",
 CellTags->"b:6.2.1",
 CellID->3503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetRead", "[", 
  RowBox[{"rs", ",", "2"}], "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[6]:=",
 CellID->14867],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[6]=",
 CellID->24865]
}, Open  ]],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["SQLResultSetRead",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"]], 
  "InlineFormula"],
 " maps data types into various ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. However, setting the option ",
 Cell[BoxData["\"\<GetAsStrings\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " gets results as string expressions. "
}], "Text",
 CellTags->"b:6.2.1",
 CellID->10938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetRead", "[", 
   RowBox[{"rs", ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", " ", "\[Rule]", " ", "True"}]}], "]"}], "//",
   "InputForm"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[7]:=",
 CellID->1881],

Cell["{\"CP5018\", \"2001\", \"4000\", \"0.12\"}", "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[7]//InputForm=",
 CellID->9257]
}, Open  ]],

Cell[TextData[{
 "If you want to process each row individually, you can use a construct like \
the following. It reads the remaining rows and sums the last element of each \
row. Since there were eight rows in the result set and four had already been \
read, this operation will read four rows. When ",
 Cell[BoxData[
  ButtonBox["SQLResultSetRead",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"]], 
  "InlineFormula"],
 " returns something that is not a list you have reached the end of the \
result set."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->22750],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"res", "=", "0"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", " ", 
     RowBox[{"data", "=", 
      RowBox[{"SQLResultSetRead", "[", "rs", "]"}]}], "]"}], ",", 
    RowBox[{"res", "+=", 
     RowBox[{"Last", "[", "data", "]"}]}]}], "]"}], 
  ";"}], "\n", "res"}], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[8]:=",
 CellID->28614],

Cell[BoxData["0.54`"], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[9]=",
 CellID->18598]
}, Open  ]],

Cell[TextData[{
 "If you call ",
 Cell[BoxData[
  ButtonBox["SQLResultSetRead",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"]], 
  "InlineFormula"],
 " again it will return ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " because the end of the result set has been reached."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->28458],

Cell[BoxData[
 RowBox[{"SQLResultSetRead", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[10]:=",
 CellID->2661],

Cell["This closes the result set and the SQL connection.", "Text",
 CellTags->"b:6.2.1",
 CellID->26063],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLResultSetClose", "[", "rs", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[11]:=",
 CellID->32756]
}, Open  ]],

Cell[CellGroupData[{

Cell["SQLResultSet Options", "Section",
 CellTags->{"xref:167", "b:6.2.2"},
 CellID->20807],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLResultSetOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"]], 
  "InlineFormula"],
 " takes an option, ",
 Cell[BoxData["\"\<Mode\>\""], "InlineFormula"],
 ", that controls movement in the result set and whether the result is \
sensitive to changes in the database."
}], "Text",
 CellTags->"b:6.2.2",
 CellID->20278],

Cell[TextData[{
 "First, the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " package is loaded and a connection is made to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " example database."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->156004215],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DatabaseLink`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[1]:=",
 CellID->34901447],

Cell["\<\
This opens a result set, but you can only move forwards in this result set.\
\>", "Text",
 CellID->108399858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{
    RowBox[{"SQLExecute", "[", 
     RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", 
      RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], ",", " ", 
    RowBox[{"Mode", "\[Rule]", "\"\<ForwardOnly\>\""}]}], "]"}]}]], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[3]:=",
 CellID->352657795],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"0", ",", "\<\"<>\"\>", ",", "\<\"ForwardOnly\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.1",
 CellLabel->"Out[3]=",
 CellID->598251897]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["setting", "TableHeader"], Cell["description", "TableHeader"]},
   {"\"\<ForwardOnly\>\"", Cell[
    "only moving forwards is possible", "TableText"]},
   {"\"\<ScrollInsensitive\>\"", Cell["\<\
forward and backward moving is possible and result set does not pick up \
changes to the database\
\>", "TableText"]},
   {"\"\<ScrollSensitive\>\"", Cell["\<\
forward and backward moving is possible and  result set picks up changes to \
the database\
\>", "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, 
    "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->29385656],

Cell[TextData[{
 "Settings of the ",
 Cell[BoxData["Mode"], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["SQLResultSetOpen",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetOpen"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:6.4",
 CellID->7293938],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<ForwardOnly\>\""], "InlineFormula"],
 " setting of the ",
 Cell[BoxData["\"\<Mode\>\""], "InlineFormula"],
 " option means that you can only move forwards in the result set and the \
result set is insensitive to any changes to the database after the result set \
has been created."
}], "Text",
 CellTags->"b:6.2.2",
 CellID->19489],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<ScrollInsensitive\>"], "InlineFormula"],
 StyleBox["\"", "MR"],
 " setting of the ",
 Cell[BoxData["\"\<Mode\>\""], "InlineFormula"],
 " option means that you can move forwards and backwards in the result set \
and the result set is insensitive to any changes to the database after the \
result set has been created."
}], "Text",
 CellTags->"b:6.2.2",
 CellID->19435],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<ScrollSensitive\>\""], "InlineFormula"],
 " setting of the ",
 Cell[BoxData["\"\<Mode\>\""], "InlineFormula"],
 " option means that you can move forwards and backwards in the result set \
and the result set is sensitive to any changes to the database after the \
result set has been created."
}], "Text",
 CellTags->"b:6.2.2",
 CellID->6365],

Cell["\<\
You should note that not all databases support moving backwards in the result \
set or can detect changes in the data.\
\>", "Text",
 CellTags->"b:6.2.2",
 CellID->32075],

Cell[TextData[{
 "In addition you use ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 " to change options of a result set after it has been created. The following \
sets the direction in which it is expected that result will be retrieved from \
the result set. This helps the driver to optimize retrieval of data."
}], "Text",
 CellID->849470055],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"rs", ",", 
   RowBox[{"FetchDirection", "\[Rule]", "\"\<Forward\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->493757],

Cell[BoxData[GridBox[{
   {Cell["setting", "TableHeader"], Cell["description", "TableHeader"]},
   {"\"\<FetchDirection\>\"", Cell["\<\
gives a hint as the direction in which rows will be processed\
\>", "TableText"]},
   {"\"\<FetchSize\>\"", Cell["\<\
gives a hint as to the number of rows that should be fetched from the \
database\
\>", "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, 
    "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->45415718],

Cell[TextData[{
 Cell[BoxData["SQLResultSet"], "InlineFormula"],
 " options."
}], "Caption",
 CellTags->"b:6.4",
 CellID->59131214]
}, Open  ]],

Cell[CellGroupData[{

Cell["Result Set Positions", "Section",
 CellTags->{"xref:168", "b:6.2.3"},
 CellID->7586],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->1386],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLResultSetShift",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetShift"], "[", 
     StyleBox["rs", "TI"], ",", 
     StyleBox["num", "TI"], "]"}], Cell[TextData[{
     "shift current position by ",
     Cell[BoxData[
      StyleBox["num", "TI"]], "InlineFormula"],
     " in result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetGoto",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"], "[", 
     StyleBox["rs", "TI"], ",", 
     StyleBox["num", "TI"], "]"}], Cell[TextData[{
     "move current position to ",
     Cell[BoxData[
      StyleBox["num", "TI"]], "InlineFormula"],
     " in result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetPosition"], "[", 
     StyleBox["rs", "TI"], "]"}], Cell[TextData[{
     "return current position in result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetCurrent",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetCurrent"], "[", 
     StyleBox["rs", "TI"], "]"}], Cell[TextData[{
     "read the row at the current position in result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->7833],

Cell["Result set position functions.", "Caption",
 CellTags->"b:6.0",
 CellID->8360],

Cell["\<\
A result set is created from a database query, and it can be seen as an array \
of the rows that match the query. The array actually has two extra positions, \
one before the first row and one after the last row. When the result set is \
created, its current position is before the first row.\
\>", "Text",
 CellTags->"b:6.2.3",
 CellID->13330],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and creates a result set from a query to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->26048],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DatabaseLink`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", 
     RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "]"}]}]}], "Input",\

 CellTags->"b:6.2.3",
 CellLabel->"In[1]:=",
 CellID->8928],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"0", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[3]=",
 CellID->29492]
}, Open  ]],

Cell["\<\
The position is 0, which means that the current position is before the first \
row.\
\>", "Text",
 CellTags->"b:6.2.3",
 CellID->12433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[4]:=",
 CellID->23840],

Cell[BoxData["0"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[4]=",
 CellID->6766]
}, Open  ]],

Cell[TextData[{
 "If a read is done at the current position, the result is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " because there is nothing to read before the first row."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->1735],

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[5]:=",
 CellID->19810],

Cell[TextData[{
 "The following shifts the result set by two. The result is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", which means that there is something to read at the new position."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->11599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetShift", "[", 
  RowBox[{"rs", ",", "2"}], "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[6]:=",
 CellID->11837],

Cell[BoxData["True"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[6]=",
 CellID->21892]
}, Open  ]],

Cell["The result set is now positioned at the second row.", "Text",
 CellTags->"b:6.2.3",
 CellID->31982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[7]:=",
 CellID->7328],

Cell[BoxData["2"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[7]=",
 CellID->29352]
}, Open  ]],

Cell["The following reads the row at the current position.", "Text",
 CellTags->"b:6.2.3",
 CellID->11369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[8]:=",
 CellID->31244],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
  "}"}]], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[8]=",
 CellID->21794]
}, Open  ]],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["SQLResultSetCurrent",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetCurrent"]], 
  "InlineFormula"],
 " maps data types into various ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. However, setting the option ",
 Cell[BoxData["\"\<GetAsStrings\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " gets results as string expressions. "
}], "Text",
 CellTags->"b:6.2.3",
 CellID->6608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetCurrent", "[", 
   RowBox[{"rs", ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[9]:=",
 CellID->9252],

Cell["{\"BS1011\", \"5001\", \"50000\", \"0.12\"}", "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[9]//InputForm=",
 CellID->11647]
}, Open  ]],

Cell[TextData[{
 "Now an absolute move is carried out to the eighth row. The result is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", which tells you there is something to be read."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->17432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetGoto", "[", 
  RowBox[{"rs", ",", " ", "8"}], "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[10]:=",
 CellID->9535],

Cell[BoxData["True"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[10]=",
 CellID->7208]
}, Open  ]],

Cell["This reads the last row in the result set.", "Text",
 CellTags->"b:6.2.3",
 CellID->3264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[11]:=",
 CellID->3497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], 
  "}"}]], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[11]=",
 CellID->23243]
}, Open  ]],

Cell[TextData[{
 "Now a shift of one is done and the result is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". This means that there is nothing to be read from this position."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->27649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetShift", "[", 
  RowBox[{"rs", ",", "1"}], "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[12]:=",
 CellID->22015],

Cell[BoxData["False"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[12]=",
 CellID->26841]
}, Open  ]],

Cell["\<\
The current position is nine, which means that the current position is after \
the last row.\
\>", "Text",
 CellTags->"b:6.2.3",
 CellID->189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[13]:=",
 CellID->16100],

Cell[BoxData["9"], "Output",
 CellTags->"b:6.2.3",
 CellLabel->"Out[13]=",
 CellID->19812]
}, Open  ]],

Cell[TextData[{
 "If a read is done the result is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 "; there is nothing to read after the last row."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->30648],

Cell[BoxData[
 RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[14]:=",
 CellID->9523],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLResultSetShift",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetShift"]], 
  "InlineFormula"],
 " can take a negative shift. If the result set allows moving backwards, this \
will shift backwards. ",
 Cell[BoxData[
  ButtonBox["SQLResultSetGoto",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"]], 
  "InlineFormula"],
 " also can take negative settings, these are interpreted as counting from \
the end of the result set. The following table summarizes how various \
arguments work."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->19851],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLResultSetShift",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetShift"], "[", 
     StyleBox["rs", "TI"], ",", "-", 
     StyleBox["num", "TI"], "]"}], Cell[TextData[{
     "shift ",
     Cell[BoxData[
      StyleBox["num", "TI"]], "InlineFormula"],
     " positions to the left in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetGoto",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"], "[", 
     StyleBox["rs", "TI"], ",", "0", "]"}], Cell[TextData[{
     "move to before the first row in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetGoto",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"], "[", 
     StyleBox["rs", "TI"], ",", "3", "]"}], Cell[TextData[{
     "move to the third row in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetGoto",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"], "[", 
     StyleBox["rs", "TI"], ",", "-", "2", "]"}], Cell[TextData[{
     "move to the second row from the end in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetGoto",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"], "[", 
     StyleBox["rs", "TI"], ",", "-", "1", "]"}], Cell[TextData[{
     "move to last row in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetGoto",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetGoto"], "[", 
     StyleBox["rs", "TI"], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "]"}], Cell[TextData[{
     "move to after the last row in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->24474],

Cell["Examples of result set position functions.", "Caption",
 CellTags->"b:6.0",
 CellID->28633],

Cell["This closes the result set and the SQL connection.", "Text",
 CellTags->"b:6.2.3",
 CellID->29891],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLResultSetClose", "[", "rs", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.2.3",
 CellLabel->"In[15]:=",
 CellID->27200],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SQLResultSetRead",
    BaseStyle->"Link",
    ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"], "[", 
   StyleBox["rs", "TI"], "]"}]], "InlineFormula"],
 " can be seen as equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["SQLResultSetShift",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLResultSetShift"], "[", 
    RowBox[{
     StyleBox["rs", "TI"], ",", "1"}], "]"}], ";", 
   RowBox[{
    ButtonBox["SQLResultSetCurrent",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLResultSetCurrent"], "[", 
    StyleBox["rs", "TI"], "]"}]}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.2.3",
 CellID->19854]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Result Set Operations", "Section",
 CellTags->{"xref:169", "b:6.2.4"},
 CellID->9990],

Cell["This section discusses advanced result set operations.", "Text",
 CellTags->"b:6.2.4",
 CellID->25697],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->4919],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLResultSetTake",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetTake"], "[", 
     StyleBox["rs", "TI"], ",", 
     StyleBox["spec", "TI"], "]"}], Cell[TextData[{
     "use specification ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to read from the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetRead",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"], "[", 
     StyleBox["rs", "TI"], ",", "-", 
     StyleBox["num", "TI"], "]"}], Cell[TextData[{
     "shift current position by ",
     Cell[BoxData[
      StyleBox["num", "TI"]], "InlineFormula"],
     " in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLResultSetColumnNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLResultSetColumnNames"], "[", 
     StyleBox["rs", "TI"], "]"}], Cell[TextData[{
     "return the names of the columns in the result set ",
     Cell[BoxData[
      StyleBox["rs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->17780],

Cell["Advanced result set functions.", "Caption",
 CellTags->"b:6.0",
 CellID->22578],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and creates a result set from a query to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:6.2.4",
 CellID->12931],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DatabaseLink`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", " ", 
     RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "]"}]}]}], "Input",\

 CellTags->"b:6.2.4",
 CellLabel->"In[1]:=",
 CellID->32544],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"0", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[3]=",
 CellID->3340]
}, Open  ]],

Cell["This shows the rows that are in the result set.", "Text",
 CellTags->"b:6.2.4",
 CellID->13487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", 
    RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[4]:=",
 CellID->899],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"BS1011\"\>", "0", "5000", "0.1`"},
    {"\<\"BS1011\"\>", "5001", "50000", "0.12`"},
    {"\<\"CP5018\"\>", "0", "2000", "0.1`"},
    {"\<\"CP5018\"\>", "2001", "4000", "0.12`"},
    {"\<\"CP5018\"\>", "4001", "50000", "0.16`"},
    {"\<\"BS1001\"\>", "0", "1000", "0.1`"},
    {"\<\"BS1001\"\>", "1001", "5000", "0.12`"},
    {"\<\"BS1001\"\>", "5001", "7000", "0.16`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[4]//TableForm=",
 CellID->22525]
}, Open  ]],

Cell["The following gets rows two through four.", "Text",
 CellTags->"b:6.2.4",
 CellID->8483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetTake", "[", " ", 
  RowBox[{"rs", ",", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[5]:=",
 CellID->5538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[5]=",
 CellID->7492]
}, Open  ]],

Cell["After the read, the position is at the fourth row.", "Text",
 CellTags->"b:6.2.4",
 CellID->6193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[6]:=",
 CellID->28252],

Cell[BoxData["4"], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[6]=",
 CellID->25011]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLResultSetTake",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetTake"]], 
  "InlineFormula"],
 " can take from the end of the result set. The following reads the last \
three rows of the result set."
}], "Text",
 CellTags->"b:6.2.4",
 CellID->1560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetTake", "[", " ", 
  RowBox[{"rs", ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[7]:=",
 CellID->15834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[7]=",
 CellID->1840]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[8]:=",
 CellID->31497],

Cell[BoxData["8"], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[8]=",
 CellID->2785]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLResultSetRead",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetRead"]], 
  "InlineFormula"],
 " can also take a negative number. This means that it shifts one position to \
the left and reads. This is repeated till the requested number has been read. \
The following goes to the end of the result set and then reads the previous \
four rows."
}], "Text",
 CellTags->"b:6.2.4",
 CellID->18529],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLResultSetGoto", "[", 
   RowBox[{"rs", ",", "Infinity"}], "]"}], ";"}], "\n", 
 RowBox[{"SQLResultSetRead", "[", " ", 
  RowBox[{"rs", ",", " ", 
   RowBox[{"-", "4"}]}], "]"}]}], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[9]:=",
 CellID->31540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "4001", ",", "50000", ",", "0.16`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[10]=",
 CellID->18805]
}, Open  ]],

Cell["\<\
After the read, the current position is the last thing that was read.\
\>", "Text",
 CellTags->"b:6.2.4",
 CellID->28791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetPosition", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[11]:=",
 CellID->13392],

Cell[BoxData["5"], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[11]=",
 CellID->13210]
}, Open  ]],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["SQLResultSetTake",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetTake"]], 
  "InlineFormula"],
 " maps data types into various ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. However, setting the option ",
 Cell[BoxData["\"\<GetAsStrings\>\""], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " gets results as string expressions. "
}], "Text",
 CellTags->"b:6.2.4",
 CellID->13549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLResultSetTake", "[", 
   RowBox[{"rs", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"\"\<GetAsStrings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[12]:=",
 CellID->21578],

Cell["\<\
{{\"BS1011\", \"5001\", \"50000\", \"0.12\"}, {\"CP5018\", \"0\", \"2000\", \
\"0.1\"}}\
\>", "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[12]//InputForm=",
 CellID->26979]
}, Open  ]],

Cell[TextData[{
 "Finally, you can get the names of the columns in a result set by using ",
 Cell[BoxData[
  ButtonBox["SQLResultSetColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLResultSetColumnNames"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.2.4",
 CellID->30971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetColumnNames", "[", "rs", "]"}]], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[13]:=",
 CellID->9277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", "\<\"TITLE_ID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", "\<\"LORANGE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", "\<\"HIRANGE\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", "\<\"ROYALTY\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:6.2.4",
 CellLabel->"Out[13]=",
 CellID->73]
}, Open  ]],

Cell["This closes the result set and the SQL connection.", "Text",
 CellTags->"b:6.2.4",
 CellID->20193],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLResultSetClose", "[", "rs", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.2.4",
 CellLabel->"In[14]:=",
 CellID->1620]
}, Open  ]],

Cell[CellGroupData[{

Cell["Result Set Examples", "Section",
 CellTags->{"xref:170", "b:6.2.5"},
 CellID->21497],

Cell["\<\
This section discusses common examples of result set operations.\
\>", "Text",
 CellTags->"b:6.2.5",
 CellID->13826],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->31276],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DatabaseLink`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{"rs", "=", 
  RowBox[{"SQLResultSetOpen", "[", 
   RowBox[{"SQLExecute", "[", 
    RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", " ", 
     RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "]"}]}]}], "Input",\

 CellTags->"b:6.2.5",
 CellLabel->"In[1]:=",
 CellID->19790],

Cell[BoxData[
 RowBox[{"SQLResultSet", "[", 
  RowBox[{"0", ",", "\<\"<>\"\>", ",", "\<\"Scrollable\"\>"}], 
  "]"}]], "Output",
 CellTags->"b:6.2.5",
 CellLabel->"Out[3]=",
 CellID->6582]
}, Open  ]],

Cell["This shows the rows that are in the result set.", "Text",
 CellTags->"b:6.2.5",
 CellID->13578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", " ", "\"\<SELECT * FROM roysched\>\"", ",", 
    RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "8"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:6.2.5",
 CellLabel->"In[4]:=",
 CellID->11159],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"BS1011\"\>", "0", "5000", "0.1`"},
    {"\<\"BS1011\"\>", "5001", "50000", "0.12`"},
    {"\<\"CP5018\"\>", "0", "2000", "0.1`"},
    {"\<\"CP5018\"\>", "2001", "4000", "0.12`"},
    {"\<\"CP5018\"\>", "4001", "50000", "0.16`"},
    {"\<\"BS1001\"\>", "0", "1000", "0.1`"},
    {"\<\"BS1001\"\>", "1001", "5000", "0.12`"},
    {"\<\"BS1001\"\>", "5001", "7000", "0.16`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.2.5",
 CellLabel->"Out[4]//TableForm=",
 CellID->20418]
}, Open  ]],

Cell["\<\
One common operation is to iterate over all the rows, operating on each of \
the rows one at a time. The following example sums the last element of each \
row.\
\>", "Text",
 CellTags->"b:6.2.5",
 CellID->26489],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"res", "=", "0"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", " ", 
     RowBox[{"data", "=", 
      RowBox[{"SQLResultSetRead", "[", "rs", "]"}]}], "]"}], ",", 
    RowBox[{"res", "+=", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"-", "1"}], "]"}], "]"}]}]}], "]"}], 
  ";"}], "\n", "res"}], "Input",
 CellTags->"b:6.2.5",
 CellLabel->"In[5]:=",
 CellID->159],

Cell[BoxData["0.98`"], "Output",
 CellTags->"b:6.2.5",
 CellLabel->"Out[6]=",
 CellID->3449]
}, Open  ]],

Cell["The following resets the result set to the beginning.", "Text",
 CellTags->"b:6.2.5",
 CellID->12924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLResultSetGoto", "[", 
  RowBox[{"rs", ",", "0"}], "]"}]], "Input",
 CellTags->"b:6.2.5",
 CellLabel->"In[7]:=",
 CellID->9072],

Cell[BoxData["False"], "Output",
 CellTags->"b:6.2.5",
 CellLabel->"Out[7]=",
 CellID->10380]
}, Open  ]],

Cell[TextData[{
 "This example extracts every second row of the result set. It does this by \
shifting and reading the current row. The result is formed by using ",
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.2.5",
 CellID->27008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"Reap", "[", "  ", 
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"SQLResultSetShift", "[", 
      RowBox[{"rs", ",", "2"}], "]"}], ",", 
     RowBox[{"Sow", "[", 
      RowBox[{"SQLResultSetCurrent", "[", "rs", "]"}], "]"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellTags->"b:6.2.5",
 CellLabel->"In[8]:=",
 CellID->27967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], 
     "}"}]}], "}"}], "}"}]], "Output",
 CellTags->"b:6.2.5",
 CellLabel->"Out[8]=",
 CellID->10208]
}, Open  ]],

Cell["This closes the result set and the SQL connection.", "Text",
 CellTags->"b:6.2.5",
 CellID->6477],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLResultSetClose", "[", "rs", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", " ", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.2.5",
 CellLabel->"In[9]:=",
 CellID->18503]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Result Sets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 45.6402691}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "When many rows of data are returned from a database query, a significant \
amount of memory may be required to hold the result. If all of the data does \
not need to be available at the same time it might be preferable to get the \
result row by row or a few rows at a time. Rows can then be processed \
individually or in small groups. This functionality is provided by the SQL \
result set functions of DatabaseLink. Result set operations involve creating \
a result set, reading from it, and then closing it. This section discusses \
the basic ways to work with result sets. If you find that the examples in \
this section do not work as shown, you may need to install or restore the \
example database with the DatabaseExamples` package, as described in Using \
the Example Databases.", "synonyms" -> {}, "title" -> "Result Sets", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/ResultSets"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:164"->{
  Cell[2576, 66, 67, 2, 70, "Title",
   CellTags->"xref:164",
   CellID->31310]},
 "b:6.2.0"->{
  Cell[2646, 70, 530, 12, 70, "Text",
   CellTags->"b:6.2.0",
   CellID->11058]},
 "xref:166"->{
  Cell[3201, 86, 97, 2, 70, "Section",
   CellTags->{"xref:166", "b:6.2.1"},
   CellID->7926]},
 "b:6.2.1"->{
  Cell[3201, 86, 97, 2, 70, "Section",
   CellTags->{"xref:166", "b:6.2.1"},
   CellID->7926],
  Cell[3301, 90, 219, 6, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->9487],
  Cell[5887, 174, 597, 20, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->2258],
  Cell[6487, 196, 273, 10, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->7213],
  Cell[6763, 208, 255, 9, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->9860],
  Cell[7021, 219, 183, 7, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->25783],
  Cell[7229, 230, 275, 8, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->21286],
  Cell[7507, 240, 907, 25, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->2742],
  Cell[8429, 268, 106, 2, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->8610],
  Cell[8560, 274, 309, 8, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->4472],
  Cell[8872, 284, 188, 6, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->7128],
  Cell[9075, 293, 465, 12, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->18434],
  Cell[9565, 309, 130, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->5841],
  Cell[9698, 315, 176, 6, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->20718],
  Cell[9889, 324, 99, 2, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->3503],
  Cell[10013, 330, 154, 5, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->14867],
  Cell[10170, 337, 323, 11, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->24865],
  Cell[10508, 351, 581, 20, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->10938],
  Cell[11114, 375, 257, 8, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->1881],
  Cell[11374, 385, 131, 3, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->9257],
  Cell[11520, 391, 590, 14, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->22750],
  Cell[12135, 409, 395, 13, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->28614],
  Cell[12533, 424, 93, 3, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->18598],
  Cell[12641, 430, 427, 15, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->28458],
  Cell[13071, 447, 131, 4, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->2661],
  Cell[13205, 453, 104, 2, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->26063],
  Cell[13312, 457, 234, 7, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->32756],
  Cell[14080, 487, 278, 10, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->156004215],
  Cell[14361, 499, 259, 9, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->34901447],
  Cell[14767, 517, 398, 10, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->352657795],
  Cell[15168, 529, 194, 6, 70, "Output",
   CellTags->"b:6.2.1",
   CellID->598251897]},
 "b:6.0"->{
  Cell[5803, 170, 81, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->5651],
  Cell[21245, 730, 84, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->8360],
  Cell[31434, 1128, 97, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->28633],
  Cell[34636, 1237, 85, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->22578]},
 "xref:167"->{
  Cell[13583, 469, 91, 2, 70, "Section",
   CellTags->{"xref:167", "b:6.2.2"},
   CellID->20807]},
 "b:6.2.2"->{
  Cell[13583, 469, 91, 2, 70, "Section",
   CellTags->{"xref:167", "b:6.2.2"},
   CellID->20807],
  Cell[13677, 473, 400, 12, 70, "Text",
   CellTags->"b:6.2.2",
   CellID->20278],
  Cell[16370, 571, 375, 10, 70, "Text",
   CellTags->"b:6.2.2",
   CellID->19489],
  Cell[16748, 583, 411, 11, 70, "Text",
   CellTags->"b:6.2.2",
   CellID->19435],
  Cell[17162, 596, 385, 10, 70, "Text",
   CellTags->"b:6.2.2",
   CellID->6365],
  Cell[17550, 608, 180, 5, 70, "Text",
   CellTags->"b:6.2.2",
   CellID->32075]},
 "b:6.4"->{
  Cell[16065, 557, 302, 12, 70, "Caption",
   CellTags->"b:6.4",
   CellID->7293938],
  Cell[18895, 651, 131, 5, 70, "Caption",
   CellTags->"b:6.4",
   CellID->59131214]},
 "xref:168"->{
  Cell[19063, 661, 90, 2, 70, "Section",
   CellTags->{"xref:168", "b:6.2.3"},
   CellID->7586]},
 "b:6.2.3"->{
  Cell[19063, 661, 90, 2, 70, "Section",
   CellTags->{"xref:168", "b:6.2.3"},
   CellID->7586],
  Cell[21332, 734, 354, 7, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->13330],
  Cell[21689, 743, 261, 10, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->26048],
  Cell[21975, 757, 490, 15, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->8928],
  Cell[22468, 774, 189, 6, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->29492],
  Cell[22672, 783, 145, 5, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->12433],
  Cell[22842, 792, 135, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->23840],
  Cell[22980, 798, 88, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->6766],
  Cell[23083, 804, 296, 9, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->1735],
  Cell[23382, 815, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->19810],
  Cell[23519, 821, 309, 9, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->11599],
  Cell[23853, 834, 155, 5, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->11837],
  Cell[24011, 841, 92, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->21892],
  Cell[24118, 847, 105, 2, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->31982],
  Cell[24248, 853, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->7328],
  Cell[24385, 859, 89, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->29352],
  Cell[24489, 865, 106, 2, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->11369],
  Cell[24620, 871, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->31244],
  Cell[24757, 877, 181, 6, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->21794],
  Cell[24953, 886, 586, 20, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->6608],
  Cell[25564, 910, 250, 8, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->9252],
  Cell[25817, 920, 133, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->11647],
  Cell[25965, 926, 302, 9, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->17432],
  Cell[26292, 939, 159, 5, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->9535],
  Cell[26454, 946, 92, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->7208],
  Cell[26561, 952, 95, 2, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->3264],
  Cell[26681, 958, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->3497],
  Cell[26818, 964, 181, 6, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->23243],
  Cell[27014, 973, 297, 9, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->27649],
  Cell[27336, 986, 156, 5, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->22015],
  Cell[27495, 993, 94, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->26841],
  Cell[27604, 999, 152, 5, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->189],
  Cell[27781, 1008, 136, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->16100],
  Cell[27920, 1014, 90, 3, 70, "Output",
   CellTags->"b:6.2.3",
   CellID->19812],
  Cell[28025, 1020, 263, 9, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->30648],
  Cell[28291, 1031, 134, 4, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->9523],
  Cell[28428, 1037, 640, 18, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->19851],
  Cell[31534, 1132, 104, 2, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->29891],
  Cell[31641, 1136, 234, 7, 70, "Input",
   CellTags->"b:6.2.3",
   CellID->27200],
  Cell[31878, 1145, 734, 24, 70, "Text",
   CellTags->"b:6.2.3",
   CellID->19854]},
 "xref:169"->{
  Cell[32649, 1174, 100, 2, 70, "Section",
   CellTags->{"xref:169", "b:6.2.4"},
   CellID->9990]},
 "b:6.2.4"->{
  Cell[32649, 1174, 100, 2, 70, "Section",
   CellTags->{"xref:169", "b:6.2.4"},
   CellID->9990],
  Cell[32752, 1178, 108, 2, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->25697],
  Cell[34724, 1241, 261, 10, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->12931],
  Cell[35010, 1255, 496, 15, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->32544],
  Cell[35509, 1272, 188, 6, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->3340],
  Cell[35712, 1281, 101, 2, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->13487],
  Cell[35838, 1287, 273, 8, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->899],
  Cell[36114, 1297, 908, 25, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->22525],
  Cell[37037, 1325, 94, 2, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->8483],
  Cell[37156, 1331, 212, 7, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->5538],
  Cell[37371, 1340, 430, 14, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->7492],
  Cell[37816, 1357, 103, 2, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->6193],
  Cell[37944, 1363, 135, 4, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->28252],
  Cell[38082, 1369, 89, 3, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->25011],
  Cell[38186, 1375, 321, 10, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->1560],
  Cell[38532, 1389, 255, 9, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->15834],
  Cell[38790, 1400, 428, 14, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->1840],
  Cell[39255, 1419, 135, 4, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->31497],
  Cell[39393, 1425, 88, 3, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->2785],
  Cell[39496, 1431, 466, 12, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->18529],
  Cell[39987, 1447, 288, 9, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->31540],
  Cell[40278, 1458, 537, 17, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->18805],
  Cell[40830, 1478, 131, 4, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->28791],
  Cell[40986, 1486, 136, 4, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->13392],
  Cell[41125, 1492, 90, 3, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->13210],
  Cell[41230, 1498, 581, 20, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->13549],
  Cell[41836, 1522, 305, 10, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->21578],
  Cell[42144, 1534, 186, 6, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->26979],
  Cell[42345, 1543, 311, 10, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->30971],
  Cell[42681, 1557, 138, 4, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->9277],
  Cell[42822, 1563, 468, 14, 70, "Output",
   CellTags->"b:6.2.4",
   CellID->73],
  Cell[43305, 1580, 104, 2, 70, "Text",
   CellTags->"b:6.2.4",
   CellID->20193],
  Cell[43412, 1584, 233, 7, 70, "Input",
   CellTags->"b:6.2.4",
   CellID->1620]},
 "xref:170"->{
  Cell[43682, 1596, 90, 2, 70, "Section",
   CellTags->{"xref:170", "b:6.2.5"},
   CellID->21497]},
 "b:6.2.5"->{
  Cell[43682, 1596, 90, 2, 70, "Section",
   CellTags->{"xref:170", "b:6.2.5"},
   CellID->21497],
  Cell[43775, 1600, 126, 4, 70, "Text",
   CellTags->"b:6.2.5",
   CellID->13826],
  Cell[44371, 1621, 496, 15, 70, "Input",
   CellTags->"b:6.2.5",
   CellID->19790],
  Cell[44870, 1638, 188, 6, 70, "Output",
   CellTags->"b:6.2.5",
   CellID->6582],
  Cell[45073, 1647, 101, 2, 70, "Text",
   CellTags->"b:6.2.5",
   CellID->13578],
  Cell[45199, 1653, 275, 8, 70, "Input",
   CellTags->"b:6.2.5",
   CellID->11159],
  Cell[45477, 1663, 908, 25, 70, "Output",
   CellTags->"b:6.2.5",
   CellID->20418],
  Cell[46400, 1691, 221, 6, 70, "Text",
   CellTags->"b:6.2.5",
   CellID->26489],
  Cell[46646, 1701, 440, 15, 70, "Input",
   CellTags->"b:6.2.5",
   CellID->159],
  Cell[47089, 1718, 92, 3, 70, "Output",
   CellTags->"b:6.2.5",
   CellID->3449],
  Cell[47196, 1724, 107, 2, 70, "Text",
   CellTags->"b:6.2.5",
   CellID->12924],
  Cell[47328, 1730, 153, 5, 70, "Input",
   CellTags->"b:6.2.5",
   CellID->9072],
  Cell[47484, 1737, 93, 3, 70, "Output",
   CellTags->"b:6.2.5",
   CellID->10380],
  Cell[47592, 1743, 449, 15, 70, "Text",
   CellTags->"b:6.2.5",
   CellID->27008],
  Cell[48066, 1762, 375, 12, 70, "Input",
   CellTags->"b:6.2.5",
   CellID->27967],
  Cell[48444, 1776, 574, 18, 70, "Output",
   CellTags->"b:6.2.5",
   CellID->10208],
  Cell[49033, 1797, 103, 2, 70, "Text",
   CellTags->"b:6.2.5",
   CellID->6477],
  Cell[49139, 1801, 233, 7, 70, "Input",
   CellTags->"b:6.2.5",
   CellID->18503]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:164", 51443, 1856},
 {"b:6.2.0", 51539, 1860},
 {"xref:166", 51636, 1864},
 {"b:6.2.1", 51746, 1868},
 {"b:6.0", 54335, 1962},
 {"xref:167", 54678, 1975},
 {"b:6.2.2", 54791, 1979},
 {"b:6.4", 55315, 1998},
 {"xref:168", 55503, 2005},
 {"b:6.2.3", 55615, 2009},
 {"xref:169", 58952, 2130},
 {"b:6.2.4", 59066, 2134},
 {"xref:170", 61861, 2234},
 {"b:6.2.5", 61975, 2238}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1951, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2576, 66, 67, 2, 70, "Title",
 CellTags->"xref:164",
 CellID->31310],
Cell[2646, 70, 530, 12, 70, "Text",
 CellTags->"b:6.2.0",
 CellID->11058],
Cell[CellGroupData[{
Cell[3201, 86, 97, 2, 70, "Section",
 CellTags->{"xref:166", "b:6.2.1"},
 CellID->7926],
Cell[3301, 90, 219, 6, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->9487],
Cell[3523, 98, 441, 11, 70, "Text",
 CellID->1670],
Cell[3967, 111, 1833, 57, 70, "DefinitionBox",
 CellID->32528],
Cell[5803, 170, 81, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->5651],
Cell[5887, 174, 597, 20, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->2258],
Cell[6487, 196, 273, 10, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->7213],
Cell[6763, 208, 255, 9, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->9860],
Cell[7021, 219, 183, 7, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->25783],
Cell[CellGroupData[{
Cell[7229, 230, 275, 8, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->21286],
Cell[7507, 240, 907, 25, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->2742]
}, Open  ]],
Cell[8429, 268, 106, 2, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->8610],
Cell[CellGroupData[{
Cell[8560, 274, 309, 8, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->4472],
Cell[8872, 284, 188, 6, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->7128]
}, Open  ]],
Cell[9075, 293, 465, 12, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->18434],
Cell[CellGroupData[{
Cell[9565, 309, 130, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->5841],
Cell[9698, 315, 176, 6, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->20718]
}, Open  ]],
Cell[9889, 324, 99, 2, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->3503],
Cell[CellGroupData[{
Cell[10013, 330, 154, 5, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->14867],
Cell[10170, 337, 323, 11, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->24865]
}, Open  ]],
Cell[10508, 351, 581, 20, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->10938],
Cell[CellGroupData[{
Cell[11114, 375, 257, 8, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->1881],
Cell[11374, 385, 131, 3, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->9257]
}, Open  ]],
Cell[11520, 391, 590, 14, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->22750],
Cell[CellGroupData[{
Cell[12135, 409, 395, 13, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->28614],
Cell[12533, 424, 93, 3, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->18598]
}, Open  ]],
Cell[12641, 430, 427, 15, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->28458],
Cell[13071, 447, 131, 4, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->2661],
Cell[13205, 453, 104, 2, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->26063],
Cell[13312, 457, 234, 7, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->32756]
}, Open  ]],
Cell[CellGroupData[{
Cell[13583, 469, 91, 2, 70, "Section",
 CellTags->{"xref:167", "b:6.2.2"},
 CellID->20807],
Cell[13677, 473, 400, 12, 70, "Text",
 CellTags->"b:6.2.2",
 CellID->20278],
Cell[14080, 487, 278, 10, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->156004215],
Cell[14361, 499, 259, 9, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->34901447],
Cell[14623, 510, 119, 3, 70, "Text",
 CellID->108399858],
Cell[CellGroupData[{
Cell[14767, 517, 398, 10, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->352657795],
Cell[15168, 529, 194, 6, 70, "Output",
 CellTags->"b:6.2.1",
 CellID->598251897]
}, Open  ]],
Cell[15377, 538, 685, 17, 70, "DefinitionBox",
 CellID->29385656],
Cell[16065, 557, 302, 12, 70, "Caption",
 CellTags->"b:6.4",
 CellID->7293938],
Cell[16370, 571, 375, 10, 70, "Text",
 CellTags->"b:6.2.2",
 CellID->19489],
Cell[16748, 583, 411, 11, 70, "Text",
 CellTags->"b:6.2.2",
 CellID->19435],
Cell[17162, 596, 385, 10, 70, "Text",
 CellTags->"b:6.2.2",
 CellID->6365],
Cell[17550, 608, 180, 5, 70, "Text",
 CellTags->"b:6.2.2",
 CellID->32075],
Cell[17733, 615, 425, 10, 70, "Text",
 CellID->849470055],
Cell[18161, 627, 186, 6, 70, "Input",
 CellID->493757],
Cell[18350, 635, 542, 14, 70, "DefinitionBox",
 CellID->45415718],
Cell[18895, 651, 131, 5, 70, "Caption",
 CellTags->"b:6.4",
 CellID->59131214]
}, Open  ]],
Cell[CellGroupData[{
Cell[19063, 661, 90, 2, 70, "Section",
 CellTags->{"xref:168", "b:6.2.3"},
 CellID->7586],
Cell[19156, 665, 441, 11, 70, "Text",
 CellID->1386],
Cell[19600, 678, 1642, 50, 70, "DefinitionBox",
 CellID->7833],
Cell[21245, 730, 84, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->8360],
Cell[21332, 734, 354, 7, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->13330],
Cell[21689, 743, 261, 10, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->26048],
Cell[CellGroupData[{
Cell[21975, 757, 490, 15, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->8928],
Cell[22468, 774, 189, 6, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->29492]
}, Open  ]],
Cell[22672, 783, 145, 5, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->12433],
Cell[CellGroupData[{
Cell[22842, 792, 135, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->23840],
Cell[22980, 798, 88, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->6766]
}, Open  ]],
Cell[23083, 804, 296, 9, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->1735],
Cell[23382, 815, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->19810],
Cell[23519, 821, 309, 9, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->11599],
Cell[CellGroupData[{
Cell[23853, 834, 155, 5, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->11837],
Cell[24011, 841, 92, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->21892]
}, Open  ]],
Cell[24118, 847, 105, 2, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->31982],
Cell[CellGroupData[{
Cell[24248, 853, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->7328],
Cell[24385, 859, 89, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->29352]
}, Open  ]],
Cell[24489, 865, 106, 2, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->11369],
Cell[CellGroupData[{
Cell[24620, 871, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->31244],
Cell[24757, 877, 181, 6, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->21794]
}, Open  ]],
Cell[24953, 886, 586, 20, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->6608],
Cell[CellGroupData[{
Cell[25564, 910, 250, 8, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->9252],
Cell[25817, 920, 133, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->11647]
}, Open  ]],
Cell[25965, 926, 302, 9, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->17432],
Cell[CellGroupData[{
Cell[26292, 939, 159, 5, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->9535],
Cell[26454, 946, 92, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->7208]
}, Open  ]],
Cell[26561, 952, 95, 2, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->3264],
Cell[CellGroupData[{
Cell[26681, 958, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->3497],
Cell[26818, 964, 181, 6, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->23243]
}, Open  ]],
Cell[27014, 973, 297, 9, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->27649],
Cell[CellGroupData[{
Cell[27336, 986, 156, 5, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->22015],
Cell[27495, 993, 94, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->26841]
}, Open  ]],
Cell[27604, 999, 152, 5, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->189],
Cell[CellGroupData[{
Cell[27781, 1008, 136, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->16100],
Cell[27920, 1014, 90, 3, 70, "Output",
 CellTags->"b:6.2.3",
 CellID->19812]
}, Open  ]],
Cell[28025, 1020, 263, 9, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->30648],
Cell[28291, 1031, 134, 4, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->9523],
Cell[28428, 1037, 640, 18, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->19851],
Cell[29071, 1057, 2360, 69, 70, "DefinitionBox",
 CellID->24474],
Cell[31434, 1128, 97, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->28633],
Cell[31534, 1132, 104, 2, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->29891],
Cell[31641, 1136, 234, 7, 70, "Input",
 CellTags->"b:6.2.3",
 CellID->27200],
Cell[31878, 1145, 734, 24, 70, "Text",
 CellTags->"b:6.2.3",
 CellID->19854]
}, Open  ]],
Cell[CellGroupData[{
Cell[32649, 1174, 100, 2, 70, "Section",
 CellTags->{"xref:169", "b:6.2.4"},
 CellID->9990],
Cell[32752, 1178, 108, 2, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->25697],
Cell[32863, 1182, 441, 11, 70, "Text",
 CellID->4919],
Cell[33307, 1195, 1326, 40, 70, "DefinitionBox",
 CellID->17780],
Cell[34636, 1237, 85, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->22578],
Cell[34724, 1241, 261, 10, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->12931],
Cell[CellGroupData[{
Cell[35010, 1255, 496, 15, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->32544],
Cell[35509, 1272, 188, 6, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->3340]
}, Open  ]],
Cell[35712, 1281, 101, 2, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->13487],
Cell[CellGroupData[{
Cell[35838, 1287, 273, 8, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->899],
Cell[36114, 1297, 908, 25, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->22525]
}, Open  ]],
Cell[37037, 1325, 94, 2, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->8483],
Cell[CellGroupData[{
Cell[37156, 1331, 212, 7, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->5538],
Cell[37371, 1340, 430, 14, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->7492]
}, Open  ]],
Cell[37816, 1357, 103, 2, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->6193],
Cell[CellGroupData[{
Cell[37944, 1363, 135, 4, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->28252],
Cell[38082, 1369, 89, 3, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->25011]
}, Open  ]],
Cell[38186, 1375, 321, 10, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->1560],
Cell[CellGroupData[{
Cell[38532, 1389, 255, 9, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->15834],
Cell[38790, 1400, 428, 14, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->1840]
}, Open  ]],
Cell[CellGroupData[{
Cell[39255, 1419, 135, 4, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->31497],
Cell[39393, 1425, 88, 3, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->2785]
}, Open  ]],
Cell[39496, 1431, 466, 12, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->18529],
Cell[CellGroupData[{
Cell[39987, 1447, 288, 9, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->31540],
Cell[40278, 1458, 537, 17, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->18805]
}, Open  ]],
Cell[40830, 1478, 131, 4, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->28791],
Cell[CellGroupData[{
Cell[40986, 1486, 136, 4, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->13392],
Cell[41125, 1492, 90, 3, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->13210]
}, Open  ]],
Cell[41230, 1498, 581, 20, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->13549],
Cell[CellGroupData[{
Cell[41836, 1522, 305, 10, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->21578],
Cell[42144, 1534, 186, 6, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->26979]
}, Open  ]],
Cell[42345, 1543, 311, 10, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->30971],
Cell[CellGroupData[{
Cell[42681, 1557, 138, 4, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->9277],
Cell[42822, 1563, 468, 14, 70, "Output",
 CellTags->"b:6.2.4",
 CellID->73]
}, Open  ]],
Cell[43305, 1580, 104, 2, 70, "Text",
 CellTags->"b:6.2.4",
 CellID->20193],
Cell[43412, 1584, 233, 7, 70, "Input",
 CellTags->"b:6.2.4",
 CellID->1620]
}, Open  ]],
Cell[CellGroupData[{
Cell[43682, 1596, 90, 2, 70, "Section",
 CellTags->{"xref:170", "b:6.2.5"},
 CellID->21497],
Cell[43775, 1600, 126, 4, 70, "Text",
 CellTags->"b:6.2.5",
 CellID->13826],
Cell[43904, 1606, 442, 11, 70, "Text",
 CellID->31276],
Cell[CellGroupData[{
Cell[44371, 1621, 496, 15, 70, "Input",
 CellTags->"b:6.2.5",
 CellID->19790],
Cell[44870, 1638, 188, 6, 70, "Output",
 CellTags->"b:6.2.5",
 CellID->6582]
}, Open  ]],
Cell[45073, 1647, 101, 2, 70, "Text",
 CellTags->"b:6.2.5",
 CellID->13578],
Cell[CellGroupData[{
Cell[45199, 1653, 275, 8, 70, "Input",
 CellTags->"b:6.2.5",
 CellID->11159],
Cell[45477, 1663, 908, 25, 70, "Output",
 CellTags->"b:6.2.5",
 CellID->20418]
}, Open  ]],
Cell[46400, 1691, 221, 6, 70, "Text",
 CellTags->"b:6.2.5",
 CellID->26489],
Cell[CellGroupData[{
Cell[46646, 1701, 440, 15, 70, "Input",
 CellTags->"b:6.2.5",
 CellID->159],
Cell[47089, 1718, 92, 3, 70, "Output",
 CellTags->"b:6.2.5",
 CellID->3449]
}, Open  ]],
Cell[47196, 1724, 107, 2, 70, "Text",
 CellTags->"b:6.2.5",
 CellID->12924],
Cell[CellGroupData[{
Cell[47328, 1730, 153, 5, 70, "Input",
 CellTags->"b:6.2.5",
 CellID->9072],
Cell[47484, 1737, 93, 3, 70, "Output",
 CellTags->"b:6.2.5",
 CellID->10380]
}, Open  ]],
Cell[47592, 1743, 449, 15, 70, "Text",
 CellTags->"b:6.2.5",
 CellID->27008],
Cell[CellGroupData[{
Cell[48066, 1762, 375, 12, 70, "Input",
 CellTags->"b:6.2.5",
 CellID->27967],
Cell[48444, 1776, 574, 18, 70, "Output",
 CellTags->"b:6.2.5",
 CellID->10208]
}, Open  ]],
Cell[49033, 1797, 103, 2, 70, "Text",
 CellTags->"b:6.2.5",
 CellID->6477],
Cell[49139, 1801, 233, 7, 70, "Input",
 CellTags->"b:6.2.5",
 CellID->18503]
}, Open  ]]
}, Open  ]],
Cell[49399, 1812, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

