(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44540,       1409]
NotebookOptionsPosition[     27223,        917]
NotebookOutlinePosition[     39254,       1235]
CellTagsIndexPosition[     38369,       1213]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Selecting Data with Raw SQL", "Title",
 CellID->2741],

Cell[TextData[{
 "The raw SQL command SELECT selects and returns data from a database. An \
alternative is to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 ", described in ",
 ButtonBox["Selecting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 ". "
}], "Text",
 CellTags->"b:4.2.2",
 CellID->26052],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->236],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["publisher",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:4.2.2",
 CellID->8551],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,99"},
 CellLabel->"In[1]:=",
 CellID->9487],

Cell[TextData[{
 "This retrieves data within the table, ",
 StyleBox["ROYSCHED",
  FontSlant->"Italic"],
 ", for which the data in the ",
 StyleBox["ROYALTY",
  FontSlant->"Italic"],
 " column is between 0.11 and 0.12."
}], "Text",
 CellTags->"b:4.2.2",
 CellID->31226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<SELECT * FROM ROYSCHED WHERE ROYALTY >= .11 AND ROYALTY <= .12\>\""}],
   "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
 CellLabel->"In[3]:=",
 CellID->28162],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "6000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "15000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
 CellLabel->"Out[3]=",
 CellID->16955]
}, Open  ]],

Cell[TextData[{
 "This carries out the same SELECT statement but uses a prepared statement. \
The arguments to the statement are given as the third element of the ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " command. The first argument is placed in the location of the `1` and the \
second in the location of the `2`."
}], "Text",
 CellTags->"b:4.2.2",
 CellID->23183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<SELECT * FROM ROYSCHED WHERE ROYALTY >= `1` AND ROYALTY <= `2`\>\"", 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.11", ",", "0.12"}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
 CellLabel->"In[4]:=",
 CellID->8394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "6000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "15000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
 CellLabel->"Out[4]=",
 CellID->30180]
}, Open  ]],

Cell[TextData[{
 "Column and table names must be wrapped in ",
 Cell[BoxData[
  ButtonBox["SQLColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumn"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 ", respectively. This will ensure they are not quoted as strings. The \
following selects elements of the ",
 StyleBox["ROYALTY",
  FontSlant->"Italic"],
 " column in the ",
 StyleBox["ROYSCHED",
  FontSlant->"Italic"],
 " table for which the ",
 StyleBox["TITLE_ID",
  FontSlant->"Italic"],
 " column value is ",
 StyleBox["BS1011", "MR"],
 "."
}], "Text",
 CellTags->"b:4.2.2",
 CellID->16097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<SELECT `1` FROM ROYSCHED WHERE TITLE_ID = `2`\>\"", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], ",", 
     "\"\<BS1011\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
 CellLabel->"In[5]:=",
 CellID->3065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.1`", "}"}], ",", 
   RowBox[{"{", "0.12`", "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
 CellLabel->"Out[5]=",
 CellID->27065]
}, Open  ]],

Cell[TextData[{
 "If you want to give a sequence of arguments to a prepared statement, you \
can use ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 ". This is described in ",
 ButtonBox["Argument Sequences in SQL-Style Queries",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute#16828"],
 "."
}], "Text",
 CellTags->"b:4.2.2",
 CellID->2513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\"\<SELECT `1` FROM ROYSCHED WHERE TITLE_ID = `2`\>\"", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLArgument", "[", 
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<LORANGE\>\"", "]"}], ",", 
       RowBox[{"SQLColumn", "[", "\"\<HIRANGE\>\"", "]"}], ",", 
       RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}]}], "]"}], ",", 
     "\"\<BS1011\>\""}], "}"}]}], "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
 CellLabel->"In[6]:=",
 CellID->9261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "5000", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5001", ",", "50000", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
 CellLabel->"Out[6]=",
 CellID->12578]
}, Open  ]],

Cell["\<\
Many databases offer functions that apply to the results of a select \
operation. Typical examples are COUNT, MIN, MAX, SUM, and AVG. The \
documentation for your database will describe the details of the functions \
that are available. The following examples demonstrate some of these \
functions.\
\>", "Text",
 CellTags->"b:4.2.2",
 CellID->21078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT COUNT(ROYALTY) FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
 CellLabel->"In[7]:=",
 CellID->16878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "51", "}"}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
 CellLabel->"Out[7]=",
 CellID->14140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT MIN(ROYALTY) FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
 CellLabel->"In[8]:=",
 CellID->4611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "0.1`", "}"}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
 CellLabel->"Out[8]=",
 CellID->31947]
}, Open  ]],

Cell["\<\
Many databases allow you to apply mathematical functions such as +, -, *, or \
/ to the results.\
\>", "Text",
 CellTags->"b:4.2.2",
 CellID->2445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT ROYALTY * 2 FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
 CellLabel->"In[9]:=",
 CellID->170],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.36`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.36`", "}"}], ",", 
   RowBox[{"{", "0.4`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.36`", "}"}], ",", 
   RowBox[{"{", "0.4`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.32`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.28`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}], ",", 
   RowBox[{"{", "0.24`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
 CellLabel->"Out[9]=",
 CellID->29975]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT ROYALTY / 10 FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
 CellLabel->"In[10]:=",
 CellID->13489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.018`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.018`", "}"}], ",", 
   RowBox[{"{", "0.02`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.018`", "}"}], ",", 
   RowBox[{"{", "0.02`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.016`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.014000000000000002`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}], ",", 
   RowBox[{"{", "0.012`", "}"}], ",", 
   RowBox[{"{", "0.01`", "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
 CellLabel->"Out[10]=",
 CellID->24750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT - ROYALTY FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
 CellLabel->"In[11]:=",
 CellID->6149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
 CellLabel->"Out[11]=",
 CellID->3333]
}, Open  ]],

Cell["You can also select only distinct values.", "Text",
 CellTags->"b:4.2.2",
 CellID->13865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT DISTINCT ROYALTY FROM ROYSCHED\>\""}],
   "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
 CellLabel->"In[12]:=",
 CellID->22214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0.1`", "}"}], ",", 
   RowBox[{"{", "0.12`", "}"}], ",", 
   RowBox[{"{", "0.14`", "}"}], ",", 
   RowBox[{"{", "0.16`", "}"}], ",", 
   RowBox[{"{", "0.18`", "}"}], ",", 
   RowBox[{"{", "0.2`", "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
 CellLabel->"Out[12]=",
 CellID->17282]
}, Open  ]],

Cell["You can also group values.", "Text",
 CellTags->"b:4.2.2",
 CellID->27007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", 
    "\"\<SELECT TITLE_ID,\n     MIN(ROYALTY) FROM ROYSCHED GROUP BY \
TITLE_ID\>\"", ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
 CellLabel->"In[13]:=",
 CellID->27432],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TITLE_ID\"\>", "\<\"\"\>"},
    {"\<\"BS1011\"\>", "0.1`"},
    {"\<\"CP5018\"\>", "0.1`"},
    {"\<\"BS1001\"\>", "0.1`"},
    {"\<\"PS9999\"\>", "0.1`"},
    {"\<\"PY2002\"\>", "0.1`"},
    {"\<\"PY2003\"\>", "0.1`"},
    {"\<\"UK3004\"\>", "0.1`"},
    {"\<\"CK4005\"\>", "0.1`"},
    {"\<\"CP5010\"\>", "0.1`"},
    {"\<\"PY2012\"\>", "0.1`"},
    {"\<\"PY2013\"\>", "0.1`"},
    {"\<\"UK3006\"\>", "0.1`"},
    {"\<\"BS1014\"\>", "0.1`"},
    {"\<\"UK3015\"\>", "0.1`"},
    {"\<\"CK4016\"\>", "0.1`"},
    {"\<\"CK4017\"\>", "0.1`"},
    {"\<\"BS1007\"\>", "0.1`"},
    {"\<\"PY2008\"\>", "0.1`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
 CellLabel->"Out[13]//TableForm=",
 CellID->8896]
}, Open  ]],

Cell["Many databases also support retrieving a range of results.", "Text",
 CellTags->"b:4.2.2",
 CellID->16367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT TOP 5 * FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
 CellLabel->"In[14]:=",
 CellID->28522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "4001", ",", "50000", ",", "0.16`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
 CellLabel->"Out[14]=",
 CellID->4882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT LIMIT 5 10 * FROM ROYSCHED\>\""}], 
  "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
 CellLabel->"In[15]:=",
 CellID->31810],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "7001", ",", "50000", ",", "0.18`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "5001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], 
    "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
 CellLabel->"Out[15]=",
 CellID->17641]
}, Open  ]],

Cell["\<\
More complex SELECT statements using INNER JOIN and OUTER JOIN can be used in \
a FROM clause to combine records from two tables.\
\>", "Text",
 CellTags->"b:4.2.2",
 CellID->7231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<SELECT DISTINCT TITLES.TITLE FROM TITLES INNER JOIN ROYSCHED ON \
TITLES.TITLE_ID=ROYSCHED.TITLE_ID WHERE TITLES.PUB_ID='0877' AND \
ROYSCHED.ROYALTY > .1\>\""}], "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
 CellLabel->"In[16]:=",
 CellID->2187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"Hamburger Again!\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"How to Burn a Compact Disk\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Let Them Eat Cake!\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Made to Wonder: Cooking the Macabre\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Too Many Cooks\"\>", "}"}], ",", 
   RowBox[{"{", "\<\"Treasures of the Sierra Madre\"\>", "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
 CellLabel->"Out[16]=",
 CellID->6705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", 
    "\"\<SELECT T.TITLE, T.TITLE_ID, MIN(R.ROYALTY) FROM ROYSCHED R, TITLES T \
LEFT\nOUTER JOIN ROYSCHED ON T.TITLE_ID = R.TITLE_ID GROUP BY T.TITLE, \
T.TITLE_ID\nORDER BY R.ROYALTY, T.TITLE DESC\>\"", ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
 CellLabel->"In[17]:=",
 CellID->6479],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"Not in aggregate function or group by \\\"\[Ellipsis]\\\
\"E_ID\\\\nORDER BY R.ROYALTY, T.TITLE DESC]\\\"\\)\"\>"}]], "Message", "MSG",
 
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
 CellLabel->"During evaluation of In[17]:=",
 CellID->6321],

Cell[BoxData[
 TagBox["$Failed",
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
 CellLabel->"Out[17]//TableForm=",
 CellID->6538]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:4.2.2",
 CellID->31351],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,115"},
 CellLabel->"In[42]:=",
 CellID->19447]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Selecting Data with Raw SQL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 53.8902163}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The raw SQL command SELECT selects and returns data from a database. An \
alternative is to use the Mathematica command SQLSelect, described in \
Selecting Data. If you find that the examples in this tutorial do not work as \
shown, you may need to install or restore the example database with the \
DatabaseExamples` package, as described in Using the Example Databases. This \
loads DatabaseLink and connects to the publisher database.", "synonyms" -> {},
     "title" -> "Selecting Data with Raw SQL", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/SQLSelectingData"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.2"->{
  Cell[791, 32, 504, 17, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->26052],
  Cell[1736, 66, 217, 10, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->8551],
  Cell[1956, 78, 324, 9, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,99"},
   CellID->9487],
  Cell[2283, 89, 269, 10, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->31226],
  Cell[2577, 103, 268, 8, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
   CellID->28162],
  Cell[2848, 113, 1856, 53, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
   CellID->16955],
  Cell[4719, 169, 465, 11, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->23183],
  Cell[5209, 184, 333, 10, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
   CellID->8394],
  Cell[5545, 196, 1856, 53, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
   CellID->30180],
  Cell[7416, 252, 735, 26, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->16097],
  Cell[8176, 282, 378, 11, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
   CellID->3065],
  Cell[8557, 295, 223, 7, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
   CellID->27065],
  Cell[8795, 305, 462, 14, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->2513],
  Cell[9282, 323, 568, 15, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
   CellID->9261],
  Cell[9853, 340, 303, 9, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
   CellID->12578],
  Cell[10171, 352, 360, 8, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->21078],
  Cell[10556, 364, 234, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
   CellID->16878],
  Cell[10793, 372, 169, 5, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
   CellID->14140],
  Cell[10999, 382, 231, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
   CellID->4611],
  Cell[11233, 390, 171, 5, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
   CellID->31947],
  Cell[11419, 398, 157, 5, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->2445],
  Cell[11601, 407, 229, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
   CellID->170],
  Cell[11833, 415, 2066, 56, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
   CellID->29975],
  Cell[13936, 476, 233, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
   CellID->13489],
  Cell[14172, 484, 2223, 56, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
   CellID->24750],
  Cell[16432, 545, 229, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
   CellID->6149],
  Cell[16664, 553, 3086, 107, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
   CellID->3333],
  Cell[19765, 663, 95, 2, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->13865],
  Cell[19885, 669, 237, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
   CellID->22214],
  Cell[20125, 677, 375, 11, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
   CellID->17282],
  Cell[20515, 691, 80, 2, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->27007],
  Cell[20620, 697, 375, 11, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
   CellID->27432],
  Cell[20998, 710, 1175, 36, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
   CellID->8896],
  Cell[22188, 749, 112, 2, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->16367],
  Cell[22325, 755, 228, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
   CellID->28522],
  Cell[22556, 763, 674, 20, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
   CellID->4882],
  Cell[23267, 788, 233, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
   CellID->31810],
  Cell[23503, 796, 1199, 35, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
   CellID->17641],
  Cell[24717, 834, 190, 5, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->7231],
  Cell[24932, 843, 357, 9, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
   CellID->2187],
  Cell[25292, 854, 535, 12, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
   CellID->6705],
  Cell[25864, 871, 493, 12, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
   CellID->6479],
  Cell[26360, 885, 348, 8, 70, "Message",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
   CellID->6321],
  Cell[26711, 895, 201, 6, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
   CellID->6538],
  Cell[26927, 904, 81, 2, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->31351],
  Cell[27011, 908, 170, 4, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,115"},
   CellID->19447]},
 "Ex--21943492438155078303,99"->{
  Cell[1956, 78, 324, 9, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,99"},
   CellID->9487]},
 "Ex--21943492438155078303,100"->{
  Cell[2577, 103, 268, 8, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
   CellID->28162],
  Cell[2848, 113, 1856, 53, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
   CellID->16955]},
 "Ex--21943492438155078303,101"->{
  Cell[5209, 184, 333, 10, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
   CellID->8394],
  Cell[5545, 196, 1856, 53, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
   CellID->30180]},
 "Ex--21943492438155078303,102"->{
  Cell[8176, 282, 378, 11, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
   CellID->3065],
  Cell[8557, 295, 223, 7, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
   CellID->27065]},
 "Ex--21943492438155078303,103"->{
  Cell[9282, 323, 568, 15, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
   CellID->9261],
  Cell[9853, 340, 303, 9, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
   CellID->12578]},
 "Ex--21943492438155078303,104"->{
  Cell[10556, 364, 234, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
   CellID->16878],
  Cell[10793, 372, 169, 5, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
   CellID->14140]},
 "Ex--21943492438155078303,105"->{
  Cell[10999, 382, 231, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
   CellID->4611],
  Cell[11233, 390, 171, 5, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
   CellID->31947]},
 "Ex--21943492438155078303,106"->{
  Cell[11601, 407, 229, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
   CellID->170],
  Cell[11833, 415, 2066, 56, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
   CellID->29975]},
 "Ex--21943492438155078303,107"->{
  Cell[13936, 476, 233, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
   CellID->13489],
  Cell[14172, 484, 2223, 56, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
   CellID->24750]},
 "Ex--21943492438155078303,108"->{
  Cell[16432, 545, 229, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
   CellID->6149],
  Cell[16664, 553, 3086, 107, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
   CellID->3333]},
 "Ex--21943492438155078303,109"->{
  Cell[19885, 669, 237, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
   CellID->22214],
  Cell[20125, 677, 375, 11, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
   CellID->17282]},
 "Ex--21943492438155078303,110"->{
  Cell[20620, 697, 375, 11, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
   CellID->27432],
  Cell[20998, 710, 1175, 36, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
   CellID->8896]},
 "Ex--21943492438155078303,111"->{
  Cell[22325, 755, 228, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
   CellID->28522],
  Cell[22556, 763, 674, 20, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
   CellID->4882]},
 "Ex--21943492438155078303,112"->{
  Cell[23267, 788, 233, 6, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
   CellID->31810],
  Cell[23503, 796, 1199, 35, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
   CellID->17641]},
 "Ex--21943492438155078303,113"->{
  Cell[24932, 843, 357, 9, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
   CellID->2187],
  Cell[25292, 854, 535, 12, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
   CellID->6705]},
 "Ex--21943492438155078303,114"->{
  Cell[25864, 871, 493, 12, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
   CellID->6479],
  Cell[26360, 885, 348, 8, 70, "Message",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
   CellID->6321],
  Cell[26711, 895, 201, 6, 70, "Output",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
   CellID->6538]},
 "Ex--21943492438155078303,115"->{
  Cell[27011, 908, 170, 4, 70, "Input",
   CellTags->{"b:4.2.2", "Ex--21943492438155078303,115"},
   CellID->19447]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.2", 28931, 955},
 {"Ex--21943492438155078303,99", 33895, 1094},
 {"Ex--21943492438155078303,100", 34044, 1098},
 {"Ex--21943492438155078303,101", 34315, 1105},
 {"Ex--21943492438155078303,102", 34586, 1112},
 {"Ex--21943492438155078303,103", 34855, 1119},
 {"Ex--21943492438155078303,104", 35124, 1126},
 {"Ex--21943492438155078303,105", 35395, 1133},
 {"Ex--21943492438155078303,106", 35665, 1140},
 {"Ex--21943492438155078303,107", 35936, 1147},
 {"Ex--21943492438155078303,108", 36209, 1154},
 {"Ex--21943492438155078303,109", 36481, 1161},
 {"Ex--21943492438155078303,110", 36753, 1168},
 {"Ex--21943492438155078303,111", 37026, 1175},
 {"Ex--21943492438155078303,112", 37297, 1182},
 {"Ex--21943492438155078303,113", 37570, 1189},
 {"Ex--21943492438155078303,114", 37840, 1196},
 {"Ex--21943492438155078303,115", 38228, 1206}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 59, 1, 70, "Title",
 CellID->2741],
Cell[791, 32, 504, 17, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->26052],
Cell[1298, 51, 435, 13, 70, "Text",
 CellID->236],
Cell[1736, 66, 217, 10, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->8551],
Cell[1956, 78, 324, 9, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,99"},
 CellID->9487],
Cell[2283, 89, 269, 10, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->31226],
Cell[CellGroupData[{
Cell[2577, 103, 268, 8, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
 CellID->28162],
Cell[2848, 113, 1856, 53, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,100"},
 CellID->16955]
}, Open  ]],
Cell[4719, 169, 465, 11, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->23183],
Cell[CellGroupData[{
Cell[5209, 184, 333, 10, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
 CellID->8394],
Cell[5545, 196, 1856, 53, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,101"},
 CellID->30180]
}, Open  ]],
Cell[7416, 252, 735, 26, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->16097],
Cell[CellGroupData[{
Cell[8176, 282, 378, 11, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
 CellID->3065],
Cell[8557, 295, 223, 7, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,102"},
 CellID->27065]
}, Open  ]],
Cell[8795, 305, 462, 14, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->2513],
Cell[CellGroupData[{
Cell[9282, 323, 568, 15, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
 CellID->9261],
Cell[9853, 340, 303, 9, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,103"},
 CellID->12578]
}, Open  ]],
Cell[10171, 352, 360, 8, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->21078],
Cell[CellGroupData[{
Cell[10556, 364, 234, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
 CellID->16878],
Cell[10793, 372, 169, 5, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,104"},
 CellID->14140]
}, Open  ]],
Cell[CellGroupData[{
Cell[10999, 382, 231, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
 CellID->4611],
Cell[11233, 390, 171, 5, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,105"},
 CellID->31947]
}, Open  ]],
Cell[11419, 398, 157, 5, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->2445],
Cell[CellGroupData[{
Cell[11601, 407, 229, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
 CellID->170],
Cell[11833, 415, 2066, 56, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,106"},
 CellID->29975]
}, Open  ]],
Cell[CellGroupData[{
Cell[13936, 476, 233, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
 CellID->13489],
Cell[14172, 484, 2223, 56, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,107"},
 CellID->24750]
}, Open  ]],
Cell[CellGroupData[{
Cell[16432, 545, 229, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
 CellID->6149],
Cell[16664, 553, 3086, 107, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,108"},
 CellID->3333]
}, Open  ]],
Cell[19765, 663, 95, 2, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->13865],
Cell[CellGroupData[{
Cell[19885, 669, 237, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
 CellID->22214],
Cell[20125, 677, 375, 11, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,109"},
 CellID->17282]
}, Open  ]],
Cell[20515, 691, 80, 2, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->27007],
Cell[CellGroupData[{
Cell[20620, 697, 375, 11, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
 CellID->27432],
Cell[20998, 710, 1175, 36, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,110"},
 CellID->8896]
}, Open  ]],
Cell[22188, 749, 112, 2, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->16367],
Cell[CellGroupData[{
Cell[22325, 755, 228, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
 CellID->28522],
Cell[22556, 763, 674, 20, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,111"},
 CellID->4882]
}, Open  ]],
Cell[CellGroupData[{
Cell[23267, 788, 233, 6, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
 CellID->31810],
Cell[23503, 796, 1199, 35, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,112"},
 CellID->17641]
}, Open  ]],
Cell[24717, 834, 190, 5, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->7231],
Cell[CellGroupData[{
Cell[24932, 843, 357, 9, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
 CellID->2187],
Cell[25292, 854, 535, 12, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,113"},
 CellID->6705]
}, Open  ]],
Cell[CellGroupData[{
Cell[25864, 871, 493, 12, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
 CellID->6479],
Cell[26360, 885, 348, 8, 70, "Message",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
 CellID->6321],
Cell[26711, 895, 201, 6, 70, "Output",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,114"},
 CellID->6538]
}, Open  ]],
Cell[26927, 904, 81, 2, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->31351],
Cell[27011, 908, 170, 4, 70, "Input",
 CellTags->{"b:4.2.2", "Ex--21943492438155078303,115"},
 CellID->19447]
}, Open  ]],
Cell[27196, 915, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

