(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10703,        368]
NotebookOptionsPosition[      6762,        247]
NotebookOutlinePosition[      9489,        321]
CellTagsIndexPosition[      9371,        314]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLCatalogNames" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLCatalogNames"], 
         "SQLSchemaInformation" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLSchemaInformation"], "SQLSchemaNames" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLSchemaNames"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"SQLCatalogNames\"\>", 
      2->"\<\"SQLSchemaInformation\"\>", 
      3->"\<\"SQLSchemaNames\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Schema and Catalogs", "Title",
 CellTags->{"xref:150", "b:3.6"},
 CellID->15370],

Cell[TextData[{
 "Database schema and catalogs can be used to hold collections of database \
components and objects suitable for particular users. They can be \
particularly useful when working with large databases. The functions ",
 Cell[BoxData[
  ButtonBox["SQLSchemaNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSchemaNames"]]],
 " and ",
 Cell[BoxData[
  ButtonBox["SQLCatalogNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCatalogNames"]]],
 " can be used to learn the names of the schema and catalogs in the database. \
These can be used with the \"",
 StyleBox["Schema", "MR"],
 "\" and \"",
 StyleBox["Catalog", "MR"],
 "\" options to ",
 Cell[BoxData[
  ButtonBox["SQLTableNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"]]],
 ",",
 " ",
 Cell[BoxData[
  ButtonBox["SQLTableInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"]]],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLTables",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTables"]]],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLColumnNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnNames"]]],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLColumnInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumnInformation"]]],
 ", and ",
 Cell[BoxData[
  ButtonBox["SQLColumns",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLColumns"]]],
 " to focus attention on particular parts of the database."
}], "Text",
 CellTags->"b:3.6",
 CellID->32607],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLCatalogNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLCatalogNames"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all the catalogs used in a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLSchemaNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLSchemaNames"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all the schema used in a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLSchemaInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLSchemaInformation"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "returns information about the schema used in a data source", 
     "TableText"]}
  }]], "DefinitionBox",
 CellID->14196],

Cell["Listing catalogs and schema.", "Caption",
 CellTags->"b:3.6",
 CellID->12074],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->1670],

Cell[TextData[{
 "First, the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " package is loaded and a connection is made to the ",
 StyleBox["publisher",
  FontSlant->"Italic"],
 " example database."
}], "Text",
 CellTags->"b:6.2.1",
 CellID->7213],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", "=", 
   RowBox[{"OpenSQLConnection", "[", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:6.2.1",
 CellLabel->"In[1]:=",
 CellID->9860],

Cell["This returns the schema names for the connection.", "Text",
 CellID->429791147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSchemaNames", "[", "conn", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->331443521],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"INFORMATION_SCHEMA\"\>", ",", "\<\"PUBLIC\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->356797309]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSchemaInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSchemaInformation"]]],
 " returns more information about the database schema."
}], "Text",
 CellID->14231473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSchemaInformation", "[", "conn", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->215873551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"INFORMATION_SCHEMA\"\>", ",", "Null", ",", "False"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PUBLIC\"\>", ",", "Null", ",", "True"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->301552535]
}, Open  ]],

Cell["\<\
This returns the catalog names; for this database there are not catalogs.\
\>", "Text",
 CellID->289249003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLCatalogNames", "[", "conn", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->98197707],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->189580174]
}, Open  ]],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->614112443]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Schema and Catalogs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 46.7340121}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "Database schema and catalogs can be used to hold collections of database \
components and objects suitable for particular users. They can be \
particularly useful when working with large databases. The functions \
SQLSchemaNames and SQLCatalogNames can be used to learn the names of the \
schema and catalogs in the database. These can be used with the \"Schema\" \
and \"Catalog\" options to SQLTableNames, SQLTableInformation, SQLTables, \
SQLColumnNames, SQLColumnInformation, and SQLColumns to focus attention on \
particular parts of the database. Listing catalogs and schema. If you find \
that the examples in this tutorial do not work as shown, you may need to \
install or restore the example database with the DatabaseExamples` package, \
as described in Using the Example Databases.", "synonyms" -> {}, "title" -> 
    "Schema and Catalogs", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/SchemaAndCatalogs"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:150"->{
  Cell[1531, 48, 86, 2, 70, "Title",
   CellTags->{"xref:150", "b:3.6"},
   CellID->15370]},
 "b:3.6"->{
  Cell[1531, 48, 86, 2, 70, "Title",
   CellTags->{"xref:150", "b:3.6"},
   CellID->15370],
  Cell[1620, 52, 1614, 52, 70, "Text",
   CellTags->"b:3.6",
   CellID->32607],
  Cell[4087, 132, 83, 2, 70, "Caption",
   CellTags->"b:3.6",
   CellID->12074]},
 "b:6.2.1"->{
  Cell[4612, 151, 255, 10, 70, "Text",
   CellTags->"b:6.2.1",
   CellID->7213],
  Cell[4870, 163, 276, 9, 70, "Input",
   CellTags->"b:6.2.1",
   CellID->9860]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:150", 8812, 290},
 {"b:3.6", 8917, 294},
 {"b:6.2.1", 9185, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 906, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1531, 48, 86, 2, 70, "Title",
 CellTags->{"xref:150", "b:3.6"},
 CellID->15370],
Cell[1620, 52, 1614, 52, 70, "Text",
 CellTags->"b:3.6",
 CellID->32607],
Cell[3237, 106, 847, 24, 70, "DefinitionBox",
 CellID->14196],
Cell[4087, 132, 83, 2, 70, "Caption",
 CellTags->"b:3.6",
 CellID->12074],
Cell[4173, 136, 436, 13, 70, "Text",
 CellID->1670],
Cell[4612, 151, 255, 10, 70, "Text",
 CellTags->"b:6.2.1",
 CellID->7213],
Cell[4870, 163, 276, 9, 70, "Input",
 CellTags->"b:6.2.1",
 CellID->9860],
Cell[5149, 174, 85, 1, 70, "Text",
 CellID->429791147],
Cell[CellGroupData[{
Cell[5259, 179, 113, 3, 70, "Input",
 CellID->331443521],
Cell[5375, 184, 157, 5, 70, "Output",
 CellID->356797309]
}, Open  ]],
Cell[5547, 192, 241, 7, 70, "Text",
 CellID->14231473],
Cell[CellGroupData[{
Cell[5813, 203, 119, 3, 70, "Input",
 CellID->215873551],
Cell[5935, 208, 292, 10, 70, "Output",
 CellID->301552535]
}, Open  ]],
Cell[6242, 221, 117, 3, 70, "Text",
 CellID->289249003],
Cell[CellGroupData[{
Cell[6384, 228, 113, 3, 70, "Input",
 CellID->98197707],
Cell[6500, 233, 88, 3, 70, "Output",
 CellID->189580174]
}, Open  ]],
Cell[6603, 239, 117, 3, 70, "Input",
 CellID->614112443]
}, Open  ]],
Cell[6735, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

