(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15604,        413]
NotebookOptionsPosition[     10849,        274]
NotebookOutlinePosition[     14716,        377]
CellTagsIndexPosition[     14599,        370]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Security and Authentication", "Title",
 CellTags->{"xref:67", "c:31", "b:2.5"},
 CellID->13722],

Cell["\<\
Many SQL databases can be configured to require a username and password when \
a connection is made. This is useful for preventing unwanted access and \
restricting the range of operations that certain users can execute. This \
attention to security is important since databases are typically server \
based.\
\>", "Text",
 CellTags->"b:2.5",
 CellID->12611],

Cell[TextData[{
 "There are a number of issues for ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " that need to be considered when working with passwords. These depend on \
the level of security you want and how this should be balanced with \
convenience. Another issue is whether you are running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a stand-alone mode or inside a server (as in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"web", 
    StyleBox[
     AdjustmentBox["Mathematica",
      BoxMargins->{{-0.175, 0}, {0, 0}}],
     FontSlant->"Italic"]}], TextForm]]],
 ")."
}], "Text",
 CellTags->"b:2.5",
 CellID->19019],

Cell[TextData[{
 "The most convenient way to work with a password is to place it in a \
connection configuration file, as described in ",
 ButtonBox["Database Resources: Connection Configuration",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#21025"],
 ". However, the password will be stored in plain text, and an intruder could \
inspect the configuration file and learn the password. Since this is a \
security risk, the New Connection Wizard, described in ",
 ButtonBox["The Database Explorer: New Connection Wizard",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#13584"],
 ", does not save a password. However, you can edit the configuration file \
and add a password. You could provide further protection by ensuring that the \
permission on the configuration file is restricted to those who are intended \
to run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:2.5",
 CellID->28761],

Cell[TextData[{
 "A higher level of security is obtained if you use a GUI to enter the \
password, which has the advantage that the password is never stored. The GUI \
for the password is opened whenever you use a password setting of ",
 StyleBox["\"$Prompt\"", "MR"],
 "."
}], "Text",
 CellTags->"b:2.5",
 CellID->11056],

Cell[BoxData[
 RowBox[{"conn", "=", 
  RowBox[{"OpenSQLConnection", "[", 
   RowBox[{"\"\<demo\>\"", ",", 
    RowBox[{"\"\<Username\>\"", "\[Rule]", "\"\<sa\>\""}], ",", 
    RowBox[{"\"\<Password\>\"", "\[Rule]", "\"\<$Prompt\>\""}]}], 
   "]"}]}]], "Input",
 CellTags->"b:2.5",
 CellLabel->"In[3]:=",
 CellID->12890],

Cell["Here is the dialog box for the password.", "Text",
 CellTags->"b:2.5",
 CellID->31163],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{208, 101.938},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:2.5",
 CellID->16683],

Cell[TextData[{
 "You could also enter the password in the ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " command, and then make sure that you deleted your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input as soon as you made the connection."
}], "Text",
 CellTags->"b:2.5",
 CellID->13716],

Cell[TextData[{
 "Using a GUI is useful for an interactive session of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but is not very useful if you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " inside a web server (as in ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"web", 
     StyleBox[
      AdjustmentBox["Mathematica",
       BoxMargins->{{-0.175, 0}, {0, 0}}],
      FontSlant->"Italic"]}]], TextForm]]],
 "). In this case, you have a number of options. You could place the password \
in a configuration file and use file permissions to restrict access to those \
who are running the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process in the web server. An alternative would be to store the password \
in an authenticated mechanism provided by the web server. For example, the \
Tomcat server provides a mechanism based on JDBC Realms. The database \
password could be retrieved from the web server and passed to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", which could use it in an ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " command. Any hostile inspection of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code would not find the database password without breaking the web server \
authentication mechanism."
}], "Text",
 CellTags->"b:2.5",
 CellID->19932],

Cell[TextData[{
 "For greater security, use SSL to protect the transactions between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and the database. This is described in ",
 ButtonBox["Secure Socket Layer (SSL)",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SecureSocketLayer"],
 "."
}], "Text",
 CellTags->"b:2.5",
 CellID->25452]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Security and Authentication - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 48.0308788}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "Many SQL databases can be configured to require a username and password \
when a connection is made. This is useful for preventing unwanted access and \
restricting the range of operations that certain users can execute. This \
attention to security is important since databases are typically server \
based. There are a number of issues for DatabaseLink that need to be \
considered when working with passwords. These depend on the level of security \
you want and how this should be balanced with convenience. Another issue is \
whether you are running Mathematica in a stand-alone mode or inside a server \
(as in webMathematica). The most convenient way to work with a password is to \
place it in a connection configuration file, as described in Database \
Resources: Connection Configuration. However, the password will be stored in \
plain text, and an intruder could inspect the configuration file and learn \
the password. Since this is a security risk, the New Connection Wizard, \
described in The Database Explorer: New Connection Wizard, does not save a \
password. However, you can edit the configuration file and add a password. \
You could provide further protection by ensuring that the permission on the \
configuration file is restricted to those who are intended to run \
Mathematica.", "synonyms" -> {}, "title" -> "Security and Authentication", 
    "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/SecurityAndAuthentication"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:67"->{
  Cell[729, 29, 101, 2, 70, "Title",
   CellTags->{"xref:67", "c:31", "b:2.5"},
   CellID->13722]},
 "c:31"->{
  Cell[729, 29, 101, 2, 70, "Title",
   CellTags->{"xref:67", "c:31", "b:2.5"},
   CellID->13722]},
 "b:2.5"->{
  Cell[729, 29, 101, 2, 70, "Title",
   CellTags->{"xref:67", "c:31", "b:2.5"},
   CellID->13722],
  Cell[833, 33, 368, 8, 70, "Text",
   CellTags->"b:2.5",
   CellID->12611],
  Cell[1204, 43, 641, 20, 70, "Text",
   CellTags->"b:2.5",
   CellID->19019],
  Cell[1848, 65, 1000, 21, 70, "Text",
   CellTags->"b:2.5",
   CellID->28761],
  Cell[2851, 88, 321, 8, 70, "Text",
   CellTags->"b:2.5",
   CellID->11056],
  Cell[3175, 98, 319, 9, 70, "Input",
   CellTags->"b:2.5",
   CellID->12890],
  Cell[3497, 109, 92, 2, 70, "Text",
   CellTags->"b:2.5",
   CellID->31163],
  Cell[3592, 113, 4989, 86, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:2.5",
   CellID->16683],
  Cell[8584, 201, 413, 13, 70, "Text",
   CellTags->"b:2.5",
   CellID->13716],
  Cell[9000, 216, 1445, 40, 70, "Text",
   CellTags->"b:2.5",
   CellID->19932],
  Cell[10448, 258, 359, 11, 70, "Text",
   CellTags->"b:2.5",
   CellID->25452]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:67", 13433, 324},
 {"c:31", 13544, 328},
 {"b:2.5", 13656, 332}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 101, 2, 70, "Title",
 CellTags->{"xref:67", "c:31", "b:2.5"},
 CellID->13722],
Cell[833, 33, 368, 8, 70, "Text",
 CellTags->"b:2.5",
 CellID->12611],
Cell[1204, 43, 641, 20, 70, "Text",
 CellTags->"b:2.5",
 CellID->19019],
Cell[1848, 65, 1000, 21, 70, "Text",
 CellTags->"b:2.5",
 CellID->28761],
Cell[2851, 88, 321, 8, 70, "Text",
 CellTags->"b:2.5",
 CellID->11056],
Cell[3175, 98, 319, 9, 70, "Input",
 CellTags->"b:2.5",
 CellID->12890],
Cell[3497, 109, 92, 2, 70, "Text",
 CellTags->"b:2.5",
 CellID->31163],
Cell[3592, 113, 4989, 86, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:2.5",
 CellID->16683],
Cell[8584, 201, 413, 13, 70, "Text",
 CellTags->"b:2.5",
 CellID->13716],
Cell[9000, 216, 1445, 40, 70, "Text",
 CellTags->"b:2.5",
 CellID->19932],
Cell[10448, 258, 359, 11, 70, "Text",
 CellTags->"b:2.5",
 CellID->25452]
}, Open  ]],
Cell[10822, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

