(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87271,       2602]
NotebookOptionsPosition[     63259,       1904]
NotebookOutlinePosition[     79404,       2340]
CellTagsIndexPosition[     78227,       2311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLSelect" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLSelect"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"SQLSelect\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Selecting Data", "Title",
 CellID->2741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " selects and returns data from a database. An alternative, using raw SQL, \
is described in ",
 ButtonBox["Selecting Data with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLSelectingData"],
 ". "
}], "Text",
 CellTags->"b:4.1.1",
 CellID->6813],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->2862],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLSelect",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLSelect"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["table", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "select all data from the table", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLSelect",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLSelect"], "[", 
     StyleBox["conn", "TI"], ",", "{", 
     StyleBox["tables", "TI"], "}", ",", "{", 
     StyleBox["columns", "TI"], "}", "]"}], Cell[
    "select data in certain columns from the table", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLSelect",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLSelect"], "[", 
     StyleBox["conn", "TI"], ",", "{", 
     StyleBox["tables", "TI"], "}", ",", "{", 
     StyleBox["columns", "TI"], "}", ",", 
     StyleBox["condition", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
select data in certain columns from the table meeting the condition\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->10396],

Cell["Retrieving data from a database.", "Caption",
 CellTags->"b:4.1.1",
 CellID->15460],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->20615],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,76"},
 CellLabel->"In[1]:=",
 CellID->10904],

Cell[TextData[{
 "This retrieves all data within the table ",
 StyleBox["ROYSCHED",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->2599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\""}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
 CellLabel->"In[3]:=",
 CellID->20136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "4001", ",", "50000", ",", "0.16`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "5001", ",", "7000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "7001", ",", "50000", ",", "0.18`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "5001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "5000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "5001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "2001", ",", "6000", ",", "0.14`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "6001", ",", "8000", ",", "0.18`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "8001", ",", "50000", ",", "0.2`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "6000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "6001", ",", "8000", ",", "0.16`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "8001", ",", "50000", ",", "0.16`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0", ",", "1000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "2000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "2001", ",", "6000", ",", "0.14`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "6001", ",", "8000", ",", "0.18`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "8001", ",", "50000", ",", "0.2`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0", ",", "4000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "8001", ",", "50000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "4000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "4001", ",", "8000", ",", "0.14`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "8001", ",", "12000", ",", "0.16`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "15000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0", ",", "2000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "8000", ",", "0.12`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "8001", ",", "16000", ",", "0.14`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0", ",", "5000", ",", "0.1`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "50000", ",", "0.12`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0", ",", "50000", ",", "0.1`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
 CellLabel->"Out[3]=",
 CellID->4680]
}, Open  ]],

Cell[TextData[{
 "The third parameter of ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " can be used to select only certain columns. In this example, only the ",
 StyleBox["TITLE_ID",
  FontSlant->"Italic"],
 " and ",
 StyleBox["ROYALTY",
  FontSlant->"Italic"],
 " columns are selected."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->9198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", " ", "=", " ", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}]}], 
   "]"}]}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
 CellLabel->"In[4]:=",
 CellID->27032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
 CellLabel->"Out[4]=",
 CellID->14387]
}, Open  ]],

Cell[TextData[{
 "The results of the database operation can immediately be used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->32584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Last", " ", "/@", " ", "data"}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
 CellLabel->"In[5]:=",
 CellID->7240],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.1}, {2., 0.12}, {3., 0.1}, {4., 0.12}, {5., 0.16}, {6., 
     0.1}, {7., 0.12}, {8., 0.16}, {9., 0.18}, {10., 0.1}, {11., 0.1}, {12., 
     0.12}, {13., 0.14}, {14., 0.1}, {15., 0.12}, {16., 0.14}, {17., 0.1}, {
     18., 0.12}, {19., 0.14}, {20., 0.18}, {21., 0.2}, {22., 0.1}, {23., 
     0.12}, {24., 0.16}, {25., 0.16}, {26., 0.1}, {27., 0.12}, {28., 0.1}, {
     29., 0.12}, {30., 0.1}, {31., 0.12}, {32., 0.1}, {33., 0.12}, {34., 
     0.14}, {35., 0.18}, {36., 0.2}, {37., 0.1}, {38., 0.12}, {39., 0.14}, {
     40., 0.1}, {41., 0.12}, {42., 0.14}, {43., 0.16}, {44., 0.1}, {45., 
     0.12}, {46., 0.1}, {47., 0.12}, {48., 0.14}, {49., 0.1}, {50., 0.12}, {
     51., 0.1}}]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
 CellLabel->"Out[5]=",
 CellID->3517]
}, Open  ]],

Cell[TextData[{
 "There are a number of options that can be given to ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:4.3",
 CellID->17006],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<SortingColumns\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to sort the data", "TableText"]},
   {"\"\<Distinct\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return only distinct results", "TableText"]},
   {"\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return the results as strings", "TableText"]},
   {"\"\<MaxRows\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the maximum number of rows returned", "TableText"]},
   {"\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results ", "TableText"]},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->8670],

Cell[TextData[{
 "Options of ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->241],

Cell[TextData[{
 "It is possible to select data from multiple columns in multiple tables. You \
can select multiple tables by giving a second argument that is a list of the \
table names. A list of column names should be used as the third parameter as \
shown previously. You can also associate a specific table with a column by \
pairing a column name with a table name in a list in the third argument. This \
is important if the same column name is used in more than one table. The \
following example of a data join generates an outer product of the data in \
the two tables and it uses the option ",
 Cell[BoxData["\"\<MaxRows\>\""], "InlineFormula"],
 " to show only the first five results."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->18882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLES\>\"", ",", "\"\<ROYSCHED\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE\>\""}], "}"}], ",", " ",
       
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "5"}], ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
 CellLabel->"In[6]:=",
 CellID->25249],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TITLE\"\>", "\<\"TITLE_ID\"\>", "\<\"TITLE_ID\"\>", \
"\<\"ROYALTY\"\>"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1011\"\>", "0.1`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1011\"\>", "0.12`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"CP5018\"\>", "0.1`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"CP5018\"\>", "0.12`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"CP5018\"\>", "0.16`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
 CellLabel->"Out[6]//TableForm=",
 CellID->3523]
}, Open  ]],

Cell[TextData[{
 "The following example repeats the previous query, adding a condition that \
the ",
 StyleBox["TITLE_ID",
  FontSlant->"Italic"],
 " in the two tables must be equal. Using a condition is often a useful way \
to narrow the search results."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->31758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLES\>\"", ",", "\"\<ROYSCHED\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE\>\""}], "}"}], ",", " ",
       
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}]}], 
     "}"}], ",", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<TITLES\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], "]"}],
      " ", "\[Equal]", " ", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<ROYSCHED\>\"", ",", " ", "\"\<TITLE_ID\>\""}], "}"}], 
      "]"}]}], ",", 
    RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "5"}], ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
 CellLabel->"In[7]:=",
 CellID->12105],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TITLE\"\>", "\<\"TITLE_ID\"\>", "\<\"TITLE_ID\"\>", \
"\<\"ROYALTY\"\>"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.1`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.12`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.16`"},
    {"\<\"Designer Class Action Suits\"\>", "\<\"BS1001\"\>", \
"\<\"BS1001\"\>", "0.18`"},
    {"\<\"Self Hypnosis: A Beginner's Guide\"\>", "\<\"PY2002\"\>", \
"\<\"PY2002\"\>", "0.1`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
 CellLabel->"Out[7]//TableForm=",
 CellID->29621]
}, Open  ]],

Cell["\<\
You may specify that a column value must be between certain values.\
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->17095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   " ", 
   RowBox[{".10", "<", " ", 
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "<", " ", 
    ".15"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
 CellLabel->"In[8]:=",
 CellID->7296],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
 CellLabel->"Out[8]=",
 CellID->9916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   " ", 
   RowBox[{".13", " ", ">", " ", 
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", ">", " ", 
    ".10"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
 CellLabel->"In[9]:=",
 CellID->15678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
 CellLabel->"Out[9]=",
 CellID->10178]
}, Open  ]],

Cell["\<\
You may specify that a column value must be equal to a certain value. \
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->13579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
 CellLabel->"In[10]:=",
 CellID->25058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
 CellLabel->"Out[10]=",
 CellID->27577]
}, Open  ]],

Cell["\<\
You may specify that a column value must not be equal to a certain value. \
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->12750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "!=", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
 CellLabel->"In[11]:=",
 CellID->14007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
 CellLabel->"Out[11]=",
 CellID->23729]
}, Open  ]],

Cell["\<\
You may specify that a column value must be greater than a certain value. \
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->24081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", ">", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
 CellLabel->"In[12]:=",
 CellID->2995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
 CellLabel->"Out[12]=",
 CellID->2678]
}, Open  ]],

Cell["\<\
You may specify that a column value must be less than a certain value. \
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->24676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "<", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
 CellLabel->"In[13]:=",
 CellID->27753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
 CellLabel->"Out[13]=",
 CellID->20899]
}, Open  ]],

Cell["\<\
You may specify that a column value must be greater than or equal to a \
certain value. \
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->11784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", ">=", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
 CellLabel->"In[14]:=",
 CellID->15565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
 CellLabel->"Out[14]=",
 CellID->3093]
}, Open  ]],

Cell[TextData[{
 "You may specify that a column value must match a certain pattern using the \
metacharacters '%' for matching zero or more characters and '",
 StyleBox["_'", "MR"],
 " for matching a single character."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->13608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLStringMatchQ", "[", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
     "\"\<C%\>\""}], "]"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
 CellLabel->"In[15]:=",
 CellID->6172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
 CellLabel->"Out[15]=",
 CellID->11243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLStringMatchQ", "[", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
     "\"\<_S%\>\""}], "]"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
 CellLabel->"In[16]:=",
 CellID->29929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
 CellLabel->"Out[16]=",
 CellID->7514]
}, Open  ]],

Cell["\<\
You may specify that a column value must be contained as a member of a list.\
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->10168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{"SQLMemberQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{".14", ",", " ", ".16"}], "}"}], ",", " ", 
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
 CellLabel->"In[17]:=",
 CellID->5055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
 CellLabel->"Out[17]=",
 CellID->11191]
}, Open  ]],

Cell["\<\
You may specify that a column value must be less than or equal to a certain \
value. \
\>", "Text",
 CellTags->"b:4.1.1",
 CellID->5973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "<=", " ", 
    ".12"}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
 CellLabel->"In[18]:=",
 CellID->8922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
 CellLabel->"Out[18]=",
 CellID->6748]
}, Open  ]],

Cell[TextData[{
 "You may also combine any conditions using ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->5651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<TITLE_ID\>\"", ",", " ", "\"\<LORANGE\>\"", ",", "\"\<ROYALTY\>\""}],
     "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
     ".12"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<LORANGE\>\"", "]"}], " ", ">", " ", 
     "1000"}]}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
 CellLabel->"In[19]:=",
 CellID->10986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "1001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "4001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "5001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "2001", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "5001", ",", "0.12`"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
 CellLabel->"Out[19]=",
 CellID->2144]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
     ".12"}], " ", "||", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
     ".14"}]}]}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
 CellLabel->"In[20]:=",
 CellID->16446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
 CellLabel->"Out[20]=",
 CellID->31577]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<GetAsStrings\>\""], "InlineFormula"],
 " can retrieve data without converting it to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " type. This repeats the previous query without converting the data."
}], "Text",
 CellTags->"b:4.3",
 CellID->26517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
      ".12"}], " ", "||", " ", 
     RowBox[{
      RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], " ", "==", " ", 
      ".14"}]}], ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
 CellLabel->"In[21]:=",
 CellID->14629],

Cell["\<\
{{\"BS1011\", \"0.12\"}, {\"CP5018\", \"0.12\"}, 
 {\"BS1001\", \"0.12\"}, {\"PY2002\", \"0.12\"}, 
 {\"PY2002\", \"0.14\"}, {\"PY2003\", \"0.12\"}, 
 {\"PY2003\", \"0.14\"}, {\"UK3004\", \"0.12\"}, 
 {\"UK3004\", \"0.14\"}, {\"CK4005\", \"0.12\"}, 
 {\"CP5010\", \"0.12\"}, {\"PY2012\", \"0.12\"}, 
 {\"PY2013\", \"0.12\"}, {\"UK3006\", \"0.12\"}, 
 {\"UK3006\", \"0.14\"}, {\"BS1014\", \"0.12\"}, 
 {\"BS1014\", \"0.14\"}, {\"UK3015\", \"0.12\"}, 
 {\"UK3015\", \"0.14\"}, {\"CK4016\", \"0.12\"}, 
 {\"CK4017\", \"0.12\"}, {\"CK4017\", \"0.14\"}, 
 {\"BS1007\", \"0.12\"}}\
\>", "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
 CellLabel->"Out[21]//InputForm=",
 CellID->29916]
}, Open  ]],

Cell[TextData[{
 "You may also use the option ",
 Cell[BoxData["\"\<SortingColumns\>\""], "InlineFormula"],
 " to specify how to sort the data.",
 " ",
 "This option takes a list of rules. The left side of the rule specifies the \
column and the right side specifies whether to sort that data in ascending or \
descending order. The first item in the list takes precedence over the \
supplemental items."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->5874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", " ", "=", 
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<ROYSCHED\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<TITLE_ID\>\"", ",", " ", "\"\<ROYALTY\>\""}], "}"}], ",", 
    RowBox[{"\"\<SortingColumns\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}], "->", 
        "\"\<Ascending\>\""}], ",", " ", 
       RowBox[{
        RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], "->", 
        "\"\<Ascending\>\""}]}], "}"}]}]}], "]"}]}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
 CellLabel->"In[22]:=",
 CellID->15791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
 CellLabel->"Out[22]=",
 CellID->15469]
}, Open  ]],

Cell["The following plot shows that the data is now sorted.", "Text",
 CellTags->"b:4.1.1",
 CellID->22912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Last", " ", "/@", " ", "data"}], "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
 CellLabel->"In[23]:=",
 CellID->8146],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 0.1}, {2., 0.1}, {3., 0.1}, {4., 0.1}, {5., 0.1}, {6., 
     0.1}, {7., 0.1}, {8., 0.1}, {9., 0.1}, {10., 0.1}, {11., 0.1}, {12., 
     0.1}, {13., 0.1}, {14., 0.1}, {15., 0.1}, {16., 0.1}, {17., 0.1}, {18., 
     0.1}, {19., 0.12}, {20., 0.12}, {21., 0.12}, {22., 0.12}, {23., 0.12}, {
     24., 0.12}, {25., 0.12}, {26., 0.12}, {27., 0.12}, {28., 0.12}, {29., 
     0.12}, {30., 0.12}, {31., 0.12}, {32., 0.12}, {33., 0.12}, {34., 0.12}, {
     35., 0.14}, {36., 0.14}, {37., 0.14}, {38., 0.14}, {39., 0.14}, {40., 
     0.14}, {41., 0.14}, {42., 0.16}, {43., 0.16}, {44., 0.16}, {45., 0.16}, {
     46., 0.16}, {47., 0.18}, {48., 0.18}, {49., 0.18}, {50., 0.2}, {51., 
     0.2}}]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
 CellLabel->"Out[23]=",
 CellID->30693]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute."
}], "Text",
 CellTags->"b:4.3",
 CellID->9091],

Cell["This closes the connection.", "Text",
 CellTags->"b:4.1.1",
 CellID->9815],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,98"},
 CellLabel->"In[24]:=",
 CellID->26949],

Cell[TextData[{
 "The details of how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are mapped to types stored in the database is discussed in ",
 ButtonBox["Data Type Mapping",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
 "."
}], "Text",
 CellTags->"b:4.1.1",
 CellID->26857]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Selecting Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 48.8589985}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLSelect selects and returns data from a database. An alternative, \
using raw SQL, is described in Selecting Data with Raw SQL. If you find that \
the examples in this tutorial do not work as shown, you may need to install \
or restore the example database with the DatabaseExamples` package, as \
described in Using the Example Databases. Retrieving data from a database.", 
    "synonyms" -> {}, "title" -> "Selecting Data", "type" -> "Tutorial", 
    "uri" -> "DatabaseLink/tutorial/SelectingData"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.1.1"->{
  Cell[1252, 45, 428, 13, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->6813],
  Cell[3295, 108, 89, 2, 70, "Caption",
   CellTags->"b:4.1.1",
   CellID->15460],
  Cell[3387, 112, 236, 10, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->20615],
  Cell[3626, 124, 325, 9, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,76"},
   CellID->10904],
  Cell[3954, 135, 161, 7, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->2599],
  Cell[4140, 146, 202, 5, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
   CellID->20136],
  Cell[4345, 153, 5509, 158, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
   CellID->4680],
  Cell[9869, 314, 429, 15, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->9198],
  Cell[10323, 333, 343, 9, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
   CellID->27032],
  Cell[10669, 344, 4003, 107, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
   CellID->14387],
  Cell[14687, 454, 189, 7, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->32584],
  Cell[14901, 465, 198, 5, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
   CellID->7240],
  Cell[15102, 472, 1084, 24, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
   CellID->3517],
  Cell[18072, 561, 746, 13, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->18882],
  Cell[18843, 578, 901, 25, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
   CellID->25249],
  Cell[19747, 605, 1101, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
   CellID->3523],
  Cell[20863, 637, 305, 9, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->31758],
  Cell[21193, 650, 1227, 34, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
   CellID->12105],
  Cell[22423, 686, 1108, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
   CellID->29621],
  Cell[23546, 718, 129, 4, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->17095],
  Cell[23700, 726, 428, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
   CellID->7296],
  Cell[24131, 739, 1894, 51, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
   CellID->9916],
  Cell[26062, 795, 434, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
   CellID->15678],
  Cell[26499, 808, 1363, 37, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
   CellID->10178],
  Cell[27877, 848, 132, 4, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->13579],
  Cell[28034, 856, 405, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
   CellID->25058],
  Cell[28442, 868, 1364, 37, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
   CellID->27577],
  Cell[29821, 908, 136, 4, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->12750],
  Cell[29982, 916, 405, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
   CellID->14007],
  Cell[30390, 928, 2788, 75, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
   CellID->23729],
  Cell[33193, 1006, 136, 4, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->24081],
  Cell[33354, 1014, 403, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
   CellID->2995],
  Cell[33760, 1026, 1437, 39, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
   CellID->2678],
  Cell[35212, 1068, 133, 4, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->24676],
  Cell[35370, 1076, 404, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
   CellID->27753],
  Cell[35777, 1088, 1498, 41, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
   CellID->20899],
  Cell[37290, 1132, 150, 5, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->11784],
  Cell[37465, 1141, 405, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
   CellID->15565],
  Cell[37873, 1153, 2653, 71, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
   CellID->3093],
  Cell[40541, 1227, 268, 7, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->13608],
  Cell[40834, 1238, 452, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
   CellID->6172],
  Cell[41289, 1251, 1207, 33, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
   CellID->11243],
  Cell[42533, 1289, 454, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
   CellID->29929],
  Cell[42990, 1302, 1054, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
   CellID->7514],
  Cell[44059, 1334, 138, 4, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->10168],
  Cell[44222, 1342, 496, 13, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
   CellID->5055],
  Cell[44721, 1357, 1060, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
   CellID->11191],
  Cell[45796, 1389, 146, 5, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->5973],
  Cell[45967, 1398, 404, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
   CellID->8922],
  Cell[46374, 1410, 2713, 73, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
   CellID->6748],
  Cell[49102, 1486, 341, 14, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->5651],
  Cell[49468, 1504, 574, 16, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
   CellID->10986],
  Cell[50045, 1522, 1574, 38, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
   CellID->2144],
  Cell[51656, 1565, 540, 14, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
   CellID->16446],
  Cell[52199, 1581, 1896, 51, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
   CellID->31577],
  Cell[55815, 1686, 453, 11, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->5874],
  Cell[56293, 1701, 676, 17, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
   CellID->15791],
  Cell[56972, 1720, 4004, 107, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
   CellID->15469],
  Cell[60991, 1830, 107, 2, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->22912],
  Cell[61123, 1836, 199, 5, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
   CellID->8146],
  Cell[61325, 1843, 1086, 24, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
   CellID->30693],
  Cell[62626, 1878, 80, 2, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->9815],
  Cell[62709, 1882, 169, 4, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,98"},
   CellID->26949],
  Cell[62881, 1888, 336, 11, 70, "Text",
   CellTags->"b:4.1.1",
   CellID->26857]},
 "Ex--21943492438155078303,76"->{
  Cell[3626, 124, 325, 9, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,76"},
   CellID->10904]},
 "Ex--21943492438155078303,77"->{
  Cell[4140, 146, 202, 5, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
   CellID->20136],
  Cell[4345, 153, 5509, 158, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
   CellID->4680]},
 "Ex--21943492438155078303,78"->{
  Cell[10323, 333, 343, 9, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
   CellID->27032],
  Cell[10669, 344, 4003, 107, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
   CellID->14387]},
 "Ex--21943492438155078303,79"->{
  Cell[14901, 465, 198, 5, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
   CellID->7240],
  Cell[15102, 472, 1084, 24, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
   CellID->3517]},
 "b:4.3"->{
  Cell[16201, 499, 258, 9, 70, "Text",
   CellTags->"b:4.3",
   CellID->17006],
  Cell[17850, 550, 219, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->241],
  Cell[54110, 1635, 307, 9, 70, "Text",
   CellTags->"b:4.3",
   CellID->26517],
  Cell[54442, 1648, 651, 17, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
   CellID->14629],
  Cell[55096, 1667, 704, 16, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
   CellID->29916],
  Cell[62426, 1870, 197, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->9091]},
 "Ex--21943492438155078303,80"->{
  Cell[18843, 578, 901, 25, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
   CellID->25249],
  Cell[19747, 605, 1101, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
   CellID->3523]},
 "Ex--21943492438155078303,81"->{
  Cell[21193, 650, 1227, 34, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
   CellID->12105],
  Cell[22423, 686, 1108, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
   CellID->29621]},
 "Ex--21943492438155078303,82"->{
  Cell[23700, 726, 428, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
   CellID->7296],
  Cell[24131, 739, 1894, 51, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
   CellID->9916]},
 "Ex--21943492438155078303,83"->{
  Cell[26062, 795, 434, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
   CellID->15678],
  Cell[26499, 808, 1363, 37, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
   CellID->10178]},
 "Ex--21943492438155078303,84"->{
  Cell[28034, 856, 405, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
   CellID->25058],
  Cell[28442, 868, 1364, 37, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
   CellID->27577]},
 "Ex--21943492438155078303,85"->{
  Cell[29982, 916, 405, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
   CellID->14007],
  Cell[30390, 928, 2788, 75, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
   CellID->23729]},
 "Ex--21943492438155078303,86"->{
  Cell[33354, 1014, 403, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
   CellID->2995],
  Cell[33760, 1026, 1437, 39, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
   CellID->2678]},
 "Ex--21943492438155078303,87"->{
  Cell[35370, 1076, 404, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
   CellID->27753],
  Cell[35777, 1088, 1498, 41, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
   CellID->20899]},
 "Ex--21943492438155078303,88"->{
  Cell[37465, 1141, 405, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
   CellID->15565],
  Cell[37873, 1153, 2653, 71, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
   CellID->3093]},
 "Ex--21943492438155078303,89"->{
  Cell[40834, 1238, 452, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
   CellID->6172],
  Cell[41289, 1251, 1207, 33, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
   CellID->11243]},
 "Ex--21943492438155078303,90"->{
  Cell[42533, 1289, 454, 11, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
   CellID->29929],
  Cell[42990, 1302, 1054, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
   CellID->7514]},
 "Ex--21943492438155078303,91"->{
  Cell[44222, 1342, 496, 13, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
   CellID->5055],
  Cell[44721, 1357, 1060, 29, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
   CellID->11191]},
 "Ex--21943492438155078303,92"->{
  Cell[45967, 1398, 404, 10, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
   CellID->8922],
  Cell[46374, 1410, 2713, 73, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
   CellID->6748]},
 "Ex--21943492438155078303,93"->{
  Cell[49468, 1504, 574, 16, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
   CellID->10986],
  Cell[50045, 1522, 1574, 38, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
   CellID->2144]},
 "Ex--21943492438155078303,94"->{
  Cell[51656, 1565, 540, 14, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
   CellID->16446],
  Cell[52199, 1581, 1896, 51, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
   CellID->31577]},
 "Ex--21943492438155078303,95"->{
  Cell[54442, 1648, 651, 17, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
   CellID->14629],
  Cell[55096, 1667, 704, 16, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
   CellID->29916]},
 "Ex--21943492438155078303,96"->{
  Cell[56293, 1701, 676, 17, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
   CellID->15791],
  Cell[56972, 1720, 4004, 107, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
   CellID->15469]},
 "Ex--21943492438155078303,97"->{
  Cell[61123, 1836, 199, 5, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
   CellID->8146],
  Cell[61325, 1843, 1086, 24, 70, "Output",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
   CellID->30693]},
 "Ex--21943492438155078303,98"->{
  Cell[62709, 1882, 169, 4, 70, "Input",
   CellTags->{"b:4.1.1", "Ex--21943492438155078303,98"},
   CellID->26949]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.1.1", 64875, 1941},
 {"Ex--21943492438155078303,76", 71676, 2134},
 {"Ex--21943492438155078303,77", 71826, 2138},
 {"Ex--21943492438155078303,78", 72094, 2145},
 {"Ex--21943492438155078303,79", 72365, 2152},
 {"b:4.3", 72611, 2159},
 {"Ex--21943492438155078303,80", 73201, 2178},
 {"Ex--21943492438155078303,81", 73471, 2185},
 {"Ex--21943492438155078303,82", 73743, 2192},
 {"Ex--21943492438155078303,83", 74012, 2199},
 {"Ex--21943492438155078303,84", 74283, 2206},
 {"Ex--21943492438155078303,85", 74554, 2213},
 {"Ex--21943492438155078303,86", 74825, 2220},
 {"Ex--21943492438155078303,87", 75096, 2227},
 {"Ex--21943492438155078303,88", 75369, 2234},
 {"Ex--21943492438155078303,89", 75641, 2241},
 {"Ex--21943492438155078303,90", 75913, 2248},
 {"Ex--21943492438155078303,91", 76185, 2255},
 {"Ex--21943492438155078303,92", 76457, 2262},
 {"Ex--21943492438155078303,93", 76728, 2269},
 {"Ex--21943492438155078303,94", 77000, 2276},
 {"Ex--21943492438155078303,95", 77273, 2283},
 {"Ex--21943492438155078303,96", 77541, 2290},
 {"Ex--21943492438155078303,97", 77815, 2297},
 {"Ex--21943492438155078303,98", 78086, 2304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 578, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1203, 42, 46, 1, 70, "Title",
 CellID->2741],
Cell[1252, 45, 428, 13, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->6813],
Cell[1683, 60, 442, 11, 70, "Text",
 CellID->2862],
Cell[2128, 73, 1164, 33, 70, "DefinitionBox",
 CellID->10396],
Cell[3295, 108, 89, 2, 70, "Caption",
 CellTags->"b:4.1.1",
 CellID->15460],
Cell[3387, 112, 236, 10, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->20615],
Cell[3626, 124, 325, 9, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,76"},
 CellID->10904],
Cell[3954, 135, 161, 7, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->2599],
Cell[CellGroupData[{
Cell[4140, 146, 202, 5, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
 CellID->20136],
Cell[4345, 153, 5509, 158, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,77"},
 CellID->4680]
}, Open  ]],
Cell[9869, 314, 429, 15, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->9198],
Cell[CellGroupData[{
Cell[10323, 333, 343, 9, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
 CellID->27032],
Cell[10669, 344, 4003, 107, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,78"},
 CellID->14387]
}, Open  ]],
Cell[14687, 454, 189, 7, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->32584],
Cell[CellGroupData[{
Cell[14901, 465, 198, 5, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
 CellID->7240],
Cell[15102, 472, 1084, 24, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,79"},
 CellID->3517]
}, Open  ]],
Cell[16201, 499, 258, 9, 70, "Text",
 CellTags->"b:4.3",
 CellID->17006],
Cell[16462, 510, 1385, 38, 70, "DefinitionBox3Col",
 CellID->8670],
Cell[17850, 550, 219, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->241],
Cell[18072, 561, 746, 13, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->18882],
Cell[CellGroupData[{
Cell[18843, 578, 901, 25, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
 CellID->25249],
Cell[19747, 605, 1101, 29, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,80"},
 CellID->3523]
}, Open  ]],
Cell[20863, 637, 305, 9, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->31758],
Cell[CellGroupData[{
Cell[21193, 650, 1227, 34, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
 CellID->12105],
Cell[22423, 686, 1108, 29, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,81"},
 CellID->29621]
}, Open  ]],
Cell[23546, 718, 129, 4, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->17095],
Cell[CellGroupData[{
Cell[23700, 726, 428, 11, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
 CellID->7296],
Cell[24131, 739, 1894, 51, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,82"},
 CellID->9916]
}, Open  ]],
Cell[CellGroupData[{
Cell[26062, 795, 434, 11, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
 CellID->15678],
Cell[26499, 808, 1363, 37, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,83"},
 CellID->10178]
}, Open  ]],
Cell[27877, 848, 132, 4, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->13579],
Cell[CellGroupData[{
Cell[28034, 856, 405, 10, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
 CellID->25058],
Cell[28442, 868, 1364, 37, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,84"},
 CellID->27577]
}, Open  ]],
Cell[29821, 908, 136, 4, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->12750],
Cell[CellGroupData[{
Cell[29982, 916, 405, 10, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
 CellID->14007],
Cell[30390, 928, 2788, 75, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,85"},
 CellID->23729]
}, Open  ]],
Cell[33193, 1006, 136, 4, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->24081],
Cell[CellGroupData[{
Cell[33354, 1014, 403, 10, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
 CellID->2995],
Cell[33760, 1026, 1437, 39, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,86"},
 CellID->2678]
}, Open  ]],
Cell[35212, 1068, 133, 4, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->24676],
Cell[CellGroupData[{
Cell[35370, 1076, 404, 10, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
 CellID->27753],
Cell[35777, 1088, 1498, 41, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,87"},
 CellID->20899]
}, Open  ]],
Cell[37290, 1132, 150, 5, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->11784],
Cell[CellGroupData[{
Cell[37465, 1141, 405, 10, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
 CellID->15565],
Cell[37873, 1153, 2653, 71, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,88"},
 CellID->3093]
}, Open  ]],
Cell[40541, 1227, 268, 7, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->13608],
Cell[CellGroupData[{
Cell[40834, 1238, 452, 11, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
 CellID->6172],
Cell[41289, 1251, 1207, 33, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,89"},
 CellID->11243]
}, Open  ]],
Cell[CellGroupData[{
Cell[42533, 1289, 454, 11, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
 CellID->29929],
Cell[42990, 1302, 1054, 29, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,90"},
 CellID->7514]
}, Open  ]],
Cell[44059, 1334, 138, 4, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->10168],
Cell[CellGroupData[{
Cell[44222, 1342, 496, 13, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
 CellID->5055],
Cell[44721, 1357, 1060, 29, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,91"},
 CellID->11191]
}, Open  ]],
Cell[45796, 1389, 146, 5, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->5973],
Cell[CellGroupData[{
Cell[45967, 1398, 404, 10, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
 CellID->8922],
Cell[46374, 1410, 2713, 73, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,92"},
 CellID->6748]
}, Open  ]],
Cell[49102, 1486, 341, 14, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->5651],
Cell[CellGroupData[{
Cell[49468, 1504, 574, 16, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
 CellID->10986],
Cell[50045, 1522, 1574, 38, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,93"},
 CellID->2144]
}, Open  ]],
Cell[CellGroupData[{
Cell[51656, 1565, 540, 14, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
 CellID->16446],
Cell[52199, 1581, 1896, 51, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,94"},
 CellID->31577]
}, Open  ]],
Cell[54110, 1635, 307, 9, 70, "Text",
 CellTags->"b:4.3",
 CellID->26517],
Cell[CellGroupData[{
Cell[54442, 1648, 651, 17, 70, "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
 CellID->14629],
Cell[55096, 1667, 704, 16, 70, "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,95"},
 CellID->29916]
}, Open  ]],
Cell[55815, 1686, 453, 11, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->5874],
Cell[CellGroupData[{
Cell[56293, 1701, 676, 17, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
 CellID->15791],
Cell[56972, 1720, 4004, 107, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,96"},
 CellID->15469]
}, Open  ]],
Cell[60991, 1830, 107, 2, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->22912],
Cell[CellGroupData[{
Cell[61123, 1836, 199, 5, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
 CellID->8146],
Cell[61325, 1843, 1086, 24, 70, "Output",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,97"},
 CellID->30693]
}, Open  ]],
Cell[62426, 1870, 197, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->9091],
Cell[62626, 1878, 80, 2, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->9815],
Cell[62709, 1882, 169, 4, 70, "Input",
 CellTags->{"b:4.1.1", "Ex--21943492438155078303,98"},
 CellID->26949],
Cell[62881, 1888, 336, 11, 70, "Text",
 CellTags->"b:4.1.1",
 CellID->26857]
}, Open  ]],
Cell[63232, 1902, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

