(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49487,       1480]
NotebookOptionsPosition[     34306,       1012]
NotebookOutlinePosition[     44592,       1309]
CellTagsIndexPosition[     43760,       1285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLTable" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTable"], 
         "SQLTableInformation" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLTableInformation"], "SQLTableNames" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTableNames"], 
         "SQLTables" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLTables"], 
         "SQLTableTypeNames" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLTableTypeNames"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"SQLTable\"\>", 2->"\<\"SQLTableInformation\"\>", 
      3->"\<\"SQLTableNames\"\>", 4->"\<\"SQLTables\"\>", 
      5->"\<\"SQLTableTypeNames\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Table Structure", "Title",
 CellTags->{"xref:25", "c:35", "b:3.1"},
 CellID->14197],

Cell[CellGroupData[{

Cell["Table Description", "Section",
 CellTags->"c:01a",
 CellID->22106],

Cell["\<\
This section discusses commands that get information about database tables. \
\>", "Text",
 CellTags->"b:3.1",
 CellID->8752],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->15821],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLTableNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all table names within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLTableNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["name", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "list all table names that match name within a data source", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLTables",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTables"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all tables within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLTables",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTables"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["name", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "list all tables that match name within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLTableInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all table information within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLTableInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["name", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell["\<\
list all table information for tables that match name within a data source\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLTableTypeNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list the types of table supported in this data source", "TableText"]}
  }]], "DefinitionBox",
 CellID->17296],

Cell["Functions for retrieving information about tables.", "Caption",
 CellTags->"b:3.1",
 CellID->26281],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["publisher",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:3.1",
 CellID->26021],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,63"},
 CellLabel->"In[28]:=",
 CellID->24455],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTableNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"]], "InlineFormula"],
 " returns a list of the names of the tables within the connection."
}], "Text",
 CellTags->"b:3.1",
 CellID->15947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
 CellLabel->"In[3]:=",
 CellID->27124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AUTHORS\"\>", ",", "\<\"EDITORS\"\>", 
   ",", "\<\"PUBLISHERS\"\>", ",", "\<\"ROYSCHED\"\>", ",", "\<\"SALES\"\>", 
   ",", "\<\"SALESDETAILS\"\>", ",", "\<\"TITLEAUTHORS\"\>", 
   ",", "\<\"TITLEDITORS\"\>", ",", "\<\"TITLES\"\>"}], "}"}]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
 CellLabel->"Out[3]=",
 CellID->18318]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTables",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTables"]], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " expressions. These hold information about the tables in a database."
}], "Text",
 CellTags->"b:3.1",
 CellID->9135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
 CellLabel->"In[4]:=",
 CellID->11376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"AUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"EDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"PUBLISHERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALESDETAILS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEAUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
 CellLabel->"Out[4]=",
 CellID->1774]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTableInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"]], 
  "InlineFormula"],
 " returns more complete information about tables."
}], "Text",
 CellTags->"b:3.1",
 CellID->29859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", "conn", "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
 CellLabel->"In[5]:=",
 CellID->24998],

Cell[BoxData[
 TagBox[GridBox[{
    {"Null", "\<\"PUBLIC\"\>", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null",
      "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
 CellLabel->"Out[5]//TableForm=",
 CellID->12074]
}, Open  ]],

Cell[TextData[{
 "With each function, you can filter the names of the tables by providing a \
string to match as the second parameter. An important point is that this \
filtering is done on the database server, which leads to significant speed \
enhancements. The following example searches for a table named ",
 StyleBox["AUTHORS",
  FontSlant->"Italic"],
 ". If no such table existed, the result would be an empty list."
}], "Text",
 CellTags->"b:3.1",
 CellID->9253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", 
  RowBox[{"conn", ",", " ", "\"\<AUTHORS\>\""}], "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
 CellLabel->"In[6]:=",
 CellID->6922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"SQLTable", "[", 
   RowBox[{"\<\"AUTHORS\"\>", ",", 
    RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], 
  "}"}]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
 CellLabel->"Out[6]=",
 CellID->10635]
}, Open  ]],

Cell[TextData[{
 "It is also possible to give metacharacters to match more than one table. \
The metacharacters are '%' which matches zero or more characters, and '_' \
which matches a single character. The following command returns the names of \
all tables that start with ",
 StyleBox["TITLE",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:3.1",
 CellID->1643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<TITLE%\>\""}], "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
 CellLabel->"In[7]:=",
 CellID->28888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TITLEAUTHORS\"\>", ",", "\<\"TITLEDITORS\"\>", 
   ",", "\<\"TITLES\"\>"}], "}"}]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
 CellLabel->"Out[7]=",
 CellID->8153]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTables",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTables"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SQLTableNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableNames"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["SQLTableInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"]], 
  "InlineFormula"],
 " take a number of options."
}], "Text",
 CellTags->"b:3.1",
 CellID->13232],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<TableType\>\"", "\"\<TABLE\>\"", Cell[
    "type of table to be returned", "TableText"]},
   {"\"\<Catalog\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database catalog to use", "TableText"]},
   {"\"\<Schema\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "database schema to use", "TableText"]},
   {"\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to return headings with the results (",
     Cell[BoxData[
      ButtonBox["SQLTableInformation",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"]], 
      "InlineFormula"],
     " option only)"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->4747],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<TableType\>\""], "InlineFormula"],
 " selects which type of table is returned. Typically, it is the tables of \
type ",
 StyleBox["TABLE",
  FontSlant->"Italic"],
 " that are of interest and by default ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " table functions only return information on these. You can use ",
 Cell[BoxData[
  ButtonBox["SQLTableTypeNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"]], 
  "InlineFormula"],
 " to find all the different types of tables in your data source."
}], "Text",
 CellTags->"b:3.1",
 CellID->28680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
 CellLabel->"In[8]:=",
 CellID->19926],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GLOBAL TEMPORARY\"\>", ",", "\<\"SYSTEM TABLE\"\>", 
   ",", "\<\"TABLE\"\>", ",", "\<\"VIEW\"\>"}], "}"}]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
 CellLabel->"Out[8]=",
 CellID->25678]
}, Open  ]],

Cell[TextData[{
 "If you want to see all the tables in the data source, you can use the \
result of ",
 Cell[BoxData[
  ButtonBox["SQLTableTypeNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableTypeNames"]], 
  "InlineFormula"],
 " with the option ",
 Cell[BoxData["\"\<TableType\>\""], "InlineFormula"],
 ". This is demonstrated in the following."
}], "Text",
 CellTags->"b:3.1",
 CellID->6450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", 
  RowBox[{"conn", ",", 
   RowBox[{"\"\<TableType\>\"", "\[Rule]", 
    RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]}]}], "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
 CellLabel->"In[9]:=",
 CellID->14801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_ALIASES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_ALLTYPEINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_AUTHORIZATIONS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_BESTROWIDENTIFIER\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CACHEINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CATALOGS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_CONSTRAINTS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CLASSPRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_COLLATIONS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_COLUMNPRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_COLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CROSSREFERENCE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_INDEXINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PRIMARYKEYS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PROCEDURECOLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PROCEDURES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_PROPERTIES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_ROLE_AUTHORIZATION_DESCRIPTORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SCHEMAS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SCHEMATA\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SEQUENCES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SESSIONINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SESSIONS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SUPERTABLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_SUPERTYPES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLEPRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLETYPES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TABLE_CONSTRAINTS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TEXTTABLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TRIGGERCOLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TRIGGERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_TYPEINFO\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_UDTATTRIBUTES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_UDTS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_USERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VERSIONCOLUMNS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEWS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"AUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"EDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"PUBLISHERS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"ROYSCHED\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SALESDETAILS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEAUTHORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLEDITORS\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}], ",", 
   
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"TITLES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
 CellLabel->"Out[9]=",
 CellID->24961]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<ShowColumnHeadings\>\""], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["SQLTableInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTableInformation"]], 
  "InlineFormula"],
 " to return the column headings."
}], "Text",
 CellTags->"b:3.1",
 CellID->14199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLTableInformation", "[", 
   RowBox[{"conn", ",", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
 CellLabel->"In[10]:=",
 CellID->20855],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TABLE_CAT\"\>", "\<\"TABLE_SCHEM\"\>", "\<\"TABLE_NAME\"\>", \
"\<\"TABLE_TYPE\"\>", "\<\"REMARKS\"\>", "\<\"TYPE_CAT\"\>", \
"\<\"TYPE_SCHEM\"\>", "\<\"TYPE_NAME\"\>", \
"\<\"SELF_REFERENCING_COL_NAME\"\>", "\<\"REF_GENERATION\"\>", \
"\<\"HSQLDB_TYPE\"\>", "\<\"READ_ONLY\"\>"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"AUTHORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"EDITORS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"PUBLISHERS\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"ROYSCHED\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"SALESDETAILS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEAUTHORS\"\>", "\<\"TABLE\"\>", 
     "Null", "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", 
     "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLEDITORS\"\>", "\<\"TABLE\"\>", "Null",
      "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"},
    {"Null", "\<\"PUBLIC\"\>", "\<\"TITLES\"\>", "\<\"TABLE\"\>", "Null", 
     "Null", "Null", "Null", "Null", "Null", "\<\"MEMORY\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
 CellLabel->"Out[10]//TableForm=",
 CellID->26363]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:3.1",
 CellID->5716],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,72"},
 CellLabel->"In[11]:=",
 CellID->10573],

Cell[TextData[{
 "If the database was designed with particular schema and catalogs, you can \
also select tables by using the ",
 Cell[BoxData["\"\<Catalog\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Schema\>\""], "InlineFormula"],
 " options."
}], "Text",
 CellTags->"b:3.1",
 CellID->31561]
}, Open  ]],

Cell[CellGroupData[{

Cell["Table Representation", "Section",
 CellTags->{"xref:77", "c:36", "b:3.2"},
 CellID->23245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " expressions hold information about the tables in a database. "
}], "Text",
 CellTags->"b:3.2",
 CellID->6473],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->28274],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLTable",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLTable"], "[", 
     StyleBox["table", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "expression that represents an SQL table", "TableText"]}
  }]], "DefinitionBox",
 CellID->1550],

Cell[TextData[{
 "An example demonstrating ",
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " expressions follows. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:3.2",
 CellID->24353],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:3.2", "Ex--21943492438155078303,73"},
 CellLabel->"In[12]:=",
 CellID->1181],

Cell[TextData[{
 "The ",
 StyleBox["TableType", "MR"],
 " option is used to select the type of the table in the database."
}], "Text",
 CellTags->"b:3.2",
 CellID->4287],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<TableType\>\"", "\"\<TABLE\>\"", Cell[
    "type of the table", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->2699],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["SQLTables",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTables"]], "InlineFormula"],
 " is used to return a list of the tables in the database; they are returned \
as ",
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " expressions. In this example, a pattern is given to match the names of the \
tables, and the ",
 Cell[BoxData["\"\<TableType\>\""], "InlineFormula"],
 " option is set to return tables of all types."
}], "Text",
 CellTags->"b:3.2",
 CellID->18110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTables", "[", 
  RowBox[{"conn", ",", "\"\<%SA%\>\"", ",", " ", 
   RowBox[{"\"\<TableType\>\"", "\[Rule]", 
    RowBox[{"SQLTableTypeNames", "[", "conn", "]"}]}]}], "]"}]], "Input",
 CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
 CellLabel->"In[3]:=",
 CellID->18643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_COLUMN_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_ROUTINE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_CHECK_TABLE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_USAGE_PRIVILEGES\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_COLUMN_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_ROUTINE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SYSTEM_VIEW_TABLE_USAGE\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"SYSTEM TABLE\"\>"}]}], 
    "]"}], ",", 
   RowBox[{"SQLTable", "[", 
    RowBox[{"\<\"SAMPLETABLE1\"\>", ",", 
     RowBox[{"\<\"TableType\"\>", "\[Rule]", "\<\"TABLE\"\>"}]}], "]"}]}], 
  "}"}]], "Output",
 CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
 CellLabel->"Out[3]=",
 CellID->17465]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:3.2",
 CellID->7172],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:3.2", "Ex--21943492438155078303,75"},
 CellLabel->"In[4]:=",
 CellID->2529],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLTable"]], "InlineFormula"],
 " expressions can also be used in commands as shown in ",
 ButtonBox["Selecting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 "."
}], "Text",
 CellTags->"b:3.2",
 CellID->9981]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Table Structure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 56.2964509}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "This section discusses commands that get information about database \
tables. If you find that the examples in this section do not work as shown, \
you may need to install or restore the example database with the \
DatabaseExamples` package, as described in Using the Example Databases. \
Functions for retrieving information about tables.", "synonyms" -> {}, 
    "title" -> "Table Structure", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/TableStructure"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:25"->{
  Cell[1772, 52, 89, 2, 70, "Title",
   CellTags->{"xref:25", "c:35", "b:3.1"},
   CellID->14197]},
 "c:35"->{
  Cell[1772, 52, 89, 2, 70, "Title",
   CellTags->{"xref:25", "c:35", "b:3.1"},
   CellID->14197]},
 "b:3.1"->{
  Cell[1772, 52, 89, 2, 70, "Title",
   CellTags->{"xref:25", "c:35", "b:3.1"},
   CellID->14197],
  Cell[1961, 62, 135, 4, 70, "Text",
   CellTags->"b:3.1",
   CellID->8752],
  Cell[4645, 142, 105, 2, 70, "Caption",
   CellTags->"b:3.1",
   CellID->26281],
  Cell[4753, 146, 216, 10, 70, "Text",
   CellTags->"b:3.1",
   CellID->26021],
  Cell[4972, 158, 324, 9, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,63"},
   CellID->24455],
  Cell[5299, 169, 274, 8, 70, "Text",
   CellTags->"b:3.1",
   CellID->15947],
  Cell[5598, 181, 161, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
   CellID->27124],
  Cell[5762, 187, 388, 8, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
   CellID->18318],
  Cell[6165, 198, 424, 13, 70, "Text",
   CellTags->"b:3.1",
   CellID->9135],
  Cell[6614, 215, 157, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
   CellID->11376],
  Cell[6774, 221, 1499, 41, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
   CellID->1774],
  Cell[8288, 265, 272, 9, 70, "Text",
   CellTags->"b:3.1",
   CellID->29859],
  Cell[8585, 278, 202, 6, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
   CellID->24998],
  Cell[8790, 286, 1926, 37, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
   CellID->12074],
  Cell[10731, 326, 469, 10, 70, "Text",
   CellTags->"b:3.1",
   CellID->9253],
  Cell[11225, 340, 198, 5, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
   CellID->6922],
  Cell[11426, 347, 277, 8, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
   CellID->10635],
  Cell[11718, 358, 372, 10, 70, "Text",
   CellTags->"b:3.1",
   CellID->1643],
  Cell[12115, 372, 202, 5, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
   CellID->28888],
  Cell[12320, 379, 228, 6, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
   CellID->8153],
  Cell[12563, 388, 544, 19, 70, "Text",
   CellTags->"b:3.1",
   CellID->13232],
  Cell[14249, 443, 641, 19, 70, "Text",
   CellTags->"b:3.1",
   CellID->28680],
  Cell[14915, 466, 165, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
   CellID->19926],
  Cell[15083, 472, 254, 6, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
   CellID->25678],
  Cell[15352, 481, 422, 13, 70, "Text",
   CellTags->"b:3.1",
   CellID->6450],
  Cell[15799, 498, 275, 7, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
   CellID->14801],
  Cell[16077, 507, 9110, 221, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
   CellID->24961],
  Cell[25202, 731, 357, 12, 70, "Text",
   CellTags->"b:3.1",
   CellID->14199],
  Cell[25584, 747, 286, 8, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
   CellID->20855],
  Cell[25873, 757, 2218, 42, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
   CellID->26363],
  Cell[28106, 802, 78, 2, 70, "Text",
   CellTags->"b:3.1",
   CellID->5716],
  Cell[28187, 806, 167, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,72"},
   CellID->10573],
  Cell[28357, 812, 302, 9, 70, "Text",
   CellTags->"b:3.1",
   CellID->31561]},
 "c:01a"->{
  Cell[1886, 58, 72, 2, 70, "Section",
   CellTags->"c:01a",
   CellID->22106]},
 "Ex--21943492438155078303,63"->{
  Cell[4972, 158, 324, 9, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,63"},
   CellID->24455]},
 "Ex--21943492438155078303,64"->{
  Cell[5598, 181, 161, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
   CellID->27124],
  Cell[5762, 187, 388, 8, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
   CellID->18318]},
 "Ex--21943492438155078303,65"->{
  Cell[6614, 215, 157, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
   CellID->11376],
  Cell[6774, 221, 1499, 41, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
   CellID->1774]},
 "Ex--21943492438155078303,66"->{
  Cell[8585, 278, 202, 6, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
   CellID->24998],
  Cell[8790, 286, 1926, 37, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
   CellID->12074]},
 "Ex--21943492438155078303,67"->{
  Cell[11225, 340, 198, 5, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
   CellID->6922],
  Cell[11426, 347, 277, 8, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
   CellID->10635]},
 "Ex--21943492438155078303,68"->{
  Cell[12115, 372, 202, 5, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
   CellID->28888],
  Cell[12320, 379, 228, 6, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
   CellID->8153]},
 "Ex--21943492438155078303,69"->{
  Cell[14915, 466, 165, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
   CellID->19926],
  Cell[15083, 472, 254, 6, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
   CellID->25678]},
 "Ex--21943492438155078303,70"->{
  Cell[15799, 498, 275, 7, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
   CellID->14801],
  Cell[16077, 507, 9110, 221, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
   CellID->24961]},
 "Ex--21943492438155078303,71"->{
  Cell[25584, 747, 286, 8, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
   CellID->20855],
  Cell[25873, 757, 2218, 42, 70, "Output",
   CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
   CellID->26363]},
 "Ex--21943492438155078303,72"->{
  Cell[28187, 806, 167, 4, 70, "Input",
   CellTags->{"b:3.1", "Ex--21943492438155078303,72"},
   CellID->10573]},
 "xref:77"->{
  Cell[28696, 826, 96, 2, 70, "Section",
   CellTags->{"xref:77", "c:36", "b:3.2"},
   CellID->23245]},
 "c:36"->{
  Cell[28696, 826, 96, 2, 70, "Section",
   CellTags->{"xref:77", "c:36", "b:3.2"},
   CellID->23245]},
 "b:3.2"->{
  Cell[28696, 826, 96, 2, 70, "Section",
   CellTags->{"xref:77", "c:36", "b:3.2"},
   CellID->23245],
  Cell[28795, 830, 260, 8, 70, "Text",
   CellTags->"b:3.2",
   CellID->6473],
  Cell[29837, 865, 413, 15, 70, "Text",
   CellTags->"b:3.2",
   CellID->24353],
  Cell[30253, 882, 318, 9, 70, "Input",
   CellTags->{"b:3.2", "Ex--21943492438155078303,73"},
   CellID->1181],
  Cell[30574, 893, 169, 6, 70, "Text",
   CellTags->"b:3.2",
   CellID->4287],
  Cell[31147, 913, 625, 18, 70, "Text",
   CellTags->"b:3.2",
   CellID->18110],
  Cell[31797, 935, 301, 7, 70, "Input",
   CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
   CellID->18643],
  Cell[32101, 944, 1518, 37, 70, "Output",
   CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
   CellID->17465],
  Cell[33634, 984, 78, 2, 70, "Text",
   CellTags->"b:3.2",
   CellID->7172],
  Cell[33715, 988, 165, 4, 70, "Input",
   CellTags->{"b:3.2", "Ex--21943492438155078303,75"},
   CellID->2529],
  Cell[33883, 994, 369, 12, 70, "Text",
   CellTags->"b:3.2",
   CellID->9981]},
 "Ex--21943492438155078303,73"->{
  Cell[30253, 882, 318, 9, 70, "Input",
   CellTags->{"b:3.2", "Ex--21943492438155078303,73"},
   CellID->1181]},
 "Ex--21943492438155078303,74"->{
  Cell[31797, 935, 301, 7, 70, "Input",
   CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
   CellID->18643],
  Cell[32101, 944, 1518, 37, 70, "Output",
   CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
   CellID->17465]},
 "Ex--21943492438155078303,75"->{
  Cell[33715, 988, 165, 4, 70, "Input",
   CellTags->{"b:3.2", "Ex--21943492438155078303,75"},
   CellID->2529]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:25", 35890, 1049},
 {"c:35", 36001, 1053},
 {"b:3.1", 36113, 1057},
 {"c:01a", 39401, 1157},
 {"Ex--21943492438155078303,63", 39516, 1161},
 {"Ex--21943492438155078303,64", 39664, 1165},
 {"Ex--21943492438155078303,65", 39926, 1172},
 {"Ex--21943492438155078303,66", 40189, 1179},
 {"Ex--21943492438155078303,67", 40453, 1186},
 {"Ex--21943492438155078303,68", 40716, 1193},
 {"Ex--21943492438155078303,69", 40979, 1200},
 {"Ex--21943492438155078303,70", 41243, 1207},
 {"Ex--21943492438155078303,71", 41510, 1214},
 {"Ex--21943492438155078303,72", 41776, 1221},
 {"xref:77", 41905, 1225},
 {"c:36", 42020, 1229},
 {"b:3.2", 42136, 1233},
 {"Ex--21943492438155078303,73", 43209, 1267},
 {"Ex--21943492438155078303,74", 43357, 1271},
 {"Ex--21943492438155078303,75", 43623, 1278}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1147, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1772, 52, 89, 2, 70, "Title",
 CellTags->{"xref:25", "c:35", "b:3.1"},
 CellID->14197],
Cell[CellGroupData[{
Cell[1886, 58, 72, 2, 70, "Section",
 CellTags->"c:01a",
 CellID->22106],
Cell[1961, 62, 135, 4, 70, "Text",
 CellTags->"b:3.1",
 CellID->8752],
Cell[2099, 68, 442, 11, 70, "Text",
 CellID->15821],
Cell[2544, 81, 2098, 59, 70, "DefinitionBox",
 CellID->17296],
Cell[4645, 142, 105, 2, 70, "Caption",
 CellTags->"b:3.1",
 CellID->26281],
Cell[4753, 146, 216, 10, 70, "Text",
 CellTags->"b:3.1",
 CellID->26021],
Cell[4972, 158, 324, 9, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,63"},
 CellID->24455],
Cell[5299, 169, 274, 8, 70, "Text",
 CellTags->"b:3.1",
 CellID->15947],
Cell[CellGroupData[{
Cell[5598, 181, 161, 4, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
 CellID->27124],
Cell[5762, 187, 388, 8, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,64"},
 CellID->18318]
}, Open  ]],
Cell[6165, 198, 424, 13, 70, "Text",
 CellTags->"b:3.1",
 CellID->9135],
Cell[CellGroupData[{
Cell[6614, 215, 157, 4, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
 CellID->11376],
Cell[6774, 221, 1499, 41, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,65"},
 CellID->1774]
}, Open  ]],
Cell[8288, 265, 272, 9, 70, "Text",
 CellTags->"b:3.1",
 CellID->29859],
Cell[CellGroupData[{
Cell[8585, 278, 202, 6, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
 CellID->24998],
Cell[8790, 286, 1926, 37, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,66"},
 CellID->12074]
}, Open  ]],
Cell[10731, 326, 469, 10, 70, "Text",
 CellTags->"b:3.1",
 CellID->9253],
Cell[CellGroupData[{
Cell[11225, 340, 198, 5, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
 CellID->6922],
Cell[11426, 347, 277, 8, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,67"},
 CellID->10635]
}, Open  ]],
Cell[11718, 358, 372, 10, 70, "Text",
 CellTags->"b:3.1",
 CellID->1643],
Cell[CellGroupData[{
Cell[12115, 372, 202, 5, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
 CellID->28888],
Cell[12320, 379, 228, 6, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,68"},
 CellID->8153]
}, Open  ]],
Cell[12563, 388, 544, 19, 70, "Text",
 CellTags->"b:3.1",
 CellID->13232],
Cell[13110, 409, 1136, 32, 70, "DefinitionBox3Col",
 CellID->4747],
Cell[14249, 443, 641, 19, 70, "Text",
 CellTags->"b:3.1",
 CellID->28680],
Cell[CellGroupData[{
Cell[14915, 466, 165, 4, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
 CellID->19926],
Cell[15083, 472, 254, 6, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,69"},
 CellID->25678]
}, Open  ]],
Cell[15352, 481, 422, 13, 70, "Text",
 CellTags->"b:3.1",
 CellID->6450],
Cell[CellGroupData[{
Cell[15799, 498, 275, 7, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
 CellID->14801],
Cell[16077, 507, 9110, 221, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,70"},
 CellID->24961]
}, Open  ]],
Cell[25202, 731, 357, 12, 70, "Text",
 CellTags->"b:3.1",
 CellID->14199],
Cell[CellGroupData[{
Cell[25584, 747, 286, 8, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
 CellID->20855],
Cell[25873, 757, 2218, 42, 70, "Output",
 CellTags->{"b:3.1", "Ex--21943492438155078303,71"},
 CellID->26363]
}, Open  ]],
Cell[28106, 802, 78, 2, 70, "Text",
 CellTags->"b:3.1",
 CellID->5716],
Cell[28187, 806, 167, 4, 70, "Input",
 CellTags->{"b:3.1", "Ex--21943492438155078303,72"},
 CellID->10573],
Cell[28357, 812, 302, 9, 70, "Text",
 CellTags->"b:3.1",
 CellID->31561]
}, Open  ]],
Cell[CellGroupData[{
Cell[28696, 826, 96, 2, 70, "Section",
 CellTags->{"xref:77", "c:36", "b:3.2"},
 CellID->23245],
Cell[28795, 830, 260, 8, 70, "Text",
 CellTags->"b:3.2",
 CellID->6473],
Cell[29058, 840, 442, 11, 70, "Text",
 CellID->28274],
Cell[29503, 853, 331, 10, 70, "DefinitionBox",
 CellID->1550],
Cell[29837, 865, 413, 15, 70, "Text",
 CellTags->"b:3.2",
 CellID->24353],
Cell[30253, 882, 318, 9, 70, "Input",
 CellTags->{"b:3.2", "Ex--21943492438155078303,73"},
 CellID->1181],
Cell[30574, 893, 169, 6, 70, "Text",
 CellTags->"b:3.2",
 CellID->4287],
Cell[30746, 901, 398, 10, 70, "DefinitionBox3Col",
 CellID->2699],
Cell[31147, 913, 625, 18, 70, "Text",
 CellTags->"b:3.2",
 CellID->18110],
Cell[CellGroupData[{
Cell[31797, 935, 301, 7, 70, "Input",
 CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
 CellID->18643],
Cell[32101, 944, 1518, 37, 70, "Output",
 CellTags->{"b:3.2", "Ex--21943492438155078303,74"},
 CellID->17465]
}, Open  ]],
Cell[33634, 984, 78, 2, 70, "Text",
 CellTags->"b:3.2",
 CellID->7172],
Cell[33715, 988, 165, 4, 70, "Input",
 CellTags->{"b:3.2", "Ex--21943492438155078303,75"},
 CellID->2529],
Cell[33883, 994, 369, 12, 70, "Text",
 CellTags->"b:3.2",
 CellID->9981]
}, Open  ]]
}, Open  ]],
Cell[34279, 1010, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

