(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16313,        591]
NotebookOptionsPosition[     10357,        380]
NotebookOutlinePosition[     14101,        501]
CellTagsIndexPosition[     14007,        495]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLUpdate" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLUpdate"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"SQLUpdate\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Updating Data", "Title",
 CellID->4693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 " modifies data in a database. An alternative, using raw SQL, is described \
in ",
 ButtonBox["Updating Data with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLUpdatingData"],
 ". "
}], "Text",
 CellTags->"b:4.1.4",
 CellID->337],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->31311],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query."
}], "Text",
 CellTags->"b:4.1.4",
 CellID->17604],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLUpdate",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["table", "TI"], ",", "{", 
     StyleBox["columns", "TI"], "}", ",", "{", 
     StyleBox["values", "TI"], "}", ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "update data in a database", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLUpdate",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["table", "TI"], ",", "{", 
     StyleBox["columns", "TI"], "}", ",", "{", 
     StyleBox["values", "TI"], "}", ",", 
     StyleBox["condition", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "update data in a database using a condition", "TableText"]}
  }]], "DefinitionBox",
 CellID->12677],

Cell["Updating data in a database.", "Caption",
 CellTags->"b:4.1.4",
 CellID->406],

Cell[TextData[{
 "Here is an example that updates data. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:4.1.4",
 CellID->7768],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[1]:=",
 CellID->29022],

Cell[TextData[{
 "A new table, ",
 Cell[BoxData["TEST"], "InlineFormula"],
 ", is created and data is inserted."
}], "Text",
 CellTags->"b:4.1.4",
 CellID->19413],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{
   "conn", ",", " ", "\"\<TEST\>\"", ",", " ", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL1\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<INTEGER\>\""}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"SQLColumn", "[", 
       RowBox[{"\"\<COL2\>\"", ",", " ", 
        RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<DOUBLE\>\""}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{"10", ",", " ", "10.5"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[3]:=",
 CellID->5000],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " shows the values in the table."
}], "Text",
 CellTags->"b:4.1.4",
 CellID->542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[5]:=",
 CellID->17537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"10", ",", "10.5`"}], "}"}], "}"}]], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[5]=",
 CellID->30038]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 " updates the elements in the database and ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " shows the result."
}], "Text",
 CellTags->"b:4.1.4",
 CellID->21388],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLUpdate", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", " ", "12.5"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]}], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[6]:=",
 CellID->7355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"12", ",", "12.5`"}], "}"}], "}"}]], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[7]=",
 CellID->13289]
}, Open  ]],

Cell[TextData[{
 "Typically, it is useful to set a condition for an update, with the \
condition specifying which rows should be updated. (For more information on \
conditions, see ",
 ButtonBox["Selecting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SelectingData"],
 ".)",
 " ",
 "In the following example, another row is inserted into the database. "
}], "Text",
 CellTags->"b:4.1.4",
 CellID->31647],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", "  ", 
    RowBox[{"{", 
     RowBox[{"20", ",", " ", "20.5"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]}], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[8]:=",
 CellID->3181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "12.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "20.5`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[9]=",
 CellID->13093]
}, Open  ]],

Cell["\<\
Here an update is given for rows for which the entry in the first column is \
less than 15.\
\>", "Text",
 CellTags->"b:4.1.4",
 CellID->16584],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLUpdate", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<COL1\>\"", ",", " ", "\"\<COL2\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1.1"}], "}"}], ",", " ", 
    RowBox[{
     RowBox[{"SQLColumn", "[", "\"\<COL1\>\"", "]"}], " ", "<", " ", "15"}]}],
    " ", "]"}], ";"}], "\n", 
 RowBox[{"SQLSelect", "[", 
  RowBox[{"conn", ",", "\"\<TEST\>\""}], "]"}]}], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[10]:=",
 CellID->10987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "20.5`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.1.4",
 CellLabel->"Out[11]=",
 CellID->10761]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 " accepts one option."
}], "Text",
 CellTags->"b:4.3",
 CellID->20493],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->8217],

Cell[TextData[{
 "Option of ",
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->9501],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute."
}], "Text",
 CellTags->"b:4.3",
 CellID->17482],

Cell["This drops the table and closes the connection.", "Text",
 CellTags->"b:4.1.4",
 CellID->29447],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.1.4",
 CellLabel->"In[12]:=",
 CellID->15665]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Updating Data - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 59.9683024}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLUpdate modifies data in a database. An alternative, using raw SQL, is \
described in Updating Data with Raw SQL. If you find that the examples in \
this tutorial do not work as shown, you may need to install or restore the \
example database with the DatabaseExamples` package, as described in Using \
the Example Databases. The result of SQLUpdate is an integer specifying the \
number of rows affected by the query.", "synonyms" -> {}, "title" -> 
    "Updating Data", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/UpdatingData"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.1.4"->{
  Cell[1251, 45, 412, 13, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->337],
  Cell[2112, 73, 289, 9, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->17604],
  Cell[3304, 111, 83, 2, 70, "Caption",
   CellTags->"b:4.1.4",
   CellID->406],
  Cell[3390, 115, 268, 10, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->7768],
  Cell[3661, 127, 287, 9, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->29022],
  Cell[3951, 138, 162, 6, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->19413],
  Cell[4116, 146, 934, 24, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->5000],
  Cell[5053, 172, 232, 8, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->542],
  Cell[5310, 184, 165, 5, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->17537],
  Cell[5478, 191, 163, 6, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->30038],
  Cell[5656, 200, 402, 13, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->21388],
  Cell[6083, 217, 431, 12, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->7355],
  Cell[6517, 231, 163, 6, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->13289],
  Cell[6695, 240, 430, 12, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->31647],
  Cell[7150, 256, 442, 12, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->3181],
  Cell[7595, 270, 242, 9, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->13093],
  Cell[7852, 282, 153, 5, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->16584],
  Cell[8030, 291, 541, 15, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->10987],
  Cell[8574, 308, 241, 9, 70, "Output",
   CellTags->"b:4.1.4",
   CellID->10761],
  Cell[9963, 364, 101, 2, 70, "Text",
   CellTags->"b:4.1.4",
   CellID->29447],
  Cell[10067, 368, 248, 7, 70, "Input",
   CellTags->"b:4.1.4",
   CellID->15665]},
 "b:4.3"->{
  Cell[8830, 320, 221, 8, 70, "Text",
   CellTags->"b:4.3",
   CellID->20493],
  Cell[9540, 345, 219, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->9501],
  Cell[9762, 356, 198, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->17482]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.1.4", 12016, 418},
 {"b:4.3", 13744, 482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 578, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1203, 42, 45, 1, 70, "Title",
 CellID->4693],
Cell[1251, 45, 412, 13, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->337],
Cell[1666, 60, 443, 11, 70, "Text",
 CellID->31311],
Cell[2112, 73, 289, 9, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->17604],
Cell[2404, 84, 897, 25, 70, "DefinitionBox",
 CellID->12677],
Cell[3304, 111, 83, 2, 70, "Caption",
 CellTags->"b:4.1.4",
 CellID->406],
Cell[3390, 115, 268, 10, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->7768],
Cell[3661, 127, 287, 9, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->29022],
Cell[3951, 138, 162, 6, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->19413],
Cell[4116, 146, 934, 24, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->5000],
Cell[5053, 172, 232, 8, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->542],
Cell[CellGroupData[{
Cell[5310, 184, 165, 5, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->17537],
Cell[5478, 191, 163, 6, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->30038]
}, Open  ]],
Cell[5656, 200, 402, 13, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->21388],
Cell[CellGroupData[{
Cell[6083, 217, 431, 12, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->7355],
Cell[6517, 231, 163, 6, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->13289]
}, Open  ]],
Cell[6695, 240, 430, 12, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->31647],
Cell[CellGroupData[{
Cell[7150, 256, 442, 12, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->3181],
Cell[7595, 270, 242, 9, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->13093]
}, Open  ]],
Cell[7852, 282, 153, 5, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->16584],
Cell[CellGroupData[{
Cell[8030, 291, 541, 15, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->10987],
Cell[8574, 308, 241, 9, 70, "Output",
 CellTags->"b:4.1.4",
 CellID->10761]
}, Open  ]],
Cell[8830, 320, 221, 8, 70, "Text",
 CellTags->"b:4.3",
 CellID->20493],
Cell[9054, 330, 483, 13, 70, "DefinitionBox3Col",
 CellID->8217],
Cell[9540, 345, 219, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->9501],
Cell[9762, 356, 198, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->17482],
Cell[9963, 364, 101, 2, 70, "Text",
 CellTags->"b:4.1.4",
 CellID->29447],
Cell[10067, 368, 248, 7, 70, "Input",
 CellTags->"b:4.1.4",
 CellID->15665]
}, Open  ]],
Cell[10330, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

