(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8740,        297]
NotebookOptionsPosition[      4346,        158]
NotebookOutlinePosition[      7714,        255]
CellTagsIndexPosition[      7599,        248]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Using the Example Databases", "Title",
 CellTags->{"xref:62", "c:141", "b:9.1"},
 CellID->14474],

Cell[TextData[{
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " contains a number of example databases (many use ",
 ButtonBox["HSQLDB",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseReference#28289"],
 "). These allow you to try examples in the documentation and learn the \
details of working with databases in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The examples are configured to run in ",
 StyleBox["$UserBaseDirectory/DatabaseResources/Examples", "InlineCode"],
 " (they cannot reside inside the main ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation directory). To run these examples you will need to install \
them. You can do this by copying the files or by running the command ",
 StyleBox["DatabaseExamplesBuild", "InlineCode"],
 " from the ",
 StyleBox["DatabaseLink`DatabaseExamples`", "InlineCode"],
 " package. This function will install the examples (if necessary) or restore \
them to their original state."
}], "Text",
 CellTags->"b:9.1",
 CellID->2625],

Cell["\<\
The following shows the location of the database examples on this computer.\
\>", "Text",
 CellTags->"b:9.1",
 CellID->25627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToFileName", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$UserBaseDirectory", ",", " ", "\"\<DatabaseResources\>\""}], 
    "}"}], ",", " ", "\"\<Examples\>\""}], "]"}]], "Input",
 CellTags->"b:9.1",
 CellLabel->"In[1]:=",
 CellID->5629],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\twj.WRI\\\\Application Data\
\\\\Mathematica\\\\DatabaseResources\\\\Examples\"\>"], "Output",
 CellTags->"b:9.1",
 CellLabel->"Out[1]=",
 CellID->31928]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"DatabaseLink`DatabaseExamples`", Cell[TextData[{
     "load the ",
     StyleBox["DatabaseExamples`", "InlineCode"],
     " package"
    }], "TableText"]},
   {
    RowBox[{"DatabaseExamplesBuild", "[", "\"\< \>\"", "]"}], Cell[
    "install and restore the database examples", "TableText"]}
  }]], "DefinitionBox",
 CellID->25423],

Cell[TextData[{
 "Using the ",
 StyleBox["DatabaseExamples`", "InlineCode"],
 " package."
}], "Caption",
 CellTags->"b:9.1",
 CellID->28520],

Cell[TextData[{
 "You must run ",
 StyleBox["DatabaseExamplesBuild", "InlineCode"],
 " the first time you want to use the documentation, and after you have been \
working with the example databases and want to restore them to their original \
state."
}], "Text",
 CellTags->"b:9.1",
 CellID->6902],

Cell["First, the package is loaded.", "Text",
 CellTags->"b:9.1",
 CellID->14962],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "DatabaseLink`DatabaseExamples`"}], ";"}]], "Input",
 CellTags->"b:9.1",
 CellLabel->"In[2]:=",
 CellID->123],

Cell["\<\
Then the examples are installed, if necessary, or restored to their original \
state.\
\>", "Text",
 CellTags->"b:9.1",
 CellID->24596],

Cell[BoxData[
 RowBox[{"DatabaseExamplesBuild", "[", " ", "]"}]], "Input",
 CellTags->"b:9.1",
 CellLabel->"In[3]:=",
 CellID->3737],

Cell[TextData[{
 "If you want to install the examples by hand, copy the ",
 StyleBox["Examples", "InlineCode"],
 " directory from inside the ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " installation directory (typically this is ",
 StyleBox["$InstallationDirectory/AddOns/Applications/DatabaseLink", 
  "InlineCode"],
 ") to ",
 StyleBox["$UserBaseDirectory/DatabaseResources", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:9.1",
 CellID->13261]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using the Example Databases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 16, 0.7182976}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "DatabaseLink contains a number of example databases (many use HSQLDB). \
These allow you to try examples in the documentation and learn the details of \
working with databases in Mathematica. The examples are configured to run in \
$UserBaseDirectory/DatabaseResources/Examples (they cannot reside inside the \
main Mathematica installation directory). To run these examples you will need \
to install them. You can do this by copying the files or by running the \
command DatabaseExamplesBuild from the DatabaseLink`DatabaseExamples` \
package. This function will install the examples (if necessary) or restore \
them to their original state. The following shows the location of the \
database examples on this computer. Using the DatabaseExamples` package.", 
    "synonyms" -> {}, "title" -> "Using the Example Databases", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/UsingTheExampleDatabases"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:62"->{
  Cell[729, 29, 102, 2, 70, "Title",
   CellTags->{"xref:62", "c:141", "b:9.1"},
   CellID->14474]},
 "c:141"->{
  Cell[729, 29, 102, 2, 70, "Title",
   CellTags->{"xref:62", "c:141", "b:9.1"},
   CellID->14474]},
 "b:9.1"->{
  Cell[729, 29, 102, 2, 70, "Title",
   CellTags->{"xref:62", "c:141", "b:9.1"},
   CellID->14474],
  Cell[834, 33, 1037, 25, 70, "Text",
   CellTags->"b:9.1",
   CellID->2625],
  Cell[1874, 60, 135, 4, 70, "Text",
   CellTags->"b:9.1",
   CellID->25627],
  Cell[2034, 68, 269, 8, 70, "Input",
   CellTags->"b:9.1",
   CellID->5629],
  Cell[2306, 78, 203, 4, 70, "Output",
   CellTags->"b:9.1",
   CellID->31928],
  Cell[2886, 97, 140, 6, 70, "Caption",
   CellTags->"b:9.1",
   CellID->28520],
  Cell[3029, 105, 297, 8, 70, "Text",
   CellTags->"b:9.1",
   CellID->6902],
  Cell[3329, 115, 81, 2, 70, "Text",
   CellTags->"b:9.1",
   CellID->14962],
  Cell[3413, 119, 149, 5, 70, "Input",
   CellTags->"b:9.1",
   CellID->123],
  Cell[3565, 126, 145, 5, 70, "Text",
   CellTags->"b:9.1",
   CellID->24596],
  Cell[3713, 133, 132, 4, 70, "Input",
   CellTags->"b:9.1",
   CellID->3737],
  Cell[3848, 139, 456, 14, 70, "Text",
   CellTags->"b:9.1",
   CellID->13261]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:62", 6382, 200},
 {"c:141", 6495, 204},
 {"b:9.1", 6608, 208}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 102, 2, 70, "Title",
 CellTags->{"xref:62", "c:141", "b:9.1"},
 CellID->14474],
Cell[834, 33, 1037, 25, 70, "Text",
 CellTags->"b:9.1",
 CellID->2625],
Cell[1874, 60, 135, 4, 70, "Text",
 CellTags->"b:9.1",
 CellID->25627],
Cell[CellGroupData[{
Cell[2034, 68, 269, 8, 70, "Input",
 CellTags->"b:9.1",
 CellID->5629],
Cell[2306, 78, 203, 4, 70, "Output",
 CellTags->"b:9.1",
 CellID->31928]
}, Open  ]],
Cell[2524, 85, 359, 10, 70, "DefinitionBox",
 CellID->25423],
Cell[2886, 97, 140, 6, 70, "Caption",
 CellTags->"b:9.1",
 CellID->28520],
Cell[3029, 105, 297, 8, 70, "Text",
 CellTags->"b:9.1",
 CellID->6902],
Cell[3329, 115, 81, 2, 70, "Text",
 CellTags->"b:9.1",
 CellID->14962],
Cell[3413, 119, 149, 5, 70, "Input",
 CellTags->"b:9.1",
 CellID->123],
Cell[3565, 126, 145, 5, 70, "Text",
 CellTags->"b:9.1",
 CellID->24596],
Cell[3713, 133, 132, 4, 70, "Input",
 CellTags->"b:9.1",
 CellID->3737],
Cell[3848, 139, 456, 14, 70, "Text",
 CellTags->"b:9.1",
 CellID->13261]
}, Open  ]],
Cell[4319, 156, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

