
Widget["Wizard", 
  {

    Script[Needs["DatabaseLink`"];],
    
    "title" -> "JDBC Driver Wizard",
    "sideBarTitle" -> "Steps",
    
    "pages" -> {
  
    Widget["WizardPage", {
      "title" -> "Overview",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["WizardHTMLPanel", {
        "text" -> "This wizard will help you create a JDBCDriver configuration used to connect to a certain database with DatabaseLink.<p>Some information about the driver is required to use this wizard.<ul><li>Driver class</li><li>URL protocol</li></ul></p><p>Many types of databases are preconfigured within this system.  However, if a type of database is not listed, one may be added using this wizard.</p>"
          }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "<b>1. Overview</b><p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Specify Driver Class<p>5. Specify Protocol"
          }]
      }, Name -> "overviewPage"],
      
    Widget["WizardPage", {
      "title" -> "Name and Description",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateNameSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the name."}, Name-> "nameHTMLPanel"],
        Widget["TextField", {
          "text" -> "",
          "toolTipText"->"The name is used to uniquely identify a driver configuration.",
          PropertyValue[{"nameField", "document"}, Name -> "nameFieldDocument"],
          BindEvent[{"nameFieldDocument", "document"},
            Script[ ValidateNameSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateNameSourcePage[];]]
        }, Name -> "nameField"],
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the description."}],
        Widget["TextArea", {
          "text" -> "",
          "toolTipText"->"The description is used to further describe the driver configuration."
        }, Name -> "descriptionField", WidgetLayout->{"Border"->""}],
        Widget["WizardHTMLPanel", {
          "text" -> "After specifying the name and description, choose 'Next' to select the visibility of the configuration."}, 
          Name->"nameContinueHTMLPanel"]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p><b>2. Specify Name and Description</b><p>3. Specify Visibility<p>4. Specify Driver Class<p>5. Specify Protocol"
          }]
      }, Name -> "nameChoicePage"],
            
    Widget["WizardPage", {
      "title" -> "Specify Visibility",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Please specify the visibility of the driver configuration."}],
        {
          Widget["RadioButton", 
          {
            "text"->"User Level",
            "selected"->True,
            BindEvent["action", 
              Script[ 
                SetPropertyValue[{"storeConfigSystemRadioButton", "selected"}, 
                  !PropertyValue[{"storeConfigUserRadioButton", "selected"}]];
              ]
            ]
            
          }, Name->"storeConfigUserRadioButton"],
          Widget["RadioButton", 
          {
            "text"->"System Level",
            "selected"->False,
            BindEvent["action", 
              Script[ 
                SetPropertyValue[{"storeConfigUserRadioButton", "selected"}, 
                  !PropertyValue[{"storeConfigSystemRadioButton", "selected"}]];
              ]
            ]
          }, Name->"storeConfigSystemRadioButton"]
        },
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the visibility of the driver configuration, choose 'Next' to specify the driver class."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p><b>3. Specify Visibility</b><p>4. Specify Driver Class<p>5. Specify Protocol"
          }]
      }, Name -> "saveLocationPage"],

    Widget["WizardPage", {
      "title" -> "Driver Class",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateDriverSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the JDBC driver class.  This class should be located on the Java classpath as directed by JLink.  It can be automatically found in the Java directory of this application or any other application.<p>Examples:<ul><li>org.hsqldb.jdbcDriver</li><li>com.mysql.jdbc.Driver</li></ul>"}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"driverField", "document"}, Name -> "driverFieldDocument"],
          BindEvent[{"driverFieldDocument", "document"},
            Script[ ValidateDriverSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateDriverSourcePage[];]]
        }, Name -> "driverField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the driver class, choose 'Next' to specify a protocol."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p><b>4. Specify Driver Class</b><p>5. Specify Protocol"
          }]
      }, Name -> "driverChoicePage"],   
      
    Widget["WizardPage", {
      "title" -> "Protocol",
      "navigationNames" -> {"Back", "Finish", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateProtocolSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the protocol used to prefix the URL which connects to the database.  By specifying the protocol users can omit the protocol when specifying a URL in a SQLConnection.  The protocol specified by the JDBCDriver is automatically prepended to the URL.<p>Examples:<ul><li>jdbc:hsqldb:</li><li>jdbc:mysql://</li></ul>"}],
        Widget["TextField", {
          "text" -> "",
          PropertyValue[{"protocolField", "document"}, Name -> "protocolFieldDocument"],
          BindEvent[{"protocolFieldDocument", "document"},
            Script[ ValidateProtocolSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateProtocolSourcePage[];]]
        }, Name -> "protocolField"],
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the protocol, choose 'Finish' to  save the driver configuration."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Specify Driver Class<p><b>5. Specify Protocol</b>"
          }]
      }, Name -> "protocolChoicePage"]

    },    
  
  Script[

    ValidateNameSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"nameField", "text"}];
        If[ TrueQ[txt =!= ""],
          If[MemberQ[JDBCDriverNames[], txt],
            SetPropertyValue[{"nameHTMLPanel", "text"}, "Specify the name.  <i>A driver configuration with this name already exists.</i>"];
            SetPropertyValue[{"nameContinueHTMLPanel", "text"}, "After specifying the name and description, choose 'Next' to select the visibility of the configuration. <i>Continuing will eventually overwrite existing settings.</i>"]
            , 
            SetPropertyValue[{"nameHTMLPanel", "text"}, "Specify the name."];
            SetPropertyValue[{"nameContinueHTMLPanel", "text"}, "After specifying the name and description, choose 'Next' to select the visibility of the configuration."]
          ];
          isValid = True;
        ];
        SetPropertyValue[{"nameChoicePage", "allowNext"}, isValid];
      ];

    ValidateDriverSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"driverField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"driverChoicePage", "allowNext"}, isValid];
      ];

    ValidateProtocolSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"protocolField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"protocolChoicePage", "allowFinish"}, isValid];
      ];
              
  ],
    
  BindEvent[{"wizard", "wizardFinished"}, 
    Script[
      Block[{name, desc, dir, loc, driver, protocol},
        name   = PropertyValue[{"nameField", "text"}];
        desc   = PropertyValue[{"descriptionField", "text"}];
        driver = PropertyValue[{"driverField", "text"}];
        protocol = PropertyValue[{"protocolField", "text"}];
        If[PropertyValue[{"storeConfigUserRadioButton", "selected"}], 
          dir = ToFileName[{$UserBaseDirectory, "DatabaseResources"}],
          dir = ToFileName[{$BaseDirectory, "DatabaseResources"}]
        ]; 
        
        (* Make a unique name *) 
        loc = name <> ".m";
        i = 0;
        While[FileNames[loc, dir] =!= {},
          loc = name <> "(" <> ToString[++i] <> ").m"
        ];
        loc = ToFileName[dir, loc];

        jdbc = JDBCDriver[
                          "Name" -> name,
                          "Description" -> desc,
                          "Driver" -> driver,
                          "Protocol" -> protocol,
                          "Version"->DatabaseLink`Information`$VersionNumber];
        If[FileNames["DatabaseResources", {dir}] === {},  
          CreateDirectory[ToFileName[{dir,"DatabaseResources"}]];
        ];
        Put[jdbc, loc];
      ]
    ]
  ],
  
  BindEvent[{"wizard", "wizardDidReset"}, 
    Script[ 
      SetPropertyValue[{"nameField", "text"}, ""];
      SetPropertyValue[{"descriptionField", "text"}, ""];
      SetPropertyValue[{"driverField", "text"}, ""];
      SetPropertyValue[{"protocolField", "text"}, ""];

      If[WidgetReference["jdbcDriver"] =!= Null, 
        Block[{driver, name, description, class, protocol, file}, 
            
          driver = JDBCDrivers[WidgetReference["jdbcDriver"]];
                       
          name = "Name" /. Options[driver] /. Options[ JDBCDriver ]; 
          description = "Description" /. Options[driver] /. Options[ JDBCDriver ]; 
          class = "Driver" /. Options[driver] /. Options[ JDBCDriver ]; 
          protocol = "Driver" /. Options[driver] /. Options[ JDBCDriver ]; 
          file = "Location"  /. Options[driver] /. Options[ JDBCDriver ]; 
             
          SetPropertyValue[{"nameField", "text"}, name];
          SetPropertyValue[{"descriptionField", "text"}, description];
          SetPropertyValue[{"driverField", "text"}, class];
          SetPropertyValue[{"protocolField", "text"}, protocol];
          If[StringMatchQ[file, $BaseDirectory <> "*"], 
            SetPropertyValue[{"storeConfigSystemRadioButton", "selected"}, True];
            SetPropertyValue[{"storeConfigUserRadioButton", "selected"}, False]
            , 
            SetPropertyValue[{"storeConfigSystemRadioButton", "selected"}, False];
            SetPropertyValue[{"storeConfigUserRadioButton", "selected"}, True]; 
          ]; 
        ];
      ];
    ] 
  ]
  
}, Name -> "wizard"]
  