Widget["Dialog", {

  Script[Needs["DatabaseLink`"];],
  
  "title"->"Save Query", 
  "modal"->True,
  
  Widget["Panel", {
    WidgetFill[],
    WidgetGroup[
      {
        {
          WidgetFill[],
          WidgetFill[],
          WidgetFill[],
          WidgetFill[]
        },
        { 
          WidgetFill[],
          Widget["Label", {"text" -> "Name: "}, Name->"nameLabel"],
          Widget["TextField", 
          {
             PropertyValue[{"name", "document"}, Name -> "nameDocument"],
             BindEvent[{"nameDocument", "document"},
               Script[ ValidatePanel[];]]
          }, Name -> "name"],
          WidgetFill[]
        },
        { 
          WidgetFill[],
          Widget["Label", {"text" -> "Description: "}],
          Widget["TextField", Name -> "description"],
          WidgetFill[]
        },
        { 
          WidgetFill[],
          Widget["Label", {"text" -> "Location: "}, Name->"locationLabel"],
          Widget["ComboBox", 
            {
              "editable" -> True, 
              "autoComplete"->False,
              "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
              PropertyValue[{"location", "editor"}, Name->"locationEditor"],
              Script[
                lec = WidgetReference["locationEditor"]@getEditorComponent[];
                PropertyValue[{lec, "document"}, Name->"locationDocument"];
              ],
              (*
              PropertyValue[{"locationEditor", "editorComponent"}, Name->"locationEditorComponent"],
              PropertyValue[{"locationEditorComponent", "document"}, Name->"locationDocument"],
              *)
              BindEvent[{"locationDocument", "document"},
                Script[ ValidatePanel[];]],
              BindEvent["action", 
                Script[ ValidatePanel[];]]
            }, Name -> "location"],
          WidgetFill[]
        }            
      }, WidgetLayout->Grid
    ], 
    {
      WidgetFill[],
      Widget["Button", {"text" -> "Ok"}, Name -> "ok"],
      Widget["Button", {"text" -> "Cancel"}, Name -> "cancel" ],
      WidgetFill[]
    },
    WidgetFill[]
  }], 
  
  Script[
    shorten[str_String] := 
      If[StringLength[str] > 50, 
        StringTake[str, 25] <> "..." <> StringTake[str, -25], 
        str
      ];          

    locationChoices = DatabaseResourcesPath[];
    shortLocationChoices = (shorten /@ Drop[DatabaseResourcesPath[], {1, 2}]);
    PrependTo[shortLocationChoices, "$BaseDirectory/DatabaseResources"];
    PrependTo[shortLocationChoices, "$UserBaseDirectory/DatabaseResources"];

    SetAttributes[ canonicalOptions, {Listable}];
    canonicalOptions[name_Symbol -> val_] := SymbolName[name] -> val;
    canonicalOptions[expr___] := expr;

    ValidatePanel[] := 
      Module[{txt, isValid1 = False, isValid2 = False},
        txt = PropertyValue[{"name", "text"}];
        If[ TrueQ[txt =!= ""],
          SetPropertyValue[{"nameLabel", "foreground"}, WidgetReference["black"]];            
          isValid1 = True,
          SetPropertyValue[{"nameLabel", "foreground"}, WidgetReference["red"]];            
        ];
        lec = WidgetReference["locationEditor"]@getEditorComponent[];
        txt = PropertyValue[{lec, "text"}];
        If[ TrueQ[StringMatchQ[txt,"*.m"]],
          SetPropertyValue[{"locationLabel", "foreground"}, WidgetReference["black"]];            
          isValid2 = True,
          SetPropertyValue[{"locationLabel", "foreground"}, WidgetReference["red"]];            
        ];
        SetPropertyValue[{"ok", "enabled"}, isValid1 && isValid2];
      ];
      
    createDir[filename_String] :=
      Module[{
        file = filename, 
        dir = DirectoryName[filename], 
        shortfilename, 
        lst = {}}, 
        shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file]}];
        While[dir =!= file && FileNames[shortfilename, dir] == {},
          PrependTo[lst, shortfilename];
          file = dir;
          dir = DirectoryName[file];
          shortfilename = StringTake[file, {StringLength[dir] + 1, StringLength[file] - 1}];
        ];
        If[lst === {}, Return[]];
        If[dir === file, lst = Drop[lst, 1]];
        lst = Drop[lst , -1];
        (file = ToFileName[file, #];
           CreateDirectory[file]) & /@ lst;
      ];
  ],
    
  BindEvent[{"saveQueryDialog", "windowActivated"},
    Script[
      If[WidgetReference["queryToSave"] === Null, 
        SetPropertyValue[{"name", "text"}, ""];
        SetPropertyValue[{"description", "text"}, ""];
        SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, ""]],

        Block[{query, name, description, file, opts}, 
              
          query = WidgetReference["queryToSave"];
              
          opts  = canonicalOptions[Flatten[Options[query]]];  
          name = "Name" /. opts /. Options[ SQLSelect ]; 
          If[name === "Name" || name === Null, name = ""];
          description = "Description" /. opts /. Options[ SQLSelect ]; 
          If[description === "Description" || description === Null, description = ""];
          file = "Location" /. opts /. Options[ SQLSelect ];
          If[file === "Location" || file === Null, file = ""];
              
          SetPropertyValue[{"name", "text"}, name];
          SetPropertyValue[{"description", "text"}, description];

          If[!MemberQ[locationChoices, file], 
            If[file =!= "", 
              locationChoices = Prepend[locationChoices, file];
              shortLocationChoices = Prepend[shortLocationChoices, shorten[file]];
              SetPropertyValue[{"location", "items"}, shortLocationChoices], 
              SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, ""]];              
            ];
          ];
          SetPropertyValue[{"location", "selectedItem"}, file];
        ];
      ];
      ValidatePanel[];
    ]
  ],

  BindEvent[{"location", "action"}, 
    Script[
      Block[{loc, file}, 
        loc = PropertyValue[{"location", "selectedIndex"}];
        If[loc > 0, 
          file = locationChoices[[loc]];
          If[StringMatchQ[file, "*\\"] || StringMatchQ[file, "*/"], 
            file = ToFileName[file, PropertyValue[{"name", "text"}] <> ".m"];
          ];
          SetPropertyValue[{"location", "items"}, Prepend[shortLocationChoices, file]];
          SetPropertyValue[{"location", "selectedItem"}, file];
        ]
      ]  
    ] 
  ],
        
  BindEvent[{"ok", "action"},
    Script[
      Block[{name, desc, loc, query, opts, maxrows, timeout, distinct, sc, sch,
             gas, colWidth},
        name   = PropertyValue[{"name", "text"}];
        desc   = PropertyValue[{"description", "text"}];
        loc    = PropertyValue[{"location", "selectedItem"}];
        
        query = WidgetReference["queryToSave"];

        opts = canonicalOptions[Flatten[{Options[query]}]];
        maxrows = "MaxRows" /. opts /. Options[ SQLSelect ]; 
        timeout = "Timeout" /. opts /. Options[ SQLSelect ]; 
        distinct = "Distinct" /. opts /. Options[ SQLSelect ]; 
        sc = "SortingColumns" /. opts /. Options[ SQLSelect ]; 
        sch = "ShowColumnHeadings" /. opts /. Options[ SQLSelect ]; 
        gas = "GetAsStrings" /. opts /. Options[ SQLSelect ]; 
        colWidth = "ColumnWidths" /. opts /. Options[ SQLSelect ]; 
        
        query  = SQLSelect[query[[1]], query[[2]], query[[3]], query[[4]], 
                   "SortingColumns"->sc,
                   "Distinct"->distinct,
                   "MaxRows"->maxrows, 
                   "Timeout"->timeout,
                   "ShowColumnHeadings"->sch,
                   "GetAsStrings"->gas,
                   "Name"->name,
                   "Description"->desc,
                   "ColumnWidths"->colWidth,
                   "Version"->DatabaseLink`Information`$VersionNumber];
                   
        createDir[loc];
        Put[query, loc];   
               
        query  = SQLSelect[query[[1]], query[[2]], query[[3]], query[[4]], 
                   "SortingColumns"->sc,
                   "Distinct"->distinct,
                   "MaxRows"->maxrows, 
                   "Timeout"->timeout,
                   "ShowColumnHeadings"->sch,
                   "GetAsStrings"->gas,
                   "Name"->name,
                   "Description"->desc,
                   "ColumnWidths"->colWidth,
                   "Version"->DatabaseLink`Information`$VersionNumber, 
                   "Location"->loc];

        SetWidgetReference["queryToSave", query];
        
        InvokeMethod[{"saveQueryDialog", "dispose"}];
      ]
    ]
  ],
    
  BindEvent[{"cancel", "action"},
    Script[
      InvokeMethod[{"saveQueryDialog", "dispose"}];
    ]
  ]  
}, Name->"saveQueryDialog"]