Widget["Frame", 
  {
    "title"-> "Enter Password",
    
    Script[Needs["DatabaseLink`"]],
    
    Widget["DatabaseLink/Dialogs/Password", ExposeWidgetReferences -> {
      "welcomeLabel", "usernameField", "passwordField", "ok", "cancel"}],
    
    BindEvent[{"usernameField", "action"},
      Script[
        username = PropertyValue[{"usernameField", "text"}];
        password = PropertyValue[{"passwordField", "text"}];
        InvokeMethod[{"passwordFrame", "dispose"}];
      ]
    ],

    BindEvent[{"passwordField", "action"},
      Script[
        username = PropertyValue[{"usernameField", "text"}];
        password = PropertyValue[{"passwordField", "text"}];
        InvokeMethod[{"passwordFrame", "dispose"}];
      ]
    ],

    BindEvent[{"ok", "action"},
      Script[
        username = PropertyValue[{"usernameField", "text"}];
        password = PropertyValue[{"passwordField", "text"}];
        InvokeMethod[{"passwordFrame", "dispose"}];
      ]
    ],

    BindEvent[{"cancel", "action"},
      Script[
        InvokeMethod[{"passwordFrame", "dispose"}];
        username = None;
        password = None;
      ]
    ],
    
    BindEvent["endModal",
      Script[
        {username, password}
      ]
    ],
    
    BindEvent[{"passwordFrame", "windowActivated"},
      Script[
        name = DatabaseLink`SQL`Private`passwordDialogName;
        username = DatabaseLink`SQL`Private`passwordDialogUsername;
        password = "";
        
        If[name === Null, name = ""];
        SetPropertyValue[{"welcomeLabel", "text"}, "Enter username and password for \"" <> name <> "\"."];
        SetPropertyValue[{"usernameField", "text"}, username];
      ]
    ]
    
  }, Name -> "passwordFrame"
]
