Widget["Frame", {
  Script[Needs["DatabaseLink`"]],

  "title" -> "Database Explorer", 

(**** This section defines all the actions for the menu bar, tool bar, and 
      context sensentive menu *)
  
  Widget["Action", 
    {
      "name" -> "Open Connection",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/New16.gif"}],
      "shortDescription" -> "Connect to a data source.",
      "accelerator" -> Widget["MenuShortcut", InitialArguments -> {"O"}]
    }, Name -> "connectionAction"],

  Widget["Action", 
    {
      "name" -> "New",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/Add16.gif"}],
      "shortDescription" -> "Create a new query.",
      "accelerator" -> Widget["MenuShortcut", InitialArguments -> {"N"}]
    }, Name -> "newAction"],

  Widget["Action", 
    {
      "name" -> "Save",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/Save16.gif"}],
      "shortDescription" -> "Save the query.",
      "accelerator" -> Widget["MenuShortcut", InitialArguments -> {"S"}]
    }, Name -> "saveAction"],

  Widget["Action", 
    {
      "name" -> "Save As...",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/SaveAs16.gif"}],
      "shortDescription" -> "Save the query as ..."
    }, Name -> "saveAsAction"],
(*
  Widget["Action", 
    {
      "name" -> "Stop",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/Stop16.gif"}],
      "shortDescription" -> "Stop the query."
    }, Name -> "stopAction"],
*)
  Widget["Action", 
    {
      "name" -> "Reload",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/Refresh16.gif"}],
      "shortDescription" -> "Reload the query."
    }, Name -> "reloadAction"],

  Widget["Action", 
    {
      "name" -> "Delete",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/Delete16.gif"}],
      "shortDescription" -> "Delete the query.",
      "accelerator" -> Widget["MenuShortcut", InitialArguments -> {"DELETE"}]
    }, Name -> "deleteAction"],

  Widget["Action", 
    {
      "name" -> "Save to Notebook",
      "icon" -> Widget["Icon", {"path" -> "DatabaseLink/Images/Edit16.gif"}],
      "shortDescription" -> "Create a notebook with this query."
    }, Name -> "notebookAction"],

(**** This section defines the menu *)
  "menus" -> Widget["MenuBar", {
    Widget["Menu", {
      "text" -> "File",
      Widget["MenuItem", {
        "action"->WidgetReference["connectionAction"]
      }, Name->"connectionMenuItem"], 
      Widget["MenuSeparator"], 
      Widget["MenuItem", {
        "action"->WidgetReference["newAction"]
      }, Name->"newMenuItem"], 
      Widget["MenuSeparator"], 
      Widget["MenuItem", {
        "action"->WidgetReference["saveAction"]
      }, Name->"saveMenuItem"], 
      Widget["MenuItem", {
        "action"->WidgetReference["saveAsAction"]
      }, Name->"saveAsMenuItem"], 
      Widget["MenuItem", {
        "action"->WidgetReference["notebookAction"]
      }, Name->"notebookMenuItem"],
      Widget["MenuSeparator"], 
      Widget["MenuItem", {
        "action"->WidgetReference["deleteAction"]
      }, Name->"deleteMenuItem"], 
      Widget["MenuSeparator"], 
      Widget["MenuItem", {
        "text" -> "Exit",
        BindEvent["action", Script[CloseGUIObject[]]]
      }]
    }],
    Widget["Menu", {
      "text" -> "View",
(*    Widget["MenuItem", {
        "enabled"->False,
        "action"->WidgetReference["stopAction"]
      }, Name->"stopMenuItem"], *)
      Widget["MenuItem", {
        "action"->WidgetReference["reloadAction"]
      },Name->"reloadMenuItem"]
    }], 
    Widget["Menu", {
      "text" -> "Help",
      Widget["MenuItem", {
        "text" -> "About Database Explorer...",
        BindEvent[{"aboutMenuItem", "action"}, 
          InvokeMethod[{"helpDialog", "show"}]
        ]
      }, Name->"aboutMenuItem"]
    }]    
  }], 
                        
(**** This section defines the popup menu *)
  Widget["PopupMenu", {
    Widget["MenuItem", {
      "action"->WidgetReference["connectionAction"]
    }, Name->"connectionMenuItem"], 
    Widget["MenuSeparator"], 
    Widget["MenuItem", {
      "action"->WidgetReference["newAction"]
    }], 
    Widget["MenuSeparator"], 
    Widget["MenuItem", {
      "action"->WidgetReference["saveAction"]
    }], 
    Widget["MenuItem", {
      "action"->WidgetReference["saveAsAction"]
    }], 
    Widget["MenuItem", {
      "action"->WidgetReference["notebookAction"]
    }],
    Widget["MenuSeparator"], 
    Widget["MenuItem", {
      "action"->WidgetReference["deleteAction"]
    }], 
    Widget["MenuSeparator"], 
(*  Widget["MenuItem", {
      "enabled"->False,
      "action"->WidgetReference["stopAction"]
    }], *)
    Widget["MenuItem", {
      "action"->WidgetReference["reloadAction"]
    }]
  }, Name->"popupMenu"],

(**** This section defines the tool bar *)                               

  Widget["ToolBar", 
    {
      Widget["Button", {
        "action"->WidgetReference["connectionAction"],
        "text"->""
      }, Name -> "connectionButton"], 
      Widget["Button", {
        "action"->WidgetReference["newAction"],
        "text"->""      
      }, Name -> "newButton"], 
      Widget["Button", {
        "action"->WidgetReference["saveAction"],
        "text"->""      
      }, Name -> "saveButton"], 
      Widget["Button", {
        "action"->WidgetReference["saveAsAction"],
        "text"->""      
      }, Name -> "saveAsButton"], 
      Widget["Button", {
        "action"->WidgetReference["deleteAction"],
        "text"->""      
      }, Name -> "deleteButton"], 
      Widget["Button", {
        "action"->WidgetReference["reloadAction"],
        "text"->""      
      }, Name -> "reloadButton"], 
(*      
      Widget["Button", {
        "action"->WidgetReference["stopAction"],
        "text"->""      
      }, Name -> "stopButton"], 
*)
      Widget["Button", {
        "action"->WidgetReference["notebookAction"],
        "text"->""      
      }, Name -> "notebookButton"], 
      "floatable" -> True, 
      "rollover" -> True
    },
    Name -> "toolBar"],

(**** This section defines any dialogs *)
                                                                               
  Widget["DatabaseLink/Dialogs/SaveQuery", Name->"saveQueryDialog"], 
  
  Widget["Dialog", {
    "title"-> "Confirm Deletion",
    "modal"->True,     
    Widget["Panel", 
      {
        "preferredSize" -> Widget["Dimension", {"width" -> 250, "height" -> 50}], 
        {
          Widget["Label", {"text"->"Are you sure you want to delete?"}, Name->"deleteText"]
        },
        {
          WidgetFill[],
          Widget["Button", {"text" -> "Yes"}, Name->"confirmDeleteButton"],
          Widget["Button", {"text" -> "No"}, Name->"noDeleteButton"],
          WidgetFill[]
        }
      }]}, Name->"deleteQueryDialog"],
  
  Widget["Dialog", {
    "title"-> "Select Data Source",
    "modal"->True,
     
    Widget["DatabaseLink/Dialogs/SelectDataSource", ExposeWidgetReferences -> {"connectionList", "ok", "cancel"} ],
    
    Script[
      conn = Null;
    ],
    
    BindEvent[{"ok", "action"},
      Script[
        If[PropertyValue[{"connectionList", "selectedValues"}] =!= Null,          
          If[Length[PropertyValue[{"connectionList", "selectedValues"}]] > 0, 
            Block[{connName, sqlConn, password},
              connName = First[PropertyValue[{"connectionList", "selectedValues"}]];
              If[connName =!= "" && !MemberQ["Name" /. (Options /@ SQLConnections[]), connName],               
                sqlConn = DataSources[][[First[Flatten[Position[DataSourceNames[], connName]]]]];
                password = "Password" /. Options[sqlConn];
                If[StringQ[password] && StringMatchQ[password, "$Prompt"], 
                  InvokeMethod[{"passwordDialog", "show"}];
                  password = PropertyValue[{"passwordField", "text"}];
                  sqlConn = sqlConn /. {("Password" -> _) -> ("Password" -> password)};
                ];
                conn = OpenSQLConnection[sqlConn];                
                If[conn =!= Null && conn =!= $Failed,
                  KeepJavaObject[conn[[2]]];
                  AppendTo[conns, conn];
                ]
              ];
            ];
          ];
        ];
        InvokeMethod[{"dataSourceDialog", "dispose"}];
      ]
    ],    
    BindEvent[{"cancel", "action"},
      {
        InvokeMethod[{"dataSourceDialog", "dispose"}]
      }
    ]        
  }, Name -> "dataSourceDialog", InitialArguments -> {WidgetReference["mainFrame"]}],
    
  Widget["Dialog", {
    "title"-> "Enter Password",
    "modal"->True,
     
    Widget["DatabaseLink/Dialogs/Password", ExposeWidgetReferences -> {"passwordField", "ok"->"passwordOk", "cancel"->"passwordCancel"} ],
        
    BindEvent[{"passwordField", "action"},
      {
        InvokeMethod[{"passwordDialog", "dispose"}]
      }
    ],
    BindEvent[{"passwordOk", "action"},
      {
        InvokeMethod[{"passwordDialog", "dispose"}]
      }
    ],
    BindEvent[{"passwordCancel", "action"},
      {
        InvokeMethod[{"passwordDialog", "dispose"}]
      }
    ]
    
  }, Name -> "passwordDialog", InitialArguments -> {WidgetReference["dataSourceDialog"]}],    

  Widget["DatabaseLink/Dialogs/toCome", {
    SetPropertyValue[{"aboutSQLToolsTextPanel", "text"}, 
      "<html><head><title>Database Explorer</title></head><body><h1><i>Database Explorer</i></h1>Version Number: 1.0.0</body></html>"]
  }, Name -> "helpDialog", ExposeWidgetReferences -> {"dialogTextPanel" -> "aboutSQLToolsTextPanel"}],
  
(**** This section defines the GUI *)

  WidgetGroup[{
    WidgetGroup[{
      WidgetGroup[{
        Widget["Panel", {
          WidgetSpace[10],
          {
            WidgetGroup[{
              Widget["Label", {"text" -> " Queries:"}],
              Widget["ScrollPane", {
                "preferredSize" -> Widget["Dimension", {"width" -> 130, "height" -> 150}],
                "viewportView" -> 
                  Widget["List", {
                    "items" -> {},
                    PropertyValue["selectionModel", Name -> "queryListSelectionModel"],
                    "selectionMode" -> 
                      PropertyValue[{"queryListSelectionModel", "SINGLE_SELECTION"}]
                  }, Name -> "queryList"]
              }, WidgetLayout -> {"Stretching" -> {Maximize, Maximize}}]
            },
            WidgetLayout -> {"Grouping" -> Column},
            Name -> "datalistPanes"]
          }
        },    
        WidgetLayout -> {"Stretching" -> { True, True}, "Border" -> { {{10, 0}, {0, 10}}}},
        Name -> "mainPanel"]

      }, WidgetLayout -> Row],
      WidgetGroup[{
        Widget["DatabaseLink/SQLQuery", 
          ExposeWidgetReferences->{
                                    "connectionList"->"queryConnectionList", 
                                    "tableList", 
                                    "columnList",
                                    "conditionCheckBox",
                                    "conditionComboBox",
                                    "conditions",
                                    "sortCheckBox",
                                    "sorts",
                                    "timeoutCheckBox", 
                                    "timeoutTextField", 
                                    "limitCheckBox", 
                                    "limitTextField", 
                                    "distinctCheckBox",
                                    "showColumnHeadingsCheckBox",
                                    "getAsStringsCheckBox", 
                                    "selectAllButton",
                                    "advancedOptionsButton", 
                                    "advancedOptionsPanel"
                                  }, Name->"query"],
        Widget["ScrollPane", {
          "preferredSize" -> Widget["Dimension", {"width" -> 500, "height" -> 500}],
          "viewportView" -> 
            Widget["Table", {
              "columnSelectionAllowed"->True,
              "columnEditable"->{False},
              "autoResizeMode"->PropertyValue["AUTO_RESIZE_OFF"],
              PropertyValue["selectionModel", Name -> "contentTableSelectionModel"],
              PropertyValue["model", Name-> "contentTableModel"]
            }, Name->"contentTable"]
        }, WidgetLayout -> {"Stretching" -> Automatic}]
      }, 
      WidgetLayout -> {"Grouping" -> {Tabs, Bottom, {"Query", "Result"}},
        "Border" -> {{5, 5}, {5, 0}}
      }, Name->"tabbedPane"]
    }, 
    WidgetLayout -> {"Grouping" -> {Split, Horizontal}, "Stretching" -> { True, True} },
    Name -> "mainGroup"]
  }, WidgetLayout -> Column],
  
  Widget["Label", Name->"statusBar", WidgetLayout->{"Border"->"", "Stretching" -> { True, False}}],

  SetPropertyValue[{"mainGroup", "oneTouchExpandable"}, True],
  
(**** This section defines bind events *)

  (* Action events for menu bar, tool bar, and context sensitive menu *)
  BindEvent[{"connectionAction", "action"},
    Script[openConnection[]]], 

  BindEvent[{"newAction", "action"},
    Script[newQuery[]], InvokeThread->"New"],

  BindEvent[{"saveAction", "action"},
    Script[saveQuery[]]],

  BindEvent[{"saveAsAction", "action"},
    Script[saveQueryAs[Null]]],

  BindEvent[{"reloadAction", "action"},
    Script[reloadQuery[]], InvokeThread->"New"],

(*
  BindEvent[{"stopAction", "action"},
   InvokeMethod[{"ScriptEvaluator", "abort"}]],
*)
  BindEvent[{"deleteAction", "action"},
    Script[
      InvokeMethod[{"deleteQueryDialog", "show"}];
      KeepJavaObject[#[[2]]] & /@ conns;
    ]
  ],

  BindEvent[{"notebookAction", "action"},
    Script[createNotebook[]]],

  (* Action events for popup menu *)
  (*
  BindEvent[{"queryList", "mousePressed"},
    Script[
      If[ MemberQ[ "PropertyNames" /. GUIInformation["#", {"PropertyNames"}], "popupTrigger"],
        If[ TrueQ[ PropertyValue[{"#", "popupTrigger"}]],
          InvokeMethod[{"popupMenu", "show"}, 
            PropertyValue[{"#", "component"}], PropertyValue[{"#", "x"}], PropertyValue[{"#", "y"}]]];
        ]
      ]
    ],
  BindEvent[{"queryList", "mouseReleased"},
    Script[
      If[ MemberQ[ "PropertyNames" /. GUIInformation["#", {"PropertyNames"}], "popupTrigger"],
        If[ TrueQ[ PropertyValue[{"#", "popupTrigger"}]],
          InvokeMethod[{"popupMenu", "show"}, 
            PropertyValue[{"#", "component"}], PropertyValue[{"#", "x"}], PropertyValue[{"#", "y"}]]];
        ]
      ]
    ],
  *)
  (* Action events for confirm deletion dialog *)
  BindEvent[{"noDeleteButton", "action"}, 
    Script[InvokeMethod[{"deleteQueryDialog", "dispose"}]]],

  BindEvent[{"confirmDeleteButton", "action"}, 
    Script[deleteQuery[];InvokeMethod[{"deleteQueryDialog", "dispose"}]]],  
    
  (* Action event for the connection item in the query - updates table names *)
  BindEvent[{"queryConnectionList", "action"},
    Script[ 
      If[selectedConn =!= PropertyValue[{"queryConnectionList", "selectedItem"}],
        selectedConn = PropertyValue[{"queryConnectionList", "selectedItem"}];
        filterODBC[];
        updateTableList[]
      ]
    ], Name->"queryConnectionListActionListener"],

  (* Action event for the table item in the query - updates column names *)
  BindEvent[{"tableList", "valueChanged"},
    Script[ 
      If[selectedTables =!= PropertyValue[{"tableList", "selectedValues"}],
        selectedTables = PropertyValue[{"tableList", "selectedValues"}];
        updateColumnLists[]
      ]
    ], Name->"tableListActionListener"],

  (* Action event for the query list - switches queries *)
  BindEvent[{"queryList", "valueChanged"},
    Script[
      If[selectedValue =!= PropertyValue[{"queryList", "selectedValue"}],
        selectedValue = PropertyValue[{"queryList", "selectedValue"}];
        swapOutQuery[];
        swapInQuery[getQuery[StringDrop[PropertyValue[{"queryList", "selectedValue"}],-1]]];
        executeQuery[]
      ]
    ], InvokeThread->"New"
  ],

  (* Action event for the tabs - executes query *)
  BindEvent[{"tabbedPane", "stateChanged"},
    Script[ 
      swapOutQuery[];
      executeQuery[]
    ], InvokeThread->"New"
  ],
  
  (* Action event for the condition item in query - enables/disables *)
  BindEvent[{"conditionCheckBox", "action"},
    SetPropertyValue[{"conditionComboBox", "enabled"}, 
      PropertyValue[{"conditionCheckBox", "selected"}]],
    SetPropertyValue[{"conditions", "enabled"}, 
      PropertyValue[{"conditionCheckBox", "selected"}]]
  ],                          

  (* Action event for the sort item in query - enables/disables *)
  BindEvent[{"sortCheckBox", "action"},
    SetPropertyValue[{"sorts", "enabled"}, 
      PropertyValue[{"sortCheckBox", "selected"}]]
  ],                          

  (* Action event for the advanced item in query - shows/hides *)
  BindEvent[{"advancedOptionsButton", "action"}, 
    Script[
      Block[{visible = PropertyValue[{"advancedOptionsPanel", "visible"}]}, 
        If[visible, 
          SetPropertyValue[{"advancedOptionsButton", "text"}, "Show Advanced Options"], 
          SetPropertyValue[{"advancedOptionsButton", "text"}, "Hide Advanced Options"]
        ];
        SetPropertyValue[{"advancedOptionsPanel", "visible"}, !visible];
      ]
    ]
  ], 

  (* Action event for the select all item in query - selects columns *)
  BindEvent[{"selectAllButton", "action"}, 
    Script[
      Block[{items = PropertyValue[{"columnList", "items"}]}, 
        InvokeMethod[{"columnList", "setSelectionInterval"}, 0, Length[items]-1];
      ]
    ]
  ], 

  (* Action events for main window *)
  BindEvent[{"mainFrame", "windowClosed"}, 
    Script[
      CloseSQLConnection /@ conns;
    ]
  ],
  
  BindEvent[{"mainFrame", "windowActivated"},
    Script[
      Block[{model = PropertyValue[{"queryList", "model"}]}, 
        If[PropertyValue[{model, "size"}] < 1, 
          newQuery[]
        ];
      ]
    ]
  ],

(**** This section defines the Mathematica code *)
  Script[
  
    conn = Null;                 
    conns = {};
    
    queryIndex = 1;
    currentQuery = Null;
    currentLocation = Null;
    currentDescription = Null;
    queries = SQLQueries[];
    reload = False;
    
    openConnection[]:=
      Module[{}, 
        InvokeMethod[{"dataSourceDialog", "show"}];
        If[conn =!= Null && conn =!= $Failed, 
          KeepJavaObject[conn[[2]]];
          Block[{value = PropertyValue[{"queryConnectionList", "selectedItem"}]},           
            SetPropertyValue[{"queryConnectionList", "items"}, "Name" /. (Options /@ SQLConnections[])];
            If[value != Null, 
              SetPropertyValue[{"queryConnectionList", "selectedItem"}, value];
            ];
          ];
        ]
      ];
     
    filterODBC[] := 
      Module[{index = PropertyValue[{"queryConnectionList", "selectedIndex"}], driverName},
        If[index >= 0, 
          driverName = SQLConnections[][[index+1]][[2]]@getMetaData[]@getDriverName[];
          If[StringMatchQ[driverName, "JDBC-ODBC Bridge*"], 
            SetPropertyValue[{"timeoutTextField", "enabled"}, False];
            SetPropertyValue[{"timeoutCheckBox", "enabled"}, False], 
            SetPropertyValue[{"timeoutTextField", "enabled"}, True];
            SetPropertyValue[{"timeoutCheckBox", "enabled"}, True]
          ];
        ];
      ];
     
    updateTableList[]:=
      Module[{index = PropertyValue[{"queryConnectionList", "selectedIndex"}]},
        If[index >= 0, 
          SetPropertyValue[{"tableList", "items"}, SQLTableNames[SQLConnections[][[index+1]]]];        
        ];
      ];

    updateColumnLists[]:=
      Module[{columnNames=getColumnNames[]},
          SetPropertyValue[{"columnList", "items"}, columnNames];
          SetPropertyValue[{"columnList", "selectedIndex"}, 0];
          setWhereConditionItems[columnNames];
          setSortConditionItems[columnNames];        
      ];
      
    getColumnNames[]:=
      Module[{index, indices, tables, values, columnNames = {}, i},
        index = PropertyValue[{"queryConnectionList", "selectedIndex"}];         
        If[index >= 0, 
          indices = PropertyValue[{"tableList", "selectedIndices"}]; 
          tables = PropertyValue[{"tableList", "selectedValues"}];
          Do[
            columnNames = 
              Join[columnNames, 
                   StringDrop[StringDrop[ToString[#],1],-1] & /@ SQLColumnNames[SQLConnections[][[index+1]], tables[[i]]]],
            {i, 1, Length[indices]}];
        ];
        columnNames
      ];

    setWhereConditionItems[items_List] :=
      Module[{conditions, i},
         InvokeMethod[{"conditions", "stopEditing"}];
         conditions = PropertyValue[{"conditions", "conditions"}];
         Do[
           SetPropertyValue[{conditions[[i]], "columnItems"}, items];
           SetPropertyValue[{conditions[[i]], "valueItems"}, items];
           ,{i, 1, Length[conditions]}];
         InvokeMethod[{"conditions", "dataChanged"}];
      ];
    
    setSortConditionItems[items_List] :=
      Module[{conditions, i},
         InvokeMethod[{"sorts", "stopEditing"}];
         conditions = PropertyValue[{"sorts", "conditions"}];
         Do[
           SetPropertyValue[{conditions[[i]], "columnItems"}, items];
           ,{i, 1, Length[conditions]}];
         InvokeMethod[{"conditions", "dataChanged"}];
      ];

    newQuery[]:=
      Module[{cols, name = "Untitled-"<>ToString[queryIndex++]},
        
        query = SQLSelect["", {""}, {""}, None, Timeout->30, 
                                                MaxRows->100, 
                                                Distinct->False, 
                                                SortingColumns->None, 
                                                ShowColumnHeadings->True, 
                                                GetAsStrings->False,
                                                Name->name];
        queries = Append[Select[queries, !sameQuery[query, #] &], query];
        updateQueryList[name];
        
        swapOutQuery[];
        swapInQuery[getQuery[name]];
      ];
    
    updateQueryList[name_] :=
      Module[{names},
        names = getQueryName /@ queries;
        SetPropertyValue[{"queryList", "items"}, Sort[names]]; 
        If[name =!= Null, 
          InvokeMethod[{"queryList", "setSelectedValue"}, getQueryName[getQuery[name]], True];
        ];
      ];
      
    getQueryName[query:SQLSelect[connName_String,
                          table:(_SQLTable | {___SQLTable} | _String | {___String}),
                          columns:(_SQLColumn | {___SQLColumn}),
                          condition_,
                          opts___Rule]] :=
      Module[{useOpts, name, modified, id = " "},
        useOpts  = canonicalOptions[Flatten[{opts}]];
        name     = "Name" /. useOpts /. Options[ SQLSelect ];
        modified = MemberQ[SQLQueries[], query];
        If[!modified, id = "*"];
        name <> id      
      ];
            
    getQuery[query_String] :=
      Module[{cases},                                       
        cases = Select[queries, sameQuery[query, #]&];
        If[Length[cases] > 0, First[cases]]
      ];
              
    swapInQuery[SQLSelect[connName_String,
                          table:(_SQLTable | {___SQLTable} | _String | {___String}),
                          columns:(_SQLColumn | {___SQLColumn}),
                          condition_,
                          opts___Rule]] := 
      Module[{name, location, cols, colNames, c = {}, sort, s = {}, maxrows, 
              timeout, distinct, sch, gas, useOpts, desc},
        
        useOpts  = canonicalOptions[Flatten[{opts}]];
        name     = "Name" /. useOpts /. Options[ SQLSelect ];
        location = "Location" /. useOpts /. Options[ SQLSelect ];
        desc     = "Description" /. useOpts /. Options[ SQLSelect ];
        sort     = "SortingColumns" /. useOpts /. Options[ SQLSelect ];  
        distinct = "Distinct" /. useOpts /. Options[ SQLSelect ];
        maxrows  = "MaxRows" /. useOpts /. Options[ SQLSelect ];
        timeout  = "Timeout" /. useOpts /. Options[ SQLSelect ];
        gas      = "GetAsStrings" /. useOpts /. Options[ SQLSelect ];
        sch      = "ShowColumnHeadings" /. useOpts /. Options[ SQLSelect ];
              
        If[name === currentQuery && !reload, Return[]];
        
        InvokeMethod[{"queryConnectionList", "removeActionListener"}, 
          WidgetReference["queryConnectionListActionListener"],
          InvokeThread -> "Dispatch"];

        InvokeMethod[{"tableList", "removeListSelectionListener"}, 
          WidgetReference["tableListActionListener"],
          InvokeThread -> "Dispatch"];
          
        currentQuery = name;
        currentLocation = location;

        If[desc === "Description", desc = ""];
        currentDescription = desc;
        
        If[connName =!= "" && !MemberQ["Name" /. (Options /@ SQLConnections[]), connName], 
          conn = OpenSQLConnection[connName];
          If[conn =!= Null && conn =!= $Failed, 
            KeepJavaObject[conn[[2]]];
            AppendTo[conns, conn];
            SetPropertyValue[{"queryConnectionList", "items"}, "Name" /. (Options /@ SQLConnections[])];
          ]
        ];
        SetPropertyValue[{"queryConnectionList", "selectedItem"}, connName];
        updateTableList[];
        setSelectedValues["tableList", Flatten[{table}]];

        updateColumnLists[];
        If[Flatten[{columns}] === {SQLColumn["*"]}, 
          cols = PropertyValue[{"columnList", "items"}];
          InvokeMethod[{"columnList", "setSelectionInterval"}, 0, Length[cols]-1], 
          cols = (StringReplace[First[#], {"."->", "}] & /@ columns);
          setSelectedValues["columnList", cols];
        ];
        colNames = PropertyValue[{"columnList", "items"}];
        If[colNames =!= {}, colNames = MakeJavaObject[colNames]];

        If[condition === None, 
          SetPropertyValue[{"conditionCheckBox", "selected"}, False];
          SetPropertyValue[{"conditionComboBox", "enabled"}, False];
          SetPropertyValue[{"conditions", "enabled"}, False];
          c = {JavaNew["com.wolfram.databaselink.gui.WhereCondition", colNames, colNames]},
          SetPropertyValue[{"conditionCheckBox", "selected"}, True];
          SetPropertyValue[{"conditionComboBox", "enabled"}, True];
          SetPropertyValue[{"conditions", "enabled"}, True];
          If[MatchQ[condition, _And] || MatchQ[condition, _Or], 
            If[MatchQ[condition, _And], SetPropertyValue[{"conditionComboBox", "selectedItem"}, "All"]];
            If[MatchQ[condition, _Or], SetPropertyValue[{"conditionComboBox", "selectedItem"}, "Any"]];
            c = JavaNew["com.wolfram.databaselink.gui.WhereCondition", MakeJavaExpr[#], colNames, colNames] & /@ (List @@ condition),
            c = {JavaNew["com.wolfram.databaselink.gui.WhereCondition", MakeJavaExpr[condition], colNames, colNames]};
          ]
        ];
        SetPropertyValue[{"conditions", "conditions"}, c];

        If[sort === None, 
          SetPropertyValue[{"sortCheckBox", "selected"}, False];
          SetPropertyValue[{"sorts", "enabled"}, False];
          s = {JavaNew["com.wolfram.databaselink.gui.SortCondition", colNames]},
          SetPropertyValue[{"sortCheckBox", "selected"}, True];
          SetPropertyValue[{"sorts", "enabled"}, True];
          If[ListQ[sort], 
            s = JavaNew["com.wolfram.databaselink.gui.SortCondition", MakeJavaExpr[#], colNames] & /@ sort,
            s = {JavaNew["com.wolfram.databaselink.gui.SortCondition", MakeJavaExpr[sort], colNames]};
          ]
        ];
        SetPropertyValue[{"sorts", "conditions"}, s];

        If[maxrows === Automatic, 
          SetPropertyValue[{"limitTextField", "text"}, 100];
          SetPropertyValue[{"limitCheckBox", "selected"}, False], 
          SetPropertyValue[{"limitCheckBox", "selected"}, True];
          SetPropertyValue[{"limitTextField", "text"}, maxrows];
        ];

        If[timeout === None, 
          SetPropertyValue[{"timeoutTextField", "text"}, 30];
          SetPropertyValue[{"timeoutCheckBox", "selected"}, False], 
          SetPropertyValue[{"timeoutCheckBox", "selected"}, True];
          SetPropertyValue[{"timeoutTextField", "text"}, timeout];
        ];
        
        SetPropertyValue[{"distinctCheckBox", "selected"}, distinct];
        SetPropertyValue[{"getAsStringsCheckBox", "selected"}, gas];
        SetPropertyValue[{"showColumnHeadingsCheckBox", "selected"}, sch];        
        
        InvokeMethod[{"queryConnectionList", "addActionListener"}, 
          WidgetReference["queryConnectionListActionListener"],
          InvokeThread -> "Dispatch"];

        InvokeMethod[{"tableList", "addListSelectionListener"}, 
          WidgetReference["tableListActionListener"],
          InvokeThread -> "Dispatch"];
      ];

    swapOutQuery[]:=
      Module[{name = currentQuery,
              location = currentLocation,
              description = currentDescription,  
              conn = PropertyValue[{"queryConnectionList", "selectedItem"}], 
              tables = PropertyValue[{"tableList", "selectedValues"}], 
              cols = {}, 
              condition = None, 
              sort = None, 
              limit = Automatic, 
              timeout = None, 
              distinct = PropertyValue[{"distinctCheckBox", "selected"}], 
              sch = PropertyValue[{"showColumnHeadingsCheckBox", "selected"}], 
              gas = PropertyValue[{"getAsStringsCheckBox", "selected"}], 
              bool = PropertyValue[{"conditionComboBox", "selectedItem"}],              
              dirty = False, 
              query, 
              colModel, 
              columnWidths = {}},
        
        If[name === Null, Return[]];
        
        If[conn === Null, conn = ""];
        
        If[tables =!= {}, cols = PropertyValue[{"columnList", "selectedValues"}]];
        
        InvokeMethod[{"conditions", "stopEditing"}];
        If[bool === "Any", SetPropertyValue[{"conditions", "operator"}, "Or"]];
        If[bool === "All", SetPropertyValue[{"conditions", "operator"}, "And"]];
        If[PropertyValue[{"conditionCheckBox", "selected"}] === True,
          condition = InvokeMethod[{"conditions", "toExpr"}];
        ];
        If[PropertyValue[{"sortCheckBox", "selected"}] === True,
          sort = InvokeMethod[{"sorts", "toExpr"}];
        ];  
        If[PropertyValue[{"timeoutCheckBox", "selected"}] && 
           PropertyValue[{"timeoutCheckBox", "enabled"}],
          timeout = ToExpression[PropertyValue[{"timeoutTextField", "text"}]];
        ];  
        If[PropertyValue[{"limitCheckBox", "selected"}] === True,
          limit = ToExpression[PropertyValue[{"limitTextField", "text"}]];
        ];  
        cols = (StringReplace[#, {", "->"."}] & /@ cols);
        
        colModel = PropertyValue[{"contentTable", "ColumnModel"}];
        columnWidths = 
          getColumnWidth[colModel, #] & /@ 
            Range[0, PropertyValue[{colModel, "columnCount"}] -1];
        
        query = SQLSelect[conn, tables, cols, condition, "SortingColumns"->sort,
                                                         "Distinct"->distinct,                                                           
                                                         "MaxRows"->limit, 
                                                         "Timeout"->timeout, 
                                                         "ShowColumnHeadings"->sch, 
                                                         "GetAsStrings"->gas, 
                                                         "Name"->name,
                                                         "Description"->description,
                                                         "ColumnWidths"->columnWidths,
                                                         "Version"->DatabaseLink`Information`$VersionNumber,
                                                         "Location"->location];  
        queries = Union[{query}, Select[queries, !sameQuery[query, #] &]];
      ];
    
    executeQuery[]:=
      Module[{query, useOpts, sch, headers, data, colWidth, maxrows, actions, cases},
        
        query = getQuery[currentQuery];
                 
        cases = Cases[SQLConnections[], SQLConnection[___, "Name" -> First[query], ___]];
        If[Length[cases] < 1, 
          updateContent[{},{}, {},100];
          SetPropertyValue[{"statusBar", "text"}, "Connection not found.  Please open a connection."];
          Return[], 
          SetPropertyValue[{"statusBar", "text"}, "Connection found."];
        ];
        useOpts  = canonicalOptions[Flatten[Options[query]]];
        sch      = "ShowColumnHeadings" /. useOpts /. Options[ SQLSelect ];
        colWidth = "ColumnWidths" /. useOpts /. Options[ SQLSelect ]; 
        If[colWidth === "ColumnWidths", colWidth = {}];
        maxrows = "MaxRows" /. useOpts /. Options[ SQLSelect ];
        
        query = query /. {Rule[MaxRows | "MaxRows", x_Integer] -> Rule[MaxRows, x + 1]};
                
        actions = {"connectionAction", "newAction", "saveAction", "saveAsAction", 
                   "deleteAction", "reloadAction", "notebookAction"};
        
(*      SetPropertyValue[{"stopAction", "enabled"}, True]; *)
        SetPropertyValue[{#, "enabled"}, False] &  /@ Join[actions, {"tabbedPane"}];
        
        data = CheckAbort[SQLExecute[First[cases], query], $Aborted];

(*      SetPropertyValue[{"stopAction", "enabled"}, False];*)
        SetPropertyValue[{#, "enabled"}, True] &  /@ Join[actions, {"tabbedPane"}];
        
        If[!ListQ[data], 
          updateContent[{},{}, {},100];
          If[data === $Aborted, 
            SetPropertyValue[{"statusBar", "text"}, "Query aborted."],
            SetPropertyValue[{"statusBar", "text"}, "Invalid query.  Please choose valid tables and columns."]
          ];
          Return[], 
          SetPropertyValue[{"statusBar", "text"}, "Query complete."];          
        ];
        
        
        If[sch, 
          headers = First[data];
          data = Drop[data, 1];
        ];
        updateContent[data, headers, colWidth, maxrows];
      ];

    updateContent[data_List, headers_List, columnWidths_List, maxrows_]:=
      Module[{colModel},
        SetPropertyValue[{"contentTableModel", "columnIdentifiers"}, headers];
        SetPropertyValue[{"contentTable", "columnSortable"},True&/@Range[Length[data]]];
        colModel = PropertyValue[{"contentTable", "ColumnModel"}];
        If[Length[columnWidths] > 0, 
          If[Length[columnWidths] <= PropertyValue[{"contentTable", "columnCount"}], 
            setColumnWidth[colModel, #-1, columnWidths[[#]]] & /@ Range[Length[columnWidths]], 
            setColumnWidth[colModel, #-1, columnWidths[[#]]] & /@ Range[PropertyValue[{"contentTable", "columnCount"}]]
          ],
          If[Length[headers] > 0,
            setColumnWidth[colModel, #-1, headers[[#]]] & /@ Range[Length[headers]];
          ];          
        ];
        If[(IntegerQ[maxrows] && maxrows >= Length[data]) || maxrows === Automatic, 
          SetPropertyValue[{"contentTable", "items"}, data];
          SetPropertyValue[{"statusBar", "text"}, " " <> ToString[Length[data]] <> " items."], 
          SetPropertyValue[{"contentTable", "items"}, Drop[data,-1]];
          SetPropertyValue[{"statusBar", "text"}, " First " <> ToString[Length[data]-1] <> " items."]
        ]
      ];
  
    getColumnWidth[columnModel_, index_Integer] := 
      Module[{col = InvokeMethod[{columnModel, "GetColumn"}, index]},
        PropertyValue[{col, "PreferredWidth"}]
      ];

    setColumnWidth[columnModel_, index_Integer, length_Integer] := 
      Module[{col = InvokeMethod[{columnModel, "GetColumn"}, index]},
        SetPropertyValue[{col, "PreferredWidth"}, length];
      ];

    setSelectedValues[list_String, vals_List] :=
      Module[{indices = {}, items, i},
        items = PropertyValue[{list, "items"}];
        For[i = 1, i <= Length[items], i++,
          If[MemberQ[vals, items[[i]]], 
            AppendTo[indices, i-1];
          ];          
        ];
        SetPropertyValue[{list, "selectedIndices"}, indices];
        If[Length[indices] > 0, 
          InvokeMethod[{list, "ensureIndexIsVisible"}, First[indices]];
        ];
      ];

    SetAttributes[ canonicalOptions, {Listable}];
    canonicalOptions[name_Symbol -> val_] := SymbolName[name] -> val;
    canonicalOptions[expr___] := expr;

    sameQuery[a_String, b_SQLSelect] :=
      Module[{useOpts},
        useOpts  = canonicalOptions[Flatten[Options[b]]];
        name     = "Name" /. useOpts /. Options[ SQLSelect ];

        If[a === name, True, False]
      ];  
      
    sameQuery[a_SQLSelect, b_SQLSelect] :=
      Module[{useOptsA, useOptsB, nameA, nameB}, 
        useOptsA  = canonicalOptions[Flatten[Options[a]]];
        useOptsB  = canonicalOptions[Flatten[Options[b]]];
        nameA     = "Name" /. useOptsA /. Options[ SQLSelect ];
        nameB     = "Name" /. useOptsB /. Options[ SQLSelect ];

        If[nameA === nameB, True, False]
      ];
      
    sameQuery[___] := False;
    
    saveQuery[]:=
      Module[{query, opts, name, description, file, maxrows, timeout, distinct, 
              sc, sch, gas, colWidth},
        swapOutQuery[];
        query = getQuery[currentQuery];
        
        opts  = canonicalOptions[Flatten[Options[query]]];        
        file = "Location" /. opts /. Options[ SQLSelect ];
        
        If[file =!= "Location" && file =!= Null && file =!= "", 
        
          name = "Name" /. opts /. Options[ SQLSelect ]; 
          desc = "Description" /. opts /. Options[ SQLSelect ]; 
          maxrows = "MaxRows" /. opts /. Options[ SQLSelect ]; 
          timeout = "Timeout" /. opts /. Options[ SQLSelect ]; 
          distinct = "Distinct" /. opts /. Options[ SQLSelect ]; 
          sc = "SortingColumns" /. opts /. Options[ SQLSelect ]; 
          sch = "ShowColumnHeadings" /. opts /. Options[ SQLSelect ]; 
          gas = "GetAsStrings" /. opts /. Options[ SQLSelect ]; 
          colWidth = "ColumnWidths" /. opts /. Options[ SQLSelect ];         
        
          query  = SQLSelect[query[[1]], query[[2]], query[[3]], query[[4]], 
                       "SortingColumns"->sc,
                       "Distinct"->distinct,
                       "MaxRows"->maxrows, 
                       "Timeout"->timeout,
                       "ShowColumnHeadings"->sch,
                       "GetAsStrings"->gas,
                       "Name"->name,                     
                       "Description"->desc,
                       "ColumnWidths"->colWidth, 
                       "Version"->DatabaseLink`Information`$VersionNumber];
                    
          Put[query, file];
          updateQueryList[name],
          
          saveQueryAs[query];
          
        ];

      ];    
      
    saveQueryAs[q_] :=
      Module[{query, oldOpts, oldFile, newQuery, opts, 
              name, location, desc},
        If[q === Null, 
          swapOutQuery[];
          query = getQuery[currentQuery],
          query = q
        ];

        oldOpts = canonicalOptions[Flatten[Options[query]]];
        oldFile = "Location" /. oldOpts /. Options[ SQLSelect ];  
        
        SetWidgetReference["queryToSave", query];
        InvokeMethod[{"saveQueryDialog", "show"}];
          
        newQuery = WidgetReference["queryToSave"];

        opts  = canonicalOptions[Flatten[Options[newQuery]]];  
        name = "Name" /. opts /. Options[ SQLSelect ];  
        location = "Location" /. opts /. Options[ SQLSelect ];  
        desc = "Description" /. opts /. Options[ SQLSelect ];  
        If[desc === "Description", desc = ""];

        If[oldFile === location || oldFile === "" || oldFile === "Location" || oldFile === "", 
          queries = Append[Select[queries, !sameQuery[query, #] &], newQuery],
          queries = Append[queries, newQuery] 
        ];

        currentQuery = name;
        currentLocation = location;
        currentDescription = desc;
          
        updateQueryList[name];        
      ];    
      
    deleteQuery[] :=
      Module[{query, opts, name, file},
        swapOutQuery[];
        query = getQuery[currentQuery];    

        opts = canonicalOptions[Flatten[Options[query]]];
        file = "Location" /. opts /. Options[ SQLSelect ];  

        If[file =!= "" && file =!= "Location" && file =!= "", 
          DeleteFile[file]; 
        ];

        queries = Select[queries, !sameQuery[query, #] &];                                     
        If[queries === {}, 
          newQuery[];
          queries = Select[queries, !sameQuery[query, #] &],         
          query = First[queries];
          opts = canonicalOptions[Flatten[Options[query]]];
          name = "Name" /. opts /. Options[ SQLSelect ];  
          swapInQuery[query]; 
          updateQueryList[name];          
        ];
      ];

    reloadQuery[] :=
      Module[{cases},
        cases = Select[SQLQueries[], sameQuery[currentQuery, #]&];
        If[Length[cases] > 0, 
          reload = True;
          swapInQuery[First[cases]];
          swapOutQuery[];
          executeQuery[];
          reload = False;
        ];        
      ];
      
    createNotebook[]:= 
      Module[{query, opts, desc, notebook, headers,
              data = PropertyValue[{"contentTable", "items"}]},

        swapOutQuery[];
        query = getQuery[currentQuery];    
        
        opts = canonicalOptions[Flatten[Options[query]]];
        name = "Name" /. opts /. Options[ SQLSelect ]; 
        desc = "Description" /. opts /. Options[ SQLSelect ]; 
        maxrows = "MaxRows" /. opts /. Options[ SQLSelect ]; 
        timeout = "Timeout" /. opts /. Options[ SQLSelect ]; 
        distinct = "Distinct" /. opts /. Options[ SQLSelect ]; 
        sc = "SortingColumns" /. opts /. Options[ SQLSelect ]; 
        sch = "ShowColumnHeadings" /. opts /. Options[ SQLSelect ]; 
        gas = "GetAsStrings" /. opts /. Options[ SQLSelect ]; 
        
        If[sch === True, 
          headers = InvokeMethod[{"contentTable", "getColumnName"}, #] & /@ Range[0, PropertyValue[{"contentTable", "columnCount"}]-1];
          PrependTo[data, headers];
        ];
        
        query  = SQLSelect[query[[1]], query[[2]], query[[3]], query[[4]], 
                     SortingColumns->sc,
                     Distinct->distinct,
                     MaxRows->maxrows, 
                     Timeout->timeout,
                     ShowColumnHeadings->sch,
                     GetAsStrings->gas];
        
        notebook = NotebookPut[ Notebook[{ 
           Cell[name, "Section"], 
           Cell[TextData[desc], "Text"],  
           Cell[BoxData[RowBox[{"SQLExecute", "[", RowBox[{ToBoxes[query]}],"]", "//", "TableForm"}]], "Input"], 
           Cell[BoxData[ToBoxes[data//TableForm]], "Output"]
        }]];
        SetSelectedNotebook[notebook];
      ];

      SetPropertyValue[{"queryConnectionList", "items"}, "Name" /. (Options /@ SQLConnections[])];
    ] 

}, Name -> "mainFrame"]

