/*
 * Created on Jul 13, 2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.wolfram.databaselink.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import com.wolfram.jlink.Expr;

/**
 * @author chrisw
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class Condition extends JPanel{

    protected ConditionPanel conditionPanel = null;
    protected ArrayList components = new ArrayList();
    protected JButton addButton = null;
    protected JButton removeButton = null;
    protected GridBagConstraints c = null;

    private boolean enabled = true;

    public Condition()
    {
        init();
    }

    protected void init()
    {
        BoxLayout boxLayout = new BoxLayout(this, BoxLayout.X_AXIS);
        setLayout(boxLayout);
    }

    public void setConditionPanel(ConditionPanel cp)
    {
        conditionPanel = cp;
    }

    public ConditionPanel getConditionPanel()
    {
        return conditionPanel;
    }

    public void addComponent(Component component)
    {
        components.add(component);
        add(component);
        setAddButton(addButton);
        setRemoveButton(removeButton);
    }

    public void removeComponent(Component component)
    {
        components.remove(component);
        remove(component);
    }

    public void setAddButton(JButton button)
    {
        remove(addButton);
        addButton = button;
        add(addButton);
    }

    public JButton getAddButton()
    {
        return addButton;
    }

    public void setRemoveButton(JButton button)
    {
        remove(removeButton);
        removeButton = button;
        add(removeButton);
    }

    public JButton getRemoveButton()
    {
        return removeButton;
    }

    public void removeCondition()
    {
        conditionPanel.removeCondition(this);
    }

    public abstract void addCondition();

    public abstract Expr toExpr();

    public abstract void stopEditing();

    public void setEnabled(boolean e)
    {
        enabled = e;
        for(int i = 0; i < components.size(); i++)
        {
            ((Component)components.get(i)).setEnabled(e);
        }
        addButton.setEnabled(e);
        if(conditionPanel.count() == 1)
          removeButton.setEnabled(false);
        else
          removeButton.setEnabled(e);
    }

    public boolean isEnabled()
    {
        return enabled;
    }

    public void setRemoveButtonEnabled(boolean bool)
    {
        removeButton.setEnabled(bool);
    }
}
